/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveSpanContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import io.opentracing.tag.Tags;
import java.util.Iterator;
import java.util.Map;

public final class BraveSpan
implements io.opentracing.Span {
    private final Tracer tracer;
    volatile boolean finishCalled;
    volatile Span delegate;
    volatile String remoteIpV4;
    volatile String remoteIpV6;
    volatile int remotePort;

    BraveSpan(Tracer tracer, Span delegate) {
        this.tracer = tracer;
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    public final Span unwrap() {
        return this.delegate;
    }

    public BraveSpanContext context() {
        return BraveSpanContext.create(this.delegate.context());
    }

    public BraveSpan setTag(String key, String value) {
        if (this.finishCalled) {
            return this;
        }
        if (this.trySetPeer(this.delegate, key, value)) {
            return this;
        }
        if (this.trySetKind(key, value)) {
            return this;
        }
        this.delegate.tag(key, value);
        return this;
    }

    public BraveSpan setTag(String key, boolean value) {
        if (this.finishCalled) {
            return this;
        }
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.setTag(key, Boolean.toString(value));
    }

    public BraveSpan setTag(String key, Number value) {
        if (this.finishCalled) {
            return this;
        }
        if (this.trySetPeer(key, value)) {
            return this;
        }
        if (Tags.SAMPLING_PRIORITY.getKey().equals(key) && value.intValue() == 0) {
            this.delegate.abandon();
            this.delegate = this.tracer.toSpan(this.delegate.context().toBuilder().sampled(false).build());
        }
        return this.setTag(key, value.toString());
    }

    public BraveSpan log(Map<String, ?> fields) {
        if (this.finishCalled) {
            return this;
        }
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(BraveSpan.toAnnotation(fields));
    }

    public BraveSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        if (this.finishCalled) {
            return this;
        }
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(timestampMicroseconds, BraveSpan.toAnnotation(fields));
    }

    public BraveSpan log(String event) {
        if (this.finishCalled) {
            return this;
        }
        this.delegate.annotate(event);
        return this;
    }

    public BraveSpan log(long timestampMicroseconds, String event) {
        if (this.finishCalled) {
            return this;
        }
        this.delegate.annotate(timestampMicroseconds, event);
        return this;
    }

    public BraveSpan setBaggageItem(String key, String value) {
        ExtraFieldPropagation.set((TraceContext)this.delegate.context(), (String)key, (String)value);
        return this;
    }

    public String getBaggageItem(String key) {
        return ExtraFieldPropagation.get((TraceContext)this.delegate.context(), (String)key);
    }

    public BraveSpan setOperationName(String operationName) {
        if (this.finishCalled) {
            return this;
        }
        this.delegate.name(operationName);
        return this;
    }

    public void finish() {
        if (this.finishCalled) {
            return;
        }
        this.finishCalled = true;
        this.trySetRemoteIpAndPort();
        this.delegate.finish();
    }

    public void finish(long finishMicros) {
        if (this.finishCalled) {
            return;
        }
        this.finishCalled = true;
        this.trySetRemoteIpAndPort();
        this.delegate.finish(finishMicros);
    }

    static String toAnnotation(Map<String, ?> fields) {
        Object event = fields.get("event");
        if (event != null && fields.size() == 1) {
            return event.toString();
        }
        return BraveSpan.joinOnEqualsSpace(fields);
    }

    static String joinOnEqualsSpace(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, ?>> i = fields.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ?> next = i.next();
            result.append(next.getKey()).append('=').append(next.getValue());
            if (!i.hasNext()) continue;
            result.append(' ');
        }
        return result.toString();
    }

    boolean trySetKind(String key, String value) {
        if (!Tags.SPAN_KIND.getKey().equals(key)) {
            return false;
        }
        if ("client".equals(value)) {
            this.delegate.kind(Span.Kind.CLIENT);
        } else if ("server".equals(value)) {
            this.delegate.kind(Span.Kind.SERVER);
        } else if ("producer".equals(value)) {
            this.delegate.kind(Span.Kind.PRODUCER);
        } else if ("consumer".equals(value)) {
            this.delegate.kind(Span.Kind.CONSUMER);
        } else {
            return false;
        }
        return true;
    }

    boolean trySetPeer(Span span, String key, String value) {
        if (Tags.PEER_SERVICE.getKey().equals(key)) {
            span.remoteServiceName(value);
        } else if (Tags.PEER_HOST_IPV4.getKey().equals(key)) {
            this.remoteIpV4 = value;
        } else if (Tags.PEER_HOST_IPV6.getKey().equals(key)) {
            this.remoteIpV6 = value;
        } else {
            return false;
        }
        return true;
    }

    boolean trySetPeer(String key, Number value) {
        if (Tags.PEER_HOST_IPV4.getKey().equals(key)) {
            int ipv4 = value.intValue();
            this.remoteIpV4 = "" + (ipv4 >> 24 & 0xFF) + '.' + (ipv4 >> 16 & 0xFF) + '.' + (ipv4 >> 8 & 0xFF) + '.' + (ipv4 & 0xFF);
        } else if (Tags.PEER_PORT.getKey().equals(key)) {
            this.remotePort = value.intValue();
        } else {
            return false;
        }
        return true;
    }

    void trySetRemoteIpAndPort() {
        if (this.remoteIpV4 != null) {
            this.delegate.remoteIpAndPort(this.remoteIpV4, this.remotePort);
        }
        if (this.remoteIpV6 != null) {
            this.delegate.remoteIpAndPort(this.remoteIpV6, this.remotePort);
        }
    }
}

