/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.parser.SqlBaseLexer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.Identifier;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.Vocabulary;

public final class ReservedIdentifiers {
    private static final Pattern IDENTIFIER = Pattern.compile("'([A-Z_]+)'");
    private static final Pattern TABLE_ROW = Pattern.compile("``([A-Z_]+)``.*");
    private static final String TABLE_PREFIX = "============================== ";
    private static final SqlParser PARSER = new SqlParser();

    private ReservedIdentifiers() {
    }

    public static void main(String[] args) {
        if (args.length == 2 && args[0].equals("validateDocs")) {
            try {
                ReservedIdentifiers.validateDocs(Paths.get(args[1], new String[0]));
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(100);
            }
        } else {
            for (String name : ReservedIdentifiers.reservedIdentifiers()) {
                System.out.println(name);
            }
        }
    }

    private static void validateDocs(Path path) throws IOException {
        String line;
        System.out.println("Validating " + path);
        List<String> lines = Files.readAllLines(path);
        if (lines.stream().filter(s -> s.startsWith(TABLE_PREFIX)).count() != 3L) {
            throw new RuntimeException("Failed to find exactly one table");
        }
        Iterator<String> iterator = lines.iterator();
        while (!iterator.next().startsWith(TABLE_PREFIX)) {
        }
        if (iterator.next().startsWith(TABLE_PREFIX)) {
            throw new RuntimeException("Expected to find a header line");
        }
        if (!iterator.next().startsWith(TABLE_PREFIX)) {
            throw new RuntimeException("Found multiple header lines");
        }
        Set<String> reserved = ReservedIdentifiers.reservedIdentifiers();
        HashSet<String> found = new HashSet<String>();
        while (!(line = iterator.next()).startsWith(TABLE_PREFIX)) {
            Matcher matcher = TABLE_ROW.matcher(line);
            if (!matcher.matches()) {
                throw new RuntimeException("Invalid table line: " + line);
            }
            String name = matcher.group(1);
            if (!reserved.contains(name)) {
                throw new RuntimeException("Documented identifier is not reserved: " + name);
            }
            if (found.add(name)) continue;
            throw new RuntimeException("Duplicate documented identifier: " + name);
        }
        for (String name : reserved) {
            if (found.contains(name)) continue;
            throw new RuntimeException("Reserved identifier is not documented: " + name);
        }
        System.out.println(String.format("Validated %s reserved identifiers", reserved.size()));
    }

    public static Set<String> reservedIdentifiers() {
        return (Set)ReservedIdentifiers.sqlKeywords().stream().filter(ReservedIdentifiers::reserved).sorted().collect(ImmutableSet.toImmutableSet());
    }

    public static Set<String> sqlKeywords() {
        ImmutableSet.Builder names = ImmutableSet.builder();
        Vocabulary vocabulary = SqlBaseLexer.VOCABULARY;
        for (int i = 0; i <= vocabulary.getMaxTokenType(); ++i) {
            String name = Strings.nullToEmpty((String)vocabulary.getLiteralName(i));
            Matcher matcher = IDENTIFIER.matcher(name);
            if (!matcher.matches()) continue;
            names.add((Object)matcher.group(1));
        }
        return names.build();
    }

    private static boolean reserved(String name) {
        try {
            return !(PARSER.createExpression(name) instanceof Identifier);
        }
        catch (ParsingException ignored) {
            return true;
        }
    }
}

