/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class LongLiteral
extends Literal {
    private final long value;

    public LongLiteral(String value) {
        this(Optional.empty(), value);
    }

    public LongLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    private LongLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        try {
            this.value = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + value);
        }
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

