/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.cucumber6jvm.testsourcemodel;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.messages.Messages;
import io.cucumber.messages.internal.com.google.protobuf.GeneratedMessageV3;
import io.cucumber.plugin.event.TestSourceRead;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

final class TestSourcesModel {
    private final Map<URI, TestSourceRead> pathToReadEventMap = new HashMap<URI, TestSourceRead>();
    private final Map<URI, Messages.GherkinDocument> pathToAstMap = new HashMap<URI, Messages.GherkinDocument>();
    private final Map<URI, Map<Integer, AstNode>> pathToNodeMap = new HashMap<URI, Map<Integer, AstNode>>();

    TestSourcesModel() {
    }

    public static Messages.GherkinDocument.Feature.Scenario getScenarioDefinition(AstNode astNode) {
        AstNode candidate = astNode;
        while (candidate != null && !(candidate.node instanceof Messages.GherkinDocument.Feature.Scenario)) {
            candidate = candidate.parent;
        }
        return candidate == null ? null : (Messages.GherkinDocument.Feature.Scenario)candidate.node;
    }

    public void addTestSourceReadEvent(URI path, TestSourceRead event) {
        this.pathToReadEventMap.put(path, event);
    }

    public Messages.GherkinDocument.Feature getFeature(URI path) {
        if (!this.pathToAstMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToAstMap.containsKey(path)) {
            return this.pathToAstMap.get(path).getFeature();
        }
        return null;
    }

    private void parseGherkinSource(URI path) {
        if (!this.pathToReadEventMap.containsKey(path)) {
            return;
        }
        String source = this.pathToReadEventMap.get(path).getSource();
        List<Messages.Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope((String)source, (String)path.toString()));
        List envelopes = Gherkin.fromSources(sources, (boolean)true, (boolean)true, (boolean)true, () -> String.valueOf(UUID.randomUUID())).collect(Collectors.toList());
        Messages.GherkinDocument gherkinDocument = envelopes.stream().filter(Messages.Envelope::hasGherkinDocument).map(Messages.Envelope::getGherkinDocument).findFirst().orElse(null);
        this.pathToAstMap.put(path, gherkinDocument);
        HashMap<Integer, AstNode> nodeMap = new HashMap<Integer, AstNode>();
        AstNode currentParent = this.createAstNode((GeneratedMessageV3)gherkinDocument.getFeature(), null);
        for (Messages.GherkinDocument.Feature.FeatureChild child : gherkinDocument.getFeature().getChildrenList()) {
            this.processFeatureDefinition(nodeMap, child, currentParent);
        }
        this.pathToNodeMap.put(path, nodeMap);
    }

    private void processFeatureDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.FeatureChild child, AstNode currentParent) {
        if (child.hasBackground()) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.hasScenario()) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        } else if (child.hasRule()) {
            AstNode childNode = this.createAstNode((GeneratedMessageV3)child.getRule(), currentParent);
            nodeMap.put(child.getRule().getLocation().getLine(), childNode);
            for (Messages.GherkinDocument.Feature.FeatureChild.RuleChild ruleChild : child.getRule().getChildrenList()) {
                this.processRuleDefinition(nodeMap, ruleChild, childNode);
            }
        }
    }

    private void processBackgroundDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Background background, AstNode currentParent) {
        AstNode childNode = this.createAstNode((GeneratedMessageV3)background, currentParent);
        nodeMap.put(background.getLocation().getLine(), childNode);
        for (Messages.GherkinDocument.Feature.Step step : background.getStepsList()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode((GeneratedMessageV3)step, childNode));
        }
    }

    private void processScenarioDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Scenario child, AstNode currentParent) {
        AstNode childNode = this.createAstNode((GeneratedMessageV3)child, currentParent);
        nodeMap.put(child.getLocation().getLine(), childNode);
        for (Messages.GherkinDocument.Feature.Step step : child.getStepsList()) {
            nodeMap.put(step.getLocation().getLine(), this.createAstNode((GeneratedMessageV3)step, childNode));
        }
        if (child.getExamplesCount() > 0) {
            this.processScenarioOutlineExamples(nodeMap, child, childNode);
        }
    }

    private void processRuleDefinition(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.FeatureChild.RuleChild child, AstNode currentParent) {
        if (child.hasBackground()) {
            this.processBackgroundDefinition(nodeMap, child.getBackground(), currentParent);
        } else if (child.hasScenario()) {
            this.processScenarioDefinition(nodeMap, child.getScenario(), currentParent);
        }
    }

    private void processScenarioOutlineExamples(Map<Integer, AstNode> nodeMap, Messages.GherkinDocument.Feature.Scenario scenarioOutline, AstNode parent) {
        for (Messages.GherkinDocument.Feature.Scenario.Examples examples : scenarioOutline.getExamplesList()) {
            AstNode examplesNode = this.createAstNode((GeneratedMessageV3)examples, parent);
            Messages.GherkinDocument.Feature.TableRow headerRow = examples.getTableHeader();
            AstNode headerNode = this.createAstNode((GeneratedMessageV3)headerRow, examplesNode);
            nodeMap.put(headerRow.getLocation().getLine(), headerNode);
            for (int i = 0; i < examples.getTableBodyCount(); ++i) {
                Messages.GherkinDocument.Feature.TableRow examplesRow = examples.getTableBody(i);
                AstNode expandedScenarioNode = this.createAstNode((GeneratedMessageV3)examplesRow, examplesNode);
                nodeMap.put(examplesRow.getLocation().getLine(), expandedScenarioNode);
            }
        }
    }

    public AstNode getAstNode(URI path, int line) {
        if (!this.pathToNodeMap.containsKey(path)) {
            this.parseGherkinSource(path);
        }
        if (this.pathToNodeMap.containsKey(path)) {
            return this.pathToNodeMap.get(path).get(line);
        }
        return null;
    }

    private AstNode createAstNode(GeneratedMessageV3 node, AstNode astNode) {
        return new AstNode(node, astNode);
    }

    private static class AstNode {
        private final GeneratedMessageV3 node;
        private final AstNode parent;

        AstNode(GeneratedMessageV3 node, AstNode parent) {
            this.node = node;
            this.parent = parent;
        }
    }
}

