/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.fx.views;

import io.quarkiverse.fx.FxViewLoadEvent;
import io.quarkiverse.fx.views.FxViewConfig;
import io.quarkiverse.fx.views.FxViewData;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import org.jboss.logging.Logger;

@ApplicationScoped
public class FxViewRepository {
    private static final String FXML_EXT = ".fxml";
    private static final String STYLE_EXT = ".css";
    private static final Logger LOGGER = Logger.getLogger(FxViewRepository.class);
    @Inject
    Instance<FXMLLoader> fxmlLoader;
    private final Map<String, FxViewData> viewDataMap = new HashMap<String, FxViewData>();
    @Inject
    FxViewConfig config;
    private List<String> viewNames;

    public void setViewNames(List<String> views) {
        this.viewNames = views;
    }

    void setupViews(@Observes FxViewLoadEvent event) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (String name : this.viewNames) {
            FXMLLoader loader = (FXMLLoader)this.fxmlLoader.get();
            String fxml = this.config.fxmlRoot() + name + FXML_EXT;
            String css = this.config.styleRoot() + name + STYLE_EXT;
            String resources = this.config.bundleRoot() + name;
            ResourceBundle bundle = null;
            try {
                LOGGER.debugf("Attempting to load resource bundle %s", (Object)resources);
                bundle = ResourceBundle.getBundle(resources, Locale.getDefault(), classLoader);
                LOGGER.debugf("Found resource bundle %s", (Object)bundle);
            }
            catch (MissingResourceException e) {
                LOGGER.debugf("No resource bundle found for %s", bundle);
            }
            LOGGER.debugf("Attempting to load css %s", (Object)css);
            URL styleResource = classLoader.getResource(css);
            if (styleResource != null) {
                LOGGER.debugf("Found css %s", (Object)css);
            }
            LOGGER.debugf("Loading FXML %s", (Object)fxml);
            InputStream stream = FxViewRepository.lookupResourceAsStream(classLoader, fxml);
            Objects.requireNonNull(stream, "FXML " + fxml + " not found in classpath.");
            try {
                URL url;
                if (bundle != null) {
                    loader.setResources(bundle);
                }
                if ((url = FxViewRepository.lookupResource(classLoader, this.config.fxmlRoot())) == null) {
                    throw new IllegalStateException("Failed to find FXML root location : " + this.config.fxmlRoot());
                }
                loader.setLocation(url);
                Parent rootNode = (Parent)loader.load(stream);
                if (styleResource != null) {
                    rootNode.getStylesheets().add((Object)styleResource.toExternalForm());
                }
                Object controller = loader.getController();
                FxViewData viewData = FxViewData.of(rootNode, controller);
                this.viewDataMap.put(name, viewData);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load FX view " + name, e);
            }
        }
    }

    private static URL lookupResource(ClassLoader classLoader, String name) {
        URL url = classLoader.getResource(name);
        if (url == null) {
            url = FxViewRepository.class.getResource(name);
        }
        return url;
    }

    private static InputStream lookupResourceAsStream(ClassLoader classLoader, String name) {
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            stream = FxViewRepository.class.getResourceAsStream(name);
        }
        return stream;
    }

    public FxViewData getViewData(String viewName) {
        return this.viewDataMap.get(viewName);
    }
}

