/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaDevProxyHandlerConfig;
import io.quarkiverse.quinoa.QuinoaDevWebSocketProxyHandler;
import io.quarkiverse.quinoa.QuinoaNetworkConfiguration;
import io.quarkiverse.quinoa.QuinoaRecorder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.List;
import org.jboss.logging.Logger;

class QuinoaDevProxyHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(QuinoaDevProxyHandler.class);
    private final List<String> HEADERS_TO_FORWARD = List.of(HttpHeaders.ACCEPT_RANGES.toString(), HttpHeaders.CONTENT_RANGE.toString(), HttpHeaders.CONTENT_LENGTH.toString(), HttpHeaders.CONTENT_TYPE.toString());
    private final QuinoaNetworkConfiguration networkConfiguration;
    private final WebClient client;
    private final QuinoaDevWebSocketProxyHandler wsUpgradeHandler;
    private final ClassLoader currentClassLoader;
    private final QuinoaDevProxyHandlerConfig config;

    QuinoaDevProxyHandler(QuinoaDevProxyHandlerConfig config, Vertx vertx, QuinoaNetworkConfiguration network) {
        WebClientOptions options = new WebClientOptions();
        options.setSsl(network.isTls());
        options.setTrustAll(network.isTlsAllowInsecure());
        options.setVerifyHost(!network.isTlsAllowInsecure());
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)options);
        this.wsUpgradeHandler = network.isWebsocket() ? new QuinoaDevWebSocketProxyHandler(vertx, network) : null;
        this.config = config;
        this.networkConfiguration = network;
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void handle(RoutingContext ctx) {
        String resourcePath;
        if (!QuinoaRecorder.shouldHandleMethod(ctx)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String path = ctx.normalizedPath();
        if (QuinoaRecorder.isIgnored(path, this.config.ignoredPathPrefixes)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        String string = resourcePath = path.endsWith("/") ? path + this.config.indexPage : path;
        if (QuinoaRecorder.isIgnored(resourcePath, this.config.ignoredPathPrefixes)) {
            QuinoaRecorder.next(this.currentClassLoader, ctx);
            return;
        }
        if (QuinoaDevProxyHandler.isUpgradeToWebSocket(ctx)) {
            if (this.wsUpgradeHandler != null) {
                this.wsUpgradeHandler.handle(ctx);
            } else {
                QuinoaRecorder.next(this.currentClassLoader, ctx);
            }
        } else {
            this.handleHttpRequest(ctx, resourcePath);
        }
    }

    private static boolean isUpgradeToWebSocket(RoutingContext ctx) {
        return ctx.request().headers().contains("Upgrade") && "websocket".equalsIgnoreCase(ctx.request().headers().get("Upgrade"));
    }

    private void handleHttpRequest(RoutingContext ctx, String resourcePath) {
        HttpServerRequest request = ctx.request();
        MultiMap headers = request.headers();
        String uri = this.computeResourceURI(resourcePath, request);
        headers.remove("Accept-Encoding");
        this.client.request(request.method(), this.networkConfiguration.getPort().intValue(), this.networkConfiguration.getHost(), uri).putHeaders(headers).send(event -> {
            if (event.succeeded()) {
                int statusCode = ((HttpResponse)event.result()).statusCode();
                switch (statusCode) {
                    case 200: {
                        if (this.config.devServerDirectForwarding || this.shouldForward(ctx, (HttpResponse<Buffer>)((HttpResponse)event.result()))) {
                            this.forwardResponse((AsyncResult<HttpResponse<Buffer>>)event, request, ctx, resourcePath);
                            break;
                        }
                        QuinoaRecorder.next(this.currentClassLoader, ctx);
                        break;
                    }
                    case 404: {
                        QuinoaRecorder.next(this.currentClassLoader, ctx);
                        break;
                    }
                    default: {
                        this.forwardError((AsyncResult<HttpResponse<Buffer>>)event, statusCode, ctx);
                        break;
                    }
                }
            } else {
                this.error((AsyncResult<HttpResponse<Buffer>>)event, ctx);
            }
        });
    }

    private boolean shouldForward(RoutingContext ctx, HttpResponse<Buffer> result) {
        List contentType = result.headers().getAll(HttpHeaders.CONTENT_TYPE);
        if (contentType != null && contentType.stream().anyMatch(s -> s.contains("text/html"))) {
            String path = QuinoaRecorder.resolvePath(ctx);
            return path.endsWith(".html") || path.equals("/") || path.isEmpty();
        }
        return true;
    }

    private String computeResourceURI(String path, HttpServerRequest request) {
        Object uri = path;
        String query = request.query();
        if (query != null) {
            uri = (String)uri + "?" + query;
        }
        return uri;
    }

    private void forwardError(AsyncResult<HttpResponse<Buffer>> event, int statusCode, RoutingContext ctx) {
        Buffer body = (Buffer)((HttpResponse)event.result()).body();
        HttpServerResponse response = ctx.response().setStatusCode(statusCode);
        if (body != null) {
            response.send(body);
        } else {
            response.send();
        }
    }

    private void forwardResponse(AsyncResult<HttpResponse<Buffer>> event, HttpServerRequest request, RoutingContext ctx, String resourcePath) {
        LOG.debugf("Quinoa is forwarding: '%s'", (Object)request.uri());
        HttpServerResponse response = ctx.response();
        for (String header : this.HEADERS_TO_FORWARD) {
            response.headers().add(header, (Iterable)((HttpResponse)event.result()).headers().getAll(header));
        }
        QuinoaRecorder.compressIfNeeded(this.config, ctx, resourcePath);
        Buffer body = (Buffer)((HttpResponse)event.result()).body();
        if (body != null) {
            response.send(body);
        } else {
            response.send();
        }
    }

    private void error(AsyncResult<HttpResponse<Buffer>> event, RoutingContext ctx) {
        String error = String.format("Quinoa failed to forward request '%s', see logs.", ctx.request().uri());
        ctx.response().setStatusCode(500);
        ctx.response().send(error);
        LOG.error((Object)error, event.cause());
    }
}

