/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.quinoa;

import io.quarkiverse.quinoa.QuinoaDevProxyHandler;
import io.quarkiverse.quinoa.QuinoaDevProxyHandlerConfig;
import io.quarkiverse.quinoa.QuinoaNetworkConfiguration;
import io.quarkiverse.quinoa.QuinoaSPARoutingHandler;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

@Recorder
public class QuinoaRecorder {
    private static final Logger LOG = Logger.getLogger(QuinoaRecorder.class);
    public static final String META_INF_WEB_UI = "META-INF/webui";
    public static final int QUINOA_ROUTE_ORDER = 1100;
    public static final int QUINOA_SPA_ROUTE_ORDER = 40000;
    public static final Set<HttpMethod> HANDLED_METHODS = Set.of(HttpMethod.HEAD, HttpMethod.OPTIONS, HttpMethod.GET);

    public Handler<RoutingContext> quinoaProxyDevHandler(QuinoaDevProxyHandlerConfig handlerConfig, Supplier<Vertx> vertx, QuinoaNetworkConfiguration network) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Quinoa dev proxy-handler is ignoring paths starting with: " + String.join((CharSequence)", ", handlerConfig.ignoredPathPrefixes)));
        }
        return new QuinoaDevProxyHandler(handlerConfig, vertx.get(), network);
    }

    public Handler<RoutingContext> quinoaSPARoutingHandler(List<String> ignoredPathPrefixes) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Quinoa SPA routing handler is ignoring paths starting with: " + String.join((CharSequence)", ", ignoredPathPrefixes)));
        }
        return new QuinoaSPARoutingHandler(ignoredPathPrefixes);
    }

    public void logUiRootPath(String resolvedUiRootPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Quinoa is available at: " + resolvedUiRootPath));
        }
    }

    static String resolvePath(RoutingContext ctx) {
        String path = ctx.mountPoint() == null ? ctx.normalizedPath() : ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
        String routePath = ctx.currentRoute().getPath();
        String resolvedPath = routePath == null ? path : path.substring(routePath.endsWith("/") ? routePath.length() - 1 : routePath.length());
        return resolvedPath.isEmpty() ? "/" : resolvedPath;
    }

    static boolean matchesPathSeparatedPrefix(String path, String pathSeparatedPrefix) {
        if (path.startsWith(pathSeparatedPrefix)) {
            String restPath = path.substring(pathSeparatedPrefix.length());
            return restPath.isEmpty() || restPath.startsWith("/") || Objects.equals(pathSeparatedPrefix, "/");
        }
        return false;
    }

    static boolean isIgnored(String path, List<String> ignoredPathPrefixes) {
        if (ignoredPathPrefixes.stream().anyMatch(prefix -> QuinoaRecorder.matchesPathSeparatedPrefix(path, prefix))) {
            LOG.debug((Object)("Quinoa is ignoring path (quarkus.quinoa.ignored-path-prefixes): " + path));
            return true;
        }
        return false;
    }

    static void compressIfNeeded(QuinoaDevProxyHandlerConfig config, RoutingContext ctx, String path) {
        if (config.enableCompression && QuinoaRecorder.isCompressed(config, path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private static boolean isCompressed(QuinoaDevProxyHandlerConfig config, String path) {
        if (config.compressMediaTypes.isEmpty()) {
            return false;
        }
        String contentType = MimeMapping.getMimeTypeForFilename((String)path);
        return contentType != null && config.compressMediaTypes.contains(contentType);
    }

    static boolean shouldHandleMethod(RoutingContext ctx) {
        return HANDLED_METHODS.contains(ctx.request().method());
    }

    static void next(ClassLoader cl, RoutingContext ctx) {
        Thread.currentThread().setContextClassLoader(cl);
        ctx.next();
    }
}

