/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.agroal.deployment;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.security.AgroalDefaultSecurityProvider;
import io.agroal.api.security.AgroalKerberosSecurityProvider;
import io.agroal.api.security.AgroalSecurityProvider;
import io.agroal.pool.ConnectionHandler;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.deployment.DataSourceDriverBuildItem;
import io.quarkus.agroal.deployment.DataSourceInitializedBuildItem;
import io.quarkus.agroal.runtime.AbstractDataSourceProducer;
import io.quarkus.agroal.runtime.AgroalBuildTimeConfig;
import io.quarkus.agroal.runtime.AgroalRuntimeConfig;
import io.quarkus.agroal.runtime.AgroalTemplate;
import io.quarkus.agroal.runtime.DataSourceBuildTimeConfig;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class AgroalProcessor {
    private static final Logger log = Logger.getLogger(AgroalProcessor.class);
    private static final Set<DotName> UNREMOVABLE_BEANS = new HashSet<DotName>(Arrays.asList(DotName.createSimple((String)AbstractDataSourceProducer.class.getName()), DotName.createSimple((String)javax.sql.DataSource.class.getName())));
    AgroalBuildTimeConfig agroalBuildTimeConfig;

    AgroalProcessor() {
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    BeanContainerListenerBuildItem build(RecorderContext recorder, AgroalTemplate template, BuildProducer<FeatureBuildItem> feature, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<SubstrateResourceBuildItem> resource, BuildProducer<DataSourceDriverBuildItem> dataSourceDriver, SslNativeConfigBuildItem sslNativeConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<GeneratedBeanBuildItem> generatedBean) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("agroal"));
        if (!this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            log.warn((Object)"Agroal dependency is present but no driver has been defined for the default datasource");
            return null;
        }
        resource.produce((BuildItem)new SubstrateResourceBuildItem(new String[]{"META-INF/services/" + AgroalSecurityProvider.class.getName()}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ConnectionHandler[].class.getName(), ConnectionHandler.class.getName(), AgroalDefaultSecurityProvider.class.getName(), AgroalKerberosSecurityProvider.class.getName(), Statement[].class.getName(), Statement.class.getName(), ResultSet.class.getName(), ResultSet[].class.getName()}));
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()}));
            dataSourceDriver.produce((BuildItem)new DataSourceDriverBuildItem((String)this.agroalBuildTimeConfig.defaultDataSource.driver.get()));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) continue;
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{(String)((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.get()}));
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem("agroal"));
        String dataSourceProducerClassName = AbstractDataSourceProducer.class.getPackage().getName() + ".DataSourceProducer";
        this.createDataSourceProducerBean(generatedBean, dataSourceProducerClassName);
        return new BeanContainerListenerBuildItem(template.addDataSource(recorder.classProxy(dataSourceProducerClassName), this.agroalBuildTimeConfig, sslNativeConfig.isExplicitlyDisabled()));
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureRuntimeProperties(AgroalTemplate template, BuildProducer<DataSourceInitializedBuildItem> dataSourceInitialized, AgroalRuntimeConfig agroalRuntimeConfig) {
        if (!this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent() && this.agroalBuildTimeConfig.namedDataSources.isEmpty()) {
            return;
        }
        template.configureRuntimeProperties(agroalRuntimeConfig);
        dataSourceInitialized.produce((BuildItem)new DataSourceInitializedBuildItem());
    }

    @BuildStep
    UnremovableBeanBuildItem markBeansAsUnremovable() {
        return new UnremovableBeanBuildItem(beanInfo -> {
            Set types = beanInfo.getTypes();
            for (Type t : types) {
                if (!UNREMOVABLE_BEANS.contains(t.name())) continue;
                return true;
            }
            return false;
        });
    }

    private void createDataSourceProducerBean(final BuildProducer<GeneratedBeanBuildItem> generatedBean, String dataSourceProducerClassName) {
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedBean.produce((BuildItem)new GeneratedBeanBuildItem(name, data));
            }
        };
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(dataSourceProducerClassName).superClass(AbstractDataSourceProducer.class).build();
        classCreator.addAnnotation(ApplicationScoped.class);
        if (this.agroalBuildTimeConfig.defaultDataSource.driver.isPresent()) {
            MethodCreator defaultDataSourceMethodCreator = classCreator.getMethodCreator("createDefaultDataSource", AgroalDataSource.class, new Class[0]);
            defaultDataSourceMethodCreator.addAnnotation(Singleton.class);
            defaultDataSourceMethodCreator.addAnnotation(Produces.class);
            defaultDataSourceMethodCreator.addAnnotation(Default.class);
            ResultHandle dataSourceName = defaultDataSourceMethodCreator.load("<default>");
            ResultHandle dataSourceBuildTimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            ResultHandle dataSourceRuntimeConfig = defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getDefaultRuntimeConfig", Optional.class, (Class[])new Class[0]), defaultDataSourceMethodCreator.getThis(), new ResultHandle[0]);
            defaultDataSourceMethodCreator.returnValue(defaultDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class}), defaultDataSourceMethodCreator.getThis(), new ResultHandle[]{dataSourceName, dataSourceBuildTimeConfig, dataSourceRuntimeConfig}));
        }
        for (Map.Entry namedDataSourceEntry : this.agroalBuildTimeConfig.namedDataSources.entrySet()) {
            String namedDataSourceName = (String)namedDataSourceEntry.getKey();
            if (!((DataSourceBuildTimeConfig)namedDataSourceEntry.getValue()).driver.isPresent()) {
                log.warn((Object)("No driver defined for named datasource " + namedDataSourceName + ". Ignoring."));
                continue;
            }
            MethodCreator namedDataSourceMethodCreator = classCreator.getMethodCreator("createNamedDataSource_" + HashUtil.sha1((String)namedDataSourceName), AgroalDataSource.class, new Class[0]);
            namedDataSourceMethodCreator.addAnnotation(ApplicationScoped.class);
            namedDataSourceMethodCreator.addAnnotation(Produces.class);
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotNames.NAMED, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            namedDataSourceMethodCreator.addAnnotation(AnnotationInstance.create((DotName)DotName.createSimple((String)DataSource.class.getName()), null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)namedDataSourceName)}));
            ResultHandle namedDataSourceNameRH = namedDataSourceMethodCreator.load(namedDataSourceName);
            ResultHandle namedDataSourceBuildTimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getBuildTimeConfig", DataSourceBuildTimeConfig.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            ResultHandle namedDataSourceRuntimeConfig = namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"getRuntimeConfig", Optional.class, (Class[])new Class[]{String.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH});
            namedDataSourceMethodCreator.returnValue(namedDataSourceMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractDataSourceProducer.class, (String)"createDataSource", AgroalDataSource.class, (Class[])new Class[]{String.class, DataSourceBuildTimeConfig.class, Optional.class}), namedDataSourceMethodCreator.getThis(), new ResultHandle[]{namedDataSourceNameRH, namedDataSourceBuildTimeConfig, namedDataSourceRuntimeConfig}));
        }
        classCreator.close();
    }
}

