/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.deployment.AccessorFinder;
import io.quarkus.deployment.configuration.CompoundConfigType;
import io.quarkus.deployment.configuration.ConfigType;
import io.quarkus.deployment.configuration.LeafConfigType;
import io.quarkus.deployment.configuration.MapConfigType;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.wildfly.common.Assert;

public class GroupConfigType
extends CompoundConfigType {
    private final Map<String, ConfigType> fields;
    private final Class<?> class_;
    private final Constructor<?> constructor;
    private final MethodDescriptor constructorAccessor;
    private final Map<String, FieldInfo> fieldInfos;

    public GroupConfigType(String containingName, CompoundConfigType container, boolean consumeSegment, Class<?> class_, AccessorFinder accessorFinder) {
        super(containingName, container, consumeSegment);
        Assert.checkNotNullParam((String)"containingName", (Object)containingName);
        Assert.checkNotNullParam((String)"container", (Object)container);
        Assert.checkNotNullParam((String)"class_", class_);
        Assert.checkNotNullParam((String)"accessorFinder", (Object)accessorFinder);
        this.fields = new HashMap<String, ConfigType>();
        this.class_ = class_;
        try {
            this.constructor = class_.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Constructor of " + class_ + " is missing");
        }
        if ((this.constructor.getModifiers() & 2) != 0) {
            throw new IllegalArgumentException("Constructor of " + class_ + " must not be private");
        }
        if ((this.constructor.getModifiers() & 1) == 0) {
            this.constructor.setAccessible(true);
        }
        this.constructorAccessor = accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(class_, (Class[])new Class[0]));
        this.fieldInfos = new HashMap<String, FieldInfo>();
        for (Field field : class_.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if ((modifiers & 8) != 0) continue;
            if ((modifiers & 2) != 0) {
                throw new IllegalArgumentException("Field \"" + field.getName() + "\" of " + class_ + " must not be private");
            }
            field.setAccessible(true);
            FieldDescriptor descr = FieldDescriptor.of((Field)field);
            this.fieldInfos.put(field.getName(), new FieldInfo(field, accessorFinder.getSetterFor(descr), accessorFinder.getGetterFor(descr)));
        }
    }

    @Override
    public void load() throws ClassNotFoundException {
        assert (this.class_ != null && this.constructor != null);
        if (!this.fieldInfos.keySet().containsAll(this.fields.keySet())) {
            TreeSet<String> missing = new TreeSet<String>(this.fields.keySet());
            missing.removeAll(this.fieldInfos.keySet());
            throw new IllegalArgumentException("Fields missing from " + this.class_ + ": " + missing);
        }
        if (!this.fields.keySet().containsAll(this.fieldInfos.keySet())) {
            TreeSet<String> extra = new TreeSet<String>(this.fieldInfos.keySet());
            extra.removeAll(this.fields.keySet());
            throw new IllegalArgumentException("Extra unknown fields on " + this.class_ + ": " + extra);
        }
        for (ConfigType node : this.fields.values()) {
            node.load();
        }
    }

    @Override
    public ResultHandle writeInitialization(BytecodeCreator body, AccessorFinder accessorFinder, ResultHandle cache, ResultHandle smallRyeConfig) {
        ResultHandle instance = body.invokeStaticMethod(accessorFinder.getConstructorFor(MethodDescriptor.ofConstructor(this.class_, (Class[])new Class[0])), new ResultHandle[0]);
        for (Map.Entry<String, ConfigType> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            ConfigType fieldType = entry.getValue();
            FieldDescriptor fieldDescriptor = FieldDescriptor.of((Field)this.fieldInfos.get(fieldName).getField());
            ResultHandle value = fieldType.writeInitialization(body, accessorFinder, cache, smallRyeConfig);
            body.invokeStaticMethod(accessorFinder.getSetterFor(fieldDescriptor), new ResultHandle[]{instance, value});
        }
        return instance;
    }

    public ConfigType getField(String name) {
        return this.fields.get(name);
    }

    public void addField(ConfigType node) {
        String containingName = node.getContainingName();
        ConfigType existing = this.fields.putIfAbsent(containingName, node);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot add duplicate field \"" + containingName + "\" to " + this);
        }
    }

    private Field findField(String name) {
        if (this.class_ == null) {
            throw GroupConfigType.notLoadedException();
        }
        FieldInfo fieldInfo = this.fieldInfos.get(name);
        if (fieldInfo == null) {
            throw new IllegalStateException("Missing field " + name + " on " + this.class_);
        }
        return fieldInfo.getField();
    }

    private Object create(ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        Object self;
        try {
            self = this.constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw GroupConfigType.toError(e);
        }
        catch (IllegalAccessException e) {
            throw GroupConfigType.toError(e);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException e2) {
                throw e2;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
        for (Map.Entry<String, ConfigType> entry : this.fields.entrySet()) {
            entry.getValue().getDefaultValueIntoEnclosingGroup(self, cache, config, this.findField(entry.getKey()));
        }
        return self;
    }

    private ResultHandle generateCreate(BytecodeCreator body, ResultHandle cache, ResultHandle config) {
        ResultHandle self = body.invokeStaticMethod(this.constructorAccessor, new ResultHandle[0]);
        for (Map.Entry<String, ConfigType> entry : this.fields.entrySet()) {
            ConfigType childType = entry.getValue();
            MethodDescriptor setter = this.fieldInfos.get(entry.getKey()).getSetter();
            childType.generateGetDefaultValueIntoEnclosingGroup(body, self, setter, cache, config);
        }
        return self;
    }

    @Override
    Object getChildObject(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Object self, String childName) {
        Field field = this.findField(childName);
        Object val = GroupConfigType.getFromField(field, self);
        if (val == null) {
            ConfigType childType = this.getField(childName);
            childType.getDefaultValueIntoEnclosingGroup(self, cache, config, field);
            val = GroupConfigType.getFromField(field, self);
        }
        return val;
    }

    @Override
    ResultHandle generateGetChildObject(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config, ResultHandle self, String childName) {
        AssignableResultHandle val = body.createVariable(Object.class);
        FieldInfo fieldInfo = this.fieldInfos.get(childName);
        body.assign(val, body.invokeStaticMethod(fieldInfo.getGetter(), new ResultHandle[]{self}));
        try (BytecodeCreator isNull = body.ifNull((ResultHandle)val).trueBranch();){
            ConfigType childType = this.getField(childName);
            childType.generateGetDefaultValueIntoEnclosingGroup(isNull, self, fieldInfo.getSetter(), cache, config);
            isNull.assign(val, isNull.invokeStaticMethod(fieldInfo.getGetter(), new ResultHandle[]{self}));
        }
        return val;
    }

    private static Object getFromField(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw GroupConfigType.toError(e);
        }
    }

    @Override
    Object getOrCreate(NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            name.previous();
        }
        Object enclosing = container.getOrCreate(name, cache, config);
        Object self = container.getChildObject(name, cache, config, enclosing, this.getContainingName());
        if (this.isConsumeSegment()) {
            name.next();
        }
        if (self == null) {
            self = this.create(cache, config);
            if (this.isConsumeSegment()) {
                name.previous();
            }
            container.setChildObject(name, enclosing, this.getContainingName(), self);
            if (this.isConsumeSegment()) {
                name.next();
            }
        }
        return self;
    }

    @Override
    ResultHandle generateGetOrCreate(BytecodeCreator body, ResultHandle name, ResultHandle cache, ResultHandle config) {
        CompoundConfigType container = this.getContainer();
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
        }
        ResultHandle enclosing = container.generateGetOrCreate(body, name, cache, config);
        AssignableResultHandle var = body.createVariable(Object.class);
        body.assign(var, container.generateGetChildObject(body, name, cache, config, enclosing, this.getContainingName()));
        if (this.isConsumeSegment()) {
            body.invokeVirtualMethod(NI_NEXT_METHOD, name, new ResultHandle[0]);
        }
        if (container.getClass() == MapConfigType.class) {
            try (BytecodeCreator createBranch = body.ifNull((ResultHandle)var).trueBranch();){
                createBranch.assign(var, this.generateCreate(createBranch, cache, config));
                if (this.isConsumeSegment()) {
                    createBranch.invokeVirtualMethod(NI_PREV_METHOD, name, new ResultHandle[0]);
                }
                container.generateSetChildObject(createBranch, name, enclosing, this.getContainingName(), (ResultHandle)var);
                if (this.isConsumeSegment()) {
                    createBranch.invokeVirtualMethod(NI_NEXT_METHOD, name, new ResultHandle[0]);
                }
            }
        }
        return var;
    }

    @Override
    void acceptConfigurationValueIntoLeaf(LeafConfigType leafType, NameIterator name, ExpandingConfigSource.Cache cache, SmallRyeConfig config) {
        FieldInfo fieldInfo = this.fieldInfos.get(leafType.getContainingName());
        leafType.acceptConfigurationValueIntoGroup(this.getOrCreate(name, cache, config), fieldInfo.getField(), name, config);
    }

    @Override
    void generateAcceptConfigurationValueIntoLeaf(BytecodeCreator body, LeafConfigType leafType, ResultHandle name, ResultHandle cache, ResultHandle config) {
        FieldInfo fieldInfo = this.fieldInfos.get(leafType.getContainingName());
        leafType.generateAcceptConfigurationValueIntoGroup(body, this.generateGetOrCreate(body, name, cache, config), fieldInfo.getSetter(), name, config);
    }

    @Override
    void setChildObject(NameIterator name, Object self, String containingName, Object value) {
        try {
            this.findField(containingName).set(self, value);
        }
        catch (IllegalAccessException e) {
            throw GroupConfigType.toError(e);
        }
    }

    @Override
    void generateSetChildObject(BytecodeCreator body, ResultHandle name, ResultHandle self, String containingName, ResultHandle value) {
        body.invokeStaticMethod(this.fieldInfos.get(containingName).getSetter(), new ResultHandle[]{self, value});
    }

    @Override
    void getDefaultValueIntoEnclosingGroup(Object enclosing, ExpandingConfigSource.Cache cache, SmallRyeConfig config, Field field) {
        try {
            field.set(enclosing, this.create(cache, config));
        }
        catch (IllegalAccessException e) {
            throw GroupConfigType.toError(e);
        }
    }

    @Override
    void generateGetDefaultValueIntoEnclosingGroup(BytecodeCreator body, ResultHandle enclosing, MethodDescriptor setter, ResultHandle cache, ResultHandle config) {
        ResultHandle self = this.generateCreate(body, cache, config);
        body.invokeStaticMethod(setter, new ResultHandle[]{enclosing, self});
    }

    static final class FieldInfo {
        private final Field field;
        private final MethodDescriptor setter;
        private final MethodDescriptor getter;

        public FieldInfo(Field field, MethodDescriptor setter, MethodDescriptor getter) {
            this.field = field;
            this.setter = setter;
            this.getter = getter;
        }

        public Field getField() {
            return this.field;
        }

        public MethodDescriptor getSetter() {
            return this.setter;
        }

        public MethodDescriptor getGetter() {
            return this.getter;
        }
    }
}

