/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.ClassOutput;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ClassOutputBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.substrate.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateOutputBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateResourceBundleBuildItem;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ResourceHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public class SubstrateAutoFeatureStep {
    private static final String GRAAL_AUTOFEATURE = "io/quarkus/runner/AutoFeature";
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor INITIALIZE_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitializationSupport.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class.class, String.class});
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod(RuntimeClassInitializationSupport.class, (String)"rerunInitialization", Void.TYPE, (Class[])new Class[]{Class.class, String.class});
    static final String RUNTIME_REFLECTION = RuntimeReflection.class.getName();
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LOCALIZATION_SUPPORT = "com.oracle.svm.core.jdk.LocalizationSupport";

    @BuildStep
    SubstrateOutputBuildItem generateFeature(ClassOutputBuildItem output, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<SubstrateProxyDefinitionBuildItem> proxies, List<SubstrateResourceBuildItem> resources, List<SubstrateResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems) {
        CatchBlockCreator cc;
        ResultHandle clazz;
        TryBlock tc;
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(ClassOutput.gizmoAdaptor(output.getClassOutput(), true), GRAAL_AUTOFEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        file.addAnnotation("com.oracle.svm.core.annotate.AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle initSingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClass(RuntimeClassInitializationSupport.class)});
        ResultHandle quarkus = overallCatch.load("Quarkus");
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            for (String string : runtimeInitializedClassBuildItems.stream().map(RuntimeInitializedClassBuildItem::getClassName).collect(Collectors.toList())) {
                tc = overallCatch.tryBlock();
                clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(string), tc.load(false), resultHandle});
                tc.invokeInterfaceMethod(INITIALIZE_AT_RUN_TIME, initSingleton, new ResultHandle[]{clazz, quarkus});
                cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
        }
        thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
        ResultHandle resultHandle = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
        for (String string : runtimeReinitializedClassBuildItems.stream().map(RuntimeReinitializedClassBuildItem::getClassName).collect(Collectors.toList())) {
            tc = overallCatch.tryBlock();
            clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(string), tc.load(false), resultHandle});
            tc.invokeInterfaceMethod(RERUN_INITIALIZATION, initSingleton, new ResultHandle[]{clazz, quarkus});
            cc = tc.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        if (!proxies.isEmpty()) {
            ResultHandle proxySupportClass = overallCatch.loadClass(DYNAMIC_PROXY_REGISTRY);
            ResultHandle resultHandle2 = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
            for (SubstrateProxyDefinitionBuildItem substrateProxyDefinitionBuildItem : proxies) {
                ResultHandle array = overallCatch.newArray(Class.class, overallCatch.load(substrateProxyDefinitionBuildItem.getClasses().size()));
                int i = 0;
                for (String p : substrateProxyDefinitionBuildItem.getClasses()) {
                    ResultHandle clazz2 = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(array, i++, clazz2);
                }
                overallCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), resultHandle2, new ResultHandle[]{array});
            }
        }
        for (SubstrateResourceBuildItem substrateResourceBuildItem : resources) {
            for (String string : substrateResourceBuildItem.getResources()) {
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(string)});
            }
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(serviceProviderBuildItem.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            ResultHandle locClass = overallCatch.loadClass(LOCALIZATION_SUPPORT);
            ResultHandle resultHandle3 = overallCatch.marshalAsArray(Class.class, new ResultHandle[]{overallCatch.loadClass(String.class)});
            Iterator<Object> registerMethod = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), locClass, new ResultHandle[]{overallCatch.load("addBundleToCache"), resultHandle3});
            overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(AccessibleObject.class, (String)"setAccessible", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), registerMethod, new ResultHandle[]{overallCatch.load(true)});
            ResultHandle resultHandle4 = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
            for (SubstrateResourceBundleBuildItem i : resourceBundles) {
                String p;
                TryBlock et = overallCatch.tryBlock();
                et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), registerMethod, new ResultHandle[]{resultHandle4, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                p = et.addCatch(Throwable.class);
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> linkedHashMap = new LinkedHashMap<String, ReflectionInfo>();
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(linkedHashMap, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.areFinalFieldsWritable(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(linkedHashMap, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(linkedHashMap, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(linkedHashMap, true, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ResultHandle fhandle;
            String type;
            ResultHandle paramArray;
            ResultHandle farray;
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, "V", new String[0]);
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
            TryBlock tc2 = mv.tryBlock();
            ResultHandle clazz3 = tc2.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc2.load((String)entry.getKey())});
            ResultHandle constructors = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            ResultHandle methods = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            ResultHandle fields = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz3, new ResultHandle[0]);
            if (!((ReflectionInfo)entry.getValue()).weak) {
                ResultHandle carray = tc2.newArray(Class.class, tc2.load(1));
                tc2.writeArrayValue(carray, 0, clazz3);
                tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
            }
            if (((ReflectionInfo)entry.getValue()).constructors) {
                tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
            } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                farray = tc2.newArray(Constructor.class, tc2.load(1));
                for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                    paramArray = tc2.newArray(Class.class, tc2.load(ctor.getParams().length));
                    for (int i = 0; i < ctor.getParams().length; ++i) {
                        type = ctor.getParams()[i];
                        tc2.writeArrayValue(paramArray, i, tc2.loadClass(type));
                    }
                    fhandle = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), clazz3, new ResultHandle[]{paramArray});
                    tc2.writeArrayValue(farray, 0, fhandle);
                    tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).methods) {
                tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
            } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                farray = tc2.newArray(Method.class, tc2.load(1));
                for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                    paramArray = tc2.newArray(Class.class, tc2.load(method.getParams().length));
                    for (int i = 0; i < method.getParams().length; ++i) {
                        type = method.getParams()[i];
                        tc2.writeArrayValue(paramArray, i, tc2.loadClass(type));
                    }
                    fhandle = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), clazz3, new ResultHandle[]{tc2.load(method.getName()), paramArray});
                    tc2.writeArrayValue(farray, 0, fhandle);
                    tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).fields) {
                tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{tc2.load(((ReflectionInfo)entry.getValue()).finalFieldsWritable), fields});
            } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                farray = tc2.newArray(Field.class, tc2.load(1));
                for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                    ResultHandle fhandle2 = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), clazz3, new ResultHandle[]{tc2.load(field)});
                    tc2.writeArrayValue(farray, 0, fhandle2);
                    tc2.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                }
            }
            CatchBlockCreator cc2 = tc2.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClass("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
        return new SubstrateOutputBuildItem();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, boolean constructors, boolean method, boolean fields, boolean finalFieldsWritable, boolean weak, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, finalFieldsWritable, weak));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (!fields) continue;
            existing.fields = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean finalFieldsWritable;
        boolean weak;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
            this.finalFieldsWritable = finalFieldsWritable;
            this.weak = weak;
        }
    }
}

