/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.index.ArtifactResolver;
import io.quarkus.deployment.index.ResolvedArtifact;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapArtifactResolver
implements ArtifactResolver {
    private final Map<Key, ResolvedArtifact> artifacts;

    public MapArtifactResolver(List<ResolvedArtifact> artifacts) {
        HashMap<Key, ResolvedArtifact> map = new HashMap<Key, ResolvedArtifact>();
        for (ResolvedArtifact i : artifacts) {
            map.put(new Key(i.getGroupId(), i.getArtifactId(), i.getClassifier()), i);
        }
        this.artifacts = map;
    }

    @Override
    public ResolvedArtifact getArtifact(String groupId, String artifactId, String classifier) {
        return this.artifacts.get(new Key(groupId, artifactId, classifier));
    }

    private static class Key {
        final String groupId;
        final String artifactId;
        final String classifier;

        private Key(String groupId, String artifactId, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.classifier = classifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.groupId, key.groupId) && Objects.equals(this.artifactId, key.artifactId) && Objects.equals(this.classifier, key.classifier);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.classifier);
        }
    }
}

