/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.NativeImageFeatureBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ExcludeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JPMSExportBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageAllowIncompleteClasspathAggregateBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageEnableModule;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSecurityProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageSystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeMinimalJavaVersionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsupportedOSBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageRunnerBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageSourceJarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled;
import io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabledBuildItem;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.pkg.steps.NativeImageBuildLocalContainerRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildLocalRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRemoteContainerRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunnerError;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import io.quarkus.deployment.pkg.steps.NoopNativeImageBuildRunner;
import io.quarkus.deployment.steps.LocaleProcessor;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.graal.DisableLoggingFeature;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public class NativeImageBuildStep {
    private static final Logger log = Logger.getLogger(NativeImageBuildStep.class);
    public static final String DEBUG_BUILD_PROCESS_PORT = "5005";
    private static final String JAVA_HOME_SYS = "java.home";
    private static final String JAVA_HOME_ENV = "JAVA_HOME";
    private static final String PATH = "PATH";
    private static final int OOM_ERROR_VALUE = 137;
    private static final String QUARKUS_XMX_PROPERTY = "quarkus.native.native-image-xmx";
    public static final String CONTAINER_BUILD_VOLUME_PATH = "/project";
    private static final String TRUST_STORE_SYSTEM_PROPERTY_MARKER = "-Djavax.net.ssl.trustStore=";
    private static final String MOVED_TRUST_STORE_NAME = "trustStore";
    public static final String APP_SOURCES = "app-sources";

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void nativeImageFeatures(BuildProducer<NativeImageFeatureBuildItem> features) {
        features.produce(new NativeImageFeatureBuildItem("io.quarkus.runner.Feature"));
        features.produce(new NativeImageFeatureBuildItem(DisableLoggingFeature.class));
    }

    @BuildStep(onlyIf={NativeBuild.class})
    ArtifactResultBuildItem result(NativeImageBuildItem image) {
        NativeImageBuildItem.GraalVMVersion graalVMVersion = image.getGraalVMInfo();
        return new ArtifactResultBuildItem(image.getPath(), "native", graalVMVersion.toMap());
    }

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    ArtifactResultBuildItem nativeSourcesResult(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig, BuildSystemTargetBuildItem buildSystemTargetBuildItem, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, List<NativeImageSystemPropertyBuildItem> nativeImageProperties, List<ExcludeConfigBuildItem> excludeConfigs, NativeImageAllowIncompleteClasspathAggregateBuildItem incompleteClassPathAllowed, List<NativeImageEnableModule> enableModules, List<JPMSExportBuildItem> jpmsExportBuildItems, List<NativeImageSecurityProviderBuildItem> nativeImageSecurityProviders, List<NativeImageFeatureBuildItem> nativeImageFeatures, NativeImageRunnerBuildItem nativeImageRunner) {
        Path outputDir;
        try {
            outputDir = buildSystemTargetBuildItem.getOutputDirectory().resolve("native-sources");
            IoUtils.createOrEmptyDir((Path)outputDir);
            IoUtils.copy((Path)nativeImageSourceJarBuildItem.getPath().getParent(), (Path)outputDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create native-sources output directory", e);
        }
        Path runnerJar = outputDir.resolve(nativeImageSourceJarBuildItem.getPath().getFileName());
        String nativeImageName = this.getNativeImageName(outputTargetBuildItem, packageConfig);
        NativeImageInvokerInfo nativeImageArgs = new NativeImageInvokerInfo.Builder().setNativeConfig(nativeConfig).setLocalesBuildTimeConfig(localesBuildTimeConfig).setOutputTargetBuildItem(outputTargetBuildItem).setNativeImageProperties(nativeImageProperties).setExcludeConfigs(excludeConfigs).setJPMSExportBuildItems(jpmsExportBuildItems).setEnableModules(enableModules).setBrokenClasspath(incompleteClassPathAllowed.isAllow()).setNativeImageSecurityProviders(nativeImageSecurityProviders).setOutputDir(outputDir).setRunnerJarName(runnerJar.getFileName().toString()).setNativeImageName(nativeImageName).setGraalVMVersion(GraalVM.Version.CURRENT).setNativeImageFeatures(nativeImageFeatures).setContainerBuild(nativeImageRunner.isContainerBuild()).build();
        List<String> command = nativeImageArgs.getArgs();
        try {
            Files.writeString(outputDir.resolve("native-image.args"), (CharSequence)String.join((CharSequence)" ", command), new OpenOption[0]);
            Files.writeString(outputDir.resolve("graalvm.version"), (CharSequence)GraalVM.Version.CURRENT.getVersionAsString(), new OpenOption[0]);
            if (nativeImageRunner.isContainerBuild()) {
                Files.writeString(outputDir.resolve("native-builder.image"), (CharSequence)nativeConfig.builderImage().getEffectiveImage(), new OpenOption[0]);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Failed to build native image sources", e);
        }
        log.info((Object)("The sources for a subsequent native-image run along with the necessary arguments can be found in " + outputDir));
        IoUtils.recursiveDelete((Path)nativeImageSourceJarBuildItem.getPath().getParent());
        return new ArtifactResultBuildItem(nativeImageSourceJarBuildItem.getPath(), "native-sources", Collections.emptyMap());
    }

    @BuildStep
    public NativeImageBuildItem build(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig, NativeImageSourceJarBuildItem nativeImageSourceJarBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, List<NativeImageSystemPropertyBuildItem> nativeImageProperties, List<ExcludeConfigBuildItem> excludeConfigs, NativeImageAllowIncompleteClasspathAggregateBuildItem incompleteClassPathAllowed, List<NativeImageSecurityProviderBuildItem> nativeImageSecurityProviders, List<JPMSExportBuildItem> jpmsExportBuildItems, List<NativeImageEnableModule> enableModules, List<NativeMinimalJavaVersionBuildItem> nativeMinimalJavaVersions, List<UnsupportedOSBuildItem> unsupportedOses, Optional<ProcessInheritIODisabled> processInheritIODisabled, Optional<ProcessInheritIODisabledBuildItem> processInheritIODisabledBuildItem, List<NativeImageFeatureBuildItem> nativeImageFeatures, NativeImageRunnerBuildItem nativeImageRunner) {
        if (nativeConfig.debug().enabled()) {
            this.copyJarSourcesToLib(outputTargetBuildItem, curateOutcomeBuildItem);
            NativeImageBuildStep.copySourcesToSourceCache(outputTargetBuildItem);
        }
        Path runnerJar = nativeImageSourceJarBuildItem.getPath();
        log.info((Object)("Building native image from " + runnerJar));
        Path outputDir = nativeImageSourceJarBuildItem.getPath().getParent();
        String runnerJarName = runnerJar.getFileName().toString();
        String pie = "";
        boolean isContainerBuild = nativeImageRunner.isContainerBuild();
        if (!isContainerBuild && SystemUtils.IS_OS_LINUX) {
            pie = nativeConfig.pie().isPresent() && nativeConfig.pie().get() != false ? NativeImageBuildStep.detectPIE() : NativeImageBuildStep.detectNoPIE();
        }
        String nativeImageName = this.getNativeImageName(outputTargetBuildItem, packageConfig);
        String resultingExecutableName = this.getResultingExecutableName(nativeImageName, nativeImageRunner.isContainerBuild());
        Path generatedExecutablePath = outputDir.resolve(resultingExecutableName);
        Path finalExecutablePath = outputTargetBuildItem.getOutputDirectory().resolve(resultingExecutableName);
        if (nativeConfig.reuseExisting() && Files.exists(finalExecutablePath, new LinkOption[0])) {
            return new NativeImageBuildItem(finalExecutablePath, NativeImageBuildItem.GraalVMVersion.unknown());
        }
        NativeImageBuildRunner buildRunner = nativeImageRunner.getBuildRunner();
        buildRunner.setup(processInheritIODisabled.isPresent() || processInheritIODisabledBuildItem.isPresent());
        GraalVM.Version graalVMVersion = buildRunner.getGraalVMVersion();
        this.checkGraalVMVersion(graalVMVersion);
        try {
            String symbolsName;
            Path generatedSymbols;
            if (nativeConfig.cleanupServer()) {
                log.warn((Object)"Your application is setting the deprecated 'quarkus.native.cleanup-server' configuration key to true. Please consider removing this configuration key as it is ignored (The Native image build server is always disabled) and it will be removed in a future Quarkus version.");
            }
            NativeImageInvokerInfo commandAndExecutable = new NativeImageInvokerInfo.Builder().setNativeConfig(nativeConfig).setLocalesBuildTimeConfig(localesBuildTimeConfig).setOutputTargetBuildItem(outputTargetBuildItem).setNativeImageProperties(nativeImageProperties).setExcludeConfigs(excludeConfigs).setBrokenClasspath(incompleteClassPathAllowed.isAllow()).setNativeImageSecurityProviders(nativeImageSecurityProviders).setJPMSExportBuildItems(jpmsExportBuildItems).setEnableModules(enableModules).setNativeMinimalJavaVersions(nativeMinimalJavaVersions).setUnsupportedOSes(unsupportedOses).setOutputDir(outputDir).setRunnerJarName(runnerJarName).setNativeImageName(nativeImageName).setPIE(pie).setGraalVMVersion(graalVMVersion).setNativeImageFeatures(nativeImageFeatures).setContainerBuild(isContainerBuild).build();
            List<String> nativeImageArgs = commandAndExecutable.args;
            NativeImageBuildRunner.Result buildNativeResult = buildRunner.build(nativeImageArgs, nativeImageName, resultingExecutableName, outputDir, graalVMVersion, nativeConfig.debug().enabled(), processInheritIODisabled.isPresent() || processInheritIODisabledBuildItem.isPresent());
            if (buildNativeResult.getExitCode() != 0) {
                throw this.imageGenerationFailed(buildNativeResult.getExitCode(), isContainerBuild);
            }
            IoUtils.copy((Path)generatedExecutablePath, (Path)finalExecutablePath);
            Files.delete(generatedExecutablePath);
            if (nativeConfig.debug().enabled() && (generatedSymbols = outputDir.resolve(symbolsName = String.format("%s.debug", nativeImageName))).toFile().exists()) {
                Path finalSymbolsPath = outputTargetBuildItem.getOutputDirectory().resolve(symbolsName);
                IoUtils.copy((Path)generatedSymbols, (Path)finalSymbolsPath);
                Files.delete(generatedSymbols);
            }
            if (graalVMVersion.compareTo(GraalVM.Version.VERSION_23_0_0) >= 0) {
                try (DirectoryStream<Path> sharedLibs = Files.newDirectoryStream(outputDir, "*.{so,dll}");){
                    sharedLibs.forEach(src -> {
                        Path dst = null;
                        try {
                            dst = Path.of(outputTargetBuildItem.getOutputDirectory().toAbsolutePath().toString(), src.getFileName().toString());
                            log.debugf("Copying a shared lib from %s to %s.", src, (Object)dst);
                            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            log.errorf("Could not copy shared lib from %s to %s. Continuing. Error: %s", src, dst, (Object)e);
                        }
                    });
                }
                catch (IOException e) {
                    log.errorf("Could not list files in directory %s. Continuing. Error: %s", (Object)outputDir, (Object)e);
                }
            }
            System.setProperty("native.image.path", finalExecutablePath.toAbsolutePath().toString());
            NativeImageBuildItem nativeImageBuildItem = new NativeImageBuildItem(finalExecutablePath, new NativeImageBuildItem.GraalVMVersion(graalVMVersion.fullVersion, graalVMVersion.getVersionAsString(), graalVMVersion.javaVersion.feature(), graalVMVersion.distribution.name()));
            return nativeImageBuildItem;
        }
        catch (ImageGenerationFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to build native image", e);
        }
        finally {
            if (nativeConfig.debug().enabled()) {
                this.removeJarSourcesFromLib(outputTargetBuildItem);
                IoUtils.recursiveDelete((Path)outputDir.resolve(Paths.get(APP_SOURCES, new String[0])));
            }
        }
    }

    private String getNativeImageName(OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig) {
        return outputTargetBuildItem.getBaseName() + packageConfig.computedRunnerSuffix();
    }

    private String getResultingExecutableName(String nativeImageName, boolean isContainerBuild) {
        Object resultingExecutableName = nativeImageName;
        if (SystemUtils.IS_OS_WINDOWS && !isContainerBuild) {
            resultingExecutableName = (String)resultingExecutableName + ".exe";
        }
        return resultingExecutableName;
    }

    @BuildStep(onlyIf={NativeBuild.class})
    public NativeImageRunnerBuildItem resolveNativeImageBuildRunner(NativeConfig nativeConfig) {
        boolean isExplicitContainerBuild = nativeConfig.containerBuild().orElse(nativeConfig.containerRuntime().isPresent() || nativeConfig.remoteContainerBuild());
        if (!isExplicitContainerBuild) {
            NativeImageBuildLocalRunner localRunner = NativeImageBuildStep.getNativeImageBuildLocalRunner(nativeConfig);
            if (localRunner != null) {
                return new NativeImageRunnerBuildItem(localRunner);
            }
            String executableName = NativeImageBuildStep.getNativeImageExecutableName();
            String errorMessage = "Cannot find the `" + executableName + "` in the GRAALVM_HOME, JAVA_HOME and System PATH. Install it using `gu install native-image`";
            if (!SystemUtils.IS_OS_LINUX) {
                return new NativeImageRunnerBuildItem(new NativeImageBuildRunnerError(errorMessage));
            }
            log.warn((Object)(errorMessage + " Attempting to fall back to container build."));
        }
        if (nativeConfig.remoteContainerBuild()) {
            return new NativeImageRunnerBuildItem(new NativeImageBuildRemoteContainerRunner(nativeConfig));
        }
        return new NativeImageRunnerBuildItem(new NativeImageBuildLocalContainerRunner(nativeConfig));
    }

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    public NativeImageRunnerBuildItem dummyNativeImageBuildRunner(NativeConfig nativeConfig) {
        boolean explicitContainerBuild = nativeConfig.isExplicitContainerBuild();
        return new NativeImageRunnerBuildItem(new NoopNativeImageBuildRunner(explicitContainerBuild));
    }

    @BuildStep
    public void ignoreBuildPropertyChanges(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> producer) {
        for (String propertyKey : new String[]{"quarkus.native.container-build", "quarkus.native.remote-container-build", "quarkus.native.builder-image.image", "quarkus.native.builder-image.pull", "quarkus.native.container-runtime", "quarkus.native.container-runtime-options"}) {
            producer.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem(propertyKey));
        }
    }

    private void copyJarSourcesToLib(OutputTargetBuildItem outputTargetBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File libDirFile = libDir.toFile();
        if (!libDirFile.exists()) {
            libDirFile.mkdirs();
        }
        for (ResolvedDependency depArtifact : curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies()) {
            if (!depArtifact.isJar()) continue;
            for (Path resolvedDep : depArtifact.getResolvedPaths()) {
                Path jarSourceDep;
                if (Files.isDirectory(resolvedDep, new LinkOption[0]) || !(jarSourceDep = NativeImageBuildStep.toJarSource(resolvedDep)).toFile().exists()) continue;
                String fileName = depArtifact.getGroupId() + "." + jarSourceDep.getFileName();
                Path targetPath = libDir.resolve(fileName);
                try {
                    Files.copy(jarSourceDep, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to copy from " + jarSourceDep + " to " + targetPath, e);
                }
            }
        }
    }

    private static Path toJarSource(Path path) {
        Path parent = path.getParent();
        String fileName = path.getFileName().toString();
        int extensionIndex = fileName.lastIndexOf(46);
        String sourcesFileName = String.format("%s-sources.jar", fileName.substring(0, extensionIndex));
        return parent.resolve(sourcesFileName);
    }

    private void removeJarSourcesFromLib(OutputTargetBuildItem outputTargetBuildItem) {
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path libDir = targetDirectory.resolve("lib");
        File[] jarSources = libDir.toFile().listFiles((file, name) -> name.endsWith("-sources.jar"));
        Stream.of(Objects.requireNonNull(jarSources)).forEach(File::delete);
    }

    private static void copySourcesToSourceCache(OutputTargetBuildItem outputTargetBuildItem) {
        Path javaSourcesPath;
        Path targetDirectory = outputTargetBuildItem.getOutputDirectory().resolve(outputTargetBuildItem.getBaseName() + "-native-image-source-jar");
        Path targetSrc = targetDirectory.resolve(Paths.get(APP_SOURCES, new String[0]));
        File targetSrcFile = targetSrc.toFile();
        if (!targetSrcFile.exists()) {
            targetSrcFile.mkdirs();
        }
        if (Files.exists(javaSourcesPath = outputTargetBuildItem.getOutputDirectory().resolve(Paths.get("..", "src", "main", "java")), new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(javaSourcesPath, new FileVisitOption[0]);){
                paths.forEach(path -> {
                    Path targetPath = Paths.get(targetSrc.toString(), path.toString().substring(javaSourcesPath.toString().length()));
                    try {
                        Files.copy(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Unable to copy from " + path + " to " + targetPath, e);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to walk path " + javaSourcesPath, e);
            }
        }
    }

    private RuntimeException imageGenerationFailed(int exitValue, boolean isContainerBuild) {
        if (exitValue == 137) {
            if (isContainerBuild && !SystemUtils.IS_OS_LINUX) {
                return new ImageGenerationFailureException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. The most likely cause is Docker not being given enough memory. Also consider increasing the Xmx value for native image generation by setting the \"quarkus.native.native-image-xmx\" property");
            }
            return new ImageGenerationFailureException("Image generation failed. Exit code was " + exitValue + " which indicates an out of memory error. Consider increasing the Xmx value for native image generation by setting the \"quarkus.native.native-image-xmx\" property");
        }
        return new ImageGenerationFailureException("Image generation failed. Exit code: " + exitValue);
    }

    private void checkGraalVMVersion(GraalVM.Version version) {
        log.info((Object)("Running Quarkus native-image plugin on " + version.distribution.name() + " " + version.getVersionAsString() + " JDK " + version.javaVersion));
        if (version.isObsolete()) {
            throw new IllegalStateException("Out of date version of GraalVM or Mandrel detected: " + version.getVersionAsString() + ". Quarkus currently supports " + GraalVM.Version.CURRENT.getVersionAsString() + ". Please upgrade to this version.");
        }
        if (!version.isSupported()) {
            log.warn((Object)("You are using an older version of GraalVM or Mandrel : " + version.getVersionAsString() + ". Quarkus currently supports " + GraalVM.Version.CURRENT.getVersionAsString() + ". Please upgrade to this version."));
        }
    }

    private static NativeImageBuildLocalRunner getNativeImageBuildLocalRunner(NativeConfig nativeConfig) {
        File file;
        File file2;
        String executableName = NativeImageBuildStep.getNativeImageExecutableName();
        if (nativeConfig.graalvmHome().isPresent() && (file2 = Paths.get(nativeConfig.graalvmHome().get(), "bin", executableName).toFile()).exists()) {
            return new NativeImageBuildLocalRunner(file2.getAbsolutePath());
        }
        File javaHome = nativeConfig.javaHome();
        if (javaHome == null) {
            String home = System.getProperty(JAVA_HOME_SYS);
            if (home == null) {
                home = System.getenv(JAVA_HOME_ENV);
            }
            if (home != null) {
                javaHome = new File(home);
            }
        }
        if (javaHome != null && (file = new File(javaHome, "bin/" + executableName)).exists()) {
            return new NativeImageBuildLocalRunner(file.getAbsolutePath());
        }
        String systemPath = System.getenv(PATH);
        if (systemPath != null) {
            String[] pathDirs;
            for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
                File file3;
                File dir = new File(pathDir);
                if (!dir.isDirectory() || !(file3 = new File(dir, executableName)).exists()) continue;
                return new NativeImageBuildLocalRunner(file3.getAbsolutePath());
            }
        }
        return null;
    }

    private static String getNativeImageExecutableName() {
        return SystemUtils.IS_OS_WINDOWS ? "native-image.cmd" : "native-image";
    }

    private static String detectNoPIE() {
        String argument = NativeImageBuildStep.testGCCArgument("-no-pie");
        return argument.length() == 0 ? NativeImageBuildStep.testGCCArgument("-nopie") : argument;
    }

    private static String detectPIE() {
        return NativeImageBuildStep.testGCCArgument("-pie");
    }

    private static String testGCCArgument(String argument) {
        try {
            Process gcc = new ProcessBuilder("cc", "-v", "-E", argument, "-").start();
            gcc.getOutputStream().close();
            if (gcc.waitFor() == 0) {
                return argument;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return "";
    }

    private static class NativeImageInvokerInfo {
        private final List<String> args;

        private NativeImageInvokerInfo(List<String> args) {
            this.args = args;
        }

        List<String> getArgs() {
            return this.args;
        }

        static class Builder {
            private NativeConfig nativeConfig;
            private LocalesBuildTimeConfig localesBuildTimeConfig;
            private OutputTargetBuildItem outputTargetBuildItem;
            private List<NativeImageSystemPropertyBuildItem> nativeImageProperties;
            private List<ExcludeConfigBuildItem> excludeConfigs;
            private List<NativeImageSecurityProviderBuildItem> nativeImageSecurityProviders;
            private List<JPMSExportBuildItem> jpmsExports;
            private List<NativeImageEnableModule> enableModules;
            private List<NativeMinimalJavaVersionBuildItem> nativeMinimalJavaVersions;
            private List<UnsupportedOSBuildItem> unsupportedOSes;
            private List<NativeImageFeatureBuildItem> nativeImageFeatures;
            private Path outputDir;
            private String runnerJarName;
            private String pie = "";
            private GraalVM.Version graalVMVersion = null;
            private String nativeImageName;
            private boolean classpathIsBroken;
            private boolean containerBuild;

            Builder() {
            }

            public Builder setNativeConfig(NativeConfig nativeConfig) {
                this.nativeConfig = nativeConfig;
                return this;
            }

            public Builder setLocalesBuildTimeConfig(LocalesBuildTimeConfig localesBuildTimeConfig) {
                this.localesBuildTimeConfig = localesBuildTimeConfig;
                return this;
            }

            public Builder setOutputTargetBuildItem(OutputTargetBuildItem outputTargetBuildItem) {
                this.outputTargetBuildItem = outputTargetBuildItem;
                return this;
            }

            public Builder setNativeImageProperties(List<NativeImageSystemPropertyBuildItem> nativeImageProperties) {
                this.nativeImageProperties = nativeImageProperties;
                return this;
            }

            public Builder setBrokenClasspath(boolean classpathIsBroken) {
                this.classpathIsBroken = classpathIsBroken;
                return this;
            }

            public Builder setContainerBuild(boolean containerBuild) {
                this.containerBuild = containerBuild;
                return this;
            }

            public Builder setExcludeConfigs(List<ExcludeConfigBuildItem> excludeConfigs) {
                this.excludeConfigs = excludeConfigs;
                return this;
            }

            public Builder setNativeImageSecurityProviders(List<NativeImageSecurityProviderBuildItem> nativeImageSecurityProviders) {
                this.nativeImageSecurityProviders = nativeImageSecurityProviders;
                return this;
            }

            public Builder setJPMSExportBuildItems(List<JPMSExportBuildItem> JPMSExportBuildItems) {
                this.jpmsExports = JPMSExportBuildItems;
                return this;
            }

            public Builder setEnableModules(List<NativeImageEnableModule> modules) {
                this.enableModules = modules;
                return this;
            }

            public Builder setNativeMinimalJavaVersions(List<NativeMinimalJavaVersionBuildItem> nativeMinimalJavaVersions) {
                this.nativeMinimalJavaVersions = nativeMinimalJavaVersions;
                return this;
            }

            public Builder setUnsupportedOSes(List<UnsupportedOSBuildItem> unsupportedOSes) {
                this.unsupportedOSes = unsupportedOSes;
                return this;
            }

            public Builder setNativeImageFeatures(List<NativeImageFeatureBuildItem> nativeImageFeatures) {
                this.nativeImageFeatures = nativeImageFeatures;
                return this;
            }

            public Builder setOutputDir(Path outputDir) {
                this.outputDir = outputDir;
                return this;
            }

            public Builder setRunnerJarName(String runnerJarName) {
                this.runnerJarName = runnerJarName;
                return this;
            }

            public Builder setPIE(String pie) {
                this.pie = pie;
                return this;
            }

            public Builder setGraalVMVersion(GraalVM.Version graalVMVersion) {
                this.graalVMVersion = graalVMVersion;
                return this;
            }

            public Builder setNativeImageName(String nativeImageName) {
                this.nativeImageName = nativeImageName;
                return this;
            }

            public NativeImageInvokerInfo build() {
                String errs;
                String includeLocales;
                String userCountry;
                ArrayList<String> nativeImageArgs = new ArrayList<String>();
                boolean enableSslNative = false;
                boolean inlineBeforeAnalysis = this.nativeConfig.inlineBeforeAnalysis();
                boolean addAllCharsets = this.nativeConfig.addAllCharsets();
                boolean enableHttpsUrlHandler = this.nativeConfig.enableHttpsUrlHandler();
                for (NativeImageSystemPropertyBuildItem prop : this.nativeImageProperties) {
                    if (prop.getKey().equals("quarkus.ssl.native") && prop.getValue() != null) {
                        enableSslNative = Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.jni.enable") && prop.getValue().equals("false")) {
                        log.warn((Object)"Your application is setting the deprecated 'quarkus.jni.enable' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.native.enable-all-security-services") && prop.getValue() != null) {
                        log.warn((Object)"Your application is setting the deprecated 'quarkus.native.enable-all-security-services' configuration key. Please consider removing this configuration key as it is ignored and it will be removed in a future Quarkus version.");
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.native.enable-all-charsets") && prop.getValue() != null) {
                        addAllCharsets |= Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("quarkus.native.inline-before-analysis") && prop.getValue() != null) {
                        inlineBeforeAnalysis = Boolean.parseBoolean(prop.getValue());
                        continue;
                    }
                    if (prop.getValue() == null) {
                        nativeImageArgs.add("-J-D" + prop.getKey());
                        continue;
                    }
                    nativeImageArgs.add("-J-D" + prop.getKey() + "=" + prop.getValue());
                }
                String userLanguage = LocaleProcessor.nativeImageUserLanguage(this.nativeConfig, this.localesBuildTimeConfig);
                if (!userLanguage.isEmpty()) {
                    nativeImageArgs.add("-J-Duser.language=" + userLanguage);
                }
                if (!(userCountry = LocaleProcessor.nativeImageUserCountry(this.nativeConfig, this.localesBuildTimeConfig)).isEmpty()) {
                    nativeImageArgs.add("-J-Duser.country=" + userCountry);
                }
                if (!(includeLocales = LocaleProcessor.nativeImageIncludeLocales(this.nativeConfig, this.localesBuildTimeConfig)).isEmpty()) {
                    if ("all".equals(includeLocales)) {
                        log.warn((Object)"Your application is setting the 'quarkus.locales' configuration key to include 'all'. All JDK locales, languages, currencies, etc. will be included, inflating the size of the executable.");
                        this.addExperimentalVMOption(nativeImageArgs, "-H:+IncludeAllLocales");
                    } else {
                        this.addExperimentalVMOption(nativeImageArgs, "-H:IncludeLocales=" + includeLocales);
                    }
                }
                nativeImageArgs.add("-J-Dfile.encoding=" + this.nativeConfig.fileEncoding());
                if (enableSslNative) {
                    enableHttpsUrlHandler = true;
                }
                if (this.nativeImageFeatures == null || this.nativeImageFeatures.isEmpty()) {
                    throw new IllegalStateException("GraalVM features can't be empty, quarkus core is using some.");
                }
                ArrayList<String> featuresList = new ArrayList<String>(this.nativeImageFeatures.size());
                for (NativeImageFeatureBuildItem nativeImageFeature : this.nativeImageFeatures) {
                    featuresList.add(nativeImageFeature.getQualifiedName());
                }
                nativeImageArgs.add("--features=" + String.join((CharSequence)",", featuresList));
                if (this.nativeConfig.debug().enabled() && this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_0_0) >= 0) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+TrackNodeSourcePosition");
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+DebugCodeInfoUseSourceMappings");
                }
                nativeImageArgs.add("-J--add-exports=java.security.jgss/sun.security.krb5=ALL-UNNAMED");
                nativeImageArgs.add("-J--add-opens=java.base/java.text=ALL-UNNAMED");
                nativeImageArgs.add("-J--add-opens=java.base/java.io=ALL-UNNAMED");
                nativeImageArgs.add("-J--add-opens=java.base/java.lang.invoke=ALL-UNNAMED");
                nativeImageArgs.add("-J--add-opens=java.base/java.util=ALL-UNNAMED");
                if (this.nativeConfig.enableReports()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:PrintAnalysisCallTreeType=CSV");
                }
                if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_22_3_0) >= 0) {
                    if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_0_0) < 0) {
                        nativeImageArgs.add("-H:+CollectImageBuildStatistics");
                        nativeImageArgs.add("-H:ImageBuildStatisticsFile=" + this.nativeImageName + "-timing-stats.json");
                    }
                    this.addExperimentalVMOption(nativeImageArgs, "-H:BuildOutputJSONFile=" + this.nativeImageName + "-build-output-stats.json");
                }
                if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_1_0) >= 0 && this.graalVMVersion.compareTo(GraalVM.Version.VERSION_24_0_0) < 0) {
                    nativeImageArgs.add("--strict-image-heap");
                }
                this.handleAdditionalProperties(nativeImageArgs);
                this.addExperimentalVMOption(nativeImageArgs, "-H:+AllowFoldMethods");
                if (this.nativeConfig.headless()) {
                    nativeImageArgs.add("-J-Djava.awt.headless=true");
                }
                if (this.nativeConfig.enableFallbackImages()) {
                    nativeImageArgs.add("--auto-fallback");
                } else {
                    nativeImageArgs.add("--no-fallback");
                }
                if (!this.classpathIsBroken) {
                    nativeImageArgs.add("--link-at-build-time");
                }
                if (this.nativeConfig.reportErrorsAtRuntime()) {
                    nativeImageArgs.add("--report-unsupported-elements-at-runtime");
                }
                if (this.nativeConfig.reportExceptionStackTraces()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+ReportExceptionStackTraces");
                }
                if (this.nativeConfig.debug().enabled()) {
                    nativeImageArgs.add("-g");
                    this.addExperimentalVMOption(nativeImageArgs, "-H:DebugInfoSourceSearchPath=app-sources");
                }
                if (this.nativeConfig.debugBuildProcess()) {
                    String debugBuildProcessHost = this.containerBuild ? "0.0.0.0" : "localhost";
                    nativeImageArgs.add("-J-Xrunjdwp:transport=dt_socket,address=" + debugBuildProcessHost + ":5005,server=y,suspend=y");
                }
                if (this.nativeConfig.dumpProxies()) {
                    nativeImageArgs.add("-Dsun.misc.ProxyGenerator.saveGeneratedFiles=true");
                }
                if (this.nativeConfig.nativeImageXmx().isPresent()) {
                    nativeImageArgs.add("-J-Xmx" + this.nativeConfig.nativeImageXmx().get());
                }
                ArrayList<String> protocols = new ArrayList<String>(2);
                if (this.nativeConfig.enableHttpUrlHandler()) {
                    protocols.add("http");
                }
                if (enableHttpsUrlHandler) {
                    protocols.add("https");
                }
                if (addAllCharsets) {
                    nativeImageArgs.add("-H:+AddAllCharsets");
                } else {
                    nativeImageArgs.add("-H:-AddAllCharsets");
                }
                if (!protocols.isEmpty()) {
                    nativeImageArgs.add("--enable-url-protocols=" + String.join((CharSequence)",", protocols));
                }
                if (!inlineBeforeAnalysis) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:-InlineBeforeAnalysis");
                }
                if (!this.pie.isEmpty()) {
                    nativeImageArgs.add("-H:NativeLinkerOption=" + this.pie);
                }
                if (!this.nativeConfig.enableIsolates()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:-SpawnIsolates");
                }
                if (!this.nativeConfig.enableJni()) {
                    log.warn((Object)"Your application is setting the deprecated 'quarkus.native.enable-jni' configuration key to false. Please consider removing this configuration key as it is ignored (JNI is always enabled) and it will be removed in a future Quarkus version.");
                }
                if (this.nativeConfig.enableServer()) {
                    log.warn((Object)"Your application is setting the deprecated 'quarkus.native.enable-server' configuration key to true. Please consider removing this configuration key as it is ignored (The Native image build server is always disabled) and it will be removed in a future Quarkus version.");
                }
                if (this.nativeConfig.enableVmInspection()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+AllowVMInspection");
                }
                if (this.nativeConfig.march().isPresent()) {
                    nativeImageArgs.add("-march=" + this.nativeConfig.march().get());
                }
                ArrayList<NativeConfig.MonitoringOption> monitoringOptions = new ArrayList<NativeConfig.MonitoringOption>();
                monitoringOptions.add(NativeConfig.MonitoringOption.HEAPDUMP);
                if (this.nativeConfig.monitoring().isPresent()) {
                    monitoringOptions.addAll((Collection)this.nativeConfig.monitoring().get());
                }
                nativeImageArgs.add("--enable-monitoring=" + monitoringOptions.stream().distinct().map(o -> o.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(",")));
                if (this.nativeConfig.autoServiceLoaderRegistration()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+UseServiceLoaderFeature");
                    if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_1_0) < 0) {
                        nativeImageArgs.add("-H:+TraceServiceLoaderFeature");
                    }
                } else {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:-UseServiceLoaderFeature");
                }
                if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_1_0) < 0) {
                    if (this.nativeConfig.fullStackTraces()) {
                        nativeImageArgs.add("-H:+StackTrace");
                    } else {
                        nativeImageArgs.add("-H:-StackTrace");
                    }
                }
                if (this.nativeConfig.enableDashboardDump()) {
                    this.addExperimentalVMOption(nativeImageArgs, "-H:DashboardDump=" + this.outputTargetBuildItem.getBaseName() + "_dashboard.dump");
                    this.addExperimentalVMOption(nativeImageArgs, "-H:+DashboardAll");
                }
                if (this.nativeImageSecurityProviders != null && !this.nativeImageSecurityProviders.isEmpty()) {
                    String additionalSecurityProviders = this.nativeImageSecurityProviders.stream().map(p -> p.getSecurityProvider()).collect(Collectors.joining(","));
                    this.addExperimentalVMOption(nativeImageArgs, "-H:AdditionalSecurityProviders=" + additionalSecurityProviders);
                }
                if (this.jpmsExports != null) {
                    HashSet<JPMSExportBuildItem> deduplicatedJpmsExport = new HashSet<JPMSExportBuildItem>(this.jpmsExports);
                    for (JPMSExportBuildItem jpmsExport : deduplicatedJpmsExport) {
                        if (!jpmsExport.isRequired(this.graalVMVersion)) continue;
                        nativeImageArgs.add("-J--add-exports=" + jpmsExport.getModule() + "/" + jpmsExport.getPackage() + "=ALL-UNNAMED");
                    }
                }
                if (this.enableModules != null && this.enableModules.size() > 0) {
                    String modules = this.enableModules.stream().map(NativeImageEnableModule::getModuleName).distinct().sorted().collect(Collectors.joining(","));
                    nativeImageArgs.add("--add-modules=" + modules);
                }
                if (this.nativeMinimalJavaVersions != null && !this.nativeMinimalJavaVersions.isEmpty()) {
                    this.nativeMinimalJavaVersions.stream().filter(a -> !this.graalVMVersion.jdkVersionGreaterOrEqualTo((NativeMinimalJavaVersionBuildItem)((Object)a))).forEach(a -> log.warnf("Expected: Java %s, Actual: Java %s. %s", (Object)a.minVersion, (Object)this.graalVMVersion.javaVersion, (Object)a.warning));
                }
                if (this.unsupportedOSes != null && !this.unsupportedOSes.isEmpty() && !(errs = this.unsupportedOSes.stream().filter(o -> o.triggerError(this.containerBuild)).map(o -> o.error).collect(Collectors.joining(", "))).isEmpty()) {
                    throw new UnsupportedOperationException(errs);
                }
                for (ExcludeConfigBuildItem excludeConfig : this.excludeConfigs) {
                    nativeImageArgs.add("--exclude-config");
                    nativeImageArgs.add(excludeConfig.getJarFile());
                    nativeImageArgs.add(excludeConfig.getResourceName());
                }
                nativeImageArgs.add(this.nativeImageName);
                nativeImageArgs.add("-jar");
                nativeImageArgs.add(this.runnerJarName);
                return new NativeImageInvokerInfo(nativeImageArgs);
            }

            private void handleAdditionalProperties(List<String> command) {
                if (this.nativeConfig.additionalBuildArgs().isPresent()) {
                    List<String> strings = this.nativeConfig.additionalBuildArgs().get();
                    for (String buildArg : strings) {
                        String trimmedBuildArg = buildArg.trim();
                        if (trimmedBuildArg.contains(NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER) && this.containerBuild) {
                            int index = trimmedBuildArg.indexOf(NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER);
                            if (trimmedBuildArg.length() <= index + 2) continue;
                            String configuredTrustStorePath = trimmedBuildArg.substring(index + NativeImageBuildStep.TRUST_STORE_SYSTEM_PROPERTY_MARKER.length());
                            try {
                                IoUtils.copy((Path)Paths.get(configuredTrustStorePath, new String[0]), (Path)this.outputDir.resolve(NativeImageBuildStep.MOVED_TRUST_STORE_NAME));
                                command.add(trimmedBuildArg.substring(0, index) + "-Djavax.net.ssl.trustStore=/project/trustStore");
                                continue;
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Unable to copy trustStore file '" + configuredTrustStorePath + "' to volume root directory '" + this.outputDir.toAbsolutePath() + "'", e);
                            }
                        }
                        command.add(trimmedBuildArg);
                    }
                }
            }

            private void addExperimentalVMOption(List<String> nativeImageArgs, String option) {
                if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_1_0) >= 0) {
                    nativeImageArgs.add("-H:+UnlockExperimentalVMOptions");
                }
                nativeImageArgs.add(option);
                if (this.graalVMVersion.compareTo(GraalVM.Version.VERSION_23_1_0) >= 0) {
                    nativeImageArgs.add("-H:-UnlockExperimentalVMOptions");
                }
            }
        }
    }

    private static class ImageGenerationFailureException
    extends RuntimeException {
        private ImageGenerationFailureException(String message) {
            super(message);
        }
    }
}

