/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.MultiBuildItem;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DevServicesResultBuildItem
extends MultiBuildItem {
    private final String name;
    private final String description;
    private final String containerId;
    private final Map<String, String> config;

    public DevServicesResultBuildItem(String name, String containerId, Map<String, String> config) {
        this(name, null, containerId, config);
    }

    public DevServicesResultBuildItem(String name, String description, String containerId, Map<String, String> config) {
        this.name = name;
        this.description = description;
        this.containerId = containerId;
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public static class RunningDevService
    implements Closeable {
        private final String name;
        private final String description;
        private final String containerId;
        private final Map<String, String> config;
        private final Closeable closeable;

        private static Map<String, String> mapOf(String key, String value) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            return map;
        }

        public RunningDevService(String name, String containerId, Closeable closeable, String key, String value) {
            this(name, null, containerId, closeable, RunningDevService.mapOf(key, value));
        }

        public RunningDevService(String name, String description, String containerId, Closeable closeable, String key, String value) {
            this(name, description, containerId, closeable, RunningDevService.mapOf(key, value));
        }

        public RunningDevService(String name, String containerId, Closeable closeable, Map<String, String> config) {
            this(name, null, containerId, closeable, config);
        }

        public RunningDevService(String name, String description, String containerId, Closeable closeable, Map<String, String> config) {
            this.name = name;
            this.description = description;
            this.containerId = containerId;
            this.closeable = closeable;
            this.config = Collections.unmodifiableMap(config);
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public Closeable getCloseable() {
            return this.closeable;
        }

        public boolean isOwner() {
            return this.closeable != null;
        }

        @Override
        public void close() throws IOException {
            if (this.closeable != null) {
                this.closeable.close();
            }
        }

        public DevServicesResultBuildItem toBuildItem() {
            return new DevServicesResultBuildItem(this.name, this.description, this.containerId, this.config);
        }
    }
}

