/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import io.quarkus.deployment.util.FileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class NativeImageBuildLocalContainerRunner
extends NativeImageBuildContainerRunner {
    public NativeImageBuildLocalContainerRunner(NativeConfig nativeConfig) {
        super(nativeConfig);
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            ArrayList<String> containerRuntimeArgs = new ArrayList<String>(Arrays.asList(this.baseContainerRuntimeArgs));
            if (this.containerRuntime.isDocker() && this.containerRuntime.isRootless()) {
                Collections.addAll(containerRuntimeArgs, "--user", String.valueOf(0));
            } else {
                String uid = LinuxIDUtil.getLinuxID("-ur");
                String gid = LinuxIDUtil.getLinuxID("-gr");
                if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                    Collections.addAll(containerRuntimeArgs, "--user", uid + ":" + gid);
                    if (this.containerRuntime.isPodman() && this.containerRuntime.isRootless()) {
                        containerRuntimeArgs.add("--userns=keep-id");
                    }
                }
            }
            this.baseContainerRuntimeArgs = containerRuntimeArgs.toArray(this.baseContainerRuntimeArgs);
        }
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs(Path outputDir) {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs(outputDir);
        String volumeOutputPath = outputDir.toAbsolutePath().toString();
        if (SystemUtils.IS_OS_WINDOWS) {
            volumeOutputPath = FileUtil.translateToVolumePath(volumeOutputPath);
        }
        String selinuxBindOption = SystemUtils.IS_OS_MAC && this.containerRuntime.isPodman() ? "" : ":z";
        Collections.addAll(containerRuntimeArgs, "-v", volumeOutputPath + ":/project" + selinuxBindOption);
        return containerRuntimeArgs;
    }
}

