/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.builditem.nativeimage.NativeMinimalJavaVersionBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GraalVM {
    private static final Map<Integer, String> GRAAL_MAPPING = Map.of(22, "24.0", 23, "24.1", 24, "25.0", 25, "25.1");

    static enum Distribution {
        GRAALVM,
        MANDREL;

    }

    public static final class Version
    implements Comparable<Version> {
        private static final Pattern OLD_VERS_PATTERN = Pattern.compile("(GraalVM|native-image)( Version)? (?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)(?<distro>.*?)?(\\(Java Version (?<javaversion>(?<jfeature>[0-9]+)(\\.(?<jinterim>[0-9]*)\\.(?<jupdate>[0-9]*))?.*)\\))?$");
        static final Version VERSION_21_3 = new Version("GraalVM 21.3", "21.3", Distribution.GRAALVM);
        static final Version VERSION_21_3_0 = new Version("GraalVM 21.3.0", "21.3.0", Distribution.GRAALVM);
        public static final Version VERSION_22_3_0 = new Version("GraalVM 22.3.0", "22.3.0", "17", Distribution.GRAALVM);
        public static final Version VERSION_22_2_0 = new Version("GraalVM 22.2.0", "22.2.0", "17", Distribution.GRAALVM);
        public static final Version VERSION_23_0_0 = new Version("GraalVM 23.0.0", "23.0.0", "17", Distribution.GRAALVM);
        public static final Version VERSION_23_1_0 = new Version("GraalVM 23.1.0", "23.1.0", "21", Distribution.GRAALVM);
        public static final Version VERSION_24_0_0 = new Version("GraalVM 24.0.0", "24.0.0", "22", Distribution.GRAALVM);
        public static final Version MINIMUM = VERSION_22_2_0;
        public static final Version CURRENT = VERSION_23_1_0;
        final String fullVersion;
        public final Runtime.Version javaVersion;
        final Distribution distribution;
        private int[] versions;
        private String suffix;

        Version(String fullVersion, String version, Distribution distro) {
            this(fullVersion, version, "11", distro);
        }

        Version(String fullVersion, String version, String javaVersion, Distribution distro) {
            this(fullVersion, version, Runtime.Version.parse(javaVersion), distro);
        }

        Version(String fullVersion, String version, Runtime.Version javaVersion, Distribution distro) {
            this.fullVersion = fullVersion;
            this.breakdownVersion(version);
            this.javaVersion = javaVersion;
            this.distribution = distro;
        }

        private void breakdownVersion(String version) {
            int dash = version.indexOf(45);
            if (dash != -1) {
                this.suffix = version.substring(dash + 1);
                version = version.substring(0, dash);
            }
            this.versions = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }

        String getFullVersion() {
            return this.fullVersion;
        }

        boolean isObsolete() {
            return this.compareTo(MINIMUM) < 0;
        }

        boolean isMandrel() {
            return this.distribution == Distribution.MANDREL;
        }

        boolean isNewerThan(Version version) {
            return this.compareTo(version) > 0;
        }

        boolean isOlderThan(Version version) {
            return this.compareTo(version) < 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(NativeMinimalJavaVersionBuildItem javaVersionBuildItem) {
            return this.javaVersion.compareToIgnoreOptional(javaVersionBuildItem.minVersion) >= 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(String version) {
            return this.javaVersion.compareToIgnoreOptional(Runtime.Version.parse(version)) >= 0;
        }

        @Override
        public int compareTo(Version o) {
            int i;
            for (i = 0; i < this.versions.length; ++i) {
                if (i >= o.versions.length) {
                    if (this.versions[i] == 0) continue;
                    return 1;
                }
                if (this.versions[i] == o.versions[i]) continue;
                return this.versions[i] - o.versions[i];
            }
            while (i < o.versions.length) {
                if (o.versions[i] != 0) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public static Version of(Stream<String> output) {
            String line;
            Matcher oldVersMatcher;
            String stringOutput = output.collect(Collectors.joining("\n"));
            List<String> lines = stringOutput.lines().dropWhile(l -> !l.startsWith("GraalVM") && !l.startsWith("native-image")).collect(Collectors.toUnmodifiableList());
            if (lines.size() == 3) {
                Version parsedVersion = VersionParseHelper.parse(lines);
                if (parsedVersion != VersionParseHelper.UNKNOWN_VERSION) {
                    return parsedVersion;
                }
            } else if (lines.size() == 1 && (oldVersMatcher = OLD_VERS_PATTERN.matcher(line = lines.get(0))).find()) {
                String version = oldVersMatcher.group("VERSION");
                String distro = oldVersMatcher.group("distro");
                String javaVersion = oldVersMatcher.group("javaversion");
                if (javaVersion == null) {
                    if (version.startsWith("19")) {
                        javaVersion = "11";
                    } else {
                        throw new IllegalArgumentException("Cannot parse version from output: \n" + stringOutput);
                    }
                }
                return new Version(line, version, Runtime.Version.parse(javaVersion), Version.isMandrel(distro) ? Distribution.MANDREL : Distribution.GRAALVM);
            }
            throw new IllegalArgumentException("Cannot parse version from output: \n" + stringOutput);
        }

        private static boolean isMandrel(String s) {
            return s != null && s.contains("Mandrel Distribution");
        }

        public String getVersionAsString() {
            String version = Arrays.stream(this.versions).mapToObj(Integer::toString).collect(Collectors.joining("."));
            if (this.suffix != null) {
                return version + "-" + this.suffix;
            }
            return version;
        }

        public String toString() {
            return "Version{version=" + this.getVersionAsString() + ", fullVersion=" + this.fullVersion + ", distribution=" + this.distribution + ", javaVersion=" + this.javaVersion + "}";
        }

        public boolean isJava17() {
            return this.javaVersion.feature() == 17;
        }
    }

    static final class VersionParseHelper {
        private static final String JVMCI_BUILD_PREFIX = "jvmci-";
        private static final String MANDREL_VERS_PREFIX = "Mandrel-";
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VNUM_GROUP = "VNUM";
        private static final String VENDOR_VERSION_GROUP = "VENDOR";
        private static final String BUILD_INFO_GROUP = "BUILDINFO";
        private static final String VENDOR_VERS = "(?<VENDOR>.*)";
        private static final String JDK_DEBUG = "[^\\)]*";
        private static final String RUNTIME_NAME = "(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) ";
        private static final String BUILD_INFO = "(?<BUILDINFO>.*)";
        private static final String VM_NAME = "(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) ";
        private static final String FIRST_LINE_PATTERN = "native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$";
        private static final String SECOND_LINE_PATTERN = "(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$";
        private static final String THIRD_LINE_PATTERN = "(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$";
        private static final Pattern FIRST_PATTERN = Pattern.compile("native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$");
        private static final Pattern SECOND_PATTERN = Pattern.compile("(?<RUNTIME>(?:OpenJDK|GraalVM) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$");
        private static final Pattern THIRD_PATTERN = Pattern.compile("(?<VM>(?:OpenJDK 64-Bit Server|Substrate) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$");
        private static final String VERS_FORMAT = "(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)";
        private static final String VERSION_GROUP = "VERSION";
        private static final Pattern VERSION_PATTERN = Pattern.compile("(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)");
        private static final Version UNKNOWN_VERSION = null;

        VersionParseHelper() {
        }

        static Version parse(List<String> lines) {
            Matcher firstMatcher = FIRST_PATTERN.matcher(lines.get(0));
            Matcher secondMatcher = SECOND_PATTERN.matcher(lines.get(1));
            Matcher thirdMatcher = THIRD_PATTERN.matcher(lines.get(2));
            if (firstMatcher.find() && secondMatcher.find() && thirdMatcher.find()) {
                Object versNum;
                Runtime.Version v;
                String javaVersion = secondMatcher.group(BUILD_INFO_GROUP);
                try {
                    v = Runtime.Version.parse(javaVersion);
                }
                catch (IllegalArgumentException e) {
                    return UNKNOWN_VERSION;
                }
                String vendorVersion = secondMatcher.group(VENDOR_VERSION_GROUP);
                Object graalVersion = VersionParseHelper.graalVersion(javaVersion, v.feature());
                if (vendorVersion.contains("-dev")) {
                    graalVersion = (String)graalVersion + "-dev";
                }
                String mandrelVersion = VersionParseHelper.mandrelVersion(vendorVersion);
                Distribution dist = VersionParseHelper.isMandrel(vendorVersion) ? Distribution.MANDREL : Distribution.GRAALVM;
                Object object = versNum = dist == Distribution.MANDREL ? mandrelVersion : graalVersion;
                if (versNum == null) {
                    return UNKNOWN_VERSION;
                }
                return new Version(lines.stream().collect(Collectors.joining("\n")), (String)versNum, v, dist);
            }
            return UNKNOWN_VERSION;
        }

        private static boolean isMandrel(String vendorVersion) {
            if (vendorVersion == null) {
                return false;
            }
            return !vendorVersion.isBlank() && vendorVersion.startsWith(MANDREL_VERS_PREFIX);
        }

        private static String mandrelVersion(String vendorVersion) {
            if (vendorVersion == null) {
                return null;
            }
            int idx = vendorVersion.indexOf(MANDREL_VERS_PREFIX);
            if (idx < 0) {
                return null;
            }
            String version = vendorVersion.substring(idx + MANDREL_VERS_PREFIX.length());
            return VersionParseHelper.matchVersion(version);
        }

        private static String matchVersion(String version) {
            Matcher versMatcher = VERSION_PATTERN.matcher(version);
            if (versMatcher.find()) {
                return versMatcher.group(VERSION_GROUP);
            }
            return null;
        }

        private static String graalVersion(String buildInfo, int jdkFeature) {
            if (buildInfo == null) {
                return null;
            }
            int idx = buildInfo.indexOf(JVMCI_BUILD_PREFIX);
            if (idx < 0) {
                return null;
            }
            String version = buildInfo.substring(idx + JVMCI_BUILD_PREFIX.length());
            Matcher versMatcher = VERSION_PATTERN.matcher(version);
            if (versMatcher.find()) {
                return VersionParseHelper.matchVersion(version);
            }
            return GRAAL_MAPPING.get(jdkFeature);
        }
    }
}

