/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;

public class ResourceHelper {
    public static void registerResources(String resource) {
        try {
            Class<?> resourcesClass = Class.forName("com.oracle.svm.core.jdk.Resources");
            Method register = resourcesClass.getDeclaredMethod("registerResource", String.class, InputStream.class);
            Enumeration<URL> resources = ResourceHelper.class.getClassLoader().getResources(resource);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    register.invoke(null, resource, in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load resource " + resource, e);
        }
    }
}

