/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.logging.AsyncConfig;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.ConsoleConfig;
import io.quarkus.runtime.logging.FileConfig;
import io.quarkus.runtime.logging.InitialConfigurator;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.SyslogConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

@Recorder
public class LoggingSetupRecorder {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    private static final boolean IS_CON_EMU_ANSI = IS_WINDOWS && "ON".equals(System.getenv("ConEmuANSI"));
    private static final boolean IS_CYGWIN = IS_WINDOWS && System.getenv("PWD") != null && System.getenv("PWD").startsWith("/") && !"cygwin".equals(System.getenv("TERM"));
    private static final boolean IS_MINGW_XTERM = IS_WINDOWS && System.getenv("MSYSTEM") != null && System.getenv("MSYSTEM").startsWith("MINGW") && "xterm".equals(System.getenv("TERM"));

    /*
     * WARNING - void declaration
     */
    public void initializeLogging(LogConfig config, List<RuntimeValue<Optional<Handler>>> additionalHandlers, List<RuntimeValue<Optional<Formatter>>> possibleFormatters) {
        Handler syslogHandler;
        void var10_15;
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level.orElse(Level.INFO));
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            String name = entry.getKey();
            Logger logger = logContext.getLogger(name);
            CategoryConfig categoryConfig = entry.getValue();
            if ("inherit".equals(categoryConfig.level)) continue;
            logger.setLevelName(categoryConfig.level);
        }
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement((String)entry.getKey(), ((CleanupFilterConfig)entry.getValue()).ifStartsWith));
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(3 + additionalHandlers.size());
        OnlyOnceErrorManager onlyOnceErrorManager = new OnlyOnceErrorManager();
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, (ErrorManager)onlyOnceErrorManager, filterElements, possibleFormatters);
            ErrorManager errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        if (config.file.enable) {
            handlers.add(LoggingSetupRecorder.configureFileHandler(config.file, (ErrorManager)var10_15, filterElements));
        }
        if (config.syslog.enable && (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(config.syslog, (ErrorManager)var10_15, filterElements)) != null) {
            handlers.add(syslogHandler);
        }
        for (RuntimeValue<Optional<Handler>> additionalHandler : additionalHandlers) {
            Optional<Handler> optional = additionalHandler.getValue();
            if (!optional.isPresent()) continue;
            Handler handler = optional.get();
            handler.setErrorManager((ErrorManager)var10_15);
            handler.setFilter(new LogCleanupFilter(filterElements));
            handlers.add(handler);
        }
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }

    private static boolean hasColorSupport() {
        if (IS_WINDOWS) {
            return IS_CON_EMU_ANSI || IS_CYGWIN || IS_MINGW_XTERM;
        }
        return System.console() != null;
    }

    private static Handler configureConsoleHandler(ConsoleConfig config, ErrorManager defaultErrorManager, List<LogCleanupFilterElement> filterElements, List<RuntimeValue<Optional<Formatter>>> possibleFormatters) {
        ConsoleHandler handler;
        Object formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        if (formatter == null) {
            formatter = config.color.orElse(LoggingSetupRecorder.hasColorSupport()) != false ? new ColorPatternFormatter(config.darken, config.format) : new PatternFormatter(config.format);
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(formatter);
        consoleHandler.setLevel(config.level);
        consoleHandler.setErrorManager(defaultErrorManager);
        consoleHandler.setFilter((Filter)new LogCleanupFilter(filterElements));
        Object object = handler = config.async.enable ? LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)consoleHandler) : consoleHandler;
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple formatters were activated", null, 0);
        }
        return handler;
    }

    private static Handler configureFileHandler(FileConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        FileHandler handler = new FileHandler();
        FileConfig.RotationConfig rotationConfig = config.rotation;
        if (rotationConfig.maxFileSize.isPresent() && rotationConfig.fileSuffix.isPresent()) {
            PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
            periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            periodicSizeRotatingFileHandler.setRotateSize(rotationConfig.maxFileSize.get().asLongValue());
            periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex);
            handler = periodicSizeRotatingFileHandler;
        } else if (rotationConfig.maxFileSize.isPresent()) {
            SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize.get().asLongValue(), rotationConfig.maxBackupIndex);
            sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            handler = sizeRotatingFileHandler;
        } else if (rotationConfig.fileSuffix.isPresent()) {
            PeriodicRotatingFileHandler periodicRotatingFileHandler = new PeriodicRotatingFileHandler();
            periodicRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            handler = periodicRotatingFileHandler;
        }
        PatternFormatter formatter = new PatternFormatter(config.format);
        handler.setFormatter((Formatter)formatter);
        handler.setAppend(true);
        try {
            handler.setFile(config.path);
        }
        catch (FileNotFoundException e) {
            errorManager.error("Failed to set log file", e, 4);
        }
        handler.setErrorManager(errorManager);
        handler.setLevel(config.level);
        handler.setFilter((Filter)new LogCleanupFilter(filterElements));
        if (config.async.enable) {
            return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)handler);
        }
        return handler;
    }

    private static Handler configureSyslogHandler(SyslogConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        try {
            SyslogHandler handler = new SyslogHandler(config.endpoint.getHostString(), config.endpoint.getPort());
            handler.setAppName(config.appName.orElse(Process.getProcessName()));
            handler.setHostname(config.hostname.orElse(HostName.getQualifiedHostName()));
            handler.setFacility(config.facility);
            handler.setSyslogType(config.syslogType);
            handler.setProtocol(config.protocol);
            handler.setBlockOnReconnect(config.blockOnReconnect);
            handler.setTruncate(config.truncate);
            handler.setUseCountingFraming(config.useCountingFraming);
            handler.setLevel(config.level);
            PatternFormatter formatter = new PatternFormatter(config.format);
            handler.setFormatter((Formatter)formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter((Filter)new LogCleanupFilter(filterElements));
            if (config.async.enable) {
                return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create syslog handler", e, 4);
            return null;
        }
    }

    private static AsyncHandler createAsyncHandler(AsyncConfig asyncConfig, Level level, Handler handler) {
        AsyncHandler asyncHandler = new AsyncHandler(asyncConfig.queueLength);
        asyncHandler.setOverflowAction(asyncConfig.overflow);
        asyncHandler.addHandler(handler);
        asyncHandler.setLevel(level);
        return asyncHandler;
    }
}

