/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSource;
import io.quarkus.runtime.configuration.DeploymentProfileConfigSource;
import io.quarkus.runtime.configuration.ExpandingConfigSource;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime) {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        ApplicationPropertiesConfigSource.InFileSystem inFileSystem = new ApplicationPropertiesConfigSource.InFileSystem();
        ApplicationPropertiesConfigSource.InJar inJar = new ApplicationPropertiesConfigSource.InJar();
        ApplicationPropertiesConfigSource.MpConfigInJar mpConfig = new ApplicationPropertiesConfigSource.MpConfigInJar();
        builder.withSources(new ConfigSource[]{inFileSystem, inJar, mpConfig});
        ExpandingConfigSource.Cache cache = new ExpandingConfigSource.Cache();
        builder.withWrapper(ExpandingConfigSource.wrapper(cache));
        builder.withWrapper(DeploymentProfileConfigSource.wrapper());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (runTime) {
            builder.addDefaultSources();
        } else {
            ArrayList<Object> sources = new ArrayList<Object>();
            sources.addAll(new PropertiesConfigSourceProvider("META-INF/microprofile-config.properties", true, classLoader).getConfigSources(classLoader));
            sources.addAll(new PropertiesConfigSourceProvider("WEB-INF/classes/META-INF/microprofile-config.properties", true, classLoader).getConfigSources(classLoader));
            sources.add(new EnvConfigSource(300));
            sources.add(new SysPropConfigSource());
            builder.withSources(sources.toArray(new ConfigSource[0]));
        }
        builder.addDiscoveredSources();
        builder.addDiscoveredConverters();
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(new ConfigSource[]{source});
        }
    }

    static final class SysPropConfigSource
    implements ConfigSource {
        SysPropConfigSource() {
        }

        public Map<String, String> getProperties() {
            TreeMap<String, String> output = new TreeMap<String, String>();
            for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("quarkus.")) continue;
                output.put(key, entry.getValue().toString());
            }
            return output;
        }

        public String getValue(String propertyName) {
            return System.getProperty(propertyName);
        }

        public String getName() {
            return "System properties";
        }

        public int getOrdinal() {
            return 400;
        }
    }

    static final class EnvConfigSource
    implements ConfigSource {
        static final Pattern REP_PATTERN = Pattern.compile("[^a-zA-Z0-9_]");
        private final int ordinal;

        EnvConfigSource(int ordinal) {
            this.ordinal = ordinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public Map<String, String> getProperties() {
            return Collections.emptyMap();
        }

        public String getValue(String propertyName) {
            return System.getenv(REP_PATTERN.matcher(propertyName.toUpperCase(Locale.ROOT)).replaceAll("_"));
        }

        public String getName() {
            return "System environment";
        }
    }
}

