/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.wildfly.common.expression.ResolveContext;

public final class ConfigExpander
implements BiConsumer<ResolveContext<RuntimeException>, StringBuilder> {
    public static final ConfigExpander INSTANCE = new ConfigExpander();
    static final int MAX_DEPTH = 32;
    private static final ThreadLocal<int[]> depth = ThreadLocal.withInitial(() -> new int[1]);

    private ConfigExpander() {
    }

    private static boolean enter() {
        int[] depthArray = depth.get();
        if (depthArray[0] == 32) {
            return false;
        }
        depthArray[0] = depthArray[0] + 1;
        return true;
    }

    private static void exit() {
        int[] nArray = depth.get();
        nArray[0] = nArray[0] - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ResolveContext<RuntimeException> context, StringBuilder stringBuilder) {
        if (!ConfigExpander.enter()) {
            throw new IllegalArgumentException("Nested recursive expansion is too deep");
        }
        try {
            String key = context.getKey();
            if (context.hasDefault()) {
                Optional expanded = ConfigProvider.getConfig().getOptionalValue(key, String.class);
                if (expanded.isPresent()) {
                    stringBuilder.append((String)expanded.get());
                } else {
                    context.expandDefault();
                }
            } else {
                stringBuilder.append((String)ConfigProvider.getConfig().getValue(key, String.class));
            }
        }
        finally {
            ConfigExpander.exit();
        }
    }
}

