/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.DelayedHandler;

public final class InitialConfigurator
implements EmbeddedConfigurator {
    public static final DelayedHandler DELAYED_HANDLER;

    public Level getMinimumLevelOf(String loggerName) {
        return Level.ALL;
    }

    public Level getLevelOf(String loggerName) {
        return loggerName.isEmpty() ? Level.ALL : null;
    }

    public Handler[] getHandlersOf(String loggerName) {
        if (loggerName.isEmpty()) {
            if (ImageInfo.inImageBuildtimeCode()) {
                return new Handler[]{InitialConfigurator.createDefaultHandler()};
            }
            return new Handler[]{DELAYED_HANDLER};
        }
        return NO_HANDLERS;
    }

    public static ConsoleHandler createDefaultHandler() {
        ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{3.}] %s%e%n"));
        handler.setLevel(Level.INFO);
        return handler;
    }

    static {
        DelayedHandler handler = new DelayedHandler();
        ClassLoader cl = InitialConfigurator.class.getClassLoader();
        try {
            Class<?> root = Class.forName(InitialConfigurator.class.getName(), false, ClassLoader.getSystemClassLoader());
            if (root.getClassLoader() != cl) {
                handler = (DelayedHandler)root.getDeclaredField("DELAYED_HANDLER").get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DELAYED_HANDLER = handler;
    }
}

