/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import io.smallrye.config.Expressions;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

final class Substitutions {
    static final FastThreadLocalInt notExpanding = FastThreadLocalFactory.createInt();

    Substitutions() {
    }

    @TargetClass(value=Expressions.class)
    static final class Target_Expressions {
        @Delete
        private static ThreadLocal<Boolean> ENABLE;

        Target_Expressions() {
        }

        @Substitute
        private static boolean isEnabled() {
            return notExpanding.get() == 0;
        }

        @Substitute
        public static <T> T withoutExpansion(Supplier<T> supplier) {
            if (Target_Expressions.isEnabled()) {
                notExpanding.set(1);
                try {
                    T t = supplier.get();
                    return t;
                }
                finally {
                    notExpanding.set(0);
                }
            }
            return supplier.get();
        }
    }

    @TargetClass(value=ConfigProviderResolver.class)
    static final class Target_ConfigurationProviderResolver {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
        private static volatile ConfigProviderResolver instance;

        Target_ConfigurationProviderResolver() {
        }
    }
}

