/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigSourceFactoryProvider;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.KeyMap;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.MapBackedConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ConfigUtils {
    static final String UUID_KEY = "quarkus.uuid";
    public static final String QUARKUS_BUILD_TIME_RUNTIME_PROPERTIES = "quarkus-build-time-runtime.properties";
    public static final String QUARKUS_RUNTIME_CONFIG_DEFAULTS_PROPERTIES = "quarkus-runtime-config-defaults.properties";

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, true, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, false, addDiscovered, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean bootstrap, boolean addDiscovered, LaunchMode launchMode) {
        SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        builder.forClassLoader(classLoader);
        builder.withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InFileSystem());
        builder.withSources((ConfigSourceProvider)new ApplicationPropertiesConfigSourceLoader.InClassPath());
        if (launchMode.isDevOrTest() && (runTime || bootstrap)) {
            builder.withSources(new ConfigSource[]{new RuntimeOverrideConfigSource(classLoader)});
        }
        if (runTime || bootstrap) {
            builder.addDefaultSources();
            builder.addDiscoveredValidator();
            builder.withDefaultValue(UUID_KEY, UUID.randomUUID().toString());
            builder.withSources((ConfigSourceProvider)new DotEnvConfigSourceProvider());
            builder.withSources(new ConfigSource[]{new DefaultsConfigSource(ConfigUtils.loadBuildTimeRunTimeValues(), "BuildTime RunTime Fixed", Integer.MAX_VALUE)});
            builder.withSources(new ConfigSource[]{new DefaultsConfigSource(ConfigUtils.loadRunTimeDefaultValues(), "RunTime Defaults", -2147483548)});
        } else {
            ArrayList<Object> sources = new ArrayList<Object>();
            sources.addAll(PropertiesConfigSourceProvider.classPathSources((String)"META-INF/microprofile-config.properties", (ClassLoader)classLoader));
            sources.addAll(new BuildTimeDotEnvConfigSourceProvider().getConfigSources(classLoader));
            sources.add((Object)new BuildTimeEnvConfigSource());
            sources.add((Object)new BuildTimeSysPropConfigSource());
            builder.withSources(sources);
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
        }
        return builder;
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withDefaultValue("smallrye.config.profile", ProfileManager.getActiveProfile());
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<Object, Object> relocations = new HashMap<Object, Object>();
                relocations.put("smallrye.config.locations", "quarkus.config.locations");
                relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
                ConfigValue profileValue = context.proceed("smallrye.config.profile");
                if (profileValue != null) {
                    List profiles = ProfileConfigSourceInterceptor.convertProfile((String)profileValue.getValue());
                    for (String profile : profiles) {
                        relocations.put("%" + profile + ".smallrye.config.locations", "%" + profile + ".quarkus.config.locations");
                        relocations.put("%" + profile + ".smallrye.config.profile.parent", "%" + profile + ".quarkus.config.profile.parent");
                    }
                }
                return new RelocateConfigSourceInterceptor(relocations);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3195);
            }
        }});
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                HashMap<String, String> fallbacks = new HashMap<String, String>();
                fallbacks.put("quarkus.config.locations", "smallrye.config.locations");
                fallbacks.put("quarkus.config.profile.parent", "smallrye.config.profile.parent");
                return new FallbackConfigSourceInterceptor(fallbacks);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        builder.addDefaultInterceptors();
        builder.addDiscoveredInterceptors();
        builder.addDiscoveredConverters();
        return builder;
    }

    public static SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder, List<ConfigBuilder> configBuilders) {
        configBuilders.sort(ConfigBuilderComparator.INSTANCE);
        for (ConfigBuilder configBuilder : configBuilders) {
            builder = configBuilder.configBuilder(builder);
            if (builder != null) continue;
            throw new ConfigurationException(configBuilder.getClass().getName() + " returned a null builder");
        }
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(new ConfigSource[]{source});
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    public static void addSourceFactoryProvider(SmallRyeConfigBuilder builder, ConfigSourceFactoryProvider provider) {
        builder.withSources(new ConfigSourceFactory[]{provider.getConfigSourceFactory(Thread.currentThread().getContextClassLoader())});
    }

    public static Map<String, String> loadBuildTimeRunTimeValues() {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(QUARKUS_BUILD_TIME_RUNTIME_PROPERTIES);
            return resource != null ? ConfigSourceUtil.urlToMap((URL)resource) : Collections.emptyMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> loadRunTimeDefaultValues() {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(QUARKUS_RUNTIME_CONFIG_DEFAULTS_PROPERTIES);
            return resource != null ? ConfigSourceUtil.urlToMap((URL)resource) : Collections.emptyMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addMapping(SmallRyeConfigBuilder builder, String mappingClass, String prefix) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            builder.withMapping(contextClassLoader.loadClass(mappingClass), prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).isPropertyPresent(propertyName);
    }

    public static boolean isAnyPropertyPresent(Collection<String> propertyNames) {
        for (String propertyName : propertyNames) {
            if (!ConfigUtils.isPropertyPresent(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> getFirstOptionalValue(List<String> propertyNames, Class<T> propertyType) {
        Config config = ConfigProvider.getConfig();
        for (String propertyName : propertyNames) {
            Optional value = config.getOptionalValue(propertyName, propertyType);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }

    private static class ConfigBuilderComparator
    implements Comparator<ConfigBuilder> {
        private static final ConfigBuilderComparator INSTANCE = new ConfigBuilderComparator();

        private ConfigBuilderComparator() {
        }

        @Override
        public int compare(ConfigBuilder o1, ConfigBuilder o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    }

    static class DefaultsConfigSource
    extends MapBackedConfigSource {
        private final KeyMap<String> wildcards = new KeyMap();

        public DefaultsConfigSource(Map<String, String> properties, String name, int ordinal) {
            super(name, DefaultsConfigSource.filterWildcards(properties), ordinal);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (!entry.getKey().contains("*")) continue;
                this.wildcards.findOrAdd(entry.getKey()).putRootValue((Object)entry.getValue());
            }
        }

        public String getValue(String propertyName) {
            String value = super.getValue(propertyName);
            return value == null ? (String)this.wildcards.findRootValue(propertyName) : value;
        }

        private static Map<String, String> filterWildcards(Map<String, String> properties) {
            HashMap<String, String> filtered = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getKey().contains("*")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            return filtered;
        }
    }

    static class BuildTimeSysPropConfigSource
    extends SysPropConfigSource {
        BuildTimeSysPropConfigSource() {
        }

        public String getName() {
            return "System properties";
        }

        public Set<String> getPropertyNames() {
            return Collections.emptySet();
        }
    }

    static class BuildTimeDotEnvConfigSourceProvider
    extends DotEnvConfigSourceProvider {
        public BuildTimeDotEnvConfigSourceProvider() {
        }

        public BuildTimeDotEnvConfigSourceProvider(String location) {
            super(location);
        }

        protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
            return new BuildTimeEnvConfigSource(ConfigSourceUtil.urlToMap((URL)url), ordinal){

                @Override
                public String getName() {
                    return super.getName() + "[source=" + url + "]";
                }
            };
        }
    }

    static class BuildTimeEnvConfigSource
    extends EnvConfigSource {
        BuildTimeEnvConfigSource() {
        }

        BuildTimeEnvConfigSource(Map<String, String> propertyMap, int ordinal) {
            super(propertyMap, ordinal);
        }

        public Set<String> getPropertyNames() {
            return Collections.emptySet();
        }

        public String getName() {
            return "System environment";
        }
    }
}

