/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ApplicationPropertiesConfigSourceLoader;
import io.quarkus.runtime.configuration.ConfigSourceFactoryProvider;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.DotEnvConfigSourceProvider;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.PropertiesConfigSourceProvider;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SysPropConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ConfigUtils {
    static final String UUID_KEY = "quarkus.uuid";

    private ConfigUtils() {
    }

    public static <T> IntFunction<List<T>> listFactory() {
        return ArrayList::new;
    }

    public static <T> IntFunction<Set<T>> setFactory() {
        return LinkedHashSet::new;
    }

    public static <T> IntFunction<SortedSet<T>> sortedSetFactory() {
        return size -> new TreeSet();
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, true, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean addDiscovered, LaunchMode launchMode) {
        return ConfigUtils.configBuilder(runTime, false, addDiscovered, launchMode);
    }

    public static SmallRyeConfigBuilder configBuilder(boolean runTime, boolean bootstrap, boolean addDiscovered, LaunchMode launchMode) {
        SmallRyeConfigBuilder builder = ConfigUtils.emptyConfigBuilder();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        builder.withSources((Collection)new ApplicationPropertiesConfigSourceLoader.InFileSystem().getConfigSources(classLoader));
        builder.withSources((Collection)new ApplicationPropertiesConfigSourceLoader.InClassPath().getConfigSources(classLoader));
        if (launchMode.isDevOrTest() && (runTime || bootstrap)) {
            builder.withSources(new ConfigSource[]{new RuntimeOverrideConfigSource(classLoader)});
        }
        if (runTime) {
            builder.addDefaultSources();
            builder.withDefaultValue(UUID_KEY, UUID.randomUUID().toString());
            builder.withSources((Collection)DotEnvConfigSourceProvider.dotEnvSources((ClassLoader)classLoader));
        } else {
            ArrayList<Object> sources = new ArrayList<Object>();
            sources.addAll(PropertiesConfigSourceProvider.classPathSources((String)"META-INF/microprofile-config.properties", (ClassLoader)classLoader));
            sources.addAll(new BuildTimeDotEnvConfigSourceProvider().getConfigSources(classLoader));
            sources.add((Object)new BuildTimeEnvConfigSource());
            sources.add((Object)new BuildTimeSysPropConfigSource());
            builder.withSources(sources);
        }
        if (addDiscovered) {
            builder.addDiscoveredSources();
        }
        return builder;
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        SmallRyeConfigBuilder builder = new SmallRyeConfigBuilder();
        builder.withDefaultValue("smallrye.config.profile", ProfileManager.getActiveProfile());
        final HashMap<String, String> relocations = new HashMap<String, String>();
        relocations.put("smallrye.config.locations", "quarkus.config.locations");
        relocations.put("smallrye.config.profile.parent", "quarkus.config.profile.parent");
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new RelocateConfigSourceInterceptor(relocations);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3595);
            }
        }});
        final HashMap<String, String> fallbacks = new HashMap<String, String>();
        fallbacks.put("quarkus.config.locations", "smallrye.config.locations");
        fallbacks.put("quarkus.config.profile.parent", "smallrye.config.profile.parent");
        builder.withInterceptorFactories(new ConfigSourceInterceptorFactory[]{new ConfigSourceInterceptorFactory(){

            public ConfigSourceInterceptor getInterceptor(ConfigSourceInterceptorContext context) {
                return new FallbackConfigSourceInterceptor(fallbacks);
            }

            public OptionalInt getPriority() {
                return OptionalInt.of(3395);
            }
        }});
        builder.addDefaultInterceptors();
        builder.addDiscoveredInterceptors();
        builder.addDiscoveredConverters();
        builder.addDiscoveredValidator();
        return builder;
    }

    public static void addSourceProvider(SmallRyeConfigBuilder builder, ConfigSourceProvider provider) {
        Iterable sources = provider.getConfigSources(Thread.currentThread().getContextClassLoader());
        for (ConfigSource source : sources) {
            builder.withSources(new ConfigSource[]{source});
        }
    }

    public static void addSourceProviders(SmallRyeConfigBuilder builder, Collection<ConfigSourceProvider> providers) {
        for (ConfigSourceProvider provider : providers) {
            ConfigUtils.addSourceProvider(builder, provider);
        }
    }

    public static void addSourceFactoryProvider(SmallRyeConfigBuilder builder, ConfigSourceFactoryProvider provider) {
        builder.withSources(new ConfigSourceFactory[]{provider.getConfigSourceFactory(Thread.currentThread().getContextClassLoader())});
    }

    public static void addMapping(SmallRyeConfigBuilder builder, String mappingClass, String prefix) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            builder.withMapping(contextClassLoader.loadClass(mappingClass), prefix);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).isPropertyPresent(propertyName);
    }

    private static class BuildTimeSysPropMapProducer
    implements BiConsumer<Object, Object> {
        final Map<String, String> output = new TreeMap<String, String>();

        private BuildTimeSysPropMapProducer() {
        }

        @Override
        public void accept(Object k, Object v) {
            String key = (String)k;
            if (key.startsWith("quarkus.")) {
                this.output.put(key, v.toString());
            }
        }
    }

    static class BuildTimeSysPropConfigSource
    extends SysPropConfigSource {
        BuildTimeSysPropConfigSource() {
        }

        public Map<String, String> getProperties() {
            BuildTimeSysPropMapProducer buildTimeSysPropMapProducer = new BuildTimeSysPropMapProducer();
            System.getProperties().forEach(buildTimeSysPropMapProducer);
            return buildTimeSysPropMapProducer.output;
        }

        public String getName() {
            return "System properties";
        }
    }

    static class BuildTimeDotEnvConfigSourceProvider
    extends DotEnvConfigSourceProvider {
        public BuildTimeDotEnvConfigSourceProvider() {
        }

        public BuildTimeDotEnvConfigSourceProvider(String location) {
            super(location);
        }

        protected ConfigSource loadConfigSource(final URL url, int ordinal) throws IOException {
            return new BuildTimeEnvConfigSource(ConfigSourceUtil.urlToMap((URL)url), ordinal){

                @Override
                public String getName() {
                    return super.getName() + "[source=" + url + "]";
                }
            };
        }
    }

    static class BuildTimeEnvConfigSource
    extends EnvConfigSource {
        BuildTimeEnvConfigSource() {
        }

        BuildTimeEnvConfigSource(Map<String, String> propertyMap, int ordinal) {
            super(propertyMap, ordinal);
        }

        public Set<String> getPropertyNames() {
            return new HashSet<String>();
        }

        public String getName() {
            return "System environment";
        }
    }
}

