/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.init;

import io.quarkus.runtime.PreventFurtherStepsException;
import io.quarkus.runtime.annotations.Recorder;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.ConfigProvider;

@Recorder
public class InitializationTaskRecorder {
    private static final String QUARKUS_INIT_AND_EXIT = "quarkus.init-and-exit";

    public void exitIfNeeded() {
        boolean initAndExitConfigured = StreamSupport.stream(ConfigProvider.getConfig().getPropertyNames().spliterator(), false).anyMatch(n -> QUARKUS_INIT_AND_EXIT.equals(n));
        if (initAndExitConfigured && ((Boolean)ConfigProvider.getConfig().getValue(QUARKUS_INIT_AND_EXIT, Boolean.TYPE)).booleanValue()) {
            throw new PreventFurtherStepsException("Gracefully exiting after initalization.", 0);
        }
    }
}

