/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class RuntimeOverrideConfigSource
implements ConfigSource {
    public static final String FIELD_NAME = "CONFIG";
    public static final String GENERATED_CLASS_NAME = RuntimeOverrideConfigSource.class.getName() + "$$GeneratedMapHolder";
    final Map<String, String> values;

    public RuntimeOverrideConfigSource(ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader.loadClass(GENERATED_CLASS_NAME);
            Map values = (Map)cls.getDeclaredField(FIELD_NAME).get(null);
            this.values = values == null ? Collections.emptyMap() : values;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void setConfig(ClassLoader runtimeClassLoader, Map<String, String> config) {
        try {
            Class<?> cls = runtimeClassLoader.loadClass(GENERATED_CLASS_NAME);
            cls.getDeclaredField(FIELD_NAME).set(null, new HashMap<String, String>(config));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Map<String, String> getProperties() {
        return new HashMap<String, String>(this.values);
    }

    public Set<String> getPropertyNames() {
        return this.values.keySet();
    }

    public int getOrdinal() {
        return 399;
    }

    public String getValue(String s) {
        return this.values.get(s);
    }

    public String getName() {
        return "Config Override Config Source";
    }

    public static void registerRuntimeOverrideConfigSource(SmallRyeConfigBuilder builder) {
        builder.withSources(new ConfigSource[]{new RuntimeOverrideConfigSource(builder.getClassLoader())});
    }
}

