/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public final class ConfigDiagnostic {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");
    private static final List<String> errorsMessages = new CopyOnWriteArrayList<String>();
    private static final Set<String> errorKeys = new CopyOnWriteArraySet<String>();
    private static final DirectoryStream.Filter<Path> CONFIG_FILES_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) {
            String filename = entry.getFileName().toString();
            return Files.isRegularFile(entry, new LinkOption[0]) && filename.startsWith("application.") && !filename.endsWith(".properties");
        }
    };

    private ConfigDiagnostic() {
    }

    public static void invalidValue(String name, IllegalArgumentException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("An invalid value was given for configuration key \"%s\"", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void missingValue(String name, NoSuchElementException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("Configuration key \"%s\" is required, but its value is empty/missing", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void duplicate(String name) {
        String loggedMessage = String.format("Configuration key \"%s\" was specified more than once", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void deprecated(String name) {
        log.warnf("Configuration key \"%s\" is deprecated", (Object)name);
    }

    public static void unknown(String name) {
        log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored; verify that the dependency extension for this configuration is set or that you did not make a typo", (Object)name);
    }

    public static void unknown(NameIterator name) {
        ConfigDiagnostic.unknown(name.getName());
    }

    public static void unknownProperties(Set<String> properties) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        HashSet<String> usedProperties = new HashSet<String>();
        for (String property : config.getPropertyNames()) {
            if (properties.contains(property)) continue;
            usedProperties.add(StringUtil.replaceNonAlphanumericByUnderscores((String)property));
        }
        usedProperties.removeAll(properties);
        for (String property : properties) {
            ConfigValue configValue;
            if (property.contains("[") && property.contains("]")) continue;
            boolean found = false;
            for (String usedProperty : usedProperties) {
                if (!usedProperty.equalsIgnoreCase(StringUtil.replaceNonAlphanumericByUnderscores((String)property))) continue;
                found = true;
                break;
            }
            if (found || !property.equals((configValue = config.getConfigValue(property)).getName())) continue;
            ConfigDiagnostic.unknown(property);
        }
    }

    public static void unknownRunTime(String name) {
        if (ImageMode.current() == ImageMode.NATIVE_RUN) {
            ConfigDiagnostic.unknown(name);
        }
    }

    public static void unknownRunTime(NameIterator name) {
        ConfigDiagnostic.unknownRunTime(name.getName());
    }

    public static void unknownPropertiesRuntime(Set<String> properties) {
        if (ImageMode.current() == ImageMode.NATIVE_RUN) {
            ConfigDiagnostic.unknownProperties(properties);
        }
    }

    public static boolean isError() {
        return !errorsMessages.isEmpty();
    }

    public static void resetError() {
        errorKeys.clear();
        errorsMessages.clear();
    }

    public static String getNiceErrorMessage() {
        StringBuilder b = new StringBuilder();
        for (String errorsMessage : errorsMessages) {
            b.append("  - ");
            b.append(errorsMessage);
            b.append(System.lineSeparator());
        }
        return b.toString();
    }

    public static Set<String> getErrorKeys() {
        return new HashSet<String>(errorKeys);
    }

    public static Set<String> configFiles(Path configFilesLocation) throws IOException {
        if (!Files.exists(configFilesLocation, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<String> configFiles = new HashSet<String>();
        try (DirectoryStream<Path> candidates = Files.newDirectoryStream(configFilesLocation, CONFIG_FILES_FILTER);){
            for (Path candidate : candidates) {
                configFiles.add(candidate.toUri().toURL().toString());
            }
        }
        catch (NotDirectoryException ignored) {
            log.debugf("File %s is not a directory", (Object)configFilesLocation.toAbsolutePath());
            return Collections.emptySet();
        }
        return configFiles;
    }

    public static Set<String> configFilesFromLocations() throws Exception {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        final HashSet<String> configFiles = new HashSet<String>();
        configFiles.addAll(ConfigDiagnostic.configFiles(Paths.get(System.getProperty("user.dir"), "config")));
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(new Consumer<List<URI>>(){

            @Override
            public void accept(List<URI> locations) {
                for (URI location : locations) {
                    Path path = location.getScheme() != null && location.getScheme().equals("file") ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    try {
                        configFiles.addAll(ConfigDiagnostic.configFiles(path));
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        return configFiles;
    }

    public static void unknownConfigFiles(Set<String> configFiles) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        HashSet<String> configNames = new HashSet<String>();
        for (ConfigSource configSource : config.getConfigSources()) {
            if (configSource.getName() == null || !configSource.getName().contains("application")) continue;
            configNames.add(configSource.getName());
        }
        for (String configFile : configFiles) {
            boolean found = false;
            for (String configName : configNames) {
                if (!configName.contains(configFile)) continue;
                found = true;
                break;
            }
            if (found) continue;
            log.warnf("Unrecognized configuration file %s found; Please, check if your are providing the proper extension to load the file", (Object)configFile);
        }
    }
}

