/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.creator;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.creator.AppCreatorException;
import io.quarkus.creator.CuratedTask;
import io.quarkus.creator.DependenciesOrigin;
import io.quarkus.creator.VersionUpdate;
import io.quarkus.creator.VersionUpdateNumber;
import io.quarkus.creator.curator.CurateOutcome;
import io.quarkus.creator.curator.Curator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CuratedApplicationCreator
implements AutoCloseable {
    private final AppModelResolver artifactResolver;
    private final AppArtifact appArtifact;
    private final Path workDir;
    private boolean deleteTmpDir = true;
    private final DependenciesOrigin depsOrigin;
    private final VersionUpdate update;
    private final VersionUpdateNumber updateNumber;
    private final Path localRepo;
    private final String baseName;

    public static Builder builder() {
        return new Builder();
    }

    private CuratedApplicationCreator(Builder builder) {
        String name;
        int i;
        boolean del;
        this.artifactResolver = builder.modelResolver;
        this.appArtifact = builder.appArtifact;
        this.depsOrigin = builder.depsOrigin;
        this.update = builder.update;
        this.updateNumber = builder.updateNumber;
        this.localRepo = builder.localRepo;
        if (builder.workDir != null) {
            del = false;
            this.workDir = builder.workDir;
        } else {
            try {
                this.workDir = Files.createTempDirectory("quarkus-build", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            del = true;
        }
        this.deleteTmpDir = del;
        String finalName = builder.baseName;
        if (finalName == null && this.appArtifact != null && this.appArtifact.getPath() != null && (i = (name = CuratedApplicationCreator.toUri(this.appArtifact.getPath().getFileName())).lastIndexOf(46)) > 0) {
            finalName = name.substring(0, i);
        }
        this.baseName = finalName;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public AppModelResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public AppArtifact getAppArtifact() throws AppCreatorException {
        return this.appArtifact;
    }

    public DependenciesOrigin getDepsOrigin() {
        return this.depsOrigin;
    }

    public VersionUpdate getUpdate() {
        return this.update;
    }

    public VersionUpdateNumber getUpdateNumber() {
        return this.updateNumber;
    }

    public Path getLocalRepo() {
        return this.localRepo;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Path createWorkDir(String ... names) throws AppCreatorException {
        Path p = this.getWorkPath(names);
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new AppCreatorException("Failed to create directory " + p, e);
        }
        return p;
    }

    public <T> T runTask(CuratedTask<T> task) throws AppCreatorException {
        CurateOutcome curateResult = Curator.run(this);
        return task.run(curateResult, this);
    }

    public Path getWorkPath(String ... names) {
        if (names.length == 0) {
            return this.workDir;
        }
        Path p = this.workDir;
        for (String name : names) {
            p = p.resolve(name);
        }
        return p;
    }

    @Override
    public void close() {
        if (this.deleteTmpDir) {
            IoUtils.recursiveDelete((Path)this.workDir);
        }
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            CuratedApplicationCreator.toUri(b, path, seg + 1);
        }
        return b;
    }

    private static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return CuratedApplicationCreator.toUri(new StringBuilder(), path, 0).toString();
    }

    public static class Builder {
        public String baseName;
        private AppArtifact appArtifact;
        private Path workDir;
        private AppModelResolver modelResolver;
        private DependenciesOrigin depsOrigin = DependenciesOrigin.APPLICATION;
        private VersionUpdate update = VersionUpdate.NONE;
        private VersionUpdateNumber updateNumber = VersionUpdateNumber.MICRO;
        private Path localRepo;

        private Builder() {
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Builder setWorkDir(Path dir) {
            this.workDir = dir;
            return this;
        }

        public Builder setModelResolver(AppModelResolver resolver) {
            this.modelResolver = resolver;
            return this;
        }

        public Builder setAppArtifact(AppArtifact appArtifact) {
            this.appArtifact = appArtifact;
            return this;
        }

        public Builder setAppArtifact(Path path) throws AppCreatorException {
            try {
                this.appArtifact = ModelUtils.resolveAppArtifact((Path)path);
                this.appArtifact.setPath(path);
            }
            catch (IOException e) {
                throw new AppCreatorException("Unable to resolve app artifact " + path);
            }
            return this;
        }

        public Builder setDepsOrigin(DependenciesOrigin depsOrigin) {
            this.depsOrigin = depsOrigin;
            return this;
        }

        public Builder setUpdate(VersionUpdate update) {
            this.update = update;
            return this;
        }

        public Builder setUpdateNumber(VersionUpdateNumber updateNumber) {
            this.updateNumber = updateNumber;
            return this;
        }

        public Builder setLocalRepo(Path localRepo) {
            this.localRepo = localRepo;
            return this;
        }

        public CuratedApplicationCreator build() throws AppCreatorException {
            return new CuratedApplicationCreator(this);
        }
    }
}

