/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime.graal;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.sql.Connection;
import java.util.function.BooleanSupplier;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.util.ClassUtils;

@TargetClass(className="org.flywaydb.database.oracle.OracleDatabaseType", onlyWith={OracleAvailable.class, OracleDriverUnavailable.class})
public final class OracleDatabaseTypeSubstitution {
    @Substitute
    public Connection alterConnectionAsNeeded(Connection connection, Configuration configuration) {
        return connection;
    }

    public static final class OracleAvailable
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ClassUtils.isPresent((String)"org.flywaydb.database.oracle.OracleDatabaseType", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    public static final class OracleDriverUnavailable
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !ClassUtils.isPresent((String)"oracle.jdbc.OracleConnection", (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }
}

