/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.stubs;

import io.grpc.stub.StreamObserver;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class ManyToOneObserver<I, O>
extends AbstractUni<O>
implements StreamObserver<O> {
    private final StreamObserver<I> processor;
    private final Multi<I> source;
    private final UpstreamSubscriber subscriber = new UpstreamSubscriber();
    private final AtomicReference<Flow.Subscription> upstream = new AtomicReference();
    private volatile UniSubscriber<? super O> downstream;

    public ManyToOneObserver(Multi<I> source, Function<StreamObserver<O>, StreamObserver<I>> function) {
        this.processor = function.apply(this);
        this.source = source;
    }

    public void subscribe(UniSubscriber<? super O> subscriber) {
        this.downstream = subscriber;
        this.source.subscribe((Flow.Subscriber)this.subscriber);
    }

    public void onNext(O value) {
        this.cancelUpstream();
        this.downstream.onItem(value);
    }

    public void onError(Throwable t) {
        this.cancelUpstream();
        this.downstream.onFailure(t);
    }

    public void onCompleted() {
        this.cancelUpstream();
    }

    private void cancelUpstream() {
        Flow.Subscription subscription = this.upstream.getAndSet((Flow.Subscription)Subscriptions.CANCELLED);
        if (subscription != null) {
            subscription.cancel();
        }
    }

    class UpstreamSubscriber
    implements Flow.Subscriber<I>,
    UniSubscription {
        UpstreamSubscriber() {
        }

        @Override
        public void onSubscribe(Flow.Subscription items) {
            if (!ManyToOneObserver.this.upstream.compareAndSet(null, items)) {
                items.cancel();
            } else {
                ManyToOneObserver.this.downstream.onSubscribe((UniSubscription)this);
                items.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(I item) {
            ManyToOneObserver.this.processor.onNext(item);
        }

        @Override
        public void onError(Throwable t) {
            ManyToOneObserver.this.processor.onError(t);
        }

        @Override
        public void onComplete() {
            ManyToOneObserver.this.processor.onCompleted();
        }

        public void cancel() {
            ManyToOneObserver.this.cancelUpstream();
        }
    }
}

