/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

@RequestScoped
public class RequestScopedEntityManagerHolder {
    private final Map<String, EntityManager> entityManagers = new HashMap<String, EntityManager>();

    public EntityManager getOrCreateEntityManager(String name, EntityManagerFactory factory) {
        return this.entityManagers.computeIfAbsent(name, n -> factory.createEntityManager());
    }

    @PreDestroy
    public void destroy() {
        for (Map.Entry<String, EntityManager> entry : this.entityManagers.entrySet()) {
            entry.getValue().close();
        }
    }
}

