/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedEntityManagerHolder;
import io.quarkus.hibernate.orm.runtime.entitymanager.TransactionScopedEntityManager;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

@ApplicationScoped
public class TransactionEntityManagers {
    @Inject
    JPAConfig jpaConfig;
    @Inject
    Instance<RequestScopedEntityManagerHolder> requestScopedEntityManagers;
    private final ConcurrentMap<String, TransactionScopedEntityManager> managers = new ConcurrentHashMap<String, TransactionScopedEntityManager>();

    public EntityManager getEntityManager(String unitName) {
        TransactionScopedEntityManager entityManager = (TransactionScopedEntityManager)this.managers.get(unitName);
        if (entityManager != null) {
            return entityManager;
        }
        return this.managers.computeIfAbsent(unitName, un -> new TransactionScopedEntityManager(this.getTransactionManager(), this.getTransactionSynchronizationRegistry(), this.jpaConfig.getEntityManagerFactory((String)un), (String)un, this.requestScopedEntityManagers));
    }

    private TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0]).get();
    }
}

