/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.metrics;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.metrics.Counter;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;

public class HibernateCounter
implements Counter {
    private volatile SessionFactory sessionFactory;
    private String persistenceUnitName;
    private String metric;

    public HibernateCounter() {
    }

    public HibernateCounter(String persistenceUnitName, String metric) {
        this.persistenceUnitName = persistenceUnitName;
        this.metric = metric;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public long getCount() {
        Statistics statistics = this.getSessionFactory().getStatistics();
        switch (this.metric) {
            case "sessionsOpened": {
                return statistics.getSessionOpenCount();
            }
            case "sessionsClosed": {
                return statistics.getSessionCloseCount();
            }
            case "transactionCount": {
                return statistics.getTransactionCount();
            }
            case "successfulTransactions": {
                return statistics.getSuccessfulTransactionCount();
            }
            case "optimisticLockFailures": {
                return statistics.getOptimisticFailureCount();
            }
            case "flushes": {
                return statistics.getFlushCount();
            }
            case "connectionsObtained": {
                return statistics.getConnectCount();
            }
            case "statementsPrepared": {
                return statistics.getPrepareStatementCount();
            }
            case "statementsClosed": {
                return statistics.getCloseStatementCount();
            }
            case "secondLevelCachePuts": {
                return statistics.getSecondLevelCachePutCount();
            }
            case "secondLevelCacheHits": {
                return statistics.getSecondLevelCacheHitCount();
            }
            case "secondLevelCacheMisses": {
                return statistics.getSecondLevelCacheMissCount();
            }
            case "entitiesLoaded": {
                return statistics.getEntityLoadCount();
            }
            case "entitiesUpdated": {
                return statistics.getEntityUpdateCount();
            }
            case "entitiesInserted": {
                return statistics.getEntityInsertCount();
            }
            case "entitiesDeleted": {
                return statistics.getEntityDeleteCount();
            }
            case "entitiesFetched": {
                return statistics.getEntityFetchCount();
            }
            case "collectionsLoaded": {
                return statistics.getCollectionLoadCount();
            }
            case "collectionsUpdated": {
                return statistics.getCollectionUpdateCount();
            }
            case "collectionsRemoved": {
                return statistics.getCollectionRemoveCount();
            }
            case "collectionsRecreated": {
                return statistics.getCollectionRecreateCount();
            }
            case "collectionsFetched": {
                return statistics.getCollectionFetchCount();
            }
            case "naturalIdQueriesExecutedToDatabase": {
                return statistics.getNaturalIdQueryExecutionCount();
            }
            case "naturalIdCachePuts": {
                return statistics.getNaturalIdCachePutCount();
            }
            case "naturalIdCacheHits": {
                return statistics.getNaturalIdCacheHitCount();
            }
            case "naturalIdCacheMisses": {
                return statistics.getNaturalIdCacheMissCount();
            }
            case "queriesExecutedToDatabase": {
                return statistics.getQueryExecutionCount();
            }
            case "queryCachePuts": {
                return statistics.getQueryCachePutCount();
            }
            case "queryCacheHits": {
                return statistics.getQueryCacheHitCount();
            }
            case "queryCacheMisses": {
                return statistics.getQueryCacheMissCount();
            }
            case "updateTimestampsCachePuts": {
                return statistics.getUpdateTimestampsCachePutCount();
            }
            case "updateTimestampsCacheHits": {
                return statistics.getUpdateTimestampsCacheHitCount();
            }
            case "updateTimestampsCacheMisses": {
                return statistics.getUpdateTimestampsCacheMissCount();
            }
        }
        throw new IllegalArgumentException("Unknown data source metric");
    }

    public void inc() {
        throw new IllegalStateException("Hibernate metrics values are computed from Hibernate statistics objects and should not be updated manually");
    }

    public void inc(long n) {
        throw new IllegalStateException("Hibernate metrics values are computed from Hibernate statistics objects and should not be updated manually");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionFactory getSessionFactory() {
        SessionFactory sfLocal = this.sessionFactory;
        if (sfLocal == null) {
            HibernateCounter hibernateCounter = this;
            synchronized (hibernateCounter) {
                sfLocal = this.sessionFactory;
                if (sfLocal == null) {
                    this.sessionFactory = sfLocal = (SessionFactory)((JPAConfig)Arc.container().instance(JPAConfig.class, new Annotation[0]).get()).getEntityManagerFactory(this.persistenceUnitName != null ? this.persistenceUnitName : "default").unwrap(SessionFactory.class);
                }
            }
        }
        return sfLocal;
    }
}

