/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public final class HibernateMultiTenantConnectionProvider
extends AbstractMultiTenantConnectionProvider {
    private static final Logger LOG = Logger.getLogger(HibernateMultiTenantConnectionProvider.class);
    private final Map<String, ConnectionProvider> providerMap = new ConcurrentHashMap<String, ConnectionProvider>();

    protected ConnectionProvider getAnyConnectionProvider() {
        String tenantId = HibernateMultiTenantConnectionProvider.tenantResolver().getDefaultTenantId();
        if (tenantId == null) {
            throw new IllegalStateException("Method 'TenantResolver.getDefaultTenantId()' returned a null value. This violates the contract of the interface!");
        }
        return this.selectConnectionProvider(tenantId);
    }

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        LOG.debugv("selectConnectionProvider({0})", (Object)tenantIdentifier);
        ConnectionProvider provider = this.providerMap.get(tenantIdentifier);
        if (provider == null) {
            ConnectionProvider connectionProvider = HibernateMultiTenantConnectionProvider.resolveConnectionProvider(tenantIdentifier);
            this.providerMap.put(tenantIdentifier, connectionProvider);
            return connectionProvider;
        }
        return provider;
    }

    private static ConnectionProvider resolveConnectionProvider(String tenantIdentifier) {
        LOG.debugv("resolveConnectionProvider({0})", (Object)tenantIdentifier);
        InstanceHandle instance = Arc.container().instance(TenantConnectionResolver.class, new Annotation[0]);
        if (!instance.isAvailable()) {
            throw new IllegalStateException("No instance of " + TenantConnectionResolver.class.getSimpleName() + " was found. You need to create an implementation for this interface to allow resolving the current tenant connection.");
        }
        TenantConnectionResolver resolver = (TenantConnectionResolver)instance.get();
        ConnectionProvider cp = resolver.resolve(tenantIdentifier);
        if (cp == null) {
            throw new IllegalStateException("Method 'TenantConnectionResolver.resolve(String)' returned a null value. This violates the contract of the interface!");
        }
        return cp;
    }

    private static TenantResolver tenantResolver() {
        InstanceHandle resolverInstance = Arc.container().instance(TenantResolver.class, new Annotation[0]);
        if (!resolverInstance.isAvailable()) {
            throw new IllegalStateException("No instance of " + TenantResolver.class.getName() + " was found. You need to create an implementation for this interface to allow resolving the current tenant identifier.");
        }
        return (TenantResolver)resolverInstance.get();
    }
}

