/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.session;

import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.session.JTASessionOpener;
import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.runtime.BlockingOperationNotAllowedException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TransactionRequiredException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MultiIdentifierLoadAccess;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.graph.RootGraph;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.NativeQuery;
import org.hibernate.stat.SessionStatistics;

public class TransactionScopedSession
implements Session {
    protected static final String TRANSACTION_IS_NOT_ACTIVE = "Transaction is not active, consider adding @Transactional to your method to automatically activate one.";
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final SessionFactory sessionFactory;
    private final JTASessionOpener jtaSessionOpener;
    private final String unitName;
    private final String sessionKey;
    private final Instance<RequestScopedSessionHolder> requestScopedSessions;

    public TransactionScopedSession(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, SessionFactory sessionFactory, String unitName, Instance<RequestScopedSessionHolder> requestScopedSessions) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.sessionFactory = sessionFactory;
        this.jtaSessionOpener = JTASessionOpener.create(sessionFactory);
        this.unitName = unitName;
        this.sessionKey = this.getClass().getSimpleName() + "-" + unitName;
        this.requestScopedSessions = requestScopedSessions;
    }

    SessionResult acquireSession() {
        if (this.isInTransaction()) {
            Session session = (Session)this.transactionSynchronizationRegistry.getResource((Object)this.sessionKey);
            if (session != null) {
                return new SessionResult(session, false, true);
            }
            Session newSession = this.jtaSessionOpener.openSession();
            this.transactionSynchronizationRegistry.putResource((Object)this.sessionKey, (Object)newSession);
            return new SessionResult(newSession, false, true);
        }
        RequestScopedSessionHolder requestScopedSessions = (RequestScopedSessionHolder)this.requestScopedSessions.get();
        return new SessionResult(requestScopedSessions.getOrCreateSession(this.unitName, this.sessionFactory), false, false);
    }

    private void checkBlocking() {
        if (!BlockingOperationControl.isBlockingAllowed()) {
            throw new BlockingOperationNotAllowedException("You have attempted to perform a blocking operation on a IO thread. This is not allowed, as blocking the IO thread will cause major performance issues with your application. If you want to perform blocking EntityManager operations make sure you are doing it from a worker thread.");
        }
    }

    private boolean isInTransaction() {
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void persist(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.persist(entity);
        }
    }

    public Object merge(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            Object object = emr.session.merge(entity);
            return object;
        }
    }

    public void remove(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.remove(entity);
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.find(entityClass, primaryKey);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.find(entityClass, primaryKey, properties);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.find(entityClass, primaryKey, lockMode);
            return (T)object;
        }
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.find(entityClass, primaryKey, lockMode, properties);
            return (T)object;
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.getReference(entityClass, primaryKey);
            return (T)object;
        }
    }

    public void flush() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.flush();
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setFlushMode(flushMode);
        }
    }

    public FlushModeType getFlushMode() {
        try (SessionResult emr = this.acquireSession();){
            FlushModeType flushModeType = emr.session.getFlushMode();
            return flushModeType;
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.lock(entity, lockMode);
        }
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.lock(entity, lockMode, properties);
        }
    }

    public void refresh(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.refresh(entity);
        }
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.refresh(entity, properties);
        }
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.refresh(entity, lockMode);
        }
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            if (!emr.allowModification) {
                throw new TransactionRequiredException(TRANSACTION_IS_NOT_ACTIVE);
            }
            emr.session.refresh(entity, lockMode, properties);
        }
    }

    public void clear() {
        try (SessionResult emr = this.acquireSession();){
            emr.session.clear();
        }
    }

    public void detach(Object entity) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.detach(entity);
        }
    }

    public boolean contains(Object entity) {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.contains(entity);
            return bl;
        }
    }

    public LockModeType getLockMode(Object entity) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            LockModeType lockModeType = emr.session.getLockMode(entity);
            return lockModeType;
        }
    }

    public void setProperty(String propertyName, Object value) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setProperty(propertyName, value);
        }
    }

    public Map<String, Object> getProperties() {
        try (SessionResult emr = this.acquireSession();){
            Map map = emr.session.getProperties();
            return map;
        }
    }

    public org.hibernate.query.Query createQuery(String qlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createQuery(qlString);
            return query;
        }
    }

    public <T> org.hibernate.query.Query<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createQuery(criteriaQuery);
            return query;
        }
    }

    public org.hibernate.query.Query createQuery(CriteriaUpdate updateQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createQuery(updateQuery);
            return query;
        }
    }

    public org.hibernate.query.Query createQuery(CriteriaDelete deleteQuery) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createQuery(deleteQuery);
            return query;
        }
    }

    public <T> org.hibernate.query.Query<T> createQuery(String qlString, Class<T> resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createQuery(qlString, resultClass);
            return query;
        }
    }

    public org.hibernate.query.Query createNamedQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createNamedQuery(name);
            return query;
        }
    }

    public <T> org.hibernate.query.Query<T> createNamedQuery(String name, Class<T> resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.createNamedQuery(name, resultClass);
            return query;
        }
    }

    public NativeQuery createNativeQuery(String sqlString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.session.createNativeQuery(sqlString);
            return nativeQuery;
        }
    }

    public NativeQuery createNativeQuery(String sqlString, Class resultClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.session.createNativeQuery(sqlString, resultClass);
            return nativeQuery;
        }
    }

    public NativeQuery createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.session.createNativeQuery(sqlString, resultSetMapping);
            return nativeQuery;
        }
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            StoredProcedureQuery storedProcedureQuery = emr.session.createNamedStoredProcedureQuery(name);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            StoredProcedureQuery storedProcedureQuery = emr.session.createStoredProcedureQuery(procedureName);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            StoredProcedureQuery storedProcedureQuery = emr.session.createStoredProcedureQuery(procedureName, resultClasses);
            return storedProcedureQuery;
        }
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            StoredProcedureQuery storedProcedureQuery = emr.session.createStoredProcedureQuery(procedureName, resultSetMappings);
            return storedProcedureQuery;
        }
    }

    public void joinTransaction() {
        try (SessionResult emr = this.acquireSession();){
            emr.session.joinTransaction();
        }
    }

    public boolean isJoinedToTransaction() {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isJoinedToTransaction();
            return bl;
        }
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(Session.class)) {
            return (T)this;
        }
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.unwrap(cls);
            return (T)object;
        }
    }

    public Object getDelegate() {
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.getDelegate();
            return object;
        }
    }

    public void close() {
        throw new IllegalStateException("Not supported for transaction scoped entity managers");
    }

    public boolean isOpen() {
        return true;
    }

    public Transaction getTransaction() {
        throw new IllegalStateException("Not supported for JTA entity managers");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            CriteriaBuilder criteriaBuilder = emr.session.getCriteriaBuilder();
            return criteriaBuilder;
        }
    }

    public Metamodel getMetamodel() {
        try (SessionResult emr = this.acquireSession();){
            Metamodel metamodel = emr.session.getMetamodel();
            return metamodel;
        }
    }

    public <T> RootGraph<T> createEntityGraph(Class<T> rootType) {
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.session.createEntityGraph(rootType);
            return rootGraph;
        }
    }

    public RootGraph<?> createEntityGraph(String graphName) {
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.session.createEntityGraph(graphName);
            return rootGraph;
        }
    }

    public RootGraph<?> getEntityGraph(String graphName) {
        try (SessionResult emr = this.acquireSession();){
            RootGraph rootGraph = emr.session.getEntityGraph(graphName);
            return rootGraph;
        }
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try (SessionResult emr = this.acquireSession();){
            List list = emr.session.getEntityGraphs(entityClass);
            return list;
        }
    }

    public SharedSessionBuilder sessionWithOptions() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SharedSessionBuilder sharedSessionBuilder = emr.session.sessionWithOptions();
            return sharedSessionBuilder;
        }
    }

    @Deprecated
    public void setFlushMode(FlushMode flushMode) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setFlushMode(flushMode);
        }
    }

    public void setHibernateFlushMode(FlushMode flushMode) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setHibernateFlushMode(flushMode);
        }
    }

    public FlushMode getHibernateFlushMode() {
        try (SessionResult emr = this.acquireSession();){
            FlushMode flushMode = emr.session.getHibernateFlushMode();
            return flushMode;
        }
    }

    public void setCacheMode(CacheMode cacheMode) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setCacheMode(cacheMode);
        }
    }

    public CacheMode getCacheMode() {
        try (SessionResult emr = this.acquireSession();){
            CacheMode cacheMode = emr.session.getCacheMode();
            return cacheMode;
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void cancelQuery() throws HibernateException {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.cancelQuery();
        }
    }

    public boolean isDirty() throws HibernateException {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isDirty();
            return bl;
        }
    }

    public boolean isDefaultReadOnly() {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isDefaultReadOnly();
            return bl;
        }
    }

    public void setDefaultReadOnly(boolean readOnly) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setDefaultReadOnly(readOnly);
        }
    }

    public Serializable getIdentifier(Object object) {
        try (SessionResult emr = this.acquireSession();){
            Serializable serializable = emr.session.getIdentifier(object);
            return serializable;
        }
    }

    public boolean contains(String entityName, Object object) {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.contains(entityName, object);
            return bl;
        }
    }

    public void evict(Object object) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.evict(object);
        }
    }

    public <T> T load(Class<T> theClass, Serializable id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(theClass, id, lockMode);
            return (T)object;
        }
    }

    public <T> T load(Class<T> theClass, Serializable id, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(theClass, id, lockOptions);
            return (T)object;
        }
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(entityName, id, lockMode);
            return object;
        }
    }

    public Object load(String entityName, Serializable id, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(entityName, id, lockOptions);
            return object;
        }
    }

    public <T> T load(Class<T> theClass, Serializable id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(theClass, id);
            return (T)object;
        }
    }

    public Object load(String entityName, Serializable id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.load(entityName, id);
            return object;
        }
    }

    public void load(Object object, Serializable id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.load(object, id);
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.replicate(object, replicationMode);
        }
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.replicate(entityName, object, replicationMode);
        }
    }

    public Serializable save(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Serializable serializable = emr.session.save(object);
            return serializable;
        }
    }

    public Serializable save(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Serializable serializable = emr.session.save(entityName, object);
            return serializable;
        }
    }

    public void saveOrUpdate(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.saveOrUpdate(object);
        }
    }

    public void saveOrUpdate(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.saveOrUpdate(entityName, object);
        }
    }

    public void update(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.update(object);
        }
    }

    public void update(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.update(entityName, object);
        }
    }

    public Object merge(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object2 = emr.session.merge(entityName, object);
            return object2;
        }
    }

    public void persist(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.persist(entityName, object);
        }
    }

    public void delete(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.delete(object);
        }
    }

    public void delete(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.delete(entityName, object);
        }
    }

    public void lock(Object object, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.lock(object, lockMode);
        }
    }

    public void lock(String entityName, Object object, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.lock(entityName, object, lockMode);
        }
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Session.LockRequest lockRequest = emr.session.buildLockRequest(lockOptions);
            return lockRequest;
        }
    }

    public void refresh(String entityName, Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.refresh(entityName, object);
        }
    }

    public void refresh(Object object, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.refresh(object, lockMode);
        }
    }

    public void refresh(Object object, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.refresh(object, lockOptions);
        }
    }

    public void refresh(String entityName, Object object, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.refresh(entityName, object, lockOptions);
        }
    }

    public LockMode getCurrentLockMode(Object object) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            LockMode lockMode = emr.session.getCurrentLockMode(object);
            return lockMode;
        }
    }

    @Deprecated
    public Query createFilter(Object collection, String queryString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.session.createFilter(collection, queryString);
            return query;
        }
    }

    public <T> T get(Class<T> entityType, Serializable id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityType, id);
            return (T)object;
        }
    }

    public <T> T get(Class<T> entityType, Serializable id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityType, id, lockMode);
            return (T)object;
        }
    }

    public <T> T get(Class<T> entityType, Serializable id, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityType, id, lockOptions);
            return (T)object;
        }
    }

    public Object get(String entityName, Serializable id) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityName, id);
            return object;
        }
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityName, id, lockMode);
            return object;
        }
    }

    public Object get(String entityName, Serializable id, LockOptions lockOptions) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.get(entityName, id, lockOptions);
            return object;
        }
    }

    public String getEntityName(Object object) {
        try (SessionResult emr = this.acquireSession();){
            String string = emr.session.getEntityName(object);
            return string;
        }
    }

    public IdentifierLoadAccess byId(String entityName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            IdentifierLoadAccess identifierLoadAccess = emr.session.byId(entityName);
            return identifierLoadAccess;
        }
    }

    public <T> MultiIdentifierLoadAccess<T> byMultipleIds(Class<T> entityClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MultiIdentifierLoadAccess multiIdentifierLoadAccess = emr.session.byMultipleIds(entityClass);
            return multiIdentifierLoadAccess;
        }
    }

    public MultiIdentifierLoadAccess byMultipleIds(String entityName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            MultiIdentifierLoadAccess multiIdentifierLoadAccess = emr.session.byMultipleIds(entityName);
            return multiIdentifierLoadAccess;
        }
    }

    public <T> IdentifierLoadAccess<T> byId(Class<T> entityClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            IdentifierLoadAccess identifierLoadAccess = emr.session.byId(entityClass);
            return identifierLoadAccess;
        }
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NaturalIdLoadAccess naturalIdLoadAccess = emr.session.byNaturalId(entityName);
            return naturalIdLoadAccess;
        }
    }

    public <T> NaturalIdLoadAccess<T> byNaturalId(Class<T> entityClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NaturalIdLoadAccess naturalIdLoadAccess = emr.session.byNaturalId(entityClass);
            return naturalIdLoadAccess;
        }
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SimpleNaturalIdLoadAccess simpleNaturalIdLoadAccess = emr.session.bySimpleNaturalId(entityName);
            return simpleNaturalIdLoadAccess;
        }
    }

    public <T> SimpleNaturalIdLoadAccess<T> bySimpleNaturalId(Class<T> entityClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            SimpleNaturalIdLoadAccess simpleNaturalIdLoadAccess = emr.session.bySimpleNaturalId(entityClass);
            return simpleNaturalIdLoadAccess;
        }
    }

    public Filter enableFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Filter filter = emr.session.enableFilter(filterName);
            return filter;
        }
    }

    public Filter getEnabledFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Filter filter = emr.session.getEnabledFilter(filterName);
            return filter;
        }
    }

    public void disableFilter(String filterName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.disableFilter(filterName);
        }
    }

    public SessionStatistics getStatistics() {
        try (SessionResult emr = this.acquireSession();){
            SessionStatistics sessionStatistics = emr.session.getStatistics();
            return sessionStatistics;
        }
    }

    public boolean isReadOnly(Object entityOrProxy) {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isReadOnly(entityOrProxy);
            return bl;
        }
    }

    public void setReadOnly(Object entityOrProxy, boolean readOnly) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setReadOnly(entityOrProxy, readOnly);
        }
    }

    public Connection disconnect() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Connection connection = emr.session.disconnect();
            return connection;
        }
    }

    public void reconnect(Connection connection) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.reconnect(connection);
        }
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isFetchProfileEnabled(name);
            return bl;
        }
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        try (SessionResult emr = this.acquireSession();){
            emr.session.enableFetchProfile(name);
        }
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        try (SessionResult emr = this.acquireSession();){
            emr.session.disableFetchProfile(name);
        }
    }

    public TypeHelper getTypeHelper() {
        try (SessionResult emr = this.acquireSession();){
            TypeHelper typeHelper = emr.session.getTypeHelper();
            return typeHelper;
        }
    }

    public LobHelper getLobHelper() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            LobHelper lobHelper = emr.session.getLobHelper();
            return lobHelper;
        }
    }

    public void addEventListeners(SessionEventListener ... listeners) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.addEventListeners(listeners);
        }
    }

    public NativeQuery createSQLQuery(String queryString) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.session.createSQLQuery(queryString);
            return nativeQuery;
        }
    }

    public String getTenantIdentifier() {
        try (SessionResult emr = this.acquireSession();){
            String string = emr.session.getTenantIdentifier();
            return string;
        }
    }

    public boolean isConnected() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            boolean bl = emr.session.isConnected();
            return bl;
        }
    }

    public Transaction beginTransaction() {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Transaction transaction = emr.session.beginTransaction();
            return transaction;
        }
    }

    public org.hibernate.query.Query getNamedQuery(String queryName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            org.hibernate.query.Query query = emr.session.getNamedQuery(queryName);
            return query;
        }
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.session.getNamedProcedureCall(name);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.session.createStoredProcedureCall(procedureName);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.session.createStoredProcedureCall(procedureName, resultClasses);
            return procedureCall;
        }
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            ProcedureCall procedureCall = emr.session.createStoredProcedureCall(procedureName, resultSetMappings);
            return procedureCall;
        }
    }

    @Deprecated
    public Criteria createCriteria(Class persistentClass) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Criteria criteria = emr.session.createCriteria(persistentClass);
            return criteria;
        }
    }

    @Deprecated
    public Criteria createCriteria(Class persistentClass, String alias) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Criteria criteria = emr.session.createCriteria(persistentClass, alias);
            return criteria;
        }
    }

    @Deprecated
    public Criteria createCriteria(String entityName) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Criteria criteria = emr.session.createCriteria(entityName);
            return criteria;
        }
    }

    @Deprecated
    public Criteria createCriteria(String entityName, String alias) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Criteria criteria = emr.session.createCriteria(entityName, alias);
            return criteria;
        }
    }

    public Integer getJdbcBatchSize() {
        try (SessionResult emr = this.acquireSession();){
            Integer n = emr.session.getJdbcBatchSize();
            return n;
        }
    }

    public void setJdbcBatchSize(Integer jdbcBatchSize) {
        try (SessionResult emr = this.acquireSession();){
            emr.session.setJdbcBatchSize(jdbcBatchSize);
        }
    }

    public void doWork(Work work) throws HibernateException {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            emr.session.doWork(work);
        }
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Object object = emr.session.doReturningWork(work);
            return (T)object;
        }
    }

    @Deprecated
    public Query getNamedSQLQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            Query query = emr.session.getNamedSQLQuery(name);
            return query;
        }
    }

    public NativeQuery getNamedNativeQuery(String name) {
        this.checkBlocking();
        try (SessionResult emr = this.acquireSession();){
            NativeQuery nativeQuery = emr.session.getNamedNativeQuery(name);
            return nativeQuery;
        }
    }

    public Session getSession() {
        try (SessionResult emr = this.acquireSession();){
            Session session = emr.session.getSession();
            return session;
        }
    }

    static class SessionResult
    implements AutoCloseable {
        final Session session;
        final boolean closeOnEnd;
        final boolean allowModification;

        SessionResult(Session session, boolean closeOnEnd, boolean allowModification) {
            this.session = session;
            this.closeOnEnd = closeOnEnd;
            this.allowModification = allowModification;
        }

        @Override
        public void close() {
            if (this.closeOnEnd) {
                this.session.close();
            }
        }
    }
}

