/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import io.quarkus.hibernate.orm.runtime.recording.RecordedConfig;
import io.quarkus.hibernate.orm.runtime.service.QuarkusRuntimeInitDialectFactory;
import java.util.Map;
import java.util.Optional;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class QuarkusRuntimeInitDialectFactoryInitiator
implements StandardServiceInitiator<DialectFactory> {
    private final String persistenceUnitName;
    private final Dialect dialect;
    private final Optional<String> datasourceName;
    private final Optional<DatabaseVersion> buildTimeDbVersion;

    public QuarkusRuntimeInitDialectFactoryInitiator(String persistenceUnitName, Dialect dialect, RecordedConfig recordedConfig) {
        this.persistenceUnitName = persistenceUnitName;
        this.dialect = dialect;
        this.datasourceName = recordedConfig.getDataSource();
        this.buildTimeDbVersion = recordedConfig.getDbVersion().isPresent() ? Optional.of(dialect.getVersion()) : Optional.empty();
    }

    public Class<DialectFactory> getServiceInitiated() {
        return DialectFactory.class;
    }

    public DialectFactory initiateService(Map<String, Object> configurationValues, ServiceRegistryImplementor registry) {
        return new QuarkusRuntimeInitDialectFactory(this.persistenceUnitName, this.dialect, this.datasourceName, this.buildTimeDbVersion);
    }
}

