/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.ArtifactTypeUtil;
import io.quarkus.test.junit.DisabledOnIntegrationTest;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import io.quarkus.test.junit.main.QuarkusMainIntegrationTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

public class DisabledOnIntegrationTestCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@DisabledOnIntegrationTest is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        ConditionEvaluationResult disabledOnIntegrationTestReason = this.check(context, element, DisabledOnIntegrationTest.class, DisabledOnIntegrationTest::value, (ec, an) -> {
            DisabledOnIntegrationTest.ArtifactType[] disabledArtifactTypes = an.forArtifactTypes();
            String artifactType = IntegrationTestUtil.getArtifactType(IntegrationTestUtil.readQuarkusArtifactProperties(ec));
            for (DisabledOnIntegrationTest.ArtifactType disabledArtifactType : disabledArtifactTypes) {
                if (disabledArtifactType == DisabledOnIntegrationTest.ArtifactType.ALL) {
                    return true;
                }
                if (disabledArtifactType == DisabledOnIntegrationTest.ArtifactType.CONTAINER && ArtifactTypeUtil.isContainer(artifactType)) {
                    return true;
                }
                if (disabledArtifactType == DisabledOnIntegrationTest.ArtifactType.NATIVE_BINARY && ArtifactTypeUtil.isNativeBinary(artifactType)) {
                    return true;
                }
                if (disabledArtifactType != DisabledOnIntegrationTest.ArtifactType.JAR || !ArtifactTypeUtil.isJar(artifactType)) continue;
                return true;
            }
            return false;
        });
        return Objects.requireNonNullElse(disabledOnIntegrationTestReason, ENABLED);
    }

    private <T extends Annotation> ConditionEvaluationResult check(ExtensionContext context, Optional<AnnotatedElement> element, Class<T> annotationClass, Function<T, String> valueExtractor, BiFunction<ExtensionContext, T, Boolean> predicate) {
        Optional disabled = AnnotationUtils.findAnnotation(element, annotationClass);
        if (disabled.isPresent()) {
            boolean it;
            boolean bl = it = AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusIntegrationTest.class).isPresent() || AnnotationUtils.findAnnotation((Optional)context.getTestClass(), QuarkusMainIntegrationTest.class).isPresent();
            if (it && (predicate == null || predicate.apply(context, (ExtensionContext)((Annotation)disabled.get())).booleanValue())) {
                String reason = disabled.map(valueExtractor).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is @DisabledOnIntegrationTest");
                return ConditionEvaluationResult.disabled((String)reason);
            }
        }
        return null;
    }
}

