/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.QualifierRegistrarBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.QualifierRegistrar;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.panache.common.deployment.PanacheEntityClassesBuildItem;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EngineConfiguration;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Expression;
import io.quarkus.qute.Expressions;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.Namespaces;
import io.quarkus.qute.ParameterDeclaration;
import io.quarkus.qute.ParserHelper;
import io.quarkus.qute.ParserHook;
import io.quarkus.qute.ResultNode;
import io.quarkus.qute.SectionHelper;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.Variant;
import io.quarkus.qute.deployment.CheckedFragmentValidationBuildItem;
import io.quarkus.qute.deployment.CheckedTemplateAdapter;
import io.quarkus.qute.deployment.CheckedTemplateAdapterBuildItem;
import io.quarkus.qute.deployment.CheckedTemplateBuildItem;
import io.quarkus.qute.deployment.CustomTemplateLocatorPatternsBuildItem;
import io.quarkus.qute.deployment.EngineConfigurationsBuildItem;
import io.quarkus.qute.deployment.GeneratedTemplateInitializerBuildItem;
import io.quarkus.qute.deployment.GeneratedValueResolverBuildItem;
import io.quarkus.qute.deployment.ImplicitValueResolverBuildItem;
import io.quarkus.qute.deployment.IncorrectExpressionBuildItem;
import io.quarkus.qute.deployment.MessageBundleMethodBuildItem;
import io.quarkus.qute.deployment.MessageBundleProcessor;
import io.quarkus.qute.deployment.Names;
import io.quarkus.qute.deployment.NativeCheckedTemplateEnhancer;
import io.quarkus.qute.deployment.TemplateDataBuildItem;
import io.quarkus.qute.deployment.TemplateDataBuilder;
import io.quarkus.qute.deployment.TemplateExpressionMatchesBuildItem;
import io.quarkus.qute.deployment.TemplateExtensionMethodBuildItem;
import io.quarkus.qute.deployment.TemplateFilePathsBuildItem;
import io.quarkus.qute.deployment.TemplateGlobalBuildItem;
import io.quarkus.qute.deployment.TemplatePathBuildItem;
import io.quarkus.qute.deployment.TemplateRecordEnhancer;
import io.quarkus.qute.deployment.TemplateVariantsBuildItem;
import io.quarkus.qute.deployment.TemplatesAnalysisBuildItem;
import io.quarkus.qute.deployment.TypeCheckExcludeBuildItem;
import io.quarkus.qute.deployment.TypeInfos;
import io.quarkus.qute.deployment.Types;
import io.quarkus.qute.generator.ExtensionMethodGenerator;
import io.quarkus.qute.generator.TemplateGlobalGenerator;
import io.quarkus.qute.generator.ValueResolverGenerator;
import io.quarkus.qute.runtime.ContentTypes;
import io.quarkus.qute.runtime.EngineProducer;
import io.quarkus.qute.runtime.QuteConfig;
import io.quarkus.qute.runtime.QuteRecorder;
import io.quarkus.qute.runtime.TemplateProducer;
import io.quarkus.qute.runtime.extensions.CollectionTemplateExtensions;
import io.quarkus.qute.runtime.extensions.ConfigTemplateExtensions;
import io.quarkus.qute.runtime.extensions.MapTemplateExtensions;
import io.quarkus.qute.runtime.extensions.NumberTemplateExtensions;
import io.quarkus.qute.runtime.extensions.OrOperatorTemplateExtensions;
import io.quarkus.qute.runtime.extensions.StringTemplateExtensions;
import io.quarkus.qute.runtime.extensions.TimeTemplateExtensions;
import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.logging.Logger;

public class QuteProcessor {
    public static final DotName LOCATION = Names.LOCATION;
    private static final Logger LOGGER = Logger.getLogger(QuteProcessor.class);
    private static final String CHECKED_TEMPLATE_REQUIRE_TYPE_SAFE = "requireTypeSafeExpressions";
    private static final String CHECKED_TEMPLATE_BASE_PATH = "basePath";
    private static final String CHECKED_TEMPLATE_DEFAULT_NAME = "defaultName";
    private static final String IGNORE_FRAGMENTS = "ignoreFragments";
    private static final String BASE_PATH = "templates";
    private static final Set<String> ITERATION_METADATA_KEYS = Set.of("count", "index", "indexParity", "hasNext", "odd", "isOdd", "even", "isEven", "isLast", "isFirst");
    private static final Function<FieldInfo, String> GETTER_FUN = new Function<FieldInfo, String>(){

        @Override
        public String apply(FieldInfo field) {
            String prefix = field.type().kind() == Type.Kind.PRIMITIVE && field.type().asPrimitiveType().primitive() == PrimitiveType.Primitive.BOOLEAN ? "is" : "get";
            return prefix + ValueResolverGenerator.capitalize((String)field.name());
        }
    };
    static final Function<Type, Type> FIRST_PARAM_TYPE_EXTRACT_FUN = new Function<Type, Type>(){

        @Override
        public Type apply(Type type) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
    };
    static final Function<Type, Type> MAP_ENTRY_EXTRACT_FUN = new Function<Type, Type>(){

        @Override
        public Type apply(Type type) {
            Type[] args = new Type[]{(Type)type.asParameterizedType().arguments().get(0), (Type)type.asParameterizedType().arguments().get(1)};
            return ParameterizedType.create((DotName)Names.MAP_ENTRY, (Type[])args, null);
        }
    };

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.QUTE);
    }

    @BuildStep
    List<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations() {
        return List.of(new BeanDefiningAnnotationBuildItem(Names.LOCATE, DotNames.SINGLETON), new BeanDefiningAnnotationBuildItem(Names.LOCATES, DotNames.SINGLETON), new BeanDefiningAnnotationBuildItem(Names.ENGINE_CONFIGURATION));
    }

    @BuildStep
    void processTemplateErrors(TemplatesAnalysisBuildItem analysis, List<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ServiceStartBuildItem> serviceStart) {
        ArrayList<TemplateException> errors = new ArrayList<TemplateException>();
        for (IncorrectExpressionBuildItem incorrectExpression : incorrectExpressions) {
            if (incorrectExpression.reason != null) {
                errors.add(TemplateException.builder().code((ErrorCode)Code.INCORRECT_EXPRESSION).origin(incorrectExpression.origin).message("{templatePath.or(origin.templateId)}:{origin.line}:{origin.lineCharacterStart} - \\{{expression}\\}: {reason}").argument("templatePath", (Object)QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId())).argument("expression", (Object)incorrectExpression.expression).argument("reason", (Object)incorrectExpression.reason).build());
                continue;
            }
            if (incorrectExpression.clazz != null) {
                errors.add(TemplateException.builder().code((ErrorCode)Code.INCORRECT_EXPRESSION).origin(incorrectExpression.origin).message("{templatePath.or(origin.templateId)}:{origin.line}:{origin.lineCharacterStart} - \\{{expression}}: Property/method [{property}] not found on class [{clazz}] nor handled by an extension method").argument("templatePath", (Object)QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId())).argument("expression", (Object)incorrectExpression.expression).argument("property", (Object)incorrectExpression.property).argument("clazz", (Object)incorrectExpression.clazz).build());
                continue;
            }
            errors.add(TemplateException.builder().code((ErrorCode)Code.INCORRECT_EXPRESSION).origin(incorrectExpression.origin).message("{templatePath.or(origin.templateId)}:{origin.line}:{origin.lineCharacterStart} - \\{{expression}}: @Named bean not found for [{property}]").argument("templatePath", (Object)QuteProcessor.findTemplatePath(analysis, incorrectExpression.origin.getTemplateGeneratedId())).argument("expression", (Object)incorrectExpression.expression).argument("property", (Object)incorrectExpression.property).build());
        }
        if (!errors.isEmpty()) {
            StringBuilder message = new StringBuilder("Found incorrect expressions (").append(errors.size()).append("):");
            int idx = 1;
            for (TemplateException error : errors) {
                message.append("\n\t").append("[").append(idx++).append("] ").append(error.getMessage());
            }
            message.append("\n");
            TemplateException exception = new TemplateException(message.toString());
            for (TemplateException error : errors) {
                exception.addSuppressed((Throwable)error);
            }
            throw exception;
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{EngineProducer.class, TemplateProducer.class, ContentTypes.class, Template.class, TemplateInstance.class, CollectionTemplateExtensions.class, MapTemplateExtensions.class, NumberTemplateExtensions.class, ConfigTemplateExtensions.class, TimeTemplateExtensions.class, StringTemplateExtensions.class, OrOperatorTemplateExtensions.class}).build();
    }

    @BuildStep
    List<CheckedTemplateBuildItem> collectCheckedTemplates(BeanArchiveIndexBuildItem index, BuildProducer<BytecodeTransformerBuildItem> transformers, List<TemplatePathBuildItem> templatePaths, List<CheckedTemplateAdapterBuildItem> templateAdaptorBuildItems, TemplateFilePathsBuildItem filePaths, CustomTemplateLocatorPatternsBuildItem locatorPatternsBuildItem) {
        Object supportedAdaptors;
        ArrayList<CheckedTemplateBuildItem> ret = new ArrayList<CheckedTemplateBuildItem>();
        HashMap<DotName, CheckedTemplateAdapter> adaptors = new HashMap<DotName, CheckedTemplateAdapter>();
        for (CheckedTemplateAdapterBuildItem templateAdaptorBuildItem : templateAdaptorBuildItems) {
            adaptors.put(DotName.createSimple((String)templateAdaptorBuildItem.adapter.templateInstanceBinaryName().replace('/', '.')), templateAdaptorBuildItem.adapter);
        }
        if (adaptors.isEmpty()) {
            supportedAdaptors = Names.TEMPLATE_INSTANCE + " is supported";
        } else {
            StringBuffer strbuf = new StringBuffer(Names.TEMPLATE_INSTANCE.toString());
            ArrayList adaptorsList = new ArrayList(adaptors.size());
            for (Object name : adaptors.keySet()) {
                adaptorsList.add(name.toString());
            }
            Collections.sort(adaptorsList);
            Iterator<Object> iterator = adaptorsList.iterator();
            while (iterator.hasNext()) {
                Object name;
                name = (String)iterator.next();
                strbuf.append(", ").append((String)name);
            }
            supportedAdaptors = strbuf.append(" are supported").toString();
        }
        HashMap<CallSite, Object> checkedTemplates = new HashMap<CallSite, Object>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(Names.CHECKED_TEMPLATE)) {
            ClassInfo classInfo;
            if (annotation.target().kind() != AnnotationTarget.Kind.CLASS || (classInfo = annotation.target().asClass()).isRecord()) continue;
            NativeCheckedTemplateEnhancer enhancer = new NativeCheckedTemplateEnhancer();
            for (MethodInfo methodInfo : classInfo.methods()) {
                String templatePath;
                String fullPath;
                AnnotationTarget checkedTemplate;
                if (!Modifier.isStatic(methodInfo.flags()) || !Modifier.isNative(methodInfo.flags())) continue;
                if (methodInfo.returnType().kind() != Type.Kind.CLASS) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + (String)supportedAdaptors);
                }
                DotName returnTypeName = methodInfo.returnType().asClassType().name();
                CheckedTemplateAdapter adaptor = null;
                if (!returnTypeName.equals((Object)Names.TEMPLATE_INSTANCE) && (adaptor = (CheckedTemplateAdapter)adaptors.get(returnTypeName)) == null) {
                    throw new TemplateException("Incompatible checked template return type: " + methodInfo.returnType() + " only " + (String)supportedAdaptors);
                }
                String fragmentId = this.getCheckedFragmentId((AnnotationTarget)methodInfo, annotation);
                StringBuilder templatePathBuilder = new StringBuilder();
                AnnotationValue basePathValue = annotation.value(CHECKED_TEMPLATE_BASE_PATH);
                if (basePathValue != null && !basePathValue.asString().equals("<<defaulted>>")) {
                    templatePathBuilder.append(basePathValue.asString());
                } else if (classInfo.enclosingClass() != null) {
                    ClassInfo enclosingClass = index.getIndex().getClassByName(classInfo.enclosingClass());
                    templatePathBuilder.append(enclosingClass.simpleName());
                }
                if (templatePathBuilder.length() > 0 && templatePathBuilder.charAt(templatePathBuilder.length() - 1) != '/') {
                    templatePathBuilder.append('/');
                }
                if ((checkedTemplate = (AnnotationTarget)checkedTemplates.putIfAbsent((CallSite)((Object)(fullPath = (templatePath = templatePathBuilder.append(this.getCheckedTemplateName((AnnotationTarget)methodInfo, annotation, fragmentId != null)).toString()) + (String)(fragmentId != null ? "$" + fragmentId : ""))), methodInfo)) != null) {
                    throw new TemplateException(String.format("Multiple checked templates exist for the template path %s:\n\t- %s: %s\n\t- %s", fullPath, methodInfo.declaringClass().name(), methodInfo, checkedTemplate));
                }
                if (!filePaths.contains(templatePath) && this.isNotLocatedByCustomTemplateLocator(locatorPatternsBuildItem.getLocationPatterns(), templatePath)) {
                    ArrayList<String> startsWith = new ArrayList<String>();
                    for (String filePath : filePaths.getFilePaths()) {
                        if (!filePath.startsWith(templatePath) || filePath.charAt(templatePath.length()) != '.') continue;
                        startsWith.add(filePath);
                    }
                    if (startsWith.isEmpty()) {
                        throw new TemplateException("No template matching the path " + templatePath + " could be found for: " + classInfo.name() + "." + methodInfo.name());
                    }
                    throw new TemplateException(startsWith + " match the path " + templatePath + " but the file suffix is not configured via the quarkus.qute.suffixes property");
                }
                HashMap<String, String> bindings = new HashMap<String, String>();
                List parameters = methodInfo.parameterTypes();
                ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
                for (int i = 0; i < parameters.size(); ++i) {
                    Type type = (Type)parameters.get(i);
                    String name = methodInfo.parameterName(i);
                    if (name == null) {
                        throw new TemplateException("Parameter names not recorded for " + classInfo.name() + ": compile the class with -parameters");
                    }
                    bindings.put(name, QuteProcessor.getCheckedTemplateParameterTypeName(type));
                    parameterNames.add(name);
                }
                AnnotationValue requireTypeSafeExpressions = annotation.value(CHECKED_TEMPLATE_REQUIRE_TYPE_SAFE);
                ret.add(new CheckedTemplateBuildItem(templatePath, fragmentId, bindings, methodInfo, null, requireTypeSafeExpressions != null ? requireTypeSafeExpressions.asBoolean() : true));
                enhancer.implement(methodInfo, templatePath, fragmentId, parameterNames, adaptor);
            }
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(classInfo.name().toString(), (BiFunction)enhancer));
        }
        ArrayList<DotName> recordInterfaceNames = new ArrayList<DotName>();
        recordInterfaceNames.add(Names.TEMPLATE_INSTANCE);
        adaptors.keySet().forEach(recordInterfaceNames::add);
        for (DotName recordInterfaceName : recordInterfaceNames) {
            ClassInfo recordInterface = index.getIndex().getClassByName(recordInterfaceName);
            if (recordInterface == null) {
                throw new IllegalStateException(recordInterfaceName + " not found in the index");
            }
            HashSet<String> reservedNames = new HashSet<String>();
            for (MethodInfo method : recordInterface.methods()) {
                if (method.isSynthetic() || method.isBridge() || method.parametersCount() != 0) continue;
                reservedNames.add(method.name());
            }
            for (ClassInfo recordClass : index.getIndex().getAllKnownImplementors(recordInterfaceName)) {
                String templatePath;
                String fullPath;
                AnnotationTarget checkedTemplate;
                AnnotationValue basePathValue;
                if (!recordClass.isRecord()) continue;
                Type[] componentTypes = (Type[])recordClass.recordComponents().stream().map(RecordComponentInfo::type).toArray(Type[]::new);
                MethodInfo canonicalConstructor = recordClass.method("<init>", componentTypes);
                AnnotationInstance checkedTemplateAnnotation = recordClass.declaredAnnotation(Names.CHECKED_TEMPLATE);
                String fragmentId = this.getCheckedFragmentId((AnnotationTarget)recordClass, checkedTemplateAnnotation);
                StringBuilder templatePathBuilder = new StringBuilder();
                AnnotationValue annotationValue = basePathValue = checkedTemplateAnnotation != null ? checkedTemplateAnnotation.value(CHECKED_TEMPLATE_BASE_PATH) : null;
                if (basePathValue != null && !basePathValue.asString().equals("<<defaulted>>")) {
                    templatePathBuilder.append(basePathValue.asString());
                } else if (recordClass.enclosingClass() != null) {
                    ClassInfo enclosingClass = index.getIndex().getClassByName(recordClass.enclosingClass());
                    templatePathBuilder.append(enclosingClass.simpleName());
                }
                if (templatePathBuilder.length() > 0 && templatePathBuilder.charAt(templatePathBuilder.length() - 1) != '/') {
                    templatePathBuilder.append('/');
                }
                if ((checkedTemplate = (AnnotationTarget)checkedTemplates.putIfAbsent((CallSite)((Object)(fullPath = (templatePath = templatePathBuilder.append(this.getCheckedTemplateName((AnnotationTarget)recordClass, checkedTemplateAnnotation, fragmentId != null)).toString()) + (String)(fragmentId != null ? "$" + fragmentId : ""))), recordClass)) != null) {
                    throw new TemplateException(String.format("Multiple checked templates exist for the template path %s:\n\t- %s\n\t- %s", fullPath, recordClass.name(), checkedTemplate));
                }
                if (!filePaths.contains(templatePath) && this.isNotLocatedByCustomTemplateLocator(locatorPatternsBuildItem.getLocationPatterns(), templatePath)) {
                    ArrayList<String> startsWith = new ArrayList<String>();
                    for (String filePath : filePaths.getFilePaths()) {
                        if (!filePath.startsWith(templatePath) || filePath.charAt(templatePath.length()) != '.') continue;
                        startsWith.add(filePath);
                    }
                    if (startsWith.isEmpty()) {
                        throw new TemplateException("No template matching the path " + templatePath + " could be found for: " + recordClass.name());
                    }
                    throw new TemplateException(startsWith + " match the path " + templatePath + " but the file suffix is not configured via the quarkus.qute.suffixes property");
                }
                HashMap<String, String> bindings = new HashMap<String, String>();
                List parameters = canonicalConstructor.parameterTypes();
                ArrayList<String> parameterNames = new ArrayList<String>(parameters.size());
                for (int i = 0; i < parameters.size(); ++i) {
                    Type type = (Type)parameters.get(i);
                    String name = canonicalConstructor.parameterName(i);
                    if (name == null) {
                        throw new TemplateException("Parameter names not recorded for " + recordClass.name() + ": compile the class with -parameters");
                    }
                    if (reservedNames.contains(name)) {
                        throw new TemplateException("Template record component [" + name + "] conflicts with an interface method of " + recordInterface);
                    }
                    bindings.put(name, QuteProcessor.getCheckedTemplateParameterTypeName(type));
                    parameterNames.add(name);
                }
                AnnotationValue requireTypeSafeExpressions = checkedTemplateAnnotation != null ? checkedTemplateAnnotation.value(CHECKED_TEMPLATE_REQUIRE_TYPE_SAFE) : null;
                ret.add(new CheckedTemplateBuildItem(templatePath, fragmentId, bindings, null, recordClass, requireTypeSafeExpressions != null ? requireTypeSafeExpressions.asBoolean() : true));
                transformers.produce((BuildItem)new BytecodeTransformerBuildItem(recordClass.name().toString(), (BiFunction)new TemplateRecordEnhancer(recordInterface, recordClass, templatePath, fragmentId, canonicalConstructor.parameters(), (CheckedTemplateAdapter)adaptors.get(recordInterfaceName))));
            }
        }
        return ret;
    }

    private String getCheckedTemplateName(AnnotationTarget target, AnnotationInstance checkedTemplateAnnotation, boolean checkedFragment) {
        String name;
        AnnotationValue nameValue = checkedTemplateAnnotation != null ? checkedTemplateAnnotation.value(CHECKED_TEMPLATE_DEFAULT_NAME) : null;
        String defaultName = nameValue == null ? "<<element name>>" : nameValue.asString();
        String string = name = target.kind() == AnnotationTarget.Kind.METHOD ? target.asMethod().name() : target.asClass().simpleName();
        if (checkedFragment) {
            name = name.substring(0, name.lastIndexOf(36));
        }
        return this.defaultedName(defaultName, name);
    }

    private String getCheckedFragmentId(AnnotationTarget target, AnnotationInstance checkedTemplateAnnotation) {
        AnnotationValue ignoreFragmentsValue;
        AnnotationValue annotationValue = ignoreFragmentsValue = checkedTemplateAnnotation != null ? checkedTemplateAnnotation.value(IGNORE_FRAGMENTS) : null;
        if (ignoreFragmentsValue != null && ignoreFragmentsValue.asBoolean()) {
            return null;
        }
        String name = target.kind() == AnnotationTarget.Kind.METHOD ? target.asMethod().name() : target.asClass().simpleName();
        int idx = name.lastIndexOf(36);
        if (idx == -1 || idx == name.length()) {
            return null;
        }
        AnnotationValue nameValue = checkedTemplateAnnotation != null ? checkedTemplateAnnotation.value(CHECKED_TEMPLATE_DEFAULT_NAME) : null;
        String defaultName = nameValue == null ? "<<element name>>" : nameValue.asString();
        return this.defaultedName(defaultName, name.substring(idx + 1, name.length()));
    }

    private String defaultedName(String defaultNameStrategy, final String value) {
        switch (defaultNameStrategy) {
            case "<<element name>>": {
                return value;
            }
            case "<<hyphenated element name>>": {
                return StringUtil.hyphenate((String)value);
            }
            case "<<underscored element name>>": {
                return String.join((CharSequence)"_", (Iterable<? extends CharSequence>)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return StringUtil.lowerCase((Iterator)StringUtil.camelHumpsIterator((String)value));
                    }
                });
            }
        }
        throw new IllegalArgumentException("Unsupported @CheckedTemplate#defaultName() value: " + defaultNameStrategy);
    }

    private boolean isNotLocatedByCustomTemplateLocator(Collection<Pattern> locationPatterns, String templatePath) {
        if (!locationPatterns.isEmpty() && templatePath != null) {
            for (Pattern locationPattern : locationPatterns) {
                if (!locationPattern.matcher(templatePath).matches()) continue;
                return false;
            }
        }
        return true;
    }

    @BuildStep
    TemplatesAnalysisBuildItem analyzeTemplates(final List<TemplatePathBuildItem> templatePaths, final TemplateFilePathsBuildItem filePaths, List<CheckedTemplateBuildItem> checkedTemplates, List<MessageBundleMethodBuildItem> messageBundleMethods, final List<TemplateGlobalBuildItem> globals, QuteConfig config, Optional<EngineConfigurationsBuildItem> engineConfigurations, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<CheckedFragmentValidationBuildItem> checkedFragmentValidations) {
        Template template;
        long start = System.nanoTime();
        this.checkDuplicatePaths(templatePaths);
        ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis> analysis = new ArrayList<TemplatesAnalysisBuildItem.TemplateAnalysis>();
        EngineBuilder builder = Engine.builder().addDefaultSectionHelpers();
        for (TemplatePathBuildItem path : templatePaths) {
            if (!path.isTag()) continue;
            String string = path.getPath();
            String tagName = string.substring("tags/".length(), string.length());
            if (tagName.contains(".")) {
                tagName = tagName.substring(0, tagName.indexOf(46));
            }
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, string));
        }
        if (engineConfigurations.isPresent()) {
            Collection sectionFactories = engineConfigurations.get().getConfigurations().stream().filter(c -> Types.isImplementorOf(c, Names.SECTION_HELPER_FACTORY, beanArchiveIndex.getIndex())).collect(Collectors.toList());
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            for (Object factoryClass : sectionFactories) {
                try {
                    Class<?> sectionHelperFactoryClass = tccl.loadClass(factoryClass.toString());
                    SectionHelperFactory sectionHelperFactory = (SectionHelperFactory)sectionHelperFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    builder.addSectionHelper(sectionHelperFactory);
                    LOGGER.debugf("SectionHelperFactory registered during template analysis: " + (ClassInfo)factoryClass, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to instantiate SectionHelperFactory: " + (ClassInfo)factoryClass, e);
                }
            }
        }
        builder.computeSectionHelper(name -> new SectionHelperFactory<SectionHelper>(){

            public SectionHelper initialize(SectionHelperFactory.SectionInitContext context) {
                return new SectionHelper(){

                    public CompletionStage<ResultNode> resolve(SectionHelper.SectionResolutionContext context) {
                        return ResultNode.NOOP;
                    }
                };
            }
        });
        builder.addLocator(new TemplateLocator(){

            public Optional<TemplateLocator.TemplateLocation> locate(String id) {
                final TemplatePathBuildItem found = templatePaths.stream().filter(p -> p.getPath().equals(id)).findAny().orElse(null);
                if (found != null) {
                    return Optional.of(new TemplateLocator.TemplateLocation(){

                        public Reader read() {
                            return new StringReader(found.getContent());
                        }

                        public Optional<Variant> getVariant() {
                            return Optional.empty();
                        }
                    });
                }
                return Optional.empty();
            }
        });
        final HashMap<String, String> pathToPathWithoutSuffix = new HashMap<String, String>();
        for (String string : filePaths.getFilePaths()) {
            for (Object suffix : config.suffixes) {
                if (!string.endsWith((String)suffix)) continue;
                pathToPathWithoutSuffix.put(string, string.substring(0, string.length() - (((String)suffix).length() + 1)));
                break;
            }
            if (pathToPathWithoutSuffix.containsKey(string)) continue;
            pathToPathWithoutSuffix.put(string, string);
        }
        final HashMap<String, Map> checkedTemplateIdToParamDecl = new HashMap<String, Map>();
        for (Object checkedTemplate : checkedTemplates) {
            if (checkedTemplate.isFragment()) continue;
            for (Map.Entry entry : checkedTemplate.bindings.entrySet()) {
                checkedTemplateIdToParamDecl.computeIfAbsent(checkedTemplate.templateId, s -> new HashMap()).put((String)entry.getKey(), new MethodParameterDeclaration((String)entry.getValue(), (String)entry.getKey()));
            }
        }
        final HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            MethodInfo methodInfo = messageBundleMethod.getMethod();
            ListIterator it = methodInfo.parameterTypes().listIterator();
            while (it.hasNext()) {
                Type paramType = (Type)it.next();
                String name2 = MessageBundleProcessor.getParameterName(methodInfo, it.previousIndex());
                hashMap.computeIfAbsent(messageBundleMethod.getTemplateId(), s -> new HashMap()).put(name2, new MethodParameterDeclaration(QuteProcessor.getCheckedTemplateParameterTypeName(paramType), name2));
            }
        }
        builder.addParserHook(new ParserHook(){

            public void beforeParsing(ParserHelper parserHelper) {
                String templateId = parserHelper.getTemplateId();
                if (filePaths.contains(templateId)) {
                    for (TemplateGlobalBuildItem global : globals) {
                        parserHelper.addParameter(global.getName(), QuteProcessor.getCheckedTemplateParameterTypeName(global.getVariableType()).toString());
                    }
                    QuteProcessor.this.addMethodParamsToParserHelper(parserHelper, (String)pathToPathWithoutSuffix.get(templateId), checkedTemplateIdToParamDecl);
                    if (templateId.startsWith("tags/")) {
                        parserHelper.addParameter("_args", UserTagSectionHelper.Arguments.class.getName());
                    }
                }
                QuteProcessor.this.addMethodParamsToParserHelper(parserHelper, templateId, hashMap);
            }
        }).build();
        Engine dummyEngine = builder.build();
        List checkedFragments = checkedTemplates.stream().filter(CheckedTemplateBuildItem::isFragment).collect(Collectors.toList());
        for (TemplatePathBuildItem path : templatePaths) {
            template = dummyEngine.getTemplate(path.getPath());
            if (template == null) continue;
            String templateIdWithoutSuffix = (String)pathToPathWithoutSuffix.get(template.getId());
            List<ParameterDeclaration> parameterDeclarations = checkedTemplateIdToParamDecl.isEmpty() ? template.getParameterDeclarations() : this.mergeParamDeclarations(template.getParameterDeclarations(), (Map)checkedTemplateIdToParamDecl.get(templateIdWithoutSuffix));
            if (!checkedFragments.isEmpty()) {
                for (CheckedTemplateBuildItem checkedFragment : checkedFragments) {
                    if (!checkedFragment.templateId.equals(templateIdWithoutSuffix)) continue;
                    Template.Fragment fragment = template.getFragment(checkedFragment.fragmentId);
                    if (fragment == null) {
                        throw new TemplateException("Fragment [" + checkedFragment.fragmentId + "] not defined in template " + template.getId());
                    }
                    checkedFragmentValidations.produce((BuildItem)new CheckedFragmentValidationBuildItem(template.getGeneratedId(), fragment.getExpressions(), checkedFragment));
                }
            }
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(null, template.getGeneratedId(), template.getExpressions(), parameterDeclarations, path.getPath(), template.getFragmentIds()));
        }
        for (MessageBundleMethodBuildItem messageBundleMethod : messageBundleMethods) {
            template = dummyEngine.parse(messageBundleMethod.getTemplate(), null, messageBundleMethod.getTemplateId());
            List<ParameterDeclaration> paramDeclarations = this.mergeParamDeclarations(template.getParameterDeclarations(), (Map)hashMap.get(messageBundleMethod.getTemplateId()));
            analysis.add(new TemplatesAnalysisBuildItem.TemplateAnalysis(messageBundleMethod.getTemplateId(), template.getGeneratedId(), template.getExpressions(), paramDeclarations, messageBundleMethod.getMethod().declaringClass().name() + "#" + messageBundleMethod.getMethod().name() + "()", template.getFragmentIds()));
        }
        LOGGER.debugf("Finished analysis of %s templates in %s ms", (long)analysis.size(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        return new TemplatesAnalysisBuildItem(analysis);
    }

    @BuildStep
    void validateCheckedFragments(List<CheckedFragmentValidationBuildItem> validations, List<TemplateExpressionMatchesBuildItem> expressionMatches, List<TemplateGlobalBuildItem> templateGlobals, BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        if (validations.isEmpty()) {
            return;
        }
        IndexView index = beanArchiveIndex.getIndex();
        Types.AssignabilityCheck assignabilityCheck = new Types.AssignabilityCheck(index);
        String[] hintPrefixes = new String[]{"<loop#", "<when#", "<set#"};
        Set globals = templateGlobals.stream().map(TemplateGlobalBuildItem::getName).collect(Collectors.toUnmodifiableSet());
        for (CheckedFragmentValidationBuildItem validation : validations) {
            HashMap<String, Type> paramNamesToTypes = new HashMap<String, Type>();
            TemplateExpressionMatchesBuildItem matchResults = null;
            for (TemplateExpressionMatchesBuildItem templateExpressionMatchesBuildItem : expressionMatches) {
                if (!templateExpressionMatchesBuildItem.templateGeneratedId.equals(validation.templateGeneratedId)) continue;
                matchResults = templateExpressionMatchesBuildItem;
            }
            if (matchResults == null) {
                throw new IllegalStateException("Match results not found for: " + validation.checkedTemplate.templateId);
            }
            block2: for (Expression expression : validation.fragmentExpressions) {
                String typeInfo;
                if (expression.isLiteral() || globals.contains(((Expression.Part)expression.getParts().get(0)).getName()) || (typeInfo = ((Expression.Part)expression.getParts().get(0)).getTypeInfo()) == null || typeInfo != null && typeInfo.endsWith("<metadata>")) continue;
                TypeInfos.Info info = TypeInfos.create(expression, index, null).get(0);
                if (info.isTypeInfo()) {
                    paramNamesToTypes.put(((Expression.Part)expression.getParts().get(0)).getName(), info.asTypeInfo().resolvedType);
                    continue;
                }
                if (!info.hasHints()) continue;
                for (String helperHint : info.asHintInfo().hints) {
                    for (String prefix : hintPrefixes) {
                        int generatedId;
                        Expression localExpression;
                        if (!helperHint.startsWith(prefix) || (localExpression = QuteProcessor.findExpression(generatedId = QuteProcessor.parseHintId(helperHint, prefix), validation.fragmentExpressions)) != null) continue;
                        MatchResult match = matchResults.getMatch(generatedId);
                        if (match == null) {
                            throw new IllegalStateException("Match result not found for expression [" + expression.toOriginalString() + "] in: " + validation.checkedTemplate.templateId);
                        }
                        paramNamesToTypes.put(((Expression.Part)expression.getParts().get(0)).getName(), match.type);
                        continue block2;
                    }
                }
            }
            if (paramNamesToTypes.isEmpty()) continue;
            for (Map.Entry entry : paramNamesToTypes.entrySet()) {
                MethodParameterInfo param;
                String paramName = (String)entry.getKey();
                MethodInfo methodOrConstructor = null;
                if (validation.checkedTemplate.isRecord()) {
                    Type[] componentTypes = (Type[])validation.checkedTemplate.recordClass.recordComponents().stream().map(RecordComponentInfo::type).toArray(Type[]::new);
                    methodOrConstructor = validation.checkedTemplate.recordClass.method("<init>", componentTypes);
                } else {
                    methodOrConstructor = validation.checkedTemplate.method;
                }
                if ((param = (MethodParameterInfo)methodOrConstructor.parameters().stream().filter(mp -> mp.name().equals(paramName)).findFirst().orElse(null)) != null && assignabilityCheck.isAssignableFrom((Type)entry.getValue(), param.type())) continue;
                throw new TemplateException(validation.checkedTemplate.method.declaringClass().name().withoutPackagePrefix() + "#" + validation.checkedTemplate.method.name() + "() must declare a parameter of name [" + paramName + "] and type [" + entry.getValue() + "]");
            }
        }
    }

    private static String getCheckedTemplateParameterTypeName(Type type) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                return QuteProcessor.getCheckedTemplateParameterParameterizedTypeName((ParameterizedType)type);
            }
            case ARRAY: {
                return type.toString();
            }
        }
        return type.name().toString();
    }

    private static String getCheckedTemplateParameterParameterizedTypeName(ParameterizedType parameterizedType) {
        StringBuilder builder = new StringBuilder();
        if (parameterizedType.owner() != null) {
            builder.append(parameterizedType.owner().name());
            builder.append('.');
            builder.append(parameterizedType.name().local());
        } else {
            builder.append(parameterizedType.name());
        }
        List arguments = parameterizedType.arguments();
        if (arguments.size() > 0) {
            builder.append('<');
            builder.append(QuteProcessor.getCheckedTemplateParameterTypeName((Type)arguments.get(0)));
            for (int i = 1; i < arguments.size(); ++i) {
                builder.append(", ").append(QuteProcessor.getCheckedTemplateParameterTypeName((Type)arguments.get(i)));
            }
            builder.append('>');
        }
        return builder.toString();
    }

    private List<ParameterDeclaration> mergeParamDeclarations(List<ParameterDeclaration> parameterDeclarations, Map<String, MethodParameterDeclaration> paramNameToDeclaration) {
        if (paramNameToDeclaration != null) {
            HashMap<String, MethodParameterDeclaration> mergeResult = new HashMap<String, MethodParameterDeclaration>(paramNameToDeclaration);
            for (ParameterDeclaration paramDeclaration : parameterDeclarations) {
                mergeResult.put(paramDeclaration.getKey(), (MethodParameterDeclaration)paramDeclaration);
            }
            return List.copyOf(mergeResult.values());
        }
        return parameterDeclarations;
    }

    private void addMethodParamsToParserHelper(ParserHelper parserHelper, String templateId, Map<String, Map<String, MethodParameterDeclaration>> templateIdToParamDecl) {
        Map<String, MethodParameterDeclaration> paramNameToDeclaration = templateIdToParamDecl.get(templateId);
        if (paramNameToDeclaration != null) {
            for (MethodParameterDeclaration parameterDeclaration : paramNameToDeclaration.values()) {
                parserHelper.addParameter(parameterDeclaration.getKey(), parameterDeclaration.getParamType());
            }
        }
    }

    @BuildStep
    void validateExpressions(final TemplatesAnalysisBuildItem templatesAnalysis, BeanArchiveIndexBuildItem beanArchiveIndex, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<TypeCheckExcludeBuildItem> typeCheckExcludeBuildItems, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, BuildProducer<ImplicitValueResolverBuildItem> implicitClasses, BuildProducer<TemplateExpressionMatchesBuildItem> expressionMatches, BeanDiscoveryFinishedBuildItem beanDiscovery, List<CheckedTemplateBuildItem> checkedTemplates, List<TemplateDataBuildItem> templateData, QuteConfig config, PackageConfig packageConfig) {
        long start = System.nanoTime();
        IndexView index = beanArchiveIndex.getIndex();
        Function<String, String> templateIdToPathFun = new Function<String, String>(){

            @Override
            public String apply(String id) {
                return QuteProcessor.findTemplatePath(templatesAnalysis, id);
            }
        };
        Map namedBeans = (Map)beanDiscovery.beanStream().withName().collect(Collectors.toMap(BeanInfo::getName, Function.identity()));
        HashMap<DotName, Set<String>> implicitClassToMembersUsed = new HashMap<DotName, Set<String>>();
        Map<String, TemplateDataBuildItem> namespaceTemplateData = templateData.stream().filter(TemplateDataBuildItem::hasNamespace).collect(Collectors.toMap(TemplateDataBuildItem::getNamespace, Function.identity()));
        Map<String, List<TemplateExtensionMethodBuildItem>> namespaceExtensionMethods = templateExtensionMethods.stream().filter(TemplateExtensionMethodBuildItem::hasNamespace).sorted(Comparator.comparingInt(TemplateExtensionMethodBuildItem::getPriority).reversed()).collect(Collectors.groupingBy(TemplateExtensionMethodBuildItem::getNamespace));
        List<TemplateExtensionMethodBuildItem> regularExtensionMethods = templateExtensionMethods.stream().filter(Predicate.not(TemplateExtensionMethodBuildItem::hasNamespace)).collect(Collectors.toList());
        FixedJavaMemberLookupConfig lookupConfig = new FixedJavaMemberLookupConfig(index, QuteProcessor.initDefaultMembersFilter(), false);
        Types.AssignabilityCheck assignabilityCheck = new Types.AssignabilityCheck(index);
        int expressionsValidated = 0;
        ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes = new ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>>();
        ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> extensionMethodExcludes = new ArrayList<Predicate<TypeCheckExcludeBuildItem.TypeCheck>>();
        for (TypeCheckExcludeBuildItem exclude : typeCheckExcludeBuildItems) {
            excludes.add(exclude.getPredicate());
            if (!exclude.isExtensionMethodPredicate()) continue;
            extensionMethodExcludes.add(exclude.getPredicate());
        }
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : templatesAnalysis.getAnalysis()) {
            CheckedTemplateBuildItem checkedTemplate = this.findCheckedTemplate(config, templateAnalysis, checkedTemplates);
            HashMap<Integer, MatchResult> generatedIdsToMatches = new HashMap<Integer, MatchResult>();
            for (ParameterDeclaration paramDeclaration : templateAnalysis.parameterDeclarations) {
                Type type = TypeInfos.resolveTypeFromTypeInfo(paramDeclaration.getTypeInfo());
                if (type == null) continue;
                implicitClassToMembersUsed.put(type.name(), new HashSet());
            }
            for (Expression expression : templateAnalysis.expressions) {
                if (expression.isLiteral()) continue;
                MatchResult match = QuteProcessor.validateNestedExpressions(config, templateAnalysis, null, new HashMap<String, MatchResult>(), excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, extensionMethodExcludes, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceExtensionMethods, assignabilityCheck);
                generatedIdsToMatches.put(expression.getGeneratedId(), match);
            }
            QuteProcessor.validateDefaultValuesOfParameterDeclarations(templateAnalysis, index, assignabilityCheck, generatedIdsToMatches, templateIdToPathFun, incorrectExpressions);
            expressionMatches.produce((BuildItem)new TemplateExpressionMatchesBuildItem(templateAnalysis.generatedId, generatedIdsToMatches));
            expressionsValidated += generatedIdsToMatches.size();
        }
        LOGGER.debugf("Validated %s expressions in %s ms", (long)expressionsValidated, TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        boolean isNonNativeBuild = !packageConfig.isNativeOrNativeSources();
        for (Map.Entry entry : implicitClassToMembersUsed.entrySet()) {
            ClassInfo clazz;
            if (((Set)entry.getValue()).isEmpty() && isNonNativeBuild || (clazz = index.getClassByName((DotName)entry.getKey())) == null) continue;
            TemplateDataBuilder builder = new TemplateDataBuilder();
            if (isNonNativeBuild) {
                builder.addIgnore(QuteProcessor.buildIgnorePattern((Iterable)entry.getValue()));
            }
            implicitClasses.produce((BuildItem)new ImplicitValueResolverBuildItem(clazz, builder.build()));
        }
    }

    private static void validateDefaultValuesOfParameterDeclarations(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, IndexView index, Types.AssignabilityCheck assignabilityCheck, Map<Integer, MatchResult> generatedIdsToMatches, Function<String, String> templateIdToPathFun, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        for (ParameterDeclaration parameterDeclaration : templateAnalysis.parameterDeclarations) {
            MatchResult match;
            Expression defaultValue = parameterDeclaration.getDefaultValue();
            if (defaultValue == null) continue;
            if (defaultValue.isLiteral()) {
                match = new MatchResult(assignabilityCheck);
                QuteProcessor.setMatchValues(match, defaultValue, generatedIdsToMatches, index);
            } else {
                match = generatedIdsToMatches.get(defaultValue.getGeneratedId());
                if (match == null) {
                    LOGGER.debugf("No type info available - unable to validate the default value of a parameter declaration [" + parameterDeclaration.getKey() + "] in " + defaultValue.getOrigin(), new Object[0]);
                    continue;
                }
            }
            TypeInfos.Info info = TypeInfos.create(parameterDeclaration.getTypeInfo(), null, index, templateIdToPathFun, parameterDeclaration.getDefaultValue().getOrigin());
            if (!info.isTypeInfo()) {
                throw new IllegalStateException("Invalid type info [" + info + "] of parameter declaration [" + parameterDeclaration.getKey() + "] in " + defaultValue.getOrigin().toString());
            }
            if (assignabilityCheck.isAssignableFrom(info.asTypeInfo().resolvedType, match.type())) continue;
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(defaultValue.toOriginalString(), "The type of the default value [" + match.type() + "] does not match the type of the parameter declaration [" + info.asTypeInfo().resolvedType + "]", defaultValue.getOrigin()));
        }
    }

    static Predicate<AnnotationTarget> initDefaultMembersFilter() {
        Predicate<AnnotationTarget> filter = QuteProcessor::defaultFilter;
        Predicate<AnnotationTarget> enumConstantFilter = QuteProcessor::enumConstantFilter;
        filter = filter.and(enumConstantFilter.or(Predicate.not(QuteProcessor::staticsFilter)));
        return filter;
    }

    private CheckedTemplateBuildItem findCheckedTemplate(QuteConfig config, TemplatesAnalysisBuildItem.TemplateAnalysis analysis, List<CheckedTemplateBuildItem> checkedTemplates) {
        String path = analysis.path;
        for (String suffix : config.suffixes) {
            if (!path.endsWith(suffix)) continue;
            path = path.substring(0, path.length() - (suffix.length() + 1));
            break;
        }
        for (CheckedTemplateBuildItem item : checkedTemplates) {
            if (item.isFragment() || !item.templateId.equals(path)) continue;
            return item;
        }
        return null;
    }

    static String buildIgnorePattern(Iterable<String> names) {
        StringBuilder pattern = new StringBuilder("^(?!");
        Iterator<String> it = names.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException();
        }
        while (it.hasNext()) {
            String name = it.next();
            pattern.append(Pattern.quote(name));
            if (!it.hasNext()) continue;
            pattern.append("|");
        }
        pattern.append(").*$");
        return pattern.toString();
    }

    static MatchResult validateNestedExpressions(QuteConfig config, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, ClassInfo rootClazz, Map<String, MatchResult> results, Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Expression expression, IndexView index, Map<DotName, Set<String>> implicitClassToMembersUsed, Function<String, String> templateIdToPathFun, Map<Integer, MatchResult> generatedIdsToMatches, Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> extensionMethodExcludes, CheckedTemplateBuildItem checkedTemplate, JavaMemberLookupConfig lookupConfig, Map<String, BeanInfo> namedBeans, Map<String, TemplateDataBuildItem> namespaceTemplateData, List<TemplateExtensionMethodBuildItem> regularExtensionMethods, Map<String, List<TemplateExtensionMethodBuildItem>> namespaceToExtensionMethods, Types.AssignabilityCheck assignabilityCheck) {
        LOGGER.debugf("Validate %s from %s", (Object)expression, (Object)expression.getOrigin());
        QuteProcessor.validateParametersOfNestedVirtualMethods(config, templateAnalysis, results, excludes, incorrectExpressions, expression, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, extensionMethodExcludes, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceToExtensionMethods, assignabilityCheck);
        MatchResult match = new MatchResult(assignabilityCheck);
        NamespaceResult namespaceResult = QuteProcessor.processNamespace(expression, match, index, incorrectExpressions, namedBeans, results, templateAnalysis, namespaceTemplateData, lookupConfig, namespaceToExtensionMethods, templateIdToPathFun);
        if (namespaceResult.ignoring) {
            return match;
        }
        if (namespaceResult.hasRootClazz()) {
            rootClazz = namespaceResult.rootClazz;
        }
        if (namespaceResult.hasLookupConfig()) {
            lookupConfig = namespaceResult.lookupConfig;
        }
        if (QuteProcessor.isInvalidCheckedTemplateExpression(config, checkedTemplate, expression, match, results, namespaceResult.dataNamespaceExpTypeInfo, incorrectExpressions)) {
            return match;
        }
        if (rootClazz == null && !expression.hasTypeInfo() && !namespaceResult.hasDataNamespaceInfo()) {
            return QuteProcessor.putResult(match, results, expression);
        }
        List<TypeInfos.Info> parts = TypeInfos.create(expression, index, templateIdToPathFun);
        Iterator<TypeInfos.Info> iterator = parts.iterator();
        TypeInfos.Info root = iterator.next();
        RootResult rootResult = QuteProcessor.processRoot(expression, match, root, iterator, templateAnalysis, index, incorrectExpressions, rootClazz, parts, results, generatedIdsToMatches, templateIdToPathFun, assignabilityCheck, namespaceResult);
        if (rootResult.ignoring) {
            return match;
        }
        iterator = rootResult.iterator;
        while (iterator.hasNext()) {
            TypeInfos.Info info = iterator.next();
            if (!match.isEmpty()) {
                if (match.isArray() && QuteProcessor.processArray(info, match)) continue;
                AnnotationTarget member = null;
                TemplateExtensionMethodBuildItem extensionMethod = null;
                Type type = null;
                if (!match.isPrimitive()) {
                    Set<String> membersUsed = implicitClassToMembersUsed.get(match.type().name());
                    if (membersUsed == null) {
                        membersUsed = new HashSet<String>();
                        implicitClassToMembersUsed.put(match.type().name(), membersUsed);
                    }
                    if (match.clazz() != null) {
                        if (info.isVirtualMethod()) {
                            member = QuteProcessor.findMethod(info.part.asVirtualMethod(), match.clazz(), expression, index, templateIdToPathFun, results, lookupConfig, assignabilityCheck);
                            if (member != null) {
                                membersUsed.add(member.asMethod().name());
                            }
                        } else if (info.isProperty() && (member = QuteProcessor.findProperty(info.asProperty().name, match.clazz(), lookupConfig)) != null) {
                            membersUsed.add(member.kind() == AnnotationTarget.Kind.FIELD ? member.asField().name() : member.asMethod().name());
                        }
                    }
                }
                if (member == null && (extensionMethod = QuteProcessor.findTemplateExtensionMethod(info, match.type(), regularExtensionMethods, expression, index, templateIdToPathFun, results, assignabilityCheck)) != null) {
                    type = QuteProcessor.resolveType((AnnotationTarget)extensionMethod.getMethod(), match, index, extensionMethod, results, info);
                    if (QuteProcessor.skipValidation(extensionMethodExcludes, expression, match, info, type)) break;
                    member = extensionMethod.getMethod();
                }
                if (member == null && QuteProcessor.skipValidation(excludes, expression, match, info, match.type())) break;
                if (member == null) {
                    incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), info.value, match.type().toString(), expression.getOrigin()));
                    match.clearValues();
                    break;
                }
                if (type == null) {
                    type = QuteProcessor.resolveType(member, match, index, extensionMethod, results, info);
                }
                ClassInfo clazz = null;
                if (type.kind() == Type.Kind.CLASS || type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    clazz = index.getClassByName(type.name());
                }
                match.setValues(clazz, type);
                if (info.hasHints()) {
                    QuteProcessor.processHints(templateAnalysis, info.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                }
            } else {
                LOGGER.debugf("No match class available - skip further validation for [%s] in expression [%s] in template [%s] on line %s", new Object[]{info.part, expression.toOriginalString(), expression.getOrigin().getTemplateId(), expression.getOrigin().getLine()});
                match.clearValues();
                break;
            }
            lookupConfig.nextPart();
        }
        return QuteProcessor.putResult(match, results, expression);
    }

    private static RootResult processRoot(Expression expression, MatchResult match, TypeInfos.Info root, Iterator<TypeInfos.Info> it, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, IndexView index, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, ClassInfo rootClazz, List<TypeInfos.Info> parts, Map<String, MatchResult> results, Map<Integer, MatchResult> generatedIdsToMatches, Function<String, String> templateIdToPathFun, Types.AssignabilityCheck assignabilityCheck, NamespaceResult namespace) {
        Iterator<TypeInfos.Info> iterator = it;
        boolean ignoring = false;
        if (namespace.hasExtensionMethods()) {
            TemplateExtensionMethodBuildItem extensionMethod = QuteProcessor.findTemplateExtensionMethod(root, null, namespace.extensionMethods, expression, index, templateIdToPathFun, results, assignabilityCheck);
            if (extensionMethod != null) {
                MethodInfo method = extensionMethod.getMethod();
                ClassInfo returnType = index.getClassByName(method.returnType().name());
                if (returnType != null) {
                    match.setValues(returnType, method.returnType());
                    iterator = QuteProcessor.processHintsIfNeeded(root, iterator, parts, templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
                } else {
                    QuteProcessor.putResult(match, results, expression);
                    ignoring = true;
                }
            } else {
                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), String.format("No matching namespace [%s] extension method found", namespace.namespace), expression.getOrigin()));
                match.clearValues();
                QuteProcessor.putResult(match, results, expression);
                ignoring = true;
            }
        } else if (namespace.hasDataNamespaceInfo()) {
            match.setValues(namespace.dataNamespaceExpTypeInfo.rawClass, namespace.dataNamespaceExpTypeInfo.resolvedType);
        } else if (rootClazz == null) {
            if (root.isTypeInfo()) {
                match.setValues(root.asTypeInfo().rawClass, root.asTypeInfo().resolvedType);
                QuteProcessor.processHintsIfNeeded(root, iterator, parts, templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
            } else if (root.hasHints()) {
                iterator = QuteProcessor.processHintsIfNeeded(root, iterator, parts, templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
            } else {
                QuteProcessor.putResult(match, results, expression);
                ignoring = true;
            }
        } else if (namespace.isIn("inject", "cdi")) {
            iterator = QuteProcessor.processHintsIfNeeded(root, iterator, parts, templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions);
        } else if (namespace.templateData != null) {
            match.setValues(rootClazz, Type.create((DotName)rootClazz.name(), (Type.Kind)Type.Kind.CLASS));
            iterator = parts.iterator();
        } else {
            QuteProcessor.putResult(match, results, expression);
            ignoring = true;
        }
        return new RootResult(iterator, ignoring);
    }

    private static boolean processArray(TypeInfos.Info info, MatchResult match) {
        if (info.isProperty()) {
            String name = info.asProperty().name;
            if (name.equals("length") || name.equals("size")) {
                match.setValues(null, (Type)PrimitiveType.INT);
                return true;
            }
            try {
                Integer.parseInt(name);
                Type constituent = match.type().asArrayType().constituent();
                match.setValues(match.assignabilityCheck.computingIndex.getClassByName(constituent.name()), constituent);
                return true;
            }
            catch (NumberFormatException constituent) {}
        } else if (info.isVirtualMethod()) {
            List params = info.asVirtualMethod().part.asVirtualMethod().getParameters();
            String name = info.asVirtualMethod().name;
            if (name.equals("get") && params.size() == 1) {
                Expression param = (Expression)params.get(0);
                Object literalValue = param.getLiteral();
                if (literalValue == null || literalValue instanceof Integer) {
                    Type constituent = match.type().asArrayType().constituent();
                    match.setValues(match.assignabilityCheck.computingIndex.getClassByName(constituent.name()), constituent);
                    return true;
                }
            } else if (name.equals("take") || name.equals("takeLast")) {
                return true;
            }
        }
        return false;
    }

    private static NamespaceResult processNamespace(Expression expression, MatchResult match, IndexView index, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Map<String, BeanInfo> namedBeans, Map<String, MatchResult> results, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, Map<String, TemplateDataBuildItem> namespaceTemplateData, JavaMemberLookupConfig lookupConfig, Map<String, List<TemplateExtensionMethodBuildItem>> namespaceToExtensionMethods, Function<String, String> templateIdToPathFun) {
        String namespace = expression.getNamespace();
        if (namespace == null) {
            return NamespaceResult.EMPTY;
        }
        ClassInfo rootClazz = null;
        TypeInfos.TypeInfo dataNamespaceTypeInfo = null;
        TemplateDataBuildItem templateData = null;
        List<TemplateExtensionMethodBuildItem> namespaceExtensionMethods = null;
        boolean ignored = false;
        if (namespace.equals("inject") || namespace.equals("cdi")) {
            BeanInfo bean = QuteProcessor.findBean(expression, index, incorrectExpressions, namedBeans);
            if (bean != null) {
                rootClazz = bean.getImplClazz();
                match.setValues(rootClazz, bean.getProviderType());
            } else {
                QuteProcessor.putResult(match, results, expression);
                ignored = true;
            }
        } else if (Namespaces.isDataNamespace((String)namespace)) {
            Expression.Part firstPart = (Expression.Part)expression.getParts().get(0);
            String firstPartName = firstPart.getName();
            for (ParameterDeclaration paramDeclaration : templateAnalysis.parameterDeclarations) {
                if (!paramDeclaration.getKey().equals(firstPartName)) continue;
                dataNamespaceTypeInfo = TypeInfos.create(paramDeclaration.getTypeInfo(), firstPart, index, templateIdToPathFun, expression.getOrigin()).asTypeInfo();
                break;
            }
            if (dataNamespaceTypeInfo == null) {
                QuteProcessor.putResult(match, results, expression);
                ignored = true;
            }
        } else {
            templateData = namespaceTemplateData.get(namespace);
            if (templateData != null) {
                rootClazz = templateData.getTargetClass();
                Predicate<AnnotationTarget> filter = QuteProcessor::defaultFilter;
                filter = filter.and(QuteProcessor::staticsFilter);
                filter = filter.and(templateData::filter);
                lookupConfig = new FirstPassJavaMemberLookupConfig(lookupConfig, filter, true);
            } else {
                namespaceExtensionMethods = namespaceToExtensionMethods.get(namespace);
                if (namespaceExtensionMethods == null) {
                    QuteProcessor.putResult(match, results, expression);
                    ignored = true;
                }
            }
        }
        return new NamespaceResult(namespace, rootClazz, dataNamespaceTypeInfo, templateData, namespaceExtensionMethods, ignored, lookupConfig);
    }

    private static boolean isInvalidCheckedTemplateExpression(QuteConfig config, CheckedTemplateBuildItem checkedTemplate, Expression expression, MatchResult match, Map<String, MatchResult> results, TypeInfos.TypeInfo dataNamespaceExpTypeInfo, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (checkedTemplate != null && checkedTemplate.requireTypeSafeExpressions && !expression.hasTypeInfo() && dataNamespaceExpTypeInfo == null) {
            if (!expression.hasNamespace() && expression.getParts().size() == 1 && ITERATION_METADATA_KEYS.contains(((Expression.Part)expression.getParts().get(0)).getName())) {
                Object prefixInfo = config.iterationMetadataPrefix.equals("<alias_>") ? String.format("based on the iteration alias, i.e. the correct key should be something like {it_%1$s} or {element_%1$s}", ((Expression.Part)expression.getParts().get(0)).getName()) : (config.iterationMetadataPrefix.equals("<alias?>") ? String.format("based on the iteration alias, i.e. the correct key should be something like {it?%1$s} or {element?%1$s}", ((Expression.Part)expression.getParts().get(0)).getName()) : ": " + config.iterationMetadataPrefix + ", i.e. the correct key should be: " + config.iterationMetadataPrefix + ((Expression.Part)expression.getParts().get(0)).getName());
                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "An invalid iteration metadata key is probably used\n\t- The configured iteration metadata prefix is " + (String)prefixInfo + "\n\t- You can configure the prefix via the io.quarkus.qute.iteration-metadata-prefix configuration property", expression.getOrigin()));
            } else {
                incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Only type-safe expressions are allowed in the checked template defined via: " + checkedTemplate.getDescription() + "; an expression must be based on a checked template parameter " + checkedTemplate.bindings.keySet() + ", or bound via a param declaration, or the requirement must be relaxed via @CheckedTemplate(requireTypeSafeExpressions = false)", expression.getOrigin()));
            }
            QuteProcessor.putResult(match, results, expression);
            return true;
        }
        return false;
    }

    private static void validateParametersOfNestedVirtualMethods(QuteConfig config, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, Map<String, MatchResult> results, Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Expression expression, IndexView index, Map<DotName, Set<String>> implicitClassToMembersUsed, Function<String, String> templateIdToPathFun, Map<Integer, MatchResult> generatedIdsToMatches, Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> extensionMethodExcludes, CheckedTemplateBuildItem checkedTemplate, JavaMemberLookupConfig lookupConfig, Map<String, BeanInfo> namedBeans, Map<String, TemplateDataBuildItem> namespaceTemplateData, List<TemplateExtensionMethodBuildItem> regularExtensionMethods, Map<String, List<TemplateExtensionMethodBuildItem>> namespaceExtensionMethods, Types.AssignabilityCheck assignabilityCheck) {
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                if (param.isLiteral() && param.getLiteral() == null || results.containsKey(param.toOriginalString())) continue;
                QuteProcessor.validateNestedExpressions(config, templateAnalysis, null, results, excludes, incorrectExpressions, param, index, implicitClassToMembersUsed, templateIdToPathFun, generatedIdsToMatches, extensionMethodExcludes, checkedTemplate, lookupConfig, namedBeans, namespaceTemplateData, regularExtensionMethods, namespaceExtensionMethods, assignabilityCheck);
            }
        }
    }

    private static boolean skipValidation(Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes, Expression expression, MatchResult match, TypeInfos.Info info, Type type) {
        TypeCheckExcludeBuildItem.TypeCheck check = new TypeCheckExcludeBuildItem.TypeCheck(info.isProperty() ? info.asProperty().name : info.asVirtualMethod().name, match.clazz(), type, info.part.isVirtualMethod() ? info.part.asVirtualMethod().getParameters().size() : -1);
        if (QuteProcessor.isExcluded(check, excludes)) {
            LOGGER.debugf("Expression part [%s] excluded from validation of [%s] against type [%s]", (Object)info.value, (Object)expression.toOriginalString(), (Object)match.type());
            match.clearValues();
            return true;
        }
        return false;
    }

    private static MatchResult putResult(MatchResult match, Map<String, MatchResult> results, Expression expression) {
        results.put(expression.toOriginalString(), match);
        return match;
    }

    @BuildStep
    void collectTemplateExtensionMethods(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<MethodInfo, AnnotationInstance> methods = new HashMap<MethodInfo, AnnotationInstance>();
        HashMap<DotName, AnnotationInstance> classes = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance annotationInstance : index.getAnnotations(ExtensionMethodGenerator.TEMPLATE_EXTENSION)) {
            if (annotationInstance.target().kind() == AnnotationTarget.Kind.METHOD) {
                methods.put(annotationInstance.target().asMethod(), annotationInstance);
                continue;
            }
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            classes.put(annotationInstance.target().asClass().name(), annotationInstance);
        }
        for (Map.Entry entry : methods.entrySet()) {
            MethodInfo method = (MethodInfo)entry.getKey();
            AnnotationValue namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            ExtensionMethodGenerator.validate((MethodInfo)method, (String)(namespaceValue != null ? namespaceValue.asString() : null));
            this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
        }
        boolean skippedMethodLevelAnnotation = false;
        for (Map.Entry entry : classes.entrySet()) {
            ClassInfo clazz = ((AnnotationInstance)entry.getValue()).target().asClass();
            AnnotationValue namespaceValue = ((AnnotationInstance)entry.getValue()).value("namespace");
            String namespace = namespaceValue != null ? namespaceValue.asString() : null;
            ArrayList<MethodInfo> found = new ArrayList<MethodInfo>();
            for (MethodInfo method : clazz.methods()) {
                if (!Modifier.isStatic(method.flags()) || method.returnType().kind() == Type.Kind.VOID || Modifier.isPrivate(method.flags()) || ValueResolverGenerator.isSynthetic((int)method.flags()) || (namespace == null || namespace.isEmpty()) && method.parameterTypes().isEmpty()) continue;
                if (methods.containsKey(method)) {
                    skippedMethodLevelAnnotation = true;
                    continue;
                }
                found.add(method);
                LOGGER.debugf("Found template extension method %s declared on %s", (Object)method, (Object)method.declaringClass().name());
            }
            if (found.isEmpty() && !skippedMethodLevelAnnotation) {
                throw new IllegalStateException("No template extension methods declared on " + entry.getKey() + "; a template extension method must be static, non-private and must not return void");
            }
            for (MethodInfo method : found) {
                this.produceExtensionMethod(index, extensionMethods, method, (AnnotationInstance)entry.getValue());
            }
        }
    }

    private void produceExtensionMethod(IndexView index, BuildProducer<TemplateExtensionMethodBuildItem> extensionMethods, MethodInfo method, AnnotationInstance extensionAnnotation) {
        int matchers = 0;
        String matchName = null;
        AnnotationValue matchNameValue = extensionAnnotation.value("matchName");
        if (matchNameValue != null) {
            matchName = matchNameValue.asString();
            matchers = (byte)(matchers + 1);
        }
        if (matchName == null) {
            matchName = method.name();
        }
        int priority = 5;
        AnnotationValue priorityValue = extensionAnnotation.value("priority");
        if (priorityValue != null) {
            priority = priorityValue.asInt();
        }
        String namespace = "";
        AnnotationValue namespaceValue = extensionAnnotation.value("namespace");
        if (namespaceValue != null) {
            namespace = namespaceValue.asString();
        }
        String matchRegex = null;
        AnnotationValue matchRegexValue = extensionAnnotation.value("matchRegex");
        if (matchRegexValue != null) {
            matchRegex = matchRegexValue.asString();
            matchers = (byte)(matchers + 1);
        }
        ArrayList<String> matchNames = new ArrayList<String>();
        AnnotationValue matchNamesValue = extensionAnnotation.value("matchNames");
        if (matchNamesValue != null) {
            matchers = (byte)(matchers + 1);
            for (String name : matchNamesValue.asStringArray()) {
                matchNames.add(name);
            }
        }
        if (matchers > 1) {
            LOGGER.warnf("Ignoring superfluous matching conditions defined on %s declared on: %s", (Object)extensionAnnotation, (Object)extensionAnnotation.target());
        }
        extensionMethods.produce((BuildItem)new TemplateExtensionMethodBuildItem(method, matchName, matchNames, matchRegex, namespace.isEmpty() ? method.parameterType(0) : null, priority, namespace));
    }

    private static BeanInfo findBean(Expression expression, IndexView index, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions, Map<String, BeanInfo> namedBeans) {
        Expression.Part firstPart = (Expression.Part)expression.getParts().get(0);
        if (firstPart.isVirtualMethod()) {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "The inject: namespace must be followed by a bean name", expression.getOrigin()));
            return null;
        }
        String beanName = firstPart.getName();
        BeanInfo bean = namedBeans.get(beanName);
        if (bean != null) {
            return bean;
        }
        incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), beanName, null, expression.getOrigin()));
        return null;
    }

    static boolean defaultFilter(AnnotationTarget target) {
        short flags;
        switch (target.kind()) {
            case METHOD: {
                flags = target.asMethod().flags();
                break;
            }
            case FIELD: {
                flags = target.asField().flags();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return Modifier.isPublic(flags) && !ValueResolverGenerator.isSynthetic((int)flags);
    }

    static boolean staticsFilter(AnnotationTarget target) {
        switch (target.kind()) {
            case METHOD: {
                return Modifier.isStatic(target.asMethod().flags());
            }
            case FIELD: {
                return Modifier.isStatic(target.asField().flags());
            }
        }
        throw new IllegalArgumentException();
    }

    static boolean enumConstantFilter(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.FIELD) {
            return target.asField().isEnumConstant();
        }
        return false;
    }

    static String findTemplatePath(TemplatesAnalysisBuildItem analysis, String id) {
        for (TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis : analysis.getAnalysis()) {
            if (!templateAnalysis.generatedId.equals(id)) continue;
            return templateAnalysis.path;
        }
        return null;
    }

    @BuildStep
    void generateValueResolvers(QuteConfig config, BuildProducer<GeneratedClassBuildItem> generatedClasses, BeanArchiveIndexBuildItem beanArchiveIndex, ApplicationArchivesBuildItem applicationArchivesBuildItem, List<TemplatePathBuildItem> templatePaths, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, List<ImplicitValueResolverBuildItem> implicitClasses, TemplatesAnalysisBuildItem templatesAnalysis, List<PanacheEntityClassesBuildItem> panacheEntityClasses, List<TemplateDataBuildItem> templateData, List<TemplateGlobalBuildItem> templateGlobals, List<IncorrectExpressionBuildItem> incorrectExpressions, LiveReloadBuildItem liveReloadBuildItem, CompletedApplicationClassPredicateBuildItem applicationClassPredicate, BuildProducer<GeneratedValueResolverBuildItem> generatedResolvers, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<GeneratedTemplateInitializerBuildItem> generatedInitializers) {
        if (!incorrectExpressions.isEmpty()) {
            return;
        }
        IndexView index = beanArchiveIndex.getIndex();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                String className;
                int idx = name.lastIndexOf("_Namespace_Extension_ValueResolver");
                if (idx == -1) {
                    idx = name.lastIndexOf("_Extension_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_Namespace_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_ValueResolver");
                }
                if (idx == -1) {
                    idx = name.lastIndexOf("_Globals");
                }
                if ((className = name.substring(0, idx)).contains("$_")) {
                    className = className.replace("$_", "$");
                }
                return className;
            }
        });
        ExistingValueResolvers existingValueResolvers = (ExistingValueResolvers)liveReloadBuildItem.getContextObject(ExistingValueResolvers.class);
        if (existingValueResolvers == null || !liveReloadBuildItem.isLiveReload()) {
            existingValueResolvers = new ExistingValueResolvers();
            liveReloadBuildItem.setContextObject(ExistingValueResolvers.class, (Object)existingValueResolvers);
        }
        HashSet<String> generatedValueResolvers = new HashSet<String>();
        ValueResolverGenerator.Builder builder = ValueResolverGenerator.builder().setIndex(index).setClassOutput((ClassOutput)classOutput);
        if (!panacheEntityClasses.isEmpty()) {
            final HashSet entityClasses = new HashSet();
            for (PanacheEntityClassesBuildItem panacheEntityClassesBuildItem : panacheEntityClasses) {
                entityClasses.addAll(panacheEntityClassesBuildItem.getEntityClasses());
            }
            builder.setForceGettersFunction((Function)new Function<ClassInfo, Function<FieldInfo, String>>(){

                @Override
                public Function<FieldInfo, String> apply(ClassInfo clazz) {
                    if (entityClasses.contains(clazz.name().toString())) {
                        return GETTER_FUN;
                    }
                    return null;
                }
            });
        }
        HashSet<DotName> controlled = new HashSet<DotName>();
        HashMap<DotName, AnnotationInstance> uncontrolled = new HashMap<DotName, AnnotationInstance>();
        for (TemplateDataBuildItem data : templateData) {
            this.processTemplateData(data, controlled, uncontrolled, builder);
        }
        for (ImplicitValueResolverBuildItem implicit : implicitClasses) {
            DotName implicitClassName = implicit.getClazz().name();
            if (controlled.contains(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %s ignored: class is annotated with @TemplateData", (Object)implicitClassName);
                continue;
            }
            if (uncontrolled.containsKey(implicitClassName)) {
                LOGGER.debugf("Implicit value resolver for %s ignored: %s declared on %s", (Object)implicitClassName, uncontrolled.get(implicitClassName), (Object)((AnnotationInstance)uncontrolled.get(implicitClassName)).target());
                continue;
            }
            builder.addClass(implicit.getClazz(), implicit.getTemplateData());
        }
        ValueResolverGenerator valueResolverGenerator = builder.build();
        valueResolverGenerator.generate();
        generatedValueResolvers.addAll(valueResolverGenerator.getGeneratedTypes());
        ExtensionMethodGenerator extensionMethodGenerator = new ExtensionMethodGenerator(index, (ClassOutput)classOutput);
        HashMap classToNamespaceExtensions = new HashMap();
        HashMap<String, DotName> namespaceToClass = new HashMap<String, DotName>();
        for (TemplateExtensionMethodBuildItem templateExtensionMethodBuildItem : templateExtensionMethods) {
            String generatedValueResolverClass = existingValueResolvers.getGeneratedClass(templateExtensionMethodBuildItem.getMethod());
            if (generatedValueResolverClass != null) {
                generatedValueResolvers.add(generatedValueResolverClass);
                continue;
            }
            if (templateExtensionMethodBuildItem.hasNamespace()) {
                ArrayList<TemplateExtensionMethodBuildItem> namespaceMethods;
                DotName declaringClassName = templateExtensionMethodBuildItem.getMethod().declaringClass().name();
                DotName dotName = (DotName)namespaceToClass.get(templateExtensionMethodBuildItem.getNamespace());
                if (dotName == null) {
                    namespaceToClass.put(templateExtensionMethodBuildItem.getNamespace(), dotName);
                } else if (!dotName.equals((Object)declaringClassName)) {
                    throw new IllegalStateException("Template extension methods that share the namespace " + templateExtensionMethodBuildItem.getNamespace() + " must be declared on the same class; but declared on " + dotName + " and " + declaringClassName);
                }
                HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>> namespaceToExtensions = (HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>>)classToNamespaceExtensions.get(declaringClassName);
                if (namespaceToExtensions == null) {
                    namespaceToExtensions = new HashMap<String, ArrayList<TemplateExtensionMethodBuildItem>>();
                    classToNamespaceExtensions.put(declaringClassName, namespaceToExtensions);
                }
                if ((namespaceMethods = (ArrayList<TemplateExtensionMethodBuildItem>)namespaceToExtensions.get(templateExtensionMethodBuildItem.getNamespace())) == null) {
                    namespaceMethods = new ArrayList<TemplateExtensionMethodBuildItem>();
                    namespaceToExtensions.put(templateExtensionMethodBuildItem.getNamespace(), namespaceMethods);
                }
                namespaceMethods.add(templateExtensionMethodBuildItem);
                continue;
            }
            String generatedClass = extensionMethodGenerator.generate(templateExtensionMethodBuildItem.getMethod(), templateExtensionMethodBuildItem.getMatchName(), templateExtensionMethodBuildItem.getMatchNames(), templateExtensionMethodBuildItem.getMatchRegex(), Integer.valueOf(templateExtensionMethodBuildItem.getPriority()));
            existingValueResolvers.add(templateExtensionMethodBuildItem.getMethod(), generatedClass, (Predicate<DotName>)applicationClassPredicate);
        }
        for (Map.Entry entry : classToNamespaceExtensions.entrySet()) {
            Map namespaceToMethods = (Map)entry.getValue();
            for (Map.Entry entry2 : namespaceToMethods.entrySet()) {
                Map<Integer, List<TemplateExtensionMethodBuildItem>> priorityToMethods = ((List)entry2.getValue()).stream().collect(Collectors.groupingBy(TemplateExtensionMethodBuildItem::getPriority));
                for (Map.Entry<Integer, List<TemplateExtensionMethodBuildItem>> priorityEntry : priorityToMethods.entrySet()) {
                    ExtensionMethodGenerator.NamespaceResolverCreator namespaceResolverCreator = extensionMethodGenerator.createNamespaceResolver(priorityEntry.getValue().get(0).getMethod().declaringClass(), (String)entry2.getKey(), priorityEntry.getKey().intValue());
                    try {
                        for (TemplateExtensionMethodBuildItem extensionMethod : priorityEntry.getValue()) {
                            existingValueResolvers.add(extensionMethod.getMethod(), namespaceResolverCreator.getClassName(), (Predicate<DotName>)applicationClassPredicate);
                        }
                        ExtensionMethodGenerator.NamespaceResolverCreator.ResolveCreator resolveCreator = namespaceResolverCreator.implementResolve();
                        try {
                            for (TemplateExtensionMethodBuildItem method : priorityEntry.getValue()) {
                                resolveCreator.addMethod(method.getMethod(), method.getMatchName(), method.getMatchNames(), method.getMatchRegex());
                            }
                        }
                        finally {
                            if (resolveCreator == null) continue;
                            resolveCreator.close();
                        }
                    }
                    finally {
                        if (namespaceResolverCreator == null) continue;
                        namespaceResolverCreator.close();
                    }
                }
            }
        }
        generatedValueResolvers.addAll(extensionMethodGenerator.getGeneratedTypes());
        LOGGER.debugf("Generated %s value resolvers: %s", generatedValueResolvers.size(), generatedValueResolvers);
        for (String string : generatedValueResolvers) {
            generatedResolvers.produce((BuildItem)new GeneratedValueResolverBuildItem(string));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{string}).build());
        }
        if (!templateGlobals.isEmpty()) {
            TemplateGlobalGenerator globalGenerator = new TemplateGlobalGenerator((ClassOutput)classOutput);
            HashMap<DotName, Map<String, AnnotationTarget>> hashMap = new HashMap<DotName, Map<String, AnnotationTarget>>();
            Map<DotName, List<TemplateGlobalBuildItem>> classToGlobals = templateGlobals.stream().collect(Collectors.groupingBy(TemplateGlobalBuildItem::getDeclaringClass));
            for (Map.Entry<Object, Object> entry : classToGlobals.entrySet()) {
                hashMap.put((DotName)entry.getKey(), ((List)entry.getValue()).stream().collect(Collectors.toMap(TemplateGlobalBuildItem::getName, TemplateGlobalBuildItem::getTarget)));
            }
            for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
                globalGenerator.generate(index.getClassByName((DotName)entry.getKey()), (Map)entry.getValue());
            }
            for (String string : globalGenerator.getGeneratedTypes()) {
                generatedInitializers.produce((BuildItem)new GeneratedTemplateInitializerBuildItem(string));
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{string}).build());
            }
        }
    }

    @BuildStep
    void collectTemplates(ApplicationArchivesBuildItem applicationArchives, CurateOutcomeBuildItem curateOutcome, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, QuteConfig config) throws IOException {
        HashSet basePaths = new HashSet();
        Set allApplicationArchives = applicationArchives.getAllApplicationArchives();
        List extensionArtifacts = curateOutcome.getApplicationModel().getDependencies().stream().filter(Dependency::isRuntimeExtensionArtifact).collect(Collectors.toList());
        block12: for (ResolvedDependency artifact : extensionArtifacts) {
            if (this.isApplicationArchive(artifact, allApplicationArchives)) continue;
            for (Path path : artifact.getResolvedPaths()) {
                Path basePath;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Stream<Path> paths = Files.list(path);
                    try {
                        basePath = paths.filter(QuteProcessor::isBasePath).findFirst().orElse(null);
                        if (basePath == null) continue;
                        LOGGER.debugf("Found extension templates dir: %s", (Object)path);
                        this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                        continue block12;
                    }
                    finally {
                        if (paths != null) {
                            paths.close();
                        }
                        continue block12;
                    }
                }
                try {
                    FileSystem artifactFs = ZipUtils.newFileSystem((Path)path);
                    try {
                        basePath = artifactFs.getPath(BASE_PATH, new String[0]);
                        if (!Files.exists(basePath, new LinkOption[0])) continue;
                        LOGGER.debugf("Found extension templates in: %s", (Object)path);
                        this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                    }
                    finally {
                        if (artifactFs == null) continue;
                        artifactFs.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warnf((Throwable)e, "Unable to create the file system from the path: %s", (Object)path);
                }
            }
        }
        for (ApplicationArchive archive : allApplicationArchives) {
            archive.accept(tree -> {
                for (Path rootDir : tree.getRoots()) {
                    try {
                        Stream<Path> rootDirPaths = Files.list(rootDir);
                        try {
                            Path basePath = rootDirPaths.filter(QuteProcessor::isBasePath).findFirst().orElse(null);
                            if (basePath == null) continue;
                            LOGGER.debugf("Found templates dir: %s", (Object)basePath);
                            basePaths.add(basePath);
                            this.scan(basePath, basePath, "templates/", watchedPaths, templatePaths, nativeImageResources, config);
                            break;
                        }
                        finally {
                            if (rootDirPaths == null) continue;
                            rootDirPaths.close();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }
    }

    @BuildStep
    TemplateFilePathsBuildItem collectTemplateFilePaths(QuteConfig config, List<TemplatePathBuildItem> templatePaths) {
        HashSet<String> filePaths = new HashSet<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            String path = templatePath.getPath();
            filePaths.add(path);
            for (String suffix : config.suffixes) {
                if (!path.endsWith(suffix)) continue;
                filePaths.add(path.substring(0, path.length() - (suffix.length() + 1)));
            }
        }
        return new TemplateFilePathsBuildItem(filePaths);
    }

    @BuildStep
    void validateTemplateInjectionPoints(TemplateFilePathsBuildItem filePaths, List<TemplatePathBuildItem> templatePaths, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, CustomTemplateLocatorPatternsBuildItem locatorPatternsBuildItem) {
        for (InjectionPointInfo injectionPoint : validationPhase.getContext().getInjectionPoints()) {
            AnnotationInstance location;
            String name;
            if (!injectionPoint.getRequiredType().name().equals((Object)Names.TEMPLATE) || (name = (location = injectionPoint.getRequiredQualifier(Names.LOCATION)) != null ? location.value().asString() : (injectionPoint.hasDefaultedQualifier() ? QuteProcessor.getName(injectionPoint) : null)) == null || filePaths.contains(name) || !this.isNotLocatedByCustomTemplateLocator(locatorPatternsBuildItem.getLocationPatterns(), name)) continue;
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("No template found for path [%s] defined at %s\n\t- available templates: %s", name, injectionPoint.getTargetInfo(), templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toList())))}));
        }
    }

    @BuildStep
    CustomTemplateLocatorPatternsBuildItem validateAndCollectCustomTemplateLocatorLocations(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Pattern> locationPatterns = new ArrayList<Pattern>();
        for (AnnotationInstance locate : beanArchiveIndex.getIndex().getAnnotations(Names.LOCATE)) {
            AnnotationTarget locateTarget = locate.target();
            if (locateTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
            if (Types.isImplementorOf(locateTarget.asClass(), Names.TEMPLATE_LOCATOR, beanArchiveIndex.getIndex())) {
                this.addLocationRegExToLocators(locationPatterns, locate.value(), locateTarget, validationErrors);
                continue;
            }
            this.reportFoundInvalidTarget(validationErrors, locateTarget);
        }
        for (AnnotationInstance locates : beanArchiveIndex.getIndex().getAnnotations(Names.LOCATES)) {
            AnnotationTarget locatesTarget = locates.target();
            if (locatesTarget.kind() != AnnotationTarget.Kind.CLASS) continue;
            if (Types.isImplementorOf(locatesTarget.asClass(), Names.TEMPLATE_LOCATOR, beanArchiveIndex.getIndex())) {
                for (AnnotationInstance locate : locates.value().asNestedArray()) {
                    this.addLocationRegExToLocators(locationPatterns, locate.value(), locatesTarget, validationErrors);
                }
                continue;
            }
            this.reportFoundInvalidTarget(validationErrors, locatesTarget);
        }
        return new CustomTemplateLocatorPatternsBuildItem(locationPatterns);
    }

    @BuildStep
    void collectEngineConfigurations(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<EngineConfigurationsBuildItem> engineConfig, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        Collection engineConfigAnnotations = beanArchiveIndex.getIndex().getAnnotations(Names.ENGINE_CONFIGURATION);
        if (engineConfigAnnotations.isEmpty()) {
            return;
        }
        ArrayList<ClassInfo> engineConfigClasses = new ArrayList<ClassInfo>();
        IndexView index = beanArchiveIndex.getIndex();
        for (AnnotationInstance annotation : engineConfigAnnotations) {
            AnnotationTarget target = annotation.target();
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo targetClass = target.asClass();
            if (!(targetClass.nestingType() == ClassInfo.NestingType.TOP_LEVEL || targetClass.nestingType() == ClassInfo.NestingType.INNER && Modifier.isStatic(targetClass.flags()))) {
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("Only top-level and static nested classes may be annotated with @%s: %s", EngineConfiguration.class.getSimpleName(), targetClass.name()))}));
                continue;
            }
            if (Types.isImplementorOf(targetClass, Names.SECTION_HELPER_FACTORY, index)) {
                if (targetClass.hasNoArgsConstructor()) {
                    engineConfigClasses.add(targetClass);
                    continue;
                }
                validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("A class annotated with @%s that also implements io.quarkus.qute.SectionHelperFactory must declare a no-args constructor: %s", EngineConfiguration.class.getSimpleName(), targetClass.name()))}));
                continue;
            }
            if (Types.isImplementorOf(targetClass, Names.VALUE_RESOLVER, index) || Types.isImplementorOf(targetClass, Names.NAMESPACE_RESOLVER, index)) {
                engineConfigClasses.add(targetClass);
                continue;
            }
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("A class annotated with @%s must implement one of the %s: %s", EngineConfiguration.class.getSimpleName(), Arrays.toString(new String[]{SectionHelperFactory.class.getName(), ValueResolver.class.getName(), NamespaceResolver.class.getName()}), targetClass.name()))}));
        }
        engineConfig.produce((BuildItem)new EngineConfigurationsBuildItem(engineConfigClasses));
    }

    private void addLocationRegExToLocators(Collection<Pattern> locationToLocators, AnnotationValue value, AnnotationTarget target, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        String regex = value.asString();
        if (regex.isBlank()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("'io.quarkus.qute.Locate#value()' must not be blank: %s", target.asClass().name().toString()))}));
        } else {
            locationToLocators.add(Pattern.compile(regex));
        }
    }

    private void reportFoundInvalidTarget(BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, AnnotationTarget locateTarget) {
        validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new TemplateException(String.format("Classes annotated with 'io.quarkus.qute.Locate' must implement 'io.quarkus.qute.TemplateLocator': %s", locateTarget.asClass().name().toString()))}));
    }

    @BuildStep
    TemplateVariantsBuildItem collectTemplateVariants(List<TemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(TemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.indexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        LOGGER.debugf("Template variants found: %s", baseToVariants);
        return new TemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep
    void excludeTypeChecks(QuteConfig config, BuildProducer<TypeCheckExcludeBuildItem> excludes) {
        final List<String> skipOperators = Arrays.asList("?:", "or", ":", "?", "ifTruthy", "&&", "||");
        excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

            @Override
            public boolean test(TypeCheckExcludeBuildItem.TypeCheck check) {
                if (check.isProperty() && ("raw".equals(check.name) || "safe".equals(check.name) || "orEmpty".equals(check.name))) {
                    return true;
                }
                if (check.numberOfParameters == 1 && skipOperators.contains(check.name)) {
                    return true;
                }
                return check.numberOfParameters == 1 && check.classNameEquals(Names.COLLECTION) && check.name.equals("contains");
            }
        }));
        excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

            @Override
            public boolean test(TypeCheckExcludeBuildItem.TypeCheck typeCheck) {
                return "or".equals(typeCheck.name) && typeCheck.type != null && DotNames.OBJECT.equals((Object)typeCheck.type.name());
            }
        }, true));
        if (config.typeCheckExcludes.isPresent()) {
            for (String exclude : (List)config.typeCheckExcludes.get()) {
                String[] parts = exclude.split("\\.");
                if (parts.length < 2) continue;
                final String className = Arrays.stream(parts).limit(parts.length - 1).collect(Collectors.joining("."));
                final String propertyName = parts[parts.length - 1];
                excludes.produce((BuildItem)new TypeCheckExcludeBuildItem(new Predicate<TypeCheckExcludeBuildItem.TypeCheck>(){

                    @Override
                    public boolean test(TypeCheckExcludeBuildItem.TypeCheck check) {
                        if (!className.equals("*") && !check.clazz.name().toString().equals(className)) {
                            return false;
                        }
                        return propertyName.equals("*") || check.name.equals(propertyName);
                    }
                }));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initialize(BuildProducer<SyntheticBeanBuildItem> syntheticBeans, QuteRecorder recorder, List<GeneratedValueResolverBuildItem> generatedValueResolvers, List<TemplatePathBuildItem> templatePaths, Optional<TemplateVariantsBuildItem> templateVariants, List<GeneratedTemplateInitializerBuildItem> templateInitializers) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        for (TemplatePathBuildItem templatePath : templatePaths) {
            if (templatePath.isTag()) {
                String tagPath = templatePath.getPath();
                tags.add(tagPath.substring("tags/".length(), tagPath.length()));
                continue;
            }
            templates.add(templatePath.getPath());
        }
        Map<Object, Object> variants = templateVariants.isPresent() ? templateVariants.get().getVariants() : Collections.emptyMap();
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(QuteRecorder.QuteContext.class).supplier(recorder.createContext(generatedValueResolvers.stream().map(GeneratedValueResolverBuildItem::getClassName).collect(Collectors.toList()), templates, tags, variants, templateInitializers.stream().map(GeneratedTemplateInitializerBuildItem::getClassName).collect(Collectors.toList()))).done());
    }

    @BuildStep
    QualifierRegistrarBuildItem turnLocationIntoQualifier() {
        return new QualifierRegistrarBuildItem(new QualifierRegistrar(){

            public Map<DotName, Set<String>> getAdditionalQualifiers() {
                return Collections.singletonMap(Names.LOCATION, Collections.singleton("value"));
            }
        });
    }

    private static Type resolveType(AnnotationTarget member, MatchResult match, IndexView index, TemplateExtensionMethodBuildItem extensionMethod, Map<String, MatchResult> results, TypeInfos.Info info) {
        Type matchType;
        if (member.kind() == AnnotationTarget.Kind.FIELD) {
            matchType = member.asField().type();
        } else if (member.kind() == AnnotationTarget.Kind.METHOD) {
            matchType = member.asMethod().returnType();
        } else {
            throw new IllegalStateException("Unsupported member type: " + member);
        }
        if (Types.containsTypeVariable(matchType)) {
            Object typeParameters;
            if (match.clazz == null) {
                if (member.kind() == AnnotationTarget.Kind.METHOD && match.isPrimitive()) {
                    Type wrapperType = Types.box((Type)match.type.asPrimitiveType());
                    match.setValues(index.getClassByName(wrapperType.name()), wrapperType);
                } else {
                    return matchType;
                }
            }
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            DotName declaringClassName = null;
            Type extensionMatchBase = null;
            if (member.kind() == AnnotationTarget.Kind.METHOD) {
                MethodInfo method = member.asMethod();
                typeParameters = method.typeParameters();
                if (extensionMethod != null && !extensionMethod.hasNamespace() && !typeParameters.isEmpty()) {
                    List params = method.parameterTypes();
                    Set attributeAnnotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD_PARAMETER, (DotName)ExtensionMethodGenerator.TEMPLATE_ATTRIBUTE, (Collection)method.annotations());
                    if (attributeAnnotations.isEmpty()) {
                        extensionMatchBase = (Type)params.get(0);
                    } else {
                        int i = 0;
                        while (i < params.size()) {
                            int position = i++;
                            if (!attributeAnnotations.stream().noneMatch(a -> a.target().asMethodParameter().position() == position)) continue;
                            extensionMatchBase = (Type)params.get(i);
                            break;
                        }
                    }
                    if (extensionMatchBase != null && Types.containsTypeVariable(extensionMatchBase)) {
                        if (extensionMatchBase.kind() == Type.Kind.TYPE_VARIABLE && attributeAnnotations.isEmpty() && extensionMatchBase.name().equals((Object)matchType.name()) && info.isVirtualMethod()) {
                            if (info.part.asVirtualMethod().getParameters() != null && !info.part.asVirtualMethod().getParameters().isEmpty()) {
                                List paramExpressions = info.part.asVirtualMethod().getParameters();
                                for (int i = 1; i < params.size() && i - 1 < paramExpressions.size(); ++i) {
                                    MatchResult paramMatch;
                                    if (!((Type)params.get(i)).name().equals((Object)extensionMatchBase.name()) || (paramMatch = results.get(((Expression)paramExpressions.get(i - 1)).toOriginalString())) == null) continue;
                                    Type paramMatchType = paramMatch.type();
                                    if (paramMatch.isPrimitive()) {
                                        paramMatchType = Types.box(paramMatch.type());
                                    }
                                    if (match.type().equals((Object)paramMatchType)) continue;
                                    return matchType;
                                }
                            }
                            return match.type();
                        }
                        declaringClassName = extensionMatchBase.name();
                    }
                } else {
                    declaringClassName = method.declaringClass().name();
                }
            } else if (member.kind() == AnnotationTarget.Kind.FIELD) {
                declaringClassName = member.asField().declaringClass().name();
            }
            Type declaringType = null;
            if (declaringClassName != null) {
                for (Type type : closure) {
                    if (!type.name().equals((Object)declaringClassName)) continue;
                    declaringType = type;
                    break;
                }
            }
            if (declaringType != null && declaringType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                typeParameters = extensionMatchBase != null ? extensionMethod.getMethod().typeParameters() : index.getClassByName(declaringType.name()).typeParameters();
                matchType = Types.resolveTypeParam(matchType, Types.buildResolvedMap(declaringType.asParameterizedType().arguments(), (List<TypeVariable>)typeParameters, Collections.emptyMap(), index), index);
            }
        }
        return matchType;
    }

    static Iterator<TypeInfos.Info> processHintsIfNeeded(TypeInfos.Info root, Iterator<TypeInfos.Info> iterator, List<TypeInfos.Info> parts, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, List<String> helperHints, MatchResult match, IndexView index, Expression expression, Map<Integer, MatchResult> generatedIdsToMatches, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (root.hasHints() && QuteProcessor.processHints(templateAnalysis, root.asHintInfo().hints, match, index, expression, generatedIdsToMatches, incorrectExpressions)) {
            return parts.iterator();
        }
        return iterator;
    }

    static boolean processHints(TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis, List<String> helperHints, MatchResult match, IndexView index, Expression expression, Map<Integer, MatchResult> generatedIdsToMatches, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (helperHints == null || helperHints.isEmpty()) {
            return false;
        }
        for (String helperHint : helperHints) {
            if (helperHint.equals("<loop-element>")) {
                QuteProcessor.processLoopElementHint(match, index, expression, incorrectExpressions);
                continue;
            }
            if (helperHint.startsWith("<loop#")) {
                QuteProcessor.setMatchValues(match, QuteProcessor.findExpression(helperHint, "<loop#", templateAnalysis), generatedIdsToMatches, index);
                continue;
            }
            if (helperHint.startsWith("<when#")) {
                MatchResult valueExprMatch;
                Expression valueExpr = QuteProcessor.findExpression(helperHint, "<when#", templateAnalysis);
                if (valueExpr == null || (valueExprMatch = generatedIdsToMatches.get(valueExpr.getGeneratedId())) == null || !valueExprMatch.clazz.isEnum()) continue;
                match.setValues(valueExprMatch.clazz, valueExprMatch.type);
                return true;
            }
            if (!helperHint.startsWith("<set#")) continue;
            QuteProcessor.setMatchValues(match, QuteProcessor.findExpression(helperHint, "<set#", templateAnalysis), generatedIdsToMatches, index);
        }
        return false;
    }

    private static void setMatchValues(MatchResult match, Expression valueExpr, Map<Integer, MatchResult> generatedIdsToMatches, IndexView index) {
        if (valueExpr != null) {
            if (valueExpr.isLiteral()) {
                Object literalValue = valueExpr.getLiteral();
                if (literalValue == null) {
                    match.clearValues();
                } else if (literalValue instanceof Boolean) {
                    match.setValues(index.getClassByName(DotNames.BOOLEAN), Types.box(PrimitiveType.Primitive.BOOLEAN));
                } else if (literalValue instanceof String) {
                    match.setValues(index.getClassByName(DotNames.STRING), Type.create((DotName)DotNames.STRING, (Type.Kind)Type.Kind.CLASS));
                } else if (literalValue instanceof Integer) {
                    match.setValues(index.getClassByName(DotNames.INTEGER), Types.box(PrimitiveType.Primitive.INT));
                } else if (literalValue instanceof Long) {
                    match.setValues(index.getClassByName(DotNames.LONG), Types.box(PrimitiveType.Primitive.LONG));
                } else if (literalValue instanceof Double) {
                    match.setValues(index.getClassByName(DotNames.DOUBLE), Types.box(PrimitiveType.Primitive.DOUBLE));
                } else if (literalValue instanceof Float) {
                    match.setValues(index.getClassByName(DotNames.FLOAT), Types.box(PrimitiveType.Primitive.FLOAT));
                }
            } else {
                MatchResult valueExprMatch = generatedIdsToMatches.get(valueExpr.getGeneratedId());
                if (valueExprMatch != null) {
                    match.setValues(valueExprMatch.clazz, valueExprMatch.type);
                }
            }
        }
    }

    private static Expression findExpression(String helperHint, String hintPrefix, TemplatesAnalysisBuildItem.TemplateAnalysis templateAnalysis) {
        return templateAnalysis.findExpression(Integer.parseInt(helperHint.substring(hintPrefix.length(), helperHint.length() - 1)));
    }

    private static Expression findExpression(int generatedId, Iterable<Expression> expressions) {
        for (Expression expression : expressions) {
            if (expression.getGeneratedId() != generatedId) continue;
            return expression;
        }
        return null;
    }

    private static int parseHintId(String helperHint, String hintPrefix) {
        return Integer.parseInt(helperHint.substring(hintPrefix.length(), helperHint.length() - 1));
    }

    static void processLoopElementHint(MatchResult match, IndexView index, Expression expression, BuildProducer<IncorrectExpressionBuildItem> incorrectExpressions) {
        if (match.isEmpty() || match.type().name().equals((Object)DotNames.INTEGER) || match.type().equals((Object)PrimitiveType.INT)) {
            return;
        }
        Type matchType = null;
        if (match.isArray()) {
            matchType = match.type().asArrayType().constituent();
        } else if (match.isClass() || match.isParameterizedType()) {
            Set<Type> closure = Types.getTypeClosure(match.clazz, Types.buildResolvedMap(match.getParameterizedTypeArguments(), match.getTypeParameters(), new HashMap<TypeVariable, Type>(), index), index);
            matchType = QuteProcessor.extractMatchType(closure, Names.ITERABLE, FIRST_PARAM_TYPE_EXTRACT_FUN);
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.STREAM, FIRST_PARAM_TYPE_EXTRACT_FUN);
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.MAP, MAP_ENTRY_EXTRACT_FUN);
            }
            if (matchType == null) {
                matchType = QuteProcessor.extractMatchType(closure, Names.ITERATOR, FIRST_PARAM_TYPE_EXTRACT_FUN);
            }
        }
        if (matchType != null) {
            match.setValues(index.getClassByName(matchType.name()), matchType);
        } else {
            incorrectExpressions.produce((BuildItem)new IncorrectExpressionBuildItem(expression.toOriginalString(), "Unsupported iterable type found: " + match.type, expression.getOrigin()));
            match.clearValues();
        }
    }

    static Type extractMatchType(Set<Type> closure, DotName matchName, Function<Type, Type> extractFun) {
        Type type = null;
        for (Type t : closure) {
            if (!t.name().equals((Object)matchName)) continue;
            type = t;
        }
        return type != null ? extractFun.apply(type) : null;
    }

    private static TemplateExtensionMethodBuildItem findTemplateExtensionMethod(TypeInfos.Info info, Type matchType, List<TemplateExtensionMethodBuildItem> templateExtensionMethods, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, MatchResult> results, Types.AssignabilityCheck assignabilityCheck) {
        if (!info.isProperty() && !info.isVirtualMethod()) {
            return null;
        }
        String name = info.isProperty() ? info.asProperty().name : info.asVirtualMethod().name;
        for (TemplateExtensionMethodBuildItem extensionMethod : templateExtensionMethods) {
            List evaluatedParams;
            if (!extensionMethod.matchesName(name) || matchType != null && !assignabilityCheck.isAssignableFrom(extensionMethod.getMatchType(), matchType) || (evaluatedParams = extensionMethod.getParams().evaluated()).size() > 0 && !info.isVirtualMethod()) continue;
            if (info.isVirtualMethod()) {
                Expression.VirtualMethodPart virtualMethod = info.part.asVirtualMethod();
                boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)extensionMethod.getMethod());
                int lastParamIdx = evaluatedParams.size() - 1;
                if (isVarArgs ? evaluatedParams.size() - 1 > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != evaluatedParams.size()) continue;
                boolean matches = true;
                int idx = 0;
                for (Expression param : virtualMethod.getParameters()) {
                    MatchResult result = results.get(param.toOriginalString());
                    if (result != null && !result.isEmpty()) {
                        Type paramType = isVarArgs && idx >= lastParamIdx ? ((ExtensionMethodGenerator.Param)evaluatedParams.get((int)lastParamIdx)).type.asArrayType().constituent() : ((ExtensionMethodGenerator.Param)evaluatedParams.get((int)idx)).type;
                        if (!assignabilityCheck.isAssignableFrom(paramType, result.type)) {
                            matches = false;
                            break;
                        }
                    } else {
                        LOGGER.debugf("Type info not available - skip validation for parameter [%s] of extension method [%s] for expression [%s] in template [%s] on line %s", new Object[]{extensionMethod.getMethod().parameterName(idx), extensionMethod.getMethod().declaringClass().name() + "#" + extensionMethod.getMethod(), expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
                    }
                    ++idx;
                }
                if (!matches) continue;
            }
            return extensionMethod;
        }
        return null;
    }

    private static AnnotationTarget findProperty(String name, ClassInfo clazz, JavaMemberLookupConfig config) {
        HashSet<DotName> interfaceNames;
        HashSet<DotName> hashSet = interfaceNames = config.declaredMembersOnly() ? null : new HashSet<DotName>();
        while (clazz != null) {
            if (interfaceNames != null) {
                QuteProcessor.addInterfaces(clazz, config.index(), interfaceNames);
            }
            for (MethodInfo method : clazz.methods()) {
                if (method.returnType().kind() == Type.Kind.VOID || !config.filter().test((AnnotationTarget)method) || !method.name().equals(name) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(name)) continue;
                return method;
            }
            for (FieldInfo field : clazz.fields()) {
                if (!config.filter().test((AnnotationTarget)field) || !field.name().equals(name)) continue;
                return field;
            }
            DotName superName = clazz.superName();
            if (config.declaredMembersOnly() || superName == null) {
                clazz = null;
                continue;
            }
            clazz = config.index().getClassByName(clazz.superName());
        }
        if (interfaceNames != null) {
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClassInfo = config.index().getClassByName(interfaceName);
                if (interfaceClassInfo == null) continue;
                for (MethodInfo method : interfaceClassInfo.methods()) {
                    if (!config.filter().test((AnnotationTarget)method) || !method.name().equals(name) && !ValueResolverGenerator.getPropertyName((String)method.name()).equals(name)) continue;
                    return method;
                }
            }
        }
        return null;
    }

    private static void addInterfaces(ClassInfo clazz, IndexView index, Set<DotName> interfaceNames) {
        if (clazz == null) {
            return;
        }
        List names = clazz.interfaceNames();
        if (!names.isEmpty()) {
            interfaceNames.addAll(names);
            for (DotName name : names) {
                QuteProcessor.addInterfaces(index.getClassByName(name), index, interfaceNames);
            }
        }
    }

    private static AnnotationTarget findMethod(Expression.VirtualMethodPart virtualMethod, ClassInfo clazz, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, MatchResult> results, JavaMemberLookupConfig config, Types.AssignabilityCheck assignabilityCheck) {
        HashSet<DotName> interfaceNames;
        HashSet<DotName> hashSet = interfaceNames = config.declaredMembersOnly() ? null : new HashSet<DotName>();
        while (clazz != null) {
            if (interfaceNames != null) {
                QuteProcessor.addInterfaces(clazz, index, interfaceNames);
            }
            for (MethodInfo method : clazz.methods()) {
                if (!config.filter().test((AnnotationTarget)method) || !QuteProcessor.methodMatches(method, virtualMethod, expression, index, templateIdToPathFun, results, assignabilityCheck)) continue;
                return method;
            }
            DotName superName = clazz.superName();
            if (config.declaredMembersOnly() || superName == null || DotNames.OBJECT.equals((Object)superName)) {
                clazz = null;
                continue;
            }
            clazz = index.getClassByName(clazz.superName());
        }
        if (interfaceNames != null) {
            for (DotName interfaceName : interfaceNames) {
                ClassInfo interfaceClassInfo = index.getClassByName(interfaceName);
                if (interfaceClassInfo == null) continue;
                for (MethodInfo method : interfaceClassInfo.methods()) {
                    if (!config.filter().test((AnnotationTarget)method) || !QuteProcessor.methodMatches(method, virtualMethod, expression, index, templateIdToPathFun, results, assignabilityCheck)) continue;
                    return method;
                }
            }
        }
        return null;
    }

    private static boolean methodMatches(MethodInfo method, Expression.VirtualMethodPart virtualMethod, Expression expression, IndexView index, Function<String, String> templateIdToPathFun, Map<String, MatchResult> results, Types.AssignabilityCheck assignabilityCheck) {
        if (!method.name().equals(virtualMethod.getName())) {
            return false;
        }
        boolean isVarArgs = ValueResolverGenerator.isVarArgs((MethodInfo)method);
        List parameters = method.parameterTypes();
        int lastParamIdx = parameters.size() - 1;
        if (isVarArgs ? lastParamIdx > virtualMethod.getParameters().size() : virtualMethod.getParameters().size() != parameters.size()) {
            return false;
        }
        boolean matches = true;
        int idx = 0;
        for (Expression param : virtualMethod.getParameters()) {
            MatchResult result = results.get(param.toOriginalString());
            if (result != null && !result.isEmpty()) {
                Type paramType = isVarArgs && idx >= lastParamIdx ? ((Type)parameters.get(lastParamIdx)).asArrayType().constituent() : (Type)parameters.get(idx);
                if (!assignabilityCheck.isAssignableFrom(paramType, result.type)) {
                    matches = false;
                    break;
                }
            } else {
                LOGGER.debugf("Type info not available - skip validation for parameter [%s] of method [%s] for expression [%s] in template [%s] on line %s", new Object[]{method.parameterName(idx), method.declaringClass().name() + "#" + method, expression.toOriginalString(), templateIdToPathFun.apply(expression.getOrigin().getTemplateId()), expression.getOrigin().getLine()});
            }
            idx = (byte)(idx + 1);
        }
        return matches;
    }

    private void processTemplateData(TemplateDataBuildItem templateData, Set<DotName> controlled, Map<DotName, AnnotationInstance> uncontrolled, ValueResolverGenerator.Builder builder) {
        DotName targetClassName = templateData.getTargetClass().name();
        if (templateData.isTargetAnnotatedType()) {
            controlled.add(targetClassName);
            builder.addClass(templateData.getTargetClass(), templateData.getAnnotationInstance());
        } else {
            uncontrolled.computeIfAbsent(targetClassName, name -> {
                builder.addClass(templateData.getTargetClass(), templateData.getAnnotationInstance());
                return templateData.getAnnotationInstance();
            });
        }
    }

    @BuildStep
    void collectTemplateGlobals(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateGlobalBuildItem> globals) {
        IndexView index = beanArchiveIndex.getIndex();
        HashMap<String, TemplateGlobalBuildItem> nameToGlobal = new HashMap<String, TemplateGlobalBuildItem>();
        block5: for (AnnotationInstance annotation : index.getAnnotations(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) {
            switch (annotation.target().kind()) {
                case CLASS: {
                    this.addGlobalClass(annotation.target().asClass(), nameToGlobal);
                    continue block5;
                }
                case FIELD: {
                    this.addGlobalField(annotation.value("name"), annotation.target().asField(), nameToGlobal);
                    continue block5;
                }
                case METHOD: {
                    this.addGlobalMethod(annotation.value("name"), annotation.target().asMethod(), nameToGlobal);
                    continue block5;
                }
            }
            throw new TemplateException("Invalid annotation target for @TemplateGlobal: " + annotation);
        }
        nameToGlobal.values().forEach(arg_0 -> globals.produce(arg_0));
    }

    private void addGlobalClass(ClassInfo clazz, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        for (FieldInfo field : clazz.fields()) {
            if (!Modifier.isStatic(field.flags()) || Modifier.isPrivate(field.flags()) || field.isSynthetic() || field.hasAnnotation(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) continue;
            this.addGlobalField(null, field, nameToGlobal);
        }
        for (MethodInfo method : clazz.methods()) {
            if (!Modifier.isStatic(method.flags()) || Modifier.isPrivate(method.flags()) || method.returnType().kind() == Type.Kind.VOID || method.isSynthetic() || method.hasAnnotation(TemplateGlobalGenerator.TEMPLATE_GLOBAL)) continue;
            this.addGlobalMethod(null, method, nameToGlobal);
        }
    }

    private void addGlobalMethod(AnnotationValue nameValue, MethodInfo method, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalGenerator.validate((MethodInfo)method);
        String name = "<<element name>>";
        if (nameValue != null) {
            name = nameValue.asString();
        }
        if (name.equals("<<element name>>")) {
            name = method.name();
        }
        TemplateGlobalBuildItem global = new TemplateGlobalBuildItem(name, (AnnotationTarget)method, method.returnType());
        this.addGlobalVariable(global, nameToGlobal);
    }

    private void addGlobalField(AnnotationValue nameValue, FieldInfo field, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalGenerator.validate((FieldInfo)field);
        String name = "<<element name>>";
        if (nameValue != null) {
            name = nameValue.asString();
        }
        if (name.equals("<<element name>>")) {
            name = field.name();
        }
        TemplateGlobalBuildItem global = new TemplateGlobalBuildItem(name, (AnnotationTarget)field, field.type());
        this.addGlobalVariable(global, nameToGlobal);
    }

    private void addGlobalVariable(TemplateGlobalBuildItem global, Map<String, TemplateGlobalBuildItem> nameToGlobal) {
        TemplateGlobalBuildItem prev = nameToGlobal.put(global.getName(), global);
        if (prev != null) {
            throw new TemplateException(String.format("Duplicate global variable defined via @TemplateGlobal for the name [%s]:\n\t- %s\n\t- %s", new Object[]{global.getName(), global, prev}));
        }
    }

    @BuildStep
    void collectTemplateDataAnnotations(BeanArchiveIndexBuildItem beanArchiveIndex, BuildProducer<TemplateDataBuildItem> templateDataAnnotations) {
        IndexView index = beanArchiveIndex.getIndex();
        HashSet<AnnotationInstance> annotationInstances = new HashSet<AnnotationInstance>();
        annotationInstances.addAll(index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA));
        for (AnnotationInstance containingInstance : index.getAnnotations(ValueResolverGenerator.TEMPLATE_DATA_CONTAINER)) {
            for (AnnotationInstance nestedInstance : containingInstance.value().asNestedArray()) {
                annotationInstances.add(AnnotationInstance.create((DotName)nestedInstance.name(), (AnnotationTarget)containingInstance.target(), (List)nestedInstance.values()));
            }
        }
        HashMap<DotName, AnnotationInstance> uncontrolled = new HashMap<DotName, AnnotationInstance>();
        for (AnnotationInstance templateData : annotationInstances) {
            AnnotationValue targetValue = templateData.value("target");
            ClassInfo targetClass = null;
            targetClass = targetValue == null || targetValue.asClass().name().equals((Object)ValueResolverGenerator.TEMPLATE_DATA) ? templateData.target().asClass() : index.getClassByName(targetValue.asClass().name());
            if (targetClass == null) {
                LOGGER.warnf("@TemplateData declared on %s is ignored: target %s it is not available in the index", (Object)templateData.target(), (Object)targetClass);
                continue;
            }
            uncontrolled.compute(targetClass.name(), (c, v) -> {
                if (v == null) {
                    return templateData;
                }
                if (!(Objects.equals(v.value("ignore"), templateData.value("ignore")) && Objects.equals(v.value("properties"), templateData.value("properties")) && Objects.equals(v.value("ignoreSuperclasses"), templateData.value("ignoreSuperclasses")) && Objects.equals(v.value("namespace"), templateData.value("namespace")))) {
                    throw new IllegalStateException("Multiple unequal @TemplateData declared for " + c + ": " + v + " and " + templateData);
                }
                return v;
            });
            templateDataAnnotations.produce((BuildItem)new TemplateDataBuildItem(templateData, targetClass));
        }
        for (AnnotationInstance templateEnum : index.getAnnotations(Names.TEMPLATE_ENUM)) {
            ClassInfo targetEnum = templateEnum.target().asClass();
            if (!targetEnum.isEnum()) {
                LOGGER.warnf("@TemplateEnum declared on %s is ignored: the target of this annotation must be an enum type", (Object)targetEnum);
                continue;
            }
            if (targetEnum.declaredAnnotation(ValueResolverGenerator.TEMPLATE_DATA) != null) {
                LOGGER.debugf("@TemplateEnum declared on %s is ignored: enum is annotated with @TemplateData", (Object)targetEnum);
                continue;
            }
            AnnotationInstance uncontrolledDeclaration = (AnnotationInstance)uncontrolled.get(targetEnum.name());
            if (uncontrolledDeclaration != null) {
                LOGGER.debugf("@TemplateEnum declared on %s is ignored: %s declared on %s", (Object)targetEnum, (Object)uncontrolledDeclaration, (Object)uncontrolledDeclaration.target());
                continue;
            }
            templateDataAnnotations.produce((BuildItem)new TemplateDataBuildItem(new TemplateDataBuilder().annotationTarget(templateEnum.target()).namespace("<<simplename>>").build(), targetEnum));
        }
    }

    @BuildStep
    void validateTemplateDataNamespaces(List<TemplateDataBuildItem> templateData, BuildProducer<ServiceStartBuildItem> serviceStart) {
        Map<String, List<TemplateDataBuildItem>> namespaceToData = templateData.stream().filter(TemplateDataBuildItem::hasNamespace).collect(Collectors.groupingBy(TemplateDataBuildItem::getNamespace));
        for (Map.Entry<String, List<TemplateDataBuildItem>> e : namespaceToData.entrySet()) {
            if (e.getValue().size() <= 1) continue;
            throw new TemplateException(String.format("The namespace [%s] is defined by multiple @TemplateData and/or @TemplateEnum annotations; make sure the annotation declared on the following classes do not collide:\n\t- %s", e.getKey(), e.getValue().stream().map(TemplateDataBuildItem::getAnnotationInstance).map(AnnotationInstance::target).map(Object::toString).collect(Collectors.joining("\n\t- "))));
        }
    }

    static Map<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> collectNamespaceExpressions(TemplatesAnalysisBuildItem analysis, String namespace) {
        HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>> namespaceExpressions = new HashMap<TemplatesAnalysisBuildItem.TemplateAnalysis, Set<Expression>>();
        for (TemplatesAnalysisBuildItem.TemplateAnalysis template : analysis.getAnalysis()) {
            HashSet<Expression> expressions = null;
            for (Expression expr : QuteProcessor.collectNamespaceExpressions(template, namespace)) {
                if (expressions == null) {
                    expressions = new HashSet<Expression>();
                }
                expressions.add(expr);
            }
            if (expressions == null) continue;
            namespaceExpressions.put(template, expressions);
        }
        return namespaceExpressions;
    }

    static Set<Expression> collectNamespaceExpressions(TemplatesAnalysisBuildItem.TemplateAnalysis analysis, String namespace) {
        HashSet<Expression> namespaceExpressions = new HashSet<Expression>();
        for (Expression expression : analysis.expressions) {
            QuteProcessor.collectNamespaceExpressions(expression, namespaceExpressions, namespace);
        }
        return namespaceExpressions;
    }

    static void collectNamespaceExpressions(Expression expression, Set<Expression> namespaceExpressions, String namespace) {
        if (expression.isLiteral()) {
            return;
        }
        if (namespace.equals(expression.getNamespace())) {
            namespaceExpressions.add(expression);
        }
        for (Expression.Part part : expression.getParts()) {
            if (!part.isVirtualMethod()) continue;
            for (Expression param : part.asVirtualMethod().getParameters()) {
                QuteProcessor.collectNamespaceExpressions(param, namespaceExpressions, namespace);
            }
        }
    }

    public static String getName(InjectionPointInfo injectionPoint) {
        if (injectionPoint.isField()) {
            return injectionPoint.getTarget().asField().name();
        }
        if (injectionPoint.isParam()) {
            String name = injectionPoint.getTarget().asMethod().parameterName(injectionPoint.getPosition());
            return name == null ? injectionPoint.getTarget().asMethod().name() : name;
        }
        throw new IllegalArgumentException();
    }

    private static void produceTemplateBuildItems(BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, String basePath, String filePath, Path originalPath, QuteConfig config) {
        if (filePath.isEmpty()) {
            return;
        }
        String fullPath = basePath + filePath;
        LOGGER.debugf("Produce template build items [filePath: %s, fullPath: %s, originalPath: %s", (Object)filePath, (Object)fullPath, (Object)originalPath);
        watchedPaths.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(fullPath, true));
        nativeImageResources.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fullPath}));
        templatePaths.produce((BuildItem)new TemplatePathBuildItem(filePath, originalPath, QuteProcessor.readTemplateContent(originalPath, config.defaultCharset)));
    }

    private void scan(Path root, Path directory, String basePath, BuildProducer<HotDeploymentWatchedFileBuildItem> watchedPaths, BuildProducer<TemplatePathBuildItem> templatePaths, BuildProducer<NativeImageResourceBuildItem> nativeImageResources, QuteConfig config) throws IOException {
        try (Stream<Path> files = Files.list(directory);){
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                Path filePath = (Path)iter.next();
                if (!directory.isAbsolute() && filePath.isAbsolute() && filePath.getRoot() != null) {
                    filePath = filePath.getRoot().relativize(filePath);
                }
                if (Files.isRegularFile(filePath, new LinkOption[0])) {
                    LOGGER.debugf("Found template: %s", (Object)filePath);
                    String templatePath = root.relativize(filePath).toString();
                    if (File.separatorChar != '/') {
                        templatePath = templatePath.replace(File.separatorChar, '/');
                    }
                    if (config.templatePathExclude.matcher(templatePath).matches()) {
                        LOGGER.debugf("Template file excluded: %s", (Object)filePath);
                        continue;
                    }
                    QuteProcessor.produceTemplateBuildItems(templatePaths, watchedPaths, nativeImageResources, basePath, templatePath, filePath, config);
                    continue;
                }
                if (!Files.isDirectory(filePath, new LinkOption[0])) continue;
                LOGGER.debugf("Scan directory: %s", (Object)filePath);
                this.scan(root, filePath, basePath, watchedPaths, templatePaths, nativeImageResources, config);
            }
        }
    }

    private static boolean isExcluded(TypeCheckExcludeBuildItem.TypeCheck check, Iterable<Predicate<TypeCheckExcludeBuildItem.TypeCheck>> excludes) {
        for (Predicate<TypeCheckExcludeBuildItem.TypeCheck> exclude : excludes) {
            if (!exclude.test(check)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBasePath(Path path) {
        return path.getFileName().toString().equals(BASE_PATH);
    }

    private void checkDuplicatePaths(List<TemplatePathBuildItem> templatePaths) {
        Map<String, List<TemplatePathBuildItem>> duplicates = templatePaths.stream().collect(Collectors.groupingBy(TemplatePathBuildItem::getPath));
        Iterator<List<TemplatePathBuildItem>> it = duplicates.values().iterator();
        while (it.hasNext()) {
            List<TemplatePathBuildItem> paths = it.next();
            if (!paths.isEmpty() && paths.size() != 1) continue;
            it.remove();
        }
        if (!duplicates.isEmpty()) {
            StringBuilder builder = new StringBuilder("Duplicate templates found:");
            for (Map.Entry<String, List<TemplatePathBuildItem>> e : duplicates.entrySet()) {
                builder.append("\n\t- ").append(e.getKey()).append(": ").append(e.getValue().stream().map(TemplatePathBuildItem::getFullPath).collect(Collectors.toList()));
            }
            throw new IllegalStateException(builder.toString());
        }
    }

    private boolean isApplicationArchive(ResolvedDependency dependency, Set<ApplicationArchive> applicationArchives) {
        for (ApplicationArchive archive : applicationArchives) {
            if (archive.getKey() == null || !dependency.getGroupId().equals(archive.getKey().getGroupId()) || !dependency.getArtifactId().equals(archive.getKey().getArtifactId())) continue;
            return true;
        }
        return false;
    }

    static String readTemplateContent(Path path, Charset defaultCharset) {
        try {
            return Files.readString(path, defaultCharset);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read the template content from path: " + path, e);
        }
    }

    private static final class MethodParameterDeclaration
    implements ParameterDeclaration {
        private final String paramType;
        private final String paramName;

        private MethodParameterDeclaration(String paramType, String paramName) {
            this.paramType = paramType;
            this.paramName = paramName;
        }

        public String getParamType() {
            return this.paramType;
        }

        public String getTypeInfo() {
            return Expressions.typeInfoFrom((String)this.paramType);
        }

        public String getKey() {
            return this.paramName;
        }

        public Expression getDefaultValue() {
            return null;
        }

        public TemplateNode.Origin getOrigin() {
            return null;
        }
    }

    static enum Code implements ErrorCode
    {
        INCORRECT_EXPRESSION;


        public String getName() {
            return "BUILD_" + this.name();
        }
    }

    static class FirstPassJavaMemberLookupConfig
    implements JavaMemberLookupConfig {
        private final JavaMemberLookupConfig next;
        private Predicate<AnnotationTarget> filter;
        private Boolean declaredMembersOnly;

        FirstPassJavaMemberLookupConfig(JavaMemberLookupConfig next, Predicate<AnnotationTarget> filter, Boolean declaredMembersOnly) {
            this.next = next;
            this.filter = filter;
            this.declaredMembersOnly = declaredMembersOnly;
        }

        @Override
        public IndexView index() {
            return this.next.index();
        }

        @Override
        public Predicate<AnnotationTarget> filter() {
            return this.filter != null ? this.filter : this.next.filter();
        }

        @Override
        public boolean declaredMembersOnly() {
            return this.declaredMembersOnly != null ? this.declaredMembersOnly.booleanValue() : this.next.declaredMembersOnly();
        }

        @Override
        public void nextPart() {
            this.filter = null;
            this.declaredMembersOnly = null;
        }
    }

    static class FixedJavaMemberLookupConfig
    implements JavaMemberLookupConfig {
        private final IndexView index;
        private final Predicate<AnnotationTarget> filter;
        private final boolean declaredMembersOnly;

        FixedJavaMemberLookupConfig(IndexView index, Predicate<AnnotationTarget> filter, boolean declaredMembersOnly) {
            this.index = index;
            this.filter = filter;
            this.declaredMembersOnly = declaredMembersOnly;
        }

        @Override
        public IndexView index() {
            return this.index;
        }

        @Override
        public Predicate<AnnotationTarget> filter() {
            return this.filter;
        }

        @Override
        public boolean declaredMembersOnly() {
            return this.declaredMembersOnly;
        }
    }

    static interface JavaMemberLookupConfig {
        public IndexView index();

        public Predicate<AnnotationTarget> filter();

        public boolean declaredMembersOnly();

        default public void nextPart() {
        }
    }

    static class MatchResult {
        private final Types.AssignabilityCheck assignabilityCheck;
        private ClassInfo clazz;
        private Type type;

        MatchResult(Types.AssignabilityCheck assignabilityCheck) {
            this.assignabilityCheck = assignabilityCheck;
        }

        List<Type> getParameterizedTypeArguments() {
            return this.type.kind() == Type.Kind.PARAMETERIZED_TYPE ? this.type.asParameterizedType().arguments() : Collections.emptyList();
        }

        List<TypeVariable> getTypeParameters() {
            return this.clazz.typeParameters();
        }

        ClassInfo clazz() {
            return this.clazz;
        }

        Type type() {
            return this.type;
        }

        boolean isPrimitive() {
            return this.type != null && this.type.kind() == Type.Kind.PRIMITIVE;
        }

        boolean isArray() {
            return this.type != null && this.type.kind() == Type.Kind.ARRAY;
        }

        boolean isParameterizedType() {
            return this.type != null && this.type.kind() == Type.Kind.PARAMETERIZED_TYPE;
        }

        boolean isClass() {
            return this.type != null && this.type.kind() == Type.Kind.CLASS;
        }

        void setValues(ClassInfo clazz, Type type) {
            this.clazz = clazz;
            this.type = type;
            this.autoExtractType();
        }

        void clearValues() {
            this.clazz = null;
            this.type = null;
        }

        boolean isEmpty() {
            return this.type == null;
        }

        void autoExtractType() {
            if (this.clazz != null) {
                boolean hasUni;
                boolean hasCompletionStage = this.assignabilityCheck.isAssignableFrom(Names.COMPLETION_STAGE, this.clazz.name());
                boolean bl = hasUni = hasCompletionStage ? false : this.assignabilityCheck.isAssignableFrom(Names.UNI, this.clazz.name());
                if (hasCompletionStage || hasUni) {
                    Set<Type> closure = Types.getTypeClosure(this.clazz, Types.buildResolvedMap(this.getParameterizedTypeArguments(), this.getTypeParameters(), new HashMap<TypeVariable, Type>(), this.assignabilityCheck.computingIndex), this.assignabilityCheck.computingIndex);
                    this.type = QuteProcessor.extractMatchType(closure, hasCompletionStage ? Names.COMPLETION_STAGE : Names.UNI, FIRST_PARAM_TYPE_EXTRACT_FUN);
                    this.clazz = this.assignabilityCheck.computingIndex.getClassByName(this.type.name());
                }
            }
        }
    }

    static class ExistingValueResolvers {
        final Map<String, String> identifiersToGeneratedClass = new HashMap<String, String>();

        ExistingValueResolvers() {
        }

        boolean contains(MethodInfo extensionMethod) {
            return this.identifiersToGeneratedClass.containsKey(this.toKey(extensionMethod));
        }

        String getGeneratedClass(MethodInfo extensionMethod) {
            return this.identifiersToGeneratedClass.get(this.toKey(extensionMethod));
        }

        void add(MethodInfo extensionMethod, String className, Predicate<DotName> applicationClassPredicate) {
            if (!applicationClassPredicate.test(extensionMethod.declaringClass().name())) {
                this.identifiersToGeneratedClass.put(this.toKey(extensionMethod), className);
            }
        }

        private String toKey(MethodInfo extensionMethod) {
            return extensionMethod.declaringClass().toString() + "#" + extensionMethod.toString();
        }
    }

    private static class NamespaceResult {
        static final NamespaceResult EMPTY = new NamespaceResult(null, null, null, null, null, false, null);
        private final String namespace;
        private final ClassInfo rootClazz;
        private final TypeInfos.TypeInfo dataNamespaceExpTypeInfo;
        private final TemplateDataBuildItem templateData;
        private final List<TemplateExtensionMethodBuildItem> extensionMethods;
        private final boolean ignoring;
        private final JavaMemberLookupConfig lookupConfig;

        NamespaceResult(String namespace, ClassInfo rootClazz, TypeInfos.TypeInfo dataNamespaceExpTypeInfo, TemplateDataBuildItem templateData, List<TemplateExtensionMethodBuildItem> namespaceExtensionMethods, boolean ignoring, JavaMemberLookupConfig lookupConfig) {
            this.namespace = namespace;
            this.rootClazz = rootClazz;
            this.dataNamespaceExpTypeInfo = dataNamespaceExpTypeInfo;
            this.templateData = templateData;
            this.extensionMethods = namespaceExtensionMethods;
            this.ignoring = ignoring;
            this.lookupConfig = lookupConfig;
        }

        boolean hasExtensionMethods() {
            return this.extensionMethods != null;
        }

        boolean hasDataNamespaceInfo() {
            return this.dataNamespaceExpTypeInfo != null;
        }

        boolean hasRootClazz() {
            return this.rootClazz != null;
        }

        boolean hasLookupConfig() {
            return this.lookupConfig != null;
        }

        boolean isIn(String ... values) {
            for (String value : values) {
                if (!value.equals(this.namespace)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class RootResult {
        private final Iterator<TypeInfos.Info> iterator;
        private final boolean ignoring;

        public RootResult(Iterator<TypeInfos.Info> iterator, boolean ignoring) {
            this.iterator = iterator;
            this.ignoring = ignoring;
        }
    }
}

