/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.runtime;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.Path;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

@ConstrainedTo(value=RuntimeType.CLIENT)
public class PathFeatureHandler
implements DynamicFeature {
    private static final Pattern MULTIPLE_SLASH_PATTERN = Pattern.compile("//+");

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        context.property("UrlPathTemplate", (Object)this.constructPath(resourceInfo.getResourceMethod()));
    }

    private String constructPath(Method methodInfo) {
        Path annotation = methodInfo.getAnnotation(Path.class);
        StringBuilder stringBuilder = annotation != null ? new StringBuilder(this.slashify(annotation.value())) : new StringBuilder();
        annotation = methodInfo.getDeclaringClass().getAnnotation(Path.class);
        if (annotation != null) {
            stringBuilder.insert(0, this.slashify(annotation.value()));
        }
        return MULTIPLE_SLASH_PATTERN.matcher("/" + stringBuilder.toString()).replaceAll("/");
    }

    String slashify(String path) {
        if (path == null || path.isEmpty() || "/".equals(path)) {
            return "";
        }
        if ((path = MULTIPLE_SLASH_PATTERN.matcher(path).replaceAll("/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty() || path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }
}

