/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.arc.Unremovable;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationClassPredicateBuildItem;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.RecordableConstructorBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.netty.deployment.MinNettyAllocatorMaxOrderBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ApplicationResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.FactoryUtils;
import io.quarkus.resteasy.reactive.common.deployment.ParameterContainersBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusFactoryCreator;
import io.quarkus.resteasy.reactive.common.deployment.QuarkusResteasyReactiveDotNames;
import io.quarkus.resteasy.reactive.common.deployment.ResourceInterceptorsBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.ResourceScanningResultBuildItem;
import io.quarkus.resteasy.reactive.common.deployment.SerializersUtil;
import io.quarkus.resteasy.reactive.common.deployment.ServerDefaultProducesHandlerBuildItem;
import io.quarkus.resteasy.reactive.common.runtime.JaxRsSecurityConfig;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveCommonRecorder;
import io.quarkus.resteasy.reactive.common.runtime.ResteasyReactiveConfig;
import io.quarkus.resteasy.reactive.server.EndpointDisabled;
import io.quarkus.resteasy.reactive.server.deployment.BuiltInReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ClassLevelExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ContextResolversBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.CustomResourceProducersGenerator;
import io.quarkus.resteasy.reactive.server.deployment.EndpointConfig;
import io.quarkus.resteasy.reactive.server.deployment.ExceptionMappersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.FilterClassIntrospector;
import io.quarkus.resteasy.reactive.server.deployment.MessageBodyWriterTransformerUtils;
import io.quarkus.resteasy.reactive.server.deployment.ParamConverterProvidersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusInvokerFactory;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusMultipartReturnTypeHandler;
import io.quarkus.resteasy.reactive.server.deployment.QuarkusServerEndpointIndexer;
import io.quarkus.resteasy.reactive.server.deployment.RequestContextFactoryBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentInfoBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveResourceMethodEntriesBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveServerConfig;
import io.quarkus.resteasy.reactive.server.deployment.SecurityTransformerUtils;
import io.quarkus.resteasy.reactive.server.deployment.ServerSerialisersBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.SetupEndpointsResultBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusServerFileBodyHandler;
import io.quarkus.resteasy.reactive.server.runtime.QuarkusServerPathBodyHandler;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveInitialiser;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRuntimeRecorder;
import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveServerRuntimeConfig;
import io.quarkus.resteasy.reactive.server.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationCompletionExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationFailedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.AuthenticationRedirectExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.ForbiddenExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.exceptionmappers.UnauthorizedExceptionMapper;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityHandler;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityInterceptorHandler;
import io.quarkus.resteasy.reactive.server.runtime.security.SecurityContextOverrideHandler;
import io.quarkus.resteasy.reactive.server.spi.AnnotationsTransformerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.ContextTypeBuildItem;
import io.quarkus.resteasy.reactive.server.spi.HandlerConfigurationProviderBuildItem;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.NonBlockingReturnTypeBuildItem;
import io.quarkus.resteasy.reactive.server.spi.PreExceptionMapperHandlerBuildItem;
import io.quarkus.resteasy.reactive.server.spi.ResumeOn404BuildItem;
import io.quarkus.resteasy.reactive.spi.CustomExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.DynamicFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import io.quarkus.resteasy.reactive.spi.JaxrsFeatureBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderOverrideBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterOverrideBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.vertx.http.deployment.EagerSecurityInterceptorBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import io.vertx.mutiny.core.file.AsyncFile;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.common.core.SingletonBeanFactory;
import org.jboss.resteasy.reactive.common.model.InterceptorContainer;
import org.jboss.resteasy.reactive.common.model.PreMatchInterceptorContainer;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceDynamicFeature;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.model.ResourceReader;
import org.jboss.resteasy.reactive.common.model.ResourceWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaderWriter;
import org.jboss.resteasy.reactive.common.processor.AdditionalReaders;
import org.jboss.resteasy.reactive.common.processor.AdditionalWriters;
import org.jboss.resteasy.reactive.common.processor.DefaultProducesHandler;
import org.jboss.resteasy.reactive.common.processor.EndpointIndexer;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.common.processor.TargetJavaVersion;
import org.jboss.resteasy.reactive.common.processor.scanning.ApplicationScanningResult;
import org.jboss.resteasy.reactive.common.processor.scanning.ResourceScanningResult;
import org.jboss.resteasy.reactive.common.types.AllWriteableMarker;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.common.util.types.Types;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.model.ContextResolvers;
import org.jboss.resteasy.reactive.server.model.DelegatingServerRestHandler;
import org.jboss.resteasy.reactive.server.model.DynamicFeatures;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.processor.ServerEndpointIndexer;
import org.jboss.resteasy.reactive.server.processor.generation.converters.GeneratedConverterIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.generation.exceptionmappers.ServerExceptionMapperGenerator;
import org.jboss.resteasy.reactive.server.processor.generation.injection.TransformedFieldInjectionIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.generation.multipart.GeneratedHandlerMultipartReturnTypeIndexerExtension;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResponseHeaderMethodScanner;
import org.jboss.resteasy.reactive.server.processor.scanning.ResponseStatusMethodScanner;
import org.jboss.resteasy.reactive.server.processor.util.ResteasyReactiveServerDotNames;
import org.jboss.resteasy.reactive.server.providers.serialisers.ServerFileBodyHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerMutinyAsyncFileMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerMutinyBufferMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerVertxAsyncFileMessageBodyWriter;
import org.jboss.resteasy.reactive.server.vertx.serializers.ServerVertxBufferMessageBodyWriter;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.objectweb.asm.ClassVisitor;

public class ResteasyReactiveProcessor {
    private static final int REST_ROUTE_ORDER_OFFSET = 500;
    private static final String QUARKUS_INIT_CLASS = "io.quarkus.rest.runtime.__QuarkusInit";
    private static final Logger log = Logger.getLogger((String)"io.quarkus.resteasy.reactive.server");
    private static final Predicate<Object[]> isEmpty = array -> array == null || ((Object[])array).length == 0;
    private static final Set<DotName> CONTEXT_TYPES = Set.of(DotName.createSimple((String)HttpServerRequest.class.getName()), DotName.createSimple((String)HttpServerResponse.class.getName()), DotName.createSimple((String)RoutingContext.class.getName()));
    private static final DotName FILE = DotName.createSimple((String)File.class.getName());
    private static final DotName ENDPOINT_DISABLED = DotName.createSimple((String)EndpointDisabled.class.getName());
    private static final int SECURITY_EXCEPTION_MAPPERS_PRIORITY = 5001;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @BuildStep
    public FeatureBuildItem buildSetup() {
        return new FeatureBuildItem(Feature.REST);
    }

    @BuildStep
    MinNettyAllocatorMaxOrderBuildItem setMinimalNettyMaxOrderSize() {
        return new MinNettyAllocatorMaxOrderBuildItem(3);
    }

    @BuildStep
    void recordableConstructor(BuildProducer<RecordableConstructorBuildItem> ctors) {
        ctors.produce((BuildItem)new RecordableConstructorBuildItem(ServerResourceMethod.class));
        ctors.produce((BuildItem)new RecordableConstructorBuildItem(ServerMethodParameter.class));
    }

    @BuildStep
    MethodScannerBuildItem responseStatusSupport() {
        return new MethodScannerBuildItem((MethodScanner)new ResponseStatusMethodScanner());
    }

    @BuildStep
    MethodScannerBuildItem responseHeaderSupport() {
        return new MethodScannerBuildItem((MethodScanner)new ResponseHeaderMethodScanner());
    }

    @BuildStep
    void vertxIntegration(BuildProducer<MessageBodyWriterBuildItem> writerBuildItemBuildProducer) {
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerVertxBufferMessageBodyWriter.class.getName(), Buffer.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerMutinyBufferMessageBodyWriter.class.getName(), io.vertx.mutiny.core.buffer.Buffer.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerVertxAsyncFileMessageBodyWriter.class.getName(), io.vertx.core.file.AsyncFile.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
        writerBuildItemBuildProducer.produce((BuildItem)new MessageBodyWriterBuildItem(ServerMutinyAsyncFileMessageBodyWriter.class.getName(), AsyncFile.class.getName(), Collections.singletonList("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    void generateCustomProducer(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedBeanBuildItem> generatedBeanBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildProducer) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Map resourcesThatNeedCustomProducer = resourceScanningResultBuildItem.get().getResult().getResourcesThatNeedCustomProducer();
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        if (!resourcesThatNeedCustomProducer.isEmpty() || !beanParams.isEmpty()) {
            CustomResourceProducersGenerator.generate(resourcesThatNeedCustomProducer, beanParams, generatedBeanBuildItemBuildProducer, additionalBeanBuildItemBuildProducer);
        }
    }

    @BuildStep
    void handleClassLevelExceptionMappers(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        List methodExceptionMapper = resourceScanningResultBuildItem.get().getResult().getClassLevelExceptionMappers();
        if (methodExceptionMapper.isEmpty()) {
            return;
        }
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        HashMap<DotName, Map<String, String>> resultingMappers = new HashMap<DotName, Map<String, String>>(methodExceptionMapper.size());
        for (MethodInfo methodInfo : methodExceptionMapper) {
            Map classMappers;
            Map generationResult = ServerExceptionMapperGenerator.generatePerClassMapper((MethodInfo)methodInfo, (ClassOutput)classOutput, Set.of(QuarkusResteasyReactiveDotNames.HTTP_SERVER_REQUEST, QuarkusResteasyReactiveDotNames.HTTP_SERVER_RESPONSE, QuarkusResteasyReactiveDotNames.ROUTING_CONTEXT), Set.of(Unremovable.class.getName()));
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])generationResult.values().toArray(EMPTY_STRING_ARRAY)).build());
            DotName classDotName = methodInfo.declaringClass().name();
            if (resultingMappers.containsKey(classDotName)) {
                classMappers = (Map)resultingMappers.get(classDotName);
            } else {
                classMappers = new HashMap();
                resultingMappers.put(classDotName, classMappers);
            }
            classMappers.putAll(generationResult);
        }
        classLevelExceptionMappers.produce((BuildItem)new ClassLevelExceptionMappersBuildItem(resultingMappers));
    }

    @BuildStep
    void registerCustomExceptionMappers(BuildProducer<CustomExceptionMapperBuildItem> customExceptionMapper) {
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(AuthenticationFailedExceptionMapper.class.getName()));
        customExceptionMapper.produce((BuildItem)new CustomExceptionMapperBuildItem(UnauthorizedExceptionMapper.class.getName()));
    }

    @BuildStep
    public void unremovableBeans(Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        Set beanParams = resourceScanningResultBuildItem.get().getResult().getBeanParams();
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanClassNames((String[])beanParams.toArray(EMPTY_STRING_ARRAY)));
    }

    @BuildStep
    public void additionalAsyncTypeMethodScanners(List<NonBlockingReturnTypeBuildItem> buildItems, BuildProducer<MethodScannerBuildItem> producer) {
        for (final NonBlockingReturnTypeBuildItem bi : buildItems) {
            producer.produce((BuildItem)new MethodScannerBuildItem(new MethodScanner(){

                public boolean isMethodSignatureAsync(MethodInfo info) {
                    return info.returnType().name().equals((Object)bi.getType());
                }
            }));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void setupEndpoints(ApplicationIndexBuildItem applicationIndexBuildItem, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BeanContainerBuildItem beanContainerBuildItem, ResteasyReactiveConfig config, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformerBuildItemBuildProducer, final BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer, final ResteasyReactiveRecorder recorder, List<ServerDefaultProducesHandlerBuildItem> serverDefaultProducesHandlers, Optional<ClassLevelExceptionMappersBuildItem> classLevelExceptionMappers, BuildProducer<SetupEndpointsResultBuildItem> setupEndpointsResultProducer, BuildProducer<ResteasyReactiveResourceMethodEntriesBuildItem> resourceMethodEntriesBuildItemBuildProducer, final BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, ApplicationResultBuildItem applicationResultBuildItem, ParamConverterProvidersBuildItem paramConverterProvidersBuildItem, List<ParameterContainersBuildItem> parameterContainersBuildItems, List<ApplicationClassPredicateBuildItem> applicationClassPredicateBuildItems, List<MethodScannerBuildItem> methodScanners, List<AnnotationsTransformerBuildItem> annotationTransformerBuildItems, List<ContextTypeBuildItem> contextTypeBuildItems, final CompiledJavaVersionBuildItem compiledJavaVersionBuildItem, final ResourceInterceptorsBuildItem resourceInterceptorsBuildItem, Capabilities capabilities) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        final IndexView index = beanArchiveIndexBuildItem.getIndex();
        final ResourceScanningResult result = resourceScanningResultBuildItem.get().getResult();
        Map scannedResources = result.getScannedResources();
        Map scannedResourcePaths = result.getScannedResourcePaths();
        Map pathInterfaces = result.getPathInterfaces();
        ApplicationScanningResult appResult = applicationResultBuildItem.getResult();
        Set singletonClasses = appResult.getSingletonClasses();
        HashMap existingConverters = new HashMap();
        ArrayList<ResourceClass> resourceClasses = new ArrayList<ResourceClass>();
        ArrayList<ResourceClass> subResourceClasses = new ArrayList<ResourceClass>();
        AdditionalReaders additionalReaders = new AdditionalReaders();
        AdditionalWriters additionalWriters = new AdditionalWriters();
        HashMap injectableBeans = new HashMap();
        HashSet scannedParameterContainers = new HashSet();
        for (ParameterContainersBuildItem parameterContainersBuildItem : parameterContainersBuildItems) {
            scannedParameterContainers.addAll(parameterContainersBuildItem.getClassNames());
        }
        ParamConverterProviders paramConverterProviders = paramConverterProvidersBuildItem.getParamConverterProviders();
        Function<String, BeanFactory> factoryFunction = s -> FactoryUtils.factory((String)s, (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem);
        paramConverterProviders.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.sort();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator c = new ClassCreator((ClassOutput)classOutput, QUARKUS_INIT_CLASS, null, Object.class.getName(), new String[]{ResteasyReactiveInitialiser.class.getName()});
             MethodCreator initConverters = c.getMethodCreator("init", Void.TYPE, new Class[]{Deployment.class});){
            final ArrayList<ResteasyReactiveResourceMethodEntriesBuildItem.Entry> resourceMethodEntries = new ArrayList<ResteasyReactiveResourceMethodEntriesBuildItem.Entry>();
            Predicate<String> applicationClassPredicate = s -> {
                for (ApplicationClassPredicateBuildItem i : applicationClassPredicateBuildItems) {
                    if (!i.test(s)) continue;
                    return true;
                }
                return false;
            };
            BiConsumer<String, BiFunction> transformationConsumer = (name, function) -> bytecodeTransformerBuildItemBuildProducer.produce((BuildItem)new BytecodeTransformerBuildItem(name, function));
            QuarkusServerEndpointIndexer.Builder serverEndpointIndexerBuilder = (QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)((QuarkusServerEndpointIndexer.Builder)new QuarkusServerEndpointIndexer.Builder(capabilities).addMethodScanners(methodScanners.stream().map(MethodScannerBuildItem::getMethodScanner).collect(Collectors.toList()))).setIndex(index)).setApplicationIndex((IndexView)applicationIndexBuildItem.getIndex())).addParameterContainerTypes(scannedParameterContainers)).addContextTypes(this.additionalContextTypes(contextTypeBuildItems))).setFactoryCreator((Function)new QuarkusFactoryCreator((ResteasyReactiveCommonRecorder)recorder, beanContainerBuildItem.getValue()))).setEndpointInvokerFactory(new QuarkusInvokerFactory(generatedClassBuildItemBuildProducer, recorder))).setGeneratedClassBuildItemBuildProducer(generatedClassBuildItemBuildProducer).setExistingConverters(existingConverters)).setScannedResourcePaths(scannedResourcePaths)).setConfig(this.createRestReactiveConfig(config))).setAdditionalReaders(additionalReaders)).setHttpAnnotationToMethod(result.getHttpAnnotationToMethod())).setInjectableBeans(injectableBeans)).setAdditionalWriters(additionalWriters)).setDefaultBlocking(appResult.getBlockingDefault())).setApplicationScanningResult(appResult)).setMultipartReturnTypeIndexerExtension((EndpointIndexer.MultipartReturnTypeIndexerExtension)new GeneratedHandlerMultipartReturnTypeIndexerExtension((ClassOutput)classOutput))).setFieldInjectionIndexerExtension((ServerEndpointIndexer.FieldInjectionIndexerExtension)new TransformedFieldInjectionIndexerExtension(transformationConsumer, false, field -> initConverters.invokeStaticMethod(MethodDescriptor.ofMethod((Object)field.getInjectedClassName(), (String)field.getMethodName(), Void.TYPE, (Object[])new Object[]{Deployment.class}), new ResultHandle[]{initConverters.getMethodParam(0)})))).setConverterSupplierIndexerExtension((ServerEndpointIndexer.ConverterSupplierIndexerExtension)new GeneratedConverterIndexerExtension(name -> new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true)))).setHasRuntimeConverters(!paramConverterProviders.getParamConverterProviders().isEmpty())).setClassLevelExceptionMappers(classLevelExceptionMappers.isPresent() ? classLevelExceptionMappers.get().getMappers() : Collections.emptyMap())).setResourceMethodCallback(new Consumer<EndpointIndexer.ResourceMethodCallbackEntry>(){

                @Override
                public void accept(EndpointIndexer.ResourceMethodCallbackEntry entry) {
                    MethodInfo method = entry.getMethodInfo();
                    resourceMethodEntries.add(new ResteasyReactiveResourceMethodEntriesBuildItem.Entry(entry.getBasicResourceClassInfo(), method, entry.getActualEndpointInfo(), entry.getResourceMethod()));
                    String source = ResteasyReactiveProcessor.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
                    ClassInfo classInfoWithSecurity = ResteasyReactiveProcessor.this.consumeStandardSecurityAnnotations(method, entry.getActualEndpointInfo(), index, c -> c);
                    if (classInfoWithSecurity != null) {
                        reflectiveClassBuildItemBuildProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{entry.getActualEndpointInfo().name().toString()}).constructors(false).methods().build());
                    }
                    if (!result.getPossibleSubResources().containsKey(method.returnType().name())) {
                        reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(method.returnType()).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                    }
                    boolean paramsRequireReflection = false;
                    for (short i = 0; i < method.parametersCount(); i = (short)(i + 1)) {
                        Type parameterType = method.parameterType((int)i);
                        if (!this.hasAnnotation(method, i, ResteasyReactiveServerDotNames.CONTEXT)) {
                            reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(index).ignoreTypePredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)QuarkusResteasyReactiveDotNames.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
                        }
                        if (!parameterType.name().equals((Object)FILE)) continue;
                        paramsRequireReflection = true;
                        break;
                    }
                    if (paramsRequireReflection || ResteasyReactiveDotNames.MULTI.toString().equals(entry.getResourceMethod().getSimpleReturnType()) || ResteasyReactiveDotNames.REST_MULTI.toString().equals(entry.getResourceMethod().getSimpleReturnType()) || ResteasyReactiveDotNames.PUBLISHER.toString().equals(entry.getResourceMethod().getSimpleReturnType()) || ResteasyReactiveDotNames.LEGACY_PUBLISHER.toString().equals(entry.getResourceMethod().getSimpleReturnType()) || ResteasyReactiveProcessor.this.filtersAccessResourceMethod(resourceInterceptorsBuildItem.getResourceInterceptors()) || entry.additionalRegisterClassForReflectionCheck()) {
                        this.minimallyRegisterResourceClassForReflection(entry, (BuildProducer<ReflectiveClassBuildItem>)reflectiveClassBuildItemBuildProducer);
                    }
                }

                private void minimallyRegisterResourceClassForReflection(EndpointIndexer.ResourceMethodCallbackEntry entry, BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemBuildProducer2) {
                    reflectiveClassBuildItemBuildProducer2.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{entry.getActualEndpointInfo().name().toString()}).constructors(false).methods().build());
                }

                private boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
                    for (AnnotationInstance annotationInstance : method.annotations()) {
                        AnnotationTarget target = annotationInstance.target();
                        if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
                        return true;
                    }
                    return false;
                }
            })).setResteasyReactiveRecorder(recorder).setApplicationClassPredicate(applicationClassPredicate).setTargetJavaVersion(new TargetJavaVersion(){
                private final TargetJavaVersion.Status result;
                {
                    CompiledJavaVersionBuildItem.JavaVersion.Status status = compiledJavaVersionBuildItem.getJavaVersion().isJava19OrHigher();
                    this.result = status == CompiledJavaVersionBuildItem.JavaVersion.Status.FALSE ? TargetJavaVersion.Status.FALSE : (status == CompiledJavaVersionBuildItem.JavaVersion.Status.TRUE ? TargetJavaVersion.Status.TRUE : TargetJavaVersion.Status.UNKNOWN);
                }

                public TargetJavaVersion.Status isJava19OrHigher() {
                    return this.result;
                }
            })).setIsDisabledCreator(new Function<ClassInfo, Supplier<Boolean>>(){

                @Override
                public Supplier<Boolean> apply(ClassInfo classInfo) {
                    AnnotationInstance instance = classInfo.declaredAnnotation(ENDPOINT_DISABLED);
                    if (instance == null) {
                        return null;
                    }
                    String propertyName = instance.value("name").asString();
                    String propertyValue = instance.value("stringValue").asString();
                    AnnotationValue disableIfMissingValue = instance.value("disableIfMissing");
                    boolean disableIfMissing = disableIfMissingValue != null && disableIfMissingValue.asBoolean();
                    return recorder.disableIfPropertyMatches(propertyName, propertyValue, disableIfMissing);
                }
            });
            if (!serverDefaultProducesHandlers.isEmpty()) {
                ArrayList<DefaultProducesHandler> handlers = new ArrayList<DefaultProducesHandler>(serverDefaultProducesHandlers.size());
                for (ServerDefaultProducesHandlerBuildItem serverDefaultProducesHandlerBuildItem : serverDefaultProducesHandlers) {
                    handlers.add(serverDefaultProducesHandlerBuildItem.getDefaultProducesHandler());
                }
                serverEndpointIndexerBuilder.setDefaultProducesHandler((DefaultProducesHandler)new DefaultProducesHandler.DelegatingDefaultProducesHandler(handlers));
            }
            if (!annotationTransformerBuildItems.isEmpty()) {
                ArrayList<org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer> annotationsTransformers = new ArrayList<org.jboss.resteasy.reactive.common.processor.transformation.AnnotationsTransformer>(annotationTransformerBuildItems.size());
                for (AnnotationsTransformerBuildItem annotationsTransformerBuildItem : annotationTransformerBuildItems) {
                    annotationsTransformers.add(annotationsTransformerBuildItem.getAnnotationsTransformer());
                }
                serverEndpointIndexerBuilder.setAnnotationsTransformers(annotationsTransformers);
            }
            serverEndpointIndexerBuilder.setMultipartReturnTypeIndexerExtension(new QuarkusMultipartReturnTypeHandler(generatedClassBuildItemBuildProducer, applicationClassPredicate, reflectiveClassBuildItemBuildProducer));
            QuarkusServerEndpointIndexer serverEndpointIndexer = serverEndpointIndexerBuilder.build();
            HashMap<String, List<EndpointConfig>> allMethods = new HashMap<String, List<EndpointConfig>>();
            for (ClassInfo classInfo : scannedResources.values()) {
                Optional endpoints = serverEndpointIndexer.createEndpoints(classInfo, true);
                if (!endpoints.isPresent()) continue;
                if (singletonClasses.contains(classInfo.name().toString())) {
                    ((ResourceClass)endpoints.get()).setFactory((BeanFactory)new SingletonBeanFactory(classInfo.name().toString()));
                }
                resourceClasses.add((ResourceClass)endpoints.get());
                for (ResourceMethod rm : ((ResourceClass)endpoints.get()).getMethods()) {
                    this.addResourceMethodByPath(allMethods, ((ResourceClass)endpoints.get()).getPath(), classInfo, rm);
                }
            }
            this.checkForDuplicateEndpoint(config, allMethods);
            ArrayDeque<ClassInfo> toScan = new ArrayDeque<ClassInfo>();
            for (DotName methodAnnotation : result.getHttpAnnotationToMethod().keySet()) {
                for (AnnotationInstance instance : index.getAnnotations(methodAnnotation)) {
                    MethodInfo method = instance.target().asMethod();
                    ClassInfo classInfo = method.declaringClass();
                    toScan.add(classInfo);
                }
            }
            for (AnnotationInstance instance : index.getAnnotations(ResteasyReactiveDotNames.PATH)) {
                if (instance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
                MethodInfo method = instance.target().asMethod();
                ClassInfo classInfo = method.declaringClass();
                toScan.add(classInfo);
            }
            HashMap<DotName, ClassInfo> hashMap = new HashMap<DotName, ClassInfo>();
            Set resourceClassNames = null;
            while (!toScan.isEmpty()) {
                Optional endpoints;
                ClassInfo classInfo = (ClassInfo)toScan.poll();
                if (scannedResources.containsKey(classInfo.name()) || pathInterfaces.containsKey(classInfo.name()) || hashMap.containsKey(classInfo.name())) continue;
                hashMap.put(classInfo.name(), classInfo);
                if (classInfo.isInterface()) {
                    int resourceClassImplCount = 0;
                    if (resourceClassNames == null) {
                        resourceClassNames = resourceClasses.stream().map(ResourceClass::getClassName).collect(Collectors.toSet());
                    }
                    for (ClassInfo impl : index.getAllKnownImplementors(classInfo.name())) {
                        if (!resourceClassNames.contains(impl.name().toString())) continue;
                        ++resourceClassImplCount;
                    }
                    if (resourceClassImplCount > 1) continue;
                }
                if ((endpoints = serverEndpointIndexer.createEndpoints(classInfo, false)).isPresent()) {
                    subResourceClasses.add((ResourceClass)endpoints.get());
                }
                toScan.addAll(index.getKnownDirectImplementors(classInfo.name()));
                toScan.addAll(index.getKnownDirectSubclasses(classInfo.name()));
            }
            setupEndpointsResultProducer.produce((BuildItem)new SetupEndpointsResultBuildItem(resourceClasses, subResourceClasses, additionalReaders, additionalWriters));
            resourceMethodEntriesBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveResourceMethodEntriesBuildItem(resourceMethodEntries));
            initConverters.returnValue(null);
        }
        this.handleDateFormatReflection(reflectiveClassBuildItemBuildProducer, index);
    }

    private boolean filtersAccessResourceMethod(ResourceInterceptors resourceInterceptors) {
        final AtomicBoolean ab = new AtomicBoolean(false);
        ResourceInterceptors.FiltersVisitor visitor = new ResourceInterceptors.FiltersVisitor(){

            public ResourceInterceptors.FiltersVisitor.VisitResult visitPreMatchRequestFilter(ResourceInterceptor<ContainerRequestFilter> interceptor) {
                return this.inspect(interceptor);
            }

            public ResourceInterceptors.FiltersVisitor.VisitResult visitGlobalRequestFilter(ResourceInterceptor<ContainerRequestFilter> interceptor) {
                return this.inspect(interceptor);
            }

            public ResourceInterceptors.FiltersVisitor.VisitResult visitNamedRequestFilter(ResourceInterceptor<ContainerRequestFilter> interceptor) {
                return this.inspect(interceptor);
            }

            public ResourceInterceptors.FiltersVisitor.VisitResult visitGlobalResponseFilter(ResourceInterceptor<ContainerResponseFilter> interceptor) {
                return this.inspect(interceptor);
            }

            public ResourceInterceptors.FiltersVisitor.VisitResult visitNamedResponseFilter(ResourceInterceptor<ContainerResponseFilter> interceptor) {
                return this.inspect(interceptor);
            }

            private ResourceInterceptors.FiltersVisitor.VisitResult inspect(ResourceInterceptor<?> interceptor) {
                Map metadata = interceptor.metadata;
                if (metadata == null) {
                    return ResourceInterceptors.FiltersVisitor.VisitResult.CONTINUE;
                }
                MethodInfo methodInfo = (MethodInfo)metadata.get("filterSourceMethod");
                if (methodInfo == null) {
                    return ResourceInterceptors.FiltersVisitor.VisitResult.CONTINUE;
                }
                boolean result = this.createFilterClassIntrospector().usesGetResourceMethod(methodInfo);
                if (result) {
                    ab.set(true);
                    return ResourceInterceptors.FiltersVisitor.VisitResult.ABORT;
                }
                return ResourceInterceptors.FiltersVisitor.VisitResult.CONTINUE;
            }

            private FilterClassIntrospector createFilterClassIntrospector() {
                return new FilterClassIntrospector(Thread.currentThread().getContextClassLoader());
            }
        };
        resourceInterceptors.visitFilters(visitor);
        return ab.get();
    }

    @BuildStep
    public void transformEndpoints(ResourceScanningResultBuildItem resourceScanningResultBuildItem, ResourceInterceptorsBuildItem resourceInterceptorsBuildItem, BuildProducer<io.quarkus.arc.deployment.AnnotationsTransformerBuildItem> annotationsTransformer, final BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        final HashSet allResources = new HashSet();
        allResources.addAll(resourceScanningResultBuildItem.getResult().getScannedResources().keySet());
        allResources.addAll(resourceScanningResultBuildItem.getResult().getPossibleSubResources().keySet());
        final Set beanParams = resourceScanningResultBuildItem.getResult().getBeanParams();
        final HashSet filtersAndInterceptors = new HashSet();
        InterceptorContainer readerInterceptors = resourceInterceptorsBuildItem.getResourceInterceptors().getReaderInterceptors();
        readerInterceptors.getNameResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        readerInterceptors.getGlobalResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        InterceptorContainer writerInterceptors = resourceInterceptorsBuildItem.getResourceInterceptors().getWriterInterceptors();
        writerInterceptors.getNameResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        writerInterceptors.getGlobalResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        PreMatchInterceptorContainer containerRequestFilters = resourceInterceptorsBuildItem.getResourceInterceptors().getContainerRequestFilters();
        containerRequestFilters.getPreMatchInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        containerRequestFilters.getNameResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        containerRequestFilters.getGlobalResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        InterceptorContainer containerResponseFilters = resourceInterceptorsBuildItem.getResourceInterceptors().getContainerResponseFilters();
        containerResponseFilters.getGlobalResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        containerResponseFilters.getNameResourceInterceptors().forEach(i -> filtersAndInterceptors.add(i.getClassName()));
        annotationsTransformer.produce((BuildItem)new io.quarkus.arc.deployment.AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo clazz = context.getTarget().asClass();
                if (allResources.contains(clazz.name()) && clazz.declaredAnnotation(ResteasyReactiveDotNames.TYPED) == null) {
                    ((Transformation)context.transform().add(ResteasyReactiveProcessor.this.createTypedAnnotationInstance(clazz, beanArchiveIndexBuildItem))).done();
                    return;
                }
                if ((clazz.declaredAnnotation(ResteasyReactiveDotNames.PROVIDER) != null || filtersAndInterceptors.contains(clazz.name().toString())) && clazz.declaredAnnotation(ResteasyReactiveDotNames.TYPED) == null) {
                    ((Transformation)context.transform().add(ResteasyReactiveProcessor.this.createTypedAnnotationInstance(clazz, beanArchiveIndexBuildItem))).done();
                    return;
                }
                if (beanParams.contains(clazz.name().toString()) && clazz.declaredAnnotation(ResteasyReactiveDotNames.TYPED) == null) {
                    ((Transformation)context.transform().add(ResteasyReactiveProcessor.this.createTypedAnnotationInstance(clazz, beanArchiveIndexBuildItem))).done();
                    return;
                }
            }
        }));
    }

    private AnnotationInstance createTypedAnnotationInstance(ClassInfo clazz, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        HashSet<DotName> interfaceNames = new HashSet<DotName>();
        ClassInfo currentClazz = clazz;
        while (!ResteasyReactiveDotNames.OBJECT.equals((Object)currentClazz.name())) {
            currentClazz.interfaceNames().forEach(iface -> interfaceNames.add((DotName)iface));
            currentClazz = beanArchiveIndexBuildItem.getIndex().getClassByName(currentClazz.superName());
        }
        HashSet<DotName> allInterfaces = new HashSet<DotName>();
        this.recursiveInterfaceSearch(interfaceNames, allInterfaces, beanArchiveIndexBuildItem);
        AnnotationValue[] annotationValues = new AnnotationValue[allInterfaces.size() + 1];
        annotationValues[0] = AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS));
        Iterator iterator = allInterfaces.iterator();
        for (int i = 1; i < annotationValues.length; ++i) {
            annotationValues[i] = AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)((DotName)iterator.next()), (Type.Kind)Type.Kind.CLASS));
        }
        return AnnotationInstance.create((DotName)ResteasyReactiveDotNames.TYPED, (AnnotationTarget)clazz, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])annotationValues)});
    }

    private void recursiveInterfaceSearch(Set<DotName> interfacesToProcess, Set<DotName> allDiscoveredInterfaces, BeanArchiveIndexBuildItem beanArchiveIndexBuildItem) {
        allDiscoveredInterfaces.addAll(interfacesToProcess);
        HashSet<DotName> additionalInterfacesToProcess = new HashSet<DotName>();
        for (DotName name : interfacesToProcess) {
            ClassInfo clazz = beanArchiveIndexBuildItem.getIndex().getClassByName(name);
            if (clazz == null) continue;
            additionalInterfacesToProcess.addAll(clazz.interfaceNames());
        }
        if (!additionalInterfacesToProcess.isEmpty()) {
            this.recursiveInterfaceSearch(additionalInterfacesToProcess, allDiscoveredInterfaces, beanArchiveIndexBuildItem);
        }
    }

    private Collection<DotName> additionalContextTypes(List<ContextTypeBuildItem> contextTypeBuildItems) {
        if (contextTypeBuildItems.isEmpty()) {
            return CONTEXT_TYPES;
        }
        HashSet<DotName> contextTypes = new HashSet<DotName>(CONTEXT_TYPES.size() + contextTypeBuildItems.size());
        contextTypes.addAll(CONTEXT_TYPES);
        for (ContextTypeBuildItem bi : contextTypeBuildItems) {
            contextTypes.add(bi.getType());
        }
        return contextTypes;
    }

    private void handleDateFormatReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, IndexView index) {
        Collection dateFormatInstances = index.getAnnotations(ResteasyReactiveDotNames.DATE_FORMAT);
        if (dateFormatInstances.isEmpty()) {
            return;
        }
        ArrayList<String> dateTimeFormatterProviderClassNames = new ArrayList<String>();
        for (AnnotationInstance instance : dateFormatInstances) {
            AnnotationValue dateTimeFormatterProviderValue = instance.value("dateTimeFormatterProvider");
            if (dateTimeFormatterProviderValue == null) continue;
            dateTimeFormatterProviderClassNames.add(dateTimeFormatterProviderValue.asClass().name().toString());
        }
        if (!dateTimeFormatterProviderClassNames.isEmpty()) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])dateTimeFormatterProviderClassNames.toArray(EMPTY_STRING_ARRAY)).serialization(false).build());
        }
    }

    @BuildStep
    public void providersFromClasspath(BuildProducer<MessageBodyReaderBuildItem> messageBodyReaderProducer, BuildProducer<MessageBodyWriterBuildItem> messageBodyWriterProducer) {
        String fileName = "META-INF/services/" + Providers.class.getName();
        Predicate<String> ignoredProviders = s -> s.startsWith("org.jboss.resteasy.plugins.providers");
        try {
            HashSet detectedProviders = new HashSet(ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)fileName));
            for (String providerClassName : detectedProviders) {
                if (ignoredProviders.test(providerClassName)) continue;
                try {
                    MessageBodyReaderBuildItem.Builder builder;
                    String handledClassName;
                    Class<?> providerClass = Class.forName(providerClassName, false, Thread.currentThread().getContextClassLoader());
                    if (MessageBodyReader.class.isAssignableFrom(providerClass)) {
                        handledClassName = ResteasyReactiveProcessor.determineHandledGenericTypeOfProviderInterface(providerClass, MessageBodyReader.class);
                        if (handledClassName == null) {
                            log.warn((Object)("Unable to determine which type MessageBodyReader '" + providerClass.getName() + "' handles so this Provider will be ignored"));
                            continue;
                        }
                        builder = new MessageBodyReaderBuildItem.Builder(providerClassName, handledClassName).setBuiltin(true);
                        Consumes consumes = providerClass.getAnnotation(Consumes.class);
                        if (consumes != null) {
                            builder.setMediaTypeStrings(Arrays.asList(consumes.value()));
                        } else {
                            builder.setMediaTypeStrings(Collections.singletonList(MediaType.WILDCARD_TYPE.toString()));
                        }
                        messageBodyReaderProducer.produce((BuildItem)builder.build());
                    }
                    if (!MessageBodyWriter.class.isAssignableFrom(providerClass)) continue;
                    handledClassName = ResteasyReactiveProcessor.determineHandledGenericTypeOfProviderInterface(providerClass, MessageBodyWriter.class);
                    if (handledClassName == null) {
                        log.warn((Object)("Unable to determine which type MessageBodyWriter '" + providerClass.getName() + "' handles so this Provider will be ignored"));
                        continue;
                    }
                    builder = new MessageBodyWriterBuildItem.Builder(providerClassName, handledClassName).setBuiltin(true);
                    Produces produces = providerClass.getAnnotation(Produces.class);
                    if (produces != null) {
                        builder.setMediaTypeStrings(Arrays.asList(produces.value()));
                    } else {
                        builder.setMediaTypeStrings(Collections.singletonList(MediaType.WILDCARD_TYPE.toString()));
                    }
                    messageBodyWriterProducer.produce((BuildItem)builder.build());
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Unable to load class '" + providerClassName + "' when trying to determine what kind of JAX-RS Provider it is."), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)("Unable to properly detect and parse the contents of '" + fileName + "'"), (Throwable)e);
        }
    }

    private static String determineHandledGenericTypeOfProviderInterface(Class<?> providerClass, Class<?> targetProviderInterface) {
        java.lang.reflect.Type[] types = Types.findParameterizedTypes(providerClass, targetProviderInterface);
        if (types == null || types.length != 1) {
            return null;
        }
        try {
            return Types.getRawType((java.lang.reflect.Type)types[0]).getName();
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @BuildStep
    public void fileHandling(BuildProducer<BuiltInReaderOverrideBuildItem> overrideProducer, BuildProducer<MessageBodyReaderBuildItem> readerProducer) {
        overrideProducer.produce((BuildItem)new BuiltInReaderOverrideBuildItem(ServerFileBodyHandler.class.getName(), QuarkusServerFileBodyHandler.class.getName()));
        readerProducer.produce((BuildItem)new MessageBodyReaderBuildItem(QuarkusServerPathBodyHandler.class.getName(), Path.class.getName(), List.of("*/*"), RuntimeType.SERVER, true, Integer.valueOf(5000)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void serverSerializers(ResteasyReactiveRecorder recorder, BeanContainerBuildItem beanContainerBuildItem, ApplicationResultBuildItem applicationResultBuildItem, List<MessageBodyReaderBuildItem> additionalMessageBodyReaders, List<MessageBodyWriterBuildItem> additionalMessageBodyWriters, List<MessageBodyReaderOverrideBuildItem> messageBodyReaderOverrideBuildItems, List<MessageBodyWriterOverrideBuildItem> messageBodyWriterOverrideBuildItems, List<BuiltInReaderOverrideBuildItem> builtInReaderOverrideBuildItems, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServerSerialisersBuildItem> serverSerializersProducer) {
        ServerSerialisers serialisers = recorder.createServerSerialisers();
        SerializersUtil.setupSerializers((ResteasyReactiveCommonRecorder)recorder, reflectiveClass, additionalMessageBodyReaders, additionalMessageBodyWriters, messageBodyReaderOverrideBuildItems, messageBodyWriterOverrideBuildItems, (BeanContainerBuildItem)beanContainerBuildItem, (ApplicationResultBuildItem)applicationResultBuildItem, (Serialisers)serialisers, (RuntimeType)RuntimeType.SERVER);
        for (Serialisers.BuiltinWriter builtinWriter : ServerSerialisers.BUILTIN_WRITERS) {
            this.registerWriter(recorder, serialisers, builtinWriter.entityClass.getName(), builtinWriter.writerClass.getName(), beanContainerBuildItem.getValue(), builtinWriter.mediaType);
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{builtinWriter.writerClass.getName()}).build());
        }
        Map<String, String> builtInReaderOverrides = BuiltInReaderOverrideBuildItem.toMap(builtInReaderOverrideBuildItems);
        for (Serialisers.BuiltinReader builtinReader : ServerSerialisers.BUILTIN_READERS) {
            String effectiveReaderClassName = builtinReader.readerClass.getName();
            if (builtInReaderOverrides.containsKey(effectiveReaderClassName)) {
                effectiveReaderClassName = builtInReaderOverrides.get(effectiveReaderClassName);
            }
            this.registerReader(recorder, serialisers, builtinReader.entityClass.getName(), effectiveReaderClassName, beanContainerBuildItem.getValue(), builtinReader.mediaType, builtinReader.constraint);
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{effectiveReaderClassName}).build());
        }
        serverSerializersProducer.produce((BuildItem)new ServerSerialisersBuildItem(serialisers));
    }

    @BuildStep
    public void additionalReflection(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, SetupEndpointsResultBuildItem setupEndpointsResult, List<MessageBodyReaderBuildItem> messageBodyReaderBuildItems, List<MessageBodyWriterBuildItem> messageBodyWriterBuildItems, BuildProducer<ReflectiveClassBuildItem> producer) {
        List interfaceNames;
        ClassInfo writerClassInfo;
        List<ResourceClass> resourceClasses = setupEndpointsResult.getResourceClasses();
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        boolean serializersRequireResourceReflection = false;
        for (MessageBodyWriterBuildItem writer : messageBodyWriterBuildItems) {
            if (writer.isBuiltin() || writer.getRuntimeType() != null && writer.getRuntimeType() == RuntimeType.CLIENT || (writerClassInfo = index.getClassByName(DotName.createSimple((String)writer.getClassName()))) == null || (interfaceNames = writerClassInfo.interfaceNames()).contains(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_WRITER)) continue;
            serializersRequireResourceReflection = true;
            break;
        }
        if (!serializersRequireResourceReflection) {
            for (MessageBodyReaderBuildItem reader : messageBodyReaderBuildItems) {
                if (reader.isBuiltin() || reader.getRuntimeType() != null && reader.getRuntimeType() == RuntimeType.CLIENT || (writerClassInfo = index.getClassByName(DotName.createSimple((String)reader.getClassName()))) == null || (interfaceNames = writerClassInfo.interfaceNames()).contains(ResteasyReactiveServerDotNames.SERVER_MESSAGE_BODY_READER)) continue;
                serializersRequireResourceReflection = true;
                break;
            }
        }
        if (serializersRequireResourceReflection) {
            producer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])resourceClasses.stream().map(ResourceClass::getClassName).toArray(String[]::new))).constructors(false).methods().build());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, useIdentityComparisonForParameters=false)
    public void setupDeployment(BeanContainerBuildItem beanContainerBuildItem, Capabilities capabilities, ResteasyReactiveConfig config, Optional<ResourceScanningResultBuildItem> resourceScanningResultBuildItem, ResteasyReactiveRecorder recorder, RecorderContext recorderContext, ShutdownContextBuildItem shutdownContext, HttpBuildTimeConfig vertxConfig, SetupEndpointsResultBuildItem setupEndpointsResult, ServerSerialisersBuildItem serverSerialisersBuildItem, List<PreExceptionMapperHandlerBuildItem> preExceptionMapperHandlerBuildItems, List<DynamicFeatureBuildItem> dynamicFeatures, List<JaxrsFeatureBuildItem> features, Optional<RequestContextFactoryBuildItem> requestContextFactoryBuildItem, BuildProducer<ResteasyReactiveDeploymentInfoBuildItem> quarkusRestDeploymentInfoBuildItemBuildProducer, BuildProducer<ResteasyReactiveDeploymentBuildItem> quarkusRestDeploymentBuildItemBuildProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<RouteBuildItem> routes, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, ApplicationResultBuildItem applicationResultBuildItem, ResourceInterceptorsBuildItem resourceInterceptorsBuildItem, ExceptionMappersBuildItem exceptionMappersBuildItem, ParamConverterProvidersBuildItem paramConverterProvidersBuildItem, ContextResolversBuildItem contextResolversBuildItem, ResteasyReactiveServerConfig serverConfig, LaunchModeBuildItem launchModeBuildItem, List<ResumeOn404BuildItem> resumeOn404Items) throws NoSuchMethodException {
        if (!resourceScanningResultBuildItem.isPresent()) {
            return;
        }
        recorderContext.registerNonDefaultConstructor(MediaType.class.getDeclaredConstructor(String.class, String.class, String.class), mediaType -> Stream.of(mediaType.getType(), mediaType.getSubtype(), mediaType.getParameters()).collect(Collectors.toList()));
        ApplicationScanningResult appResult = applicationResultBuildItem.getResult();
        Set singletonClasses = appResult.getSingletonClasses();
        Application application = appResult.getApplication();
        List<ResourceClass> resourceClasses = setupEndpointsResult.getResourceClasses();
        List<ResourceClass> subResourceClasses = setupEndpointsResult.getSubResourceClasses();
        AdditionalReaders additionalReaders = setupEndpointsResult.getAdditionalReaders();
        AdditionalWriters additionalWriters = setupEndpointsResult.getAdditionalWriters();
        ResourceInterceptors interceptors = resourceInterceptorsBuildItem.getResourceInterceptors();
        ExceptionMapping exceptionMapping = exceptionMappersBuildItem.getExceptionMapping();
        ContextResolvers contextResolvers = contextResolversBuildItem.getContextResolvers();
        ParamConverterProviders paramConverterProviders = paramConverterProvidersBuildItem.getParamConverterProviders();
        Function<String, BeanFactory> factoryFunction = s -> FactoryUtils.factory((String)s, (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem);
        interceptors.initializeDefaultFactories(factoryFunction);
        contextResolvers.initializeDefaultFactories(factoryFunction);
        exceptionMapping.initializeDefaultFactories(factoryFunction);
        exceptionMapping.replaceDiscardAtRuntimeIfBeanIsUnavailable(className -> recorder.beanUnavailable(className));
        paramConverterProviders.initializeDefaultFactories(factoryFunction);
        paramConverterProviders.sort();
        interceptors.sort();
        interceptors.getContainerRequestFilters().validateThreadModel();
        Features feats = new Features();
        for (JaxrsFeatureBuildItem jaxrsFeatureBuildItem : features) {
            ResourceFeature resourceFeature = new ResourceFeature();
            resourceFeature.setFactory(FactoryUtils.factory((String)jaxrsFeatureBuildItem.getClassName(), (Set)singletonClasses, (ResteasyReactiveCommonRecorder)recorder, (BeanContainerBuildItem)beanContainerBuildItem));
            feats.addFeature(resourceFeature);
        }
        DynamicFeatures dynamicFeats = new DynamicFeatures();
        for (DynamicFeatureBuildItem dynamicFeatureBuildItem : dynamicFeatures) {
            ResourceDynamicFeature resourceFeature = new ResourceDynamicFeature();
            resourceFeature.setFactory(recorder.factory(dynamicFeatureBuildItem.getClassName(), beanContainerBuildItem.getValue()));
            dynamicFeats.addFeature(resourceFeature);
        }
        ServerSerialisers serverSerialisers = serverSerialisersBuildItem.getSerialisers();
        for (AdditionalReaderWriter.Entry additionalReader : additionalReaders.get()) {
            String readerClass = additionalReader.getHandlerClass();
            this.registerReader(recorder, serverSerialisers, additionalReader.getEntityClass(), readerClass, beanContainerBuildItem.getValue(), additionalReader.getMediaType(), additionalReader.getConstraint());
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{readerClass}).build());
        }
        for (AdditionalReaderWriter.Entry entry : additionalWriters.get()) {
            String writerClass = entry.getHandlerClass();
            this.registerWriter(recorder, serverSerialisers, entry.getEntityClass(), writerClass, beanContainerBuildItem.getValue(), entry.getMediaType());
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{writerClass}).build());
        }
        BeanFactory beanFactory = recorder.factory(QUARKUS_INIT_CLASS, beanContainerBuildItem.getValue());
        String applicationPath = this.determineApplicationPath(appResult, this.getAppPath(serverConfig.path()));
        if (applicationPath != null && applicationPath.contains("%")) {
            applicationPath = Encode.decodePath((String)applicationPath);
        }
        String deploymentPath = this.sanitizeApplicationPath(applicationPath);
        Class applicationClass = application == null ? Application.class : application.getClass();
        DeploymentInfo deploymentInfo = new DeploymentInfo().setInterceptors(interceptors.sort()).setResteasyReactiveConfig(this.createRestReactiveConfig(config)).setExceptionMapping(exceptionMapping).setCtxResolvers(contextResolvers).setFeatures(feats).setClientProxyUnwrapper(recorder.clientProxyUnwrapper()).setApplicationSupplier(recorder.handleApplication(applicationClass, singletonClasses.isEmpty())).setFactoryCreator(recorder.factoryCreator(beanContainerBuildItem.getValue())).setDynamicFeatures(dynamicFeats).setSerialisers(serverSerialisers).setPreExceptionMapperHandler(this.determinePreExceptionMapperHandler(preExceptionMapperHandlerBuildItems)).setApplicationPath(applicationPath).setGlobalHandlerCustomizers(Collections.singletonList(new SecurityContextOverrideHandler.Customizer())).setResourceClasses(resourceClasses).setDevelopmentMode(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT).setLocatableResourceClasses(subResourceClasses).setParamConverterProviders(paramConverterProviders);
        quarkusRestDeploymentInfoBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveDeploymentInfoBuildItem(deploymentInfo));
        boolean servletPresent = false;
        int order = 20500;
        if (capabilities.isPresent("io.quarkus.servlet")) {
            order = 1500;
            servletPresent = true;
        }
        RuntimeValue deployment = recorder.createDeployment(deploymentInfo, beanContainerBuildItem.getValue(), (ShutdownContext)shutdownContext, vertxConfig, (RequestContextFactory)requestContextFactoryBuildItem.map(RequestContextFactoryBuildItem::getFactory).orElse(null), beanFactory, launchModeBuildItem.getLaunchMode());
        quarkusRestDeploymentBuildItemBuildProducer.produce((BuildItem)new ResteasyReactiveDeploymentBuildItem((RuntimeValue<Deployment>)deployment, deploymentPath));
        if (!requestContextFactoryBuildItem.isPresent()) {
            boolean noCustomAuthRedirectExMapper;
            boolean noCustomAuthFailureExMapper;
            boolean noCustomAuthCompletionExMapper;
            RuntimeValue restInitialHandler = recorder.restInitialHandler(deployment);
            Handler handler = recorder.handler(restInitialHandler);
            if (vertxConfig.auth.proactive) {
                noCustomAuthCompletionExMapper = ResteasyReactiveProcessor.notFoundCustomExMapper(AuthenticationCompletionException.class.getName(), AuthenticationCompletionExceptionMapper.class.getName(), exceptionMapping);
                noCustomAuthFailureExMapper = ResteasyReactiveProcessor.notFoundCustomExMapper(AuthenticationFailedException.class.getName(), AuthenticationFailedExceptionMapper.class.getName(), exceptionMapping);
                noCustomAuthRedirectExMapper = ResteasyReactiveProcessor.notFoundCustomExMapper(AuthenticationRedirectException.class.getName(), AuthenticationRedirectExceptionMapper.class.getName(), exceptionMapping);
            } else {
                noCustomAuthCompletionExMapper = false;
                noCustomAuthFailureExMapper = false;
                noCustomAuthRedirectExMapper = false;
            }
            Handler failureHandler = recorder.failureHandler(restInitialHandler, noCustomAuthCompletionExMapper, noCustomAuthFailureExMapper, noCustomAuthRedirectExMapper, vertxConfig.auth.proactive);
            filterBuildItemBuildProducer.produce((BuildItem)FilterBuildItem.ofAuthenticationFailureHandler((Handler)failureHandler));
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute(deploymentPath, Integer.valueOf(order)).handler(handler).build());
            Object matchPath = deploymentPath;
            matchPath = ((String)matchPath).endsWith("/") ? (String)matchPath + "*" : (String)matchPath + "/*";
            routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute((String)matchPath, Integer.valueOf(order)).handler(handler).build());
        }
    }

    private ServerRestHandler determinePreExceptionMapperHandler(List<PreExceptionMapperHandlerBuildItem> preExceptionMapperHandlerBuildItems) {
        if (preExceptionMapperHandlerBuildItems == null || preExceptionMapperHandlerBuildItems.isEmpty()) {
            return null;
        }
        if (preExceptionMapperHandlerBuildItems.size() == 1) {
            return preExceptionMapperHandlerBuildItems.get(0).getHandler();
        }
        Collections.sort(preExceptionMapperHandlerBuildItems);
        return new DelegatingServerRestHandler(preExceptionMapperHandlerBuildItems.stream().map(PreExceptionMapperHandlerBuildItem::getHandler).collect(Collectors.toList()));
    }

    private static boolean notFoundCustomExMapper(String builtInExSignature, String builtInMapperSignature, ExceptionMapping exceptionMapping) {
        for (Map.Entry entry : exceptionMapping.getMappers().entrySet()) {
            if (!builtInExSignature.equals(entry.getKey()) || ((ResourceExceptionMapper)entry.getValue()).getClassName().startsWith(builtInMapperSignature)) continue;
            return false;
        }
        for (Map.Entry entry : exceptionMapping.getRuntimeCheckMappers().entrySet()) {
            if (!builtInExSignature.equals(entry.getKey())) continue;
            for (ResourceExceptionMapper resourceExceptionMapper : (List)entry.getValue()) {
                if (resourceExceptionMapper.getClassName().startsWith(builtInMapperSignature)) continue;
                return false;
            }
        }
        return true;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public FilterBuildItem addDefaultAuthFailureHandler(ResteasyReactiveRecorder recorder) {
        return new FilterBuildItem(recorder.defaultAuthFailureHandler(), 199);
    }

    private void checkForDuplicateEndpoint(ResteasyReactiveConfig config, Map<String, List<EndpointConfig>> allMethods) {
        String message = allMethods.values().stream().map(this::getDuplicateEndpointMessage).filter(Objects::nonNull).collect(Collectors.joining());
        if (message.length() > 0) {
            if (config.failOnDuplicate()) {
                throw new DeploymentException(message);
            }
            log.warn((Object)message);
        }
    }

    private void addResourceMethodByPath(Map<String, List<EndpointConfig>> allMethods, String path, ClassInfo info, ResourceMethod rm) {
        allMethods.computeIfAbsent(this.getEndpointClassifier(rm, path), key -> new ArrayList()).addAll(this.getEndpointConfigs(path, info, rm));
    }

    private String getEndpointClassifier(ResourceMethod resourceMethod, String path) {
        return resourceMethod.getHttpMethod() + " " + (path.equals("/") ? "" : path) + resourceMethod.getPath();
    }

    private String getDuplicateEndpointMessage(List<EndpointConfig> endpoints) {
        if (endpoints.size() < 2) {
            return null;
        }
        StringBuilder message = new StringBuilder();
        Map<String, List<EndpointConfig>> duplicatesByMimeTypes = endpoints.stream().collect(Collectors.groupingBy(EndpointConfig::toString));
        for (Map.Entry<String, List<EndpointConfig>> duplicates : duplicatesByMimeTypes.entrySet()) {
            if (duplicates.getValue().size() < 2) continue;
            message.append(endpoints.get(0).getExposedEndpoint()).append(" is declared by :").append(System.lineSeparator());
            for (EndpointConfig config : duplicates.getValue()) {
                message.append(config.toCompleteString()).append(System.lineSeparator());
            }
        }
        return message.toString();
    }

    private List<EndpointConfig> getEndpointConfigs(String path, ClassInfo info, ResourceMethod rm) {
        ArrayList<EndpointConfig> result = new ArrayList<EndpointConfig>();
        String exposingMethod = info.name().toString() + "#" + rm.getName();
        if (isEmpty.test(rm.getConsumes()) && isEmpty.test(rm.getProduces())) {
            result.add(new EndpointConfig(path, rm.getHttpMethod(), null, null, exposingMethod));
        } else if (isEmpty.negate().test(rm.getConsumes()) && isEmpty.test(rm.getProduces())) {
            for (String consume : rm.getConsumes()) {
                result.add(new EndpointConfig(path, rm.getHttpMethod(), consume, null, exposingMethod));
            }
        } else if (isEmpty.test(rm.getConsumes()) && isEmpty.negate().test(rm.getProduces())) {
            for (String produce : rm.getProduces()) {
                result.add(new EndpointConfig(path, rm.getHttpMethod(), null, produce, exposingMethod));
            }
        } else {
            for (String consume : rm.getConsumes()) {
                for (String produce : rm.getProduces()) {
                    result.add(new EndpointConfig(path, rm.getHttpMethod(), consume, produce, exposingMethod));
                }
            }
        }
        return result;
    }

    private org.jboss.resteasy.reactive.common.ResteasyReactiveConfig createRestReactiveConfig(ResteasyReactiveConfig config) {
        return new org.jboss.resteasy.reactive.common.ResteasyReactiveConfig(config.inputBufferSize().asLongValue(), config.minChunkSize(), config.outputBufferSize(), config.singleDefaultProduces(), config.defaultProduces());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeConfiguration(ResteasyReactiveRuntimeRecorder recorder, Optional<ResteasyReactiveDeploymentBuildItem> deployment, ResteasyReactiveServerRuntimeConfig resteasyReactiveServerRuntimeConf, BuildProducer<HandlerConfigurationProviderBuildItem> producer) {
        if (deployment.isEmpty()) {
            return;
        }
        producer.produce((BuildItem)new HandlerConfigurationProviderBuildItem(RuntimeConfiguration.class, recorder.runtimeConfiguration(deployment.get().getDeployment(), resteasyReactiveServerRuntimeConf)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void configureHandlers(ResteasyReactiveRuntimeRecorder recorder, Optional<ResteasyReactiveDeploymentBuildItem> deployment, List<HandlerConfigurationProviderBuildItem> items) {
        if (deployment.isEmpty()) {
            return;
        }
        HashMap<Class, Supplier> runtimeConfigMap = new HashMap<Class, Supplier>();
        for (HandlerConfigurationProviderBuildItem item : items) {
            runtimeConfigMap.put(item.getConfigClass(), item.getValueSupplier());
        }
        recorder.configureHandlers(deployment.get().getDeployment(), runtimeConfigMap);
    }

    @BuildStep
    public void securityExceptionMappers(BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationCompletionExceptionMapper.class.getName(), AuthenticationCompletionException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(AuthenticationRedirectExceptionMapper.class.getName(), AuthenticationRedirectException.class.getName(), Integer.valueOf(5001), false));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(ForbiddenExceptionMapper.class.getName(), ForbiddenException.class.getName(), Integer.valueOf(5001), false));
    }

    @BuildStep
    MethodScannerBuildItem integrateEagerSecurity(Capabilities capabilities, CombinedIndexBuildItem indexBuildItem, final HttpBuildTimeConfig httpBuildTimeConfig, final Optional<EagerSecurityInterceptorBuildItem> eagerSecurityInterceptors, JaxRsSecurityConfig securityConfig) {
        if (!capabilities.isPresent("io.quarkus.security")) {
            return null;
        }
        final boolean applySecurityInterceptors = eagerSecurityInterceptors.isPresent();
        final boolean denyJaxRs = securityConfig.denyJaxRs();
        final boolean hasDefaultJaxRsRolesAllowed = !securityConfig.defaultRolesAllowed().orElse(List.of()).isEmpty();
        final IndexView index = indexBuildItem.getComputingIndex();
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                if (applySecurityInterceptors && ((EagerSecurityInterceptorBuildItem)eagerSecurityInterceptors.get()).applyInterceptorOn(method)) {
                    return List.of(EagerSecurityInterceptorHandler.Customizer.newInstance(), EagerSecurityHandler.Customizer.newInstance((boolean)httpBuildTimeConfig.auth.proactive));
                }
                if (denyJaxRs || hasDefaultJaxRsRolesAllowed) {
                    return List.of(EagerSecurityHandler.Customizer.newInstance((boolean)httpBuildTimeConfig.auth.proactive));
                }
                return Objects.requireNonNullElse(ResteasyReactiveProcessor.this.consumeStandardSecurityAnnotations(method, actualEndpointClass, index, c -> Collections.singletonList(EagerSecurityHandler.Customizer.newInstance((boolean)httpBuildTimeConfig2.auth.proactive))), Collections.emptyList());
            }
        });
    }

    @BuildStep
    void addAllWriteableMarker(List<MessageBodyWriterBuildItem> messageBodyWriterBuildItems, BuildProducer<BytecodeTransformerBuildItem> producer) {
        ArrayList<String> messageBodyWriterClassNames = new ArrayList<String>(messageBodyWriterBuildItems.size());
        for (MessageBodyWriterBuildItem bi : messageBodyWriterBuildItems) {
            if (bi.isBuiltin() || bi.getRuntimeType() != null && !bi.getRuntimeType().equals((Object)RuntimeType.SERVER)) continue;
            messageBodyWriterClassNames.add(bi.getClassName());
        }
        for (String className : messageBodyWriterClassNames) {
            if (!MessageBodyWriterTransformerUtils.shouldAddAllWriteableMarker(className, Thread.currentThread().getContextClassLoader())) continue;
            log.debug((Object)("Class '" + className + "' will be transformed to add '" + AllWriteableMarker.class.getName() + "' to its interfaces"));
            producer.produce((BuildItem)new BytecodeTransformerBuildItem(className, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String s, ClassVisitor classVisitor) {
                    return new ClassVisitor(589824, classVisitor){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            LinkedHashSet<String> newInterfaces = new LinkedHashSet<String>(interfaces.length + 1);
                            newInterfaces.addAll(Arrays.asList(interfaces));
                            newInterfaces.add(AllWriteableMarker.class.getName().replace('.', '/'));
                            super.visit(version, access, name, signature, superName, newInterfaces.toArray(EMPTY_STRING_ARRAY));
                        }
                    };
                }
            }));
        }
    }

    @BuildStep
    void registerSecurityInterceptors(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> beans) {
        if (capabilities.isPresent("io.quarkus.security")) {
            beans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{StandardSecurityCheckInterceptor.RolesAllowedInterceptor.class, StandardSecurityCheckInterceptor.AuthenticatedInterceptor.class, StandardSecurityCheckInterceptor.PermitAllInterceptor.class, StandardSecurityCheckInterceptor.PermissionsAllowedInterceptor.class}));
            beans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(EagerSecurityContext.class));
        }
    }

    private <T> T consumeStandardSecurityAnnotations(MethodInfo methodInfo, ClassInfo classInfo, IndexView index, Function<ClassInfo, T> function) {
        if (SecurityTransformerUtils.hasStandardSecurityAnnotation(methodInfo)) {
            return function.apply(methodInfo.declaringClass());
        }
        ClassInfo c = classInfo;
        while (c.superName() != null) {
            if (SecurityTransformerUtils.hasStandardSecurityAnnotation(c)) {
                return function.apply(c);
            }
            c = index.getClassByName(c.superName());
        }
        return null;
    }

    private Optional<String> getAppPath(Optional<String> newPropertyValue) {
        Optional legacyProperty = ConfigProvider.getConfig().getOptionalValue("quarkus.rest.path", String.class);
        if (legacyProperty.isPresent()) {
            return legacyProperty;
        }
        return newPropertyValue;
    }

    private String determineApplicationPath(ApplicationScanningResult appResult, Optional<String> defaultPath) {
        if (appResult.getSelectedAppClass() == null) {
            return defaultPath.orElse("/");
        }
        AnnotationInstance applicationPathValue = appResult.getSelectedAppClass().declaredAnnotation(ResteasyReactiveDotNames.APPLICATION_PATH);
        if (applicationPathValue == null) {
            return defaultPath.orElse("/");
        }
        String applicationPath = null;
        if (applicationPathValue.value() != null) {
            applicationPath = applicationPathValue.value().asString();
        }
        return applicationPath;
    }

    private String sanitizeApplicationPath(String applicationPath) {
        if (applicationPath == null || ((String)applicationPath).isEmpty() || "/".equals(applicationPath)) {
            return "/";
        }
        if (((String)(applicationPath = ((String)applicationPath).trim())).equals("/")) {
            applicationPath = "";
        }
        if (!((String)applicationPath).startsWith("/")) {
            applicationPath = "/" + (String)applicationPath;
        }
        if (((String)applicationPath).endsWith("/")) {
            applicationPath = ((String)applicationPath).substring(0, ((String)applicationPath).length() - 1);
        }
        return applicationPath;
    }

    private void registerWriter(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, String entityClass, String writerClass, BeanContainer beanContainer, String mediaType) {
        ResourceWriter writer = new ResourceWriter();
        writer.setFactory(recorder.factory(writerClass, beanContainer));
        writer.setMediaTypeStrings(Collections.singletonList(mediaType));
        recorder.registerWriter((Serialisers)serialisers, entityClass, writer);
    }

    private void registerReader(ResteasyReactiveRecorder recorder, ServerSerialisers serialisers, String entityClass, String readerClass, BeanContainer beanContainer, String mediaType, RuntimeType constraint) {
        ResourceReader reader = new ResourceReader();
        reader.setFactory(recorder.factory(readerClass, beanContainer));
        reader.setMediaTypeStrings(Collections.singletonList(mediaType));
        reader.setConstraint(constraint);
        recorder.registerReader((Serialisers)serialisers, entityClass, reader);
    }
}

