/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.security;

import io.quarkus.resteasy.reactive.server.runtime.StandardSecurityCheckInterceptor;
import io.quarkus.resteasy.reactive.server.runtime.security.EagerSecurityContext;
import io.quarkus.security.UnauthorizedException;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.spi.runtime.AuthorizationFailureEvent;
import io.quarkus.security.spi.runtime.AuthorizationSuccessEvent;
import io.quarkus.security.spi.runtime.MethodDescription;
import io.quarkus.security.spi.runtime.SecurityCheck;
import io.quarkus.security.spi.runtime.SecurityEvent;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class EagerSecurityHandler
implements ServerRestHandler {
    private static final SecurityCheck NULL_SENTINEL = new SecurityCheck(){

        public void apply(SecurityIdentity identity, Method method, Object[] parameters) {
        }

        public void apply(SecurityIdentity identity, MethodDescription method, Object[] parameters) {
        }
    };
    private final boolean onlyCheckForHttpPermissions;
    private volatile SecurityCheck check;

    public EagerSecurityHandler(boolean onlyCheckForHttpPermissions) {
        this.onlyCheckForHttpPermissions = onlyCheckForHttpPermissions;
    }

    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        Uni check;
        if (!EagerSecurityContext.instance.authorizationController.isAuthorizationEnabled()) {
            return;
        }
        Function<SecurityIdentity, Uni<?>> securityCheck = this.getSecurityCheck(requestContext);
        if (securityCheck == null) {
            if (EagerSecurityContext.instance.doNotRunPermissionSecurityCheck) {
                return;
            }
            check = Uni.createFrom().deferred(new Supplier<Uni<?>>(){

                @Override
                public Uni<?> get() {
                    return EagerSecurityContext.instance.getPermissionCheck(requestContext, null);
                }
            });
        } else {
            check = EagerSecurityContext.instance.doNotRunPermissionSecurityCheck ? EagerSecurityContext.instance.getDeferredIdentity().chain(securityCheck) : EagerSecurityContext.instance.getDeferredIdentity().flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                @Override
                public Uni<SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                    return EagerSecurityContext.instance.getPermissionCheck(requestContext, securityIdentity);
                }
            }).chain(securityCheck);
        }
        requestContext.requireCDIRequestScope();
        requestContext.suspend();
        check.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<Object>(){

            public void onSubscribe(UniSubscription subscription) {
            }

            public void onItem(Object item) {
                requestContext.resume();
            }

            public void onFailure(Throwable failure) {
                requestContext.resume(failure, true);
            }
        });
    }

    private Function<SecurityIdentity, Uni<?>> getSecurityCheck(final ResteasyReactiveRequestContext requestContext) {
        if (this.onlyCheckForHttpPermissions || this.check == NULL_SENTINEL) {
            return null;
        }
        SecurityCheck check = this.check;
        final MethodDescription methodDescription = EagerSecurityContext.lazyMethodToMethodDescription(requestContext.getTarget().getLazyMethod());
        if (check == null) {
            check = EagerSecurityContext.instance.securityCheckStorage.getSecurityCheck(methodDescription);
            if (check == null) {
                check = EagerSecurityContext.instance.securityCheckStorage.getDefaultSecurityCheck() == null || EagerSecurityHandler.isRequestAlreadyChecked(requestContext) ? NULL_SENTINEL : EagerSecurityContext.instance.securityCheckStorage.getDefaultSecurityCheck();
            }
            this.check = check;
        }
        if (check == NULL_SENTINEL) {
            return null;
        }
        if (check.isPermitAll()) {
            EagerSecurityHandler.preventRepeatedSecurityChecks(requestContext, methodDescription);
            if (EagerSecurityContext.instance.eventHelper.fireEventOnSuccess()) {
                requestContext.requireCDIRequestScope();
                EagerSecurityContext.instance.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(null, check.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
            }
            return null;
        }
        final SecurityCheck theCheck = check;
        return new Function<SecurityIdentity, Uni<?>>(){

            @Override
            public Uni<?> apply(final SecurityIdentity securityIdentity) {
                if (EagerSecurityContext.instance.isProactiveAuthDisabled) {
                    ((CurrentIdentityAssociation)EagerSecurityContext.instance.identityAssociation.get()).setIdentity(securityIdentity);
                }
                if (theCheck.requiresMethodArguments()) {
                    if (securityIdentity == null || securityIdentity.isAnonymous()) {
                        UnauthorizedException unauthorizedException = new UnauthorizedException();
                        if (EagerSecurityContext.instance.eventHelper.fireEventOnFailure()) {
                            EagerSecurityContext.instance.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, (Throwable)unauthorizedException, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                        }
                        throw unauthorizedException;
                    }
                    return Uni.createFrom().nullItem();
                }
                EagerSecurityHandler.preventRepeatedSecurityChecks(requestContext, methodDescription);
                Uni checkResult = theCheck.nonBlockingApply(securityIdentity, methodDescription, requestContext.getParameters());
                if (EagerSecurityContext.instance.eventHelper.fireEventOnFailure()) {
                    checkResult = checkResult.onFailure().invoke((Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable throwable) {
                            EagerSecurityContext.instance.eventHelper.fireFailureEvent((SecurityEvent)new AuthorizationFailureEvent(securityIdentity, throwable, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                        }
                    });
                }
                if (EagerSecurityContext.instance.eventHelper.fireEventOnSuccess()) {
                    checkResult = checkResult.invoke(new Runnable(){

                        @Override
                        public void run() {
                            EagerSecurityContext.instance.eventHelper.fireSuccessEvent((SecurityEvent)new AuthorizationSuccessEvent(securityIdentity, theCheck.getClass().getName(), EagerSecurityHandler.createEventPropsWithRoutingCtx(requestContext)));
                        }
                    });
                }
                return checkResult;
            }
        };
    }

    private static Map<String, Object> createEventPropsWithRoutingCtx(ResteasyReactiveRequestContext requestContext) {
        RoutingContext routingContext = (RoutingContext)requestContext.unwrap(RoutingContext.class);
        if (routingContext == null) {
            return Map.of();
        }
        return Map.of(RoutingContext.class.getName(), routingContext);
    }

    private static void preventRepeatedSecurityChecks(ResteasyReactiveRequestContext requestContext, MethodDescription methodDescription) {
        requestContext.setProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR, (Object)methodDescription);
    }

    private static boolean isRequestAlreadyChecked(ResteasyReactiveRequestContext requestContext) {
        return requestContext.getProperty(StandardSecurityCheckInterceptor.STANDARD_SECURITY_CHECK_INTERCEPTOR) != null;
    }

    public static abstract class Customizer
    implements HandlerChainCustomizer {
        public static HandlerChainCustomizer newInstance(boolean onlyCheckForHttpPermissions) {
            return onlyCheckForHttpPermissions ? new HttpPermissionsOnlyCustomizer() : new HttpPermissionsAndSecurityChecksCustomizer();
        }

        public List<ServerRestHandler> handlers(HandlerChainCustomizer.Phase phase, ResourceClass resourceClass, ServerResourceMethod serverResourceMethod) {
            if (phase == HandlerChainCustomizer.Phase.AFTER_MATCH) {
                return Collections.singletonList(new EagerSecurityHandler(this.onlyCheckForHttpPermissions()));
            }
            return Collections.emptyList();
        }

        protected abstract boolean onlyCheckForHttpPermissions();

        public static final class HttpPermissionsOnlyCustomizer
        extends Customizer {
            @Override
            protected boolean onlyCheckForHttpPermissions() {
                return true;
            }
        }

        public static final class HttpPermissionsAndSecurityChecksCustomizer
        extends Customizer {
            @Override
            protected boolean onlyCheckForHttpPermissions() {
                return false;
            }
        }
    }
}

