/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters;

import io.quarkus.vertx.http.runtime.AbstractRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.AbstractResponseWrapper;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

class ShutdownRequestWrapper
extends AbstractRequestWrapper {
    private volatile int done;
    private static final AtomicIntegerFieldUpdater<ShutdownRequestWrapper> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(ShutdownRequestWrapper.class, "done");
    private final Handler<Void> requestDoneHandler;
    private Handler<Throwable> exceptionHandler;
    private final AbstractResponseWrapper response;

    public ShutdownRequestWrapper(HttpServerRequest event, Handler<Void> requestDoneHandler) {
        super(event);
        this.requestDoneHandler = requestDoneHandler;
        this.response = new ResponseWrapper(this.delegate.response());
        event.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable event) {
                if (ShutdownRequestWrapper.this.exceptionHandler != null) {
                    ShutdownRequestWrapper.this.exceptionHandler.handle((Object)event);
                }
                ShutdownRequestWrapper.this.done();
            }
        });
    }

    @Override
    public HttpServerResponse response() {
        return this.response;
    }

    void done() {
        if (doneUpdater.compareAndSet(this, 0, 1)) {
            this.requestDoneHandler.handle(null);
        }
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    class ResponseWrapper
    extends AbstractResponseWrapper {
        Handler<Void> endHandler;
        Handler<Void> closeHandler;
        Handler<Throwable> exceptionHandler;

        ResponseWrapper(HttpServerResponse delegate) {
            super(delegate);
            delegate.closeHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    ShutdownRequestWrapper.this.done();
                    if (ResponseWrapper.this.closeHandler != null) {
                        ResponseWrapper.this.closeHandler.handle((Object)event);
                    }
                }
            });
            delegate.exceptionHandler((Handler)new Handler<Throwable>(){

                public void handle(Throwable event) {
                    ShutdownRequestWrapper.this.done();
                    if (ResponseWrapper.this.exceptionHandler != null) {
                        ResponseWrapper.this.exceptionHandler.handle((Object)event);
                    }
                }
            });
            delegate.endHandler((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    ShutdownRequestWrapper.this.done();
                    if (ResponseWrapper.this.endHandler != null) {
                        ResponseWrapper.this.endHandler.handle((Object)event);
                    }
                }
            });
        }

        @Override
        public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        @Override
        public HttpServerResponse closeHandler(Handler<Void> handler) {
            this.closeHandler = handler;
            return this;
        }

        @Override
        public HttpServerResponse endHandler(Handler<Void> handler) {
            this.endHandler = handler;
            return this;
        }
    }
}

