/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class HttpAuthenticator {
    @Inject
    IdentityProviderManager identityProviderManager;
    final HttpAuthenticationMechanism[] mechanisms;

    public HttpAuthenticator() {
        this.mechanisms = null;
    }

    @Inject
    public HttpAuthenticator(Instance<HttpAuthenticationMechanism> instance, Instance<IdentityProvider<?>> providers) {
        ArrayList<HttpAuthenticationMechanism> mechanisms = new ArrayList<HttpAuthenticationMechanism>();
        for (HttpAuthenticationMechanism mechanism : instance) {
            boolean notFound = false;
            for (Class<? extends AuthenticationRequest> mechType : mechanism.getCredentialTypes()) {
                boolean found = false;
                for (IdentityProvider i : providers) {
                    if (!i.getRequestType().equals(mechType)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notFound = true;
                break;
            }
            if (notFound) continue;
            mechanisms.add(mechanism);
        }
        if (mechanisms.isEmpty()) {
            this.mechanisms = new HttpAuthenticationMechanism[]{new NoAuthenticationMechanism()};
        } else {
            this.mechanisms = mechanisms.toArray(new HttpAuthenticationMechanism[mechanisms.size()]);
            HashMap<HttpCredentialTransport, HttpAuthenticationMechanism> map = new HashMap<HttpCredentialTransport, HttpAuthenticationMechanism>();
            for (HttpAuthenticationMechanism i : mechanisms) {
                HttpCredentialTransport credentialTransport = i.getCredentialTransport();
                if (credentialTransport == null) continue;
                HttpAuthenticationMechanism existing = (HttpAuthenticationMechanism)map.get(credentialTransport);
                if (existing != null) {
                    throw new RuntimeException("Multiple mechanisms present that use the same credential transport " + credentialTransport + ". Mechanisms are " + i + " and " + existing);
                }
                map.put(credentialTransport, i);
            }
        }
    }

    public CompletionStage<SecurityIdentity> attemptAuthentication(final RoutingContext routingContext) {
        CompletionStage<SecurityIdentity> result = this.mechanisms[0].authenticate(routingContext, this.identityProviderManager);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.thenCompose(new Function<SecurityIdentity, CompletionStage<SecurityIdentity>>(){

                @Override
                public CompletionStage<SecurityIdentity> apply(SecurityIdentity data) {
                    if (data != null) {
                        return CompletableFuture.completedFuture(data);
                    }
                    return mech.authenticate(routingContext, HttpAuthenticator.this.identityProviderManager);
                }
            });
        }
        return result;
    }

    public CompletionStage<Void> sendChallenge(final RoutingContext routingContext, Runnable closeTask) {
        if (closeTask == null) {
            closeTask = NoopCloseTask.INSTANCE;
        }
        CompletionStage<Boolean> result = this.mechanisms[0].sendChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.thenCompose(new Function<Boolean, CompletionStage<Boolean>>(){

                @Override
                public CompletionStage<Boolean> apply(Boolean aBoolean) {
                    if (aBoolean.booleanValue()) {
                        return CompletableFuture.completedFuture(true);
                    }
                    return mech.sendChallenge(routingContext);
                }
            });
        }
        return result.thenRun(closeTask);
    }

    public CompletionStage<ChallengeData> getChallenge(final RoutingContext routingContext) {
        CompletionStage<ChallengeData> result = this.mechanisms[0].getChallenge(routingContext);
        for (int i = 1; i < this.mechanisms.length; ++i) {
            final HttpAuthenticationMechanism mech = this.mechanisms[i];
            result = result.thenCompose(new Function<ChallengeData, CompletionStage<ChallengeData>>(){

                @Override
                public CompletionStage<ChallengeData> apply(ChallengeData data) {
                    if (data != null) {
                        return CompletableFuture.completedFuture(data);
                    }
                    return mech.getChallenge(routingContext);
                }
            });
        }
        return result;
    }

    static class NoopCloseTask
    implements Runnable {
        static final NoopCloseTask INSTANCE = new NoopCloseTask();

        NoopCloseTask() {
        }

        @Override
        public void run() {
        }
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return CompletableFuture.completedFuture(challengeData);
        }

        @Override
        public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
            return Collections.singleton(AnonymousAuthenticationRequest.class);
        }

        @Override
        public HttpCredentialTransport getCredentialTransport() {
            return null;
        }
    }
}

