/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

class ForwardedParser {
    private static final Logger log = Logger.getLogger(ForwardedParser.class);
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final AsciiString FORWARDED = AsciiString.cached((String)"Forwarded");
    private static final AsciiString X_FORWARDED_SSL = AsciiString.cached((String)"X-Forwarded-Ssl");
    private static final AsciiString X_FORWARDED_PROTO = AsciiString.cached((String)"X-Forwarded-Proto");
    private static final AsciiString X_FORWARDED_PORT = AsciiString.cached((String)"X-Forwarded-Port");
    private static final AsciiString X_FORWARDED_FOR = AsciiString.cached((String)"X-Forwarded-For");
    private static final Pattern FORWARDED_HOST_PATTERN = Pattern.compile("host=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_PROTO_PATTERN = Pattern.compile("proto=\"?([^;,\"]+)\"?");
    private static final Pattern FORWARDED_FOR_PATTERN = Pattern.compile("for=\"?([^;,\"]+)\"?");
    private final HttpServerRequest delegate;
    private final ForwardingProxyOptions forwardingProxyOptions;
    private boolean calculated;
    private String host;
    private int port = -1;
    private String scheme;
    private String uri;
    private String absoluteURI;
    private SocketAddress remoteAddress;

    ForwardedParser(HttpServerRequest delegate, ForwardingProxyOptions forwardingProxyOptions) {
        this.delegate = delegate;
        this.forwardingProxyOptions = forwardingProxyOptions;
    }

    public String scheme() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme;
    }

    String host() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.host;
    }

    boolean isSSL() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.scheme.equals(HTTPS_SCHEME);
    }

    String absoluteURI() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.absoluteURI;
    }

    SocketAddress remoteAddress() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.remoteAddress;
    }

    String uri() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.uri;
    }

    private void calculate() {
        this.calculated = true;
        this.remoteAddress = this.delegate.remoteAddress();
        this.scheme = this.delegate.scheme();
        this.setHostAndPort(this.delegate.host(), this.port);
        this.uri = this.delegate.uri();
        String forwardedSsl = this.delegate.getHeader((CharSequence)X_FORWARDED_SSL);
        boolean isForwardedSslOn = forwardedSsl != null && forwardedSsl.equalsIgnoreCase("on");
        String forwarded = this.delegate.getHeader((CharSequence)FORWARDED);
        if (this.forwardingProxyOptions.allowForwarded && forwarded != null) {
            String forwardedToUse = forwarded.split(",")[0];
            Matcher matcher = FORWARDED_PROTO_PATTERN.matcher(forwardedToUse);
            if (matcher.find()) {
                this.scheme = matcher.group(1).trim();
                this.port = -1;
            } else if (isForwardedSslOn) {
                this.scheme = HTTPS_SCHEME;
                this.port = -1;
            }
            matcher = FORWARDED_HOST_PATTERN.matcher(forwardedToUse);
            if (matcher.find()) {
                this.setHostAndPort(matcher.group(1).trim(), this.port);
            }
            if ((matcher = FORWARDED_FOR_PATTERN.matcher(forwardedToUse)).find()) {
                this.remoteAddress = this.parseFor(matcher.group(1).trim(), this.remoteAddress.port());
            }
        } else if (!this.forwardingProxyOptions.allowForwarded) {
            String forHeader;
            String portHeader;
            String prefixHeader;
            String hostHeader;
            String protocolHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PROTO);
            if (protocolHeader != null) {
                this.scheme = protocolHeader.split(",")[0];
                this.port = -1;
            } else if (isForwardedSslOn) {
                this.scheme = HTTPS_SCHEME;
                this.port = -1;
            }
            if (this.forwardingProxyOptions.enableForwardedHost && (hostHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedHostHeader)) != null) {
                this.setHostAndPort(hostHeader.split(",")[0], this.port);
            }
            if (this.forwardingProxyOptions.enableForwardedPrefix && (prefixHeader = this.delegate.getHeader((CharSequence)this.forwardingProxyOptions.forwardedPrefixHeader)) != null) {
                this.uri = this.appendPrefixToUri(prefixHeader, this.uri);
            }
            if ((portHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_PORT)) != null) {
                this.port = this.parsePort(portHeader.split(",")[0], this.port);
            }
            if ((forHeader = this.delegate.getHeader((CharSequence)X_FORWARDED_FOR)) != null) {
                this.remoteAddress = this.parseFor(forHeader.split(",")[0], this.remoteAddress.port());
            }
        }
        if (this.scheme.equals(HTTP_SCHEME) && this.port == 80 || this.scheme.equals(HTTPS_SCHEME) && this.port == 443) {
            this.port = -1;
        }
        this.host = this.host + (this.port >= 0 ? ":" + this.port : "");
        this.delegate.headers().set(HttpHeaders.HOST, (CharSequence)this.host);
        this.absoluteURI = this.scheme + "://" + this.host + this.uri;
        log.debug((Object)("Recalculated absoluteURI to " + this.absoluteURI));
    }

    private void setHostAndPort(String hostToParse, int defaultPort) {
        int portSeparatorIdx = hostToParse.lastIndexOf(58);
        if (portSeparatorIdx > hostToParse.lastIndexOf(93)) {
            this.host = hostToParse.substring(0, portSeparatorIdx);
            this.delegate.headers().set(HttpHeaders.HOST, (CharSequence)this.host);
            this.port = this.parsePort(hostToParse.substring(portSeparatorIdx + 1), defaultPort);
        } else {
            this.host = hostToParse;
            this.port = -1;
        }
    }

    private SocketAddress parseFor(String forToParse, int defaultPort) {
        String host = forToParse;
        int port = defaultPort;
        int portSeparatorIdx = forToParse.lastIndexOf(58);
        if (portSeparatorIdx > forToParse.lastIndexOf(93)) {
            host = forToParse.substring(0, portSeparatorIdx);
            port = this.parsePort(forToParse.substring(portSeparatorIdx + 1), defaultPort);
        }
        return new SocketAddressImpl(port, host);
    }

    private int parsePort(String portToParse, int defaultPort) {
        try {
            return Integer.parseInt(portToParse);
        }
        catch (NumberFormatException ignored) {
            log.error((Object)"Failed to parse a port from \"forwarded\"-type headers.");
            return defaultPort;
        }
    }

    private String appendPrefixToUri(String prefix, String uri) {
        String parsed = this.stripSlashes(prefix);
        return parsed.isEmpty() ? uri : '/' + parsed + uri;
    }

    private String stripSlashes(String uri) {
        String result;
        if (!uri.isEmpty()) {
            int beginIndex = 0;
            if (uri.startsWith("/")) {
                beginIndex = 1;
            }
            int endIndex = uri.length();
            if (uri.endsWith("/") && uri.length() > 1) {
                endIndex = uri.length() - 1;
            }
            result = uri.substring(beginIndex, endIndex);
        } else {
            result = uri;
        }
        return result;
    }
}

