/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AnonymousAuthenticationRequest;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.FormAuthConfig;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PersistentLoginManager;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;

@Recorder
public class HttpSecurityRecorder {
    private static final Logger log = Logger.getLogger(HttpSecurityRecorder.class);
    protected static final Consumer<Throwable> NOOP_CALLBACK = new Consumer<Throwable>(){

        @Override
        public void accept(Throwable throwable) {
        }
    };
    static volatile String encryptionKey;

    public Handler<RoutingContext> authenticationMechanismHandler(final boolean proactiveAuthentication) {
        return new Handler<RoutingContext>(){
            volatile HttpAuthenticator authenticator;

            public void handle(final RoutingContext event) {
                if (this.authenticator == null) {
                    this.authenticator = (HttpAuthenticator)CDI.current().select(HttpAuthenticator.class, new Annotation[0]).get();
                }
                event.put(HttpAuthenticator.class.getName(), (Object)this.authenticator);
                event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new BiConsumer<RoutingContext, Throwable>(){

                    @Override
                    public void accept(RoutingContext routingContext, Throwable throwable) {
                        if ((throwable = HttpSecurityRecorder.this.extractRootCause(throwable)) instanceof AuthenticationFailedException) {
                            authenticator.sendChallenge(event).subscribe().with((Consumer)new Consumer<Boolean>(){

                                @Override
                                public void accept(Boolean aBoolean) {
                                    if (!event.response().ended()) {
                                        event.response().end();
                                    }
                                }
                            }, (Consumer)new Consumer<Throwable>(){

                                @Override
                                public void accept(Throwable throwable) {
                                    event.fail(throwable);
                                }
                            });
                        } else if (throwable instanceof AuthenticationCompletionException) {
                            event.response().setStatusCode(401);
                            event.response().end();
                        } else if (throwable instanceof AuthenticationRedirectException) {
                            AuthenticationRedirectException redirectEx = (AuthenticationRedirectException)throwable;
                            event.response().setStatusCode(redirectEx.getCode());
                            event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)redirectEx.getRedirectUri());
                            event.response().headers().set(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-store");
                            event.response().headers().set("Pragma", "no-cache");
                            event.response().end();
                        } else {
                            event.fail(throwable);
                        }
                    }
                });
                final Uni potentialUser = this.authenticator.attemptAuthentication(event).memoize().indefinitely();
                if (proactiveAuthentication) {
                    potentialUser.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                        public void onSubscribe(UniSubscription subscription) {
                        }

                        public void onItem(SecurityIdentity identity) {
                            if (event.response().ended()) {
                                return;
                            }
                            if (identity == null) {
                                final Uni anon = authenticator.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
                                anon.subscribe().withSubscriber((UniSubscriber)new UniSubscriber<SecurityIdentity>(){

                                    public void onSubscribe(UniSubscription subscription) {
                                    }

                                    public void onItem(SecurityIdentity item) {
                                        event.put("io.quarkus.vertx.http.deferred-identity", (Object)anon);
                                        event.setUser((User)new QuarkusHttpUser(item));
                                        event.next();
                                    }

                                    public void onFailure(Throwable failure) {
                                        BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                                        if (handler != null) {
                                            handler.accept(event, failure);
                                        }
                                    }
                                });
                            } else {
                                event.setUser((User)new QuarkusHttpUser(identity));
                                event.put("io.quarkus.vertx.http.deferred-identity", (Object)potentialUser);
                                event.next();
                            }
                        }

                        public void onFailure(Throwable failure) {
                            BiConsumer handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler");
                            if (handler != null) {
                                handler.accept(event, failure);
                            }
                        }
                    });
                } else {
                    Uni lazyUser = potentialUser.flatMap((Function)new Function<SecurityIdentity, Uni<? extends SecurityIdentity>>(){

                        @Override
                        public Uni<? extends SecurityIdentity> apply(SecurityIdentity securityIdentity) {
                            if (securityIdentity == null) {
                                return authenticator.getIdentityProviderManager().authenticate((AuthenticationRequest)AnonymousAuthenticationRequest.INSTANCE);
                            }
                            return Uni.createFrom().item((Object)securityIdentity);
                        }
                    }).onTermination().invoke((Functions.TriConsumer)new Functions.TriConsumer<SecurityIdentity, Throwable, Boolean>(){

                        public void accept(SecurityIdentity identity, Throwable throwable, Boolean aBoolean) {
                            BiConsumer handler;
                            if (identity != null) {
                                if (identity != null) {
                                    event.setUser((User)new QuarkusHttpUser(identity));
                                }
                            } else if (throwable != null && (handler = (BiConsumer)event.get("io.quarkus.vertx.http.auth-failure-handler")) != null) {
                                handler.accept(event, throwable);
                            }
                        }
                    }).memoize().indefinitely();
                    event.put("io.quarkus.vertx.http.deferred-identity", (Object)lazyUser);
                    event.next();
                }
            }
        };
    }

    private Throwable extractRootCause(Throwable throwable) {
        while (throwable instanceof CompletionException && throwable.getCause() != null || throwable instanceof CompositeException) {
            if (throwable instanceof CompositeException) {
                throwable = (Throwable)((CompositeException)throwable).getCauses().get(0);
                continue;
            }
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public Handler<RoutingContext> permissionCheckHandler() {
        return new Handler<RoutingContext>(){
            volatile HttpAuthorizer authorizer;

            public void handle(RoutingContext event) {
                if (this.authorizer == null) {
                    this.authorizer = (HttpAuthorizer)CDI.current().select(HttpAuthorizer.class, new Annotation[0]).get();
                }
                this.authorizer.checkPermission(event);
            }
        };
    }

    public BeanContainerListener initPermissions(final HttpBuildTimeConfig permissions, final Map<String, Supplier<HttpSecurityPolicy>> policies) {
        return new BeanContainerListener(){

            public void created(BeanContainer container) {
                ((PathMatchingHttpSecurityPolicy)container.instance(PathMatchingHttpSecurityPolicy.class, new Annotation[0])).init(permissions, policies);
            }
        };
    }

    public Supplier<FormAuthenticationMechanism> setupFormAuth(final HttpConfiguration httpConfiguration, final HttpBuildTimeConfig buildTimeConfig) {
        return new Supplier<FormAuthenticationMechanism>(){

            @Override
            public FormAuthenticationMechanism get() {
                String key;
                if (!httpConfiguration.encryptionKey.isPresent()) {
                    if (encryptionKey != null) {
                        key = encryptionKey;
                    } else {
                        byte[] data = new byte[32];
                        new SecureRandom().nextBytes(data);
                        key = encryptionKey = Base64.getEncoder().encodeToString(data);
                        log.warn((Object)("Encryption key was not specified for persistent FORM auth, using temporary key " + key));
                    }
                } else {
                    key = httpConfiguration.encryptionKey.get();
                }
                FormAuthConfig form = buildTimeConfig.auth.form;
                PersistentLoginManager loginManager = new PersistentLoginManager(key, form.cookieName, form.timeout.toMillis(), form.newCookieInterval.toMillis());
                Object loginPage = form.loginPage.startsWith("/") ? form.loginPage : "/" + form.loginPage;
                Object errorPage = form.errorPage.startsWith("/") ? form.errorPage : "/" + form.errorPage;
                Object landingPage = form.landingPage.startsWith("/") ? form.landingPage : "/" + form.landingPage;
                Object postLocation = form.postLocation.startsWith("/") ? form.postLocation : "/" + form.postLocation;
                String usernameParameter = form.usernameParameter;
                String passwordParameter = form.passwordParameter;
                String locationCookie = form.locationCookie;
                boolean redirectAfterLogin = form.redirectAfterLogin;
                return new FormAuthenticationMechanism((String)loginPage, (String)postLocation, usernameParameter, passwordParameter, (String)errorPage, (String)landingPage, redirectAfterLogin, locationCookie, loginManager);
            }
        };
    }

    public Supplier<?> setupBasicAuth(final HttpBuildTimeConfig buildTimeConfig) {
        return new Supplier<BasicAuthenticationMechanism>(){

            @Override
            public BasicAuthenticationMechanism get() {
                return new BasicAuthenticationMechanism(buildTimeConfig.auth.realm, buildTimeConfig.auth.form.enabled);
            }
        };
    }

    public Supplier<?> setupMtlsClientAuth() {
        return new Supplier<MtlsAuthenticationMechanism>(){

            @Override
            public MtlsAuthenticationMechanism get() {
                return new MtlsAuthenticationMechanism();
            }
        };
    }
}

