/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;

public class MvnpmHandler
implements Handler<RoutingContext> {
    private final URLClassLoader mvnpmLoader;
    private static final String SLASH = "/";
    private static final String BASE_DIR = "META-INF/resources";
    private static final String DOT = ".";
    private static final String DOT_JS = ".js";
    private static final String DOT_JSON = ".json";
    private static final String DOT_HTML = ".html";
    private static final String DOT_HTM = ".htm";
    private static final String DOT_XHTML = ".xhtml";
    private static final String DOT_CSS = ".css";
    private static final String DOT_XML = ".xml";
    private static final String CONTENT_TYPE_JAVASCRIPT = "application/javascript";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_XHTML = "application/xhtml+xml";
    private static final String CONTENT_TYPE_XML = "application/xml";
    private static final String CONTENT_TYPE_CSS = "text/css";
    private static final String CONTENT_TYPE_TEXT = "text/plain";

    public MvnpmHandler(Set<URL> mvnpmJars) {
        this.mvnpmLoader = new URLClassLoader(mvnpmJars.toArray(new URL[0]));
    }

    public void handle(RoutingContext event) {
        Object fullPath = event.normalizedPath();
        String[] parts = ((String)fullPath).split(SLASH);
        String fileName = parts[parts.length - 1];
        if (!fileName.contains(DOT)) {
            fullPath = (String)fullPath + DOT_JS;
        }
        try {
            InputStream is = this.mvnpmLoader.getResourceAsStream(BASE_DIR + (String)fullPath);
            if (is != null) {
                byte[] contents = is.readAllBytes();
                event.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.getContentType(fileName)).end(Buffer.buffer((byte[])contents));
                return;
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        event.next();
    }

    private String getContentType(String filename) {
        String f = filename.toLowerCase();
        if (f.endsWith(DOT_JS)) {
            return CONTENT_TYPE_JAVASCRIPT;
        }
        if (f.endsWith(DOT_JSON)) {
            return CONTENT_TYPE_JSON;
        }
        if (f.endsWith(DOT_HTML) || f.endsWith(DOT_HTM)) {
            return CONTENT_TYPE_HTML;
        }
        if (f.endsWith(DOT_XHTML)) {
            return CONTENT_TYPE_XHTML;
        }
        if (f.endsWith(DOT_CSS)) {
            return CONTENT_TYPE_CSS;
        }
        if (f.endsWith(DOT_XML)) {
            return CONTENT_TYPE_XML;
        }
        return CONTENT_TYPE_TEXT;
    }
}

