/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.runtime.configuration.CidrAddressConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import jakarta.annotation.Priority;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;
import org.wildfly.common.net.CidrAddress;

@Priority(value=200)
public final class TrustedProxyCheckPartConverter
implements Converter<TrustedProxyCheck.TrustedProxyCheckPart> {
    private static final Pattern CIDR_PATTERN = Pattern.compile(".+\\/\\d+");

    public TrustedProxyCheck.TrustedProxyCheckPart convert(String proxyAddress) {
        InetSocketAddress inetSocketAddress;
        boolean useHostName;
        if (CIDR_PATTERN.matcher(proxyAddress).matches()) {
            final CidrAddress cidrAddress = new CidrAddressConverter().convert(proxyAddress);
            return new TrustedProxyCheck.TrustedProxyCheckPart(new BiPredicate<InetAddress, Integer>(){

                @Override
                public boolean test(InetAddress proxyIP, Integer proxyPort) {
                    return cidrAddress.matches(proxyIP);
                }
            });
        }
        if ("localhost".equals(proxyAddress)) {
            proxyAddress = "127.0.0.1";
        }
        boolean bl = useHostName = (inetSocketAddress = new InetSocketAddressConverter().convert(proxyAddress)).isUnresolved() || inetSocketAddress.getAddress() == null;
        if (useHostName) {
            return new TrustedProxyCheck.TrustedProxyCheckPart(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
        }
        return new TrustedProxyCheck.TrustedProxyCheckPart(TrustedProxyCheck.createNewIpCheck(inetSocketAddress.getAddress(), inetSocketAddress.getPort()));
    }
}

