/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.options;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceConfiguration;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.TrustOptions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HttpServerOptionsUtils {
    public static HttpServerOptions createSslOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) throws IOException {
        KeyStoreOptions options;
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        ServerSslConfig sslConfig = httpConfiguration.ssl;
        Optional<Path> certFile = sslConfig.certificate.file;
        Optional<Path> keyFile = sslConfig.certificate.keyFile;
        ArrayList<Path> keys = new ArrayList<Path>();
        ArrayList<Path> certificates = new ArrayList<Path>();
        if (sslConfig.certificate.keyFiles.isPresent()) {
            keys.addAll((Collection)sslConfig.certificate.keyFiles.get());
        }
        if (sslConfig.certificate.files.isPresent()) {
            certificates.addAll((Collection)sslConfig.certificate.files.get());
        }
        if (keyFile.isPresent()) {
            keys.add(keyFile.get());
        }
        if (certFile.isPresent()) {
            certificates.add(certFile.get());
        }
        Map credentials = Map.of();
        if (sslConfig.certificate.credentialsProvider.isPresent()) {
            String beanName = sslConfig.certificate.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = sslConfig.certificate.credentialsProvider.get();
            credentials = credentialsProvider.getCredentials(name);
        }
        Optional<Path> keyStoreFile = sslConfig.certificate.keyStoreFile;
        Optional<String> keyStorePassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.keyStorePassword, credentials, sslConfig.certificate.keyStorePasswordKey);
        Optional<String> keyStoreKeyPassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.keyStoreKeyPassword, credentials, sslConfig.certificate.keyStoreKeyPasswordKey);
        Optional<Path> trustStoreFile = sslConfig.certificate.trustStoreFile;
        Optional<String> trustStorePassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.trustStorePassword, credentials, sslConfig.certificate.trustStorePasswordKey);
        HttpServerOptions serverOptions = new HttpServerOptions();
        if (JdkSSLEngineOptions.isAlpnAvailable()) {
            serverOptions.setUseAlpn(httpConfiguration.http2);
            if (httpConfiguration.http2) {
                serverOptions.setAlpnVersions(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
            }
        }
        HttpServerOptionsUtils.setIdleTimeout(httpConfiguration, serverOptions);
        if (!certificates.isEmpty() && !keys.isEmpty()) {
            HttpServerOptionsUtils.createPemKeyCertOptions(certificates, keys, serverOptions);
        } else if (keyStoreFile.isPresent()) {
            options = HttpServerOptionsUtils.createKeyStoreOptions(keyStoreFile.get(), keyStorePassword.orElse("password"), sslConfig.certificate.keyStoreFileType, sslConfig.certificate.keyStoreProvider, sslConfig.certificate.keyStoreKeyAlias, keyStoreKeyPassword);
            serverOptions.setKeyCertOptions((KeyCertOptions)options);
        }
        if (trustStoreFile.isPresent()) {
            if (!trustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            options = HttpServerOptionsUtils.createKeyStoreOptions(trustStoreFile.get(), trustStorePassword.get(), sslConfig.certificate.trustStoreFileType, sslConfig.certificate.trustStoreProvider, sslConfig.certificate.trustStoreCertAlias, Optional.empty());
            serverOptions.setTrustOptions((TrustOptions)options);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            serverOptions.addEnabledCipherSuite(cipher);
        }
        serverOptions.setEnabledSecureTransportProtocols(sslConfig.protocols);
        serverOptions.setSsl(true);
        serverOptions.setSni(sslConfig.sni);
        int sslPort = httpConfiguration.determineSslPort(launchMode);
        serverOptions.setPort(sslPort == 0 ? -2 : sslPort);
        serverOptions.setClientAuth(buildTimeConfig.tlsClientAuth);
        HttpServerOptionsUtils.applyCommonOptions(serverOptions, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        return serverOptions;
    }

    public static HttpServerOptions createSslOptionsForManagementInterface(ManagementInterfaceBuildTimeConfig buildTimeConfig, ManagementInterfaceConfiguration httpConfiguration, LaunchMode launchMode, List<String> websocketSubProtocols) throws IOException {
        KeyStoreOptions options;
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        ServerSslConfig sslConfig = httpConfiguration.ssl;
        Optional<Path> certFile = sslConfig.certificate.file;
        Optional<Path> keyFile = sslConfig.certificate.keyFile;
        ArrayList<Path> keys = new ArrayList<Path>();
        ArrayList<Path> certificates = new ArrayList<Path>();
        if (sslConfig.certificate.keyFiles.isPresent()) {
            keys.addAll((Collection)sslConfig.certificate.keyFiles.get());
        }
        if (sslConfig.certificate.files.isPresent()) {
            certificates.addAll((Collection)sslConfig.certificate.files.get());
        }
        if (keyFile.isPresent()) {
            keys.add(keyFile.get());
        }
        if (certFile.isPresent()) {
            certificates.add(certFile.get());
        }
        Map credentials = Map.of();
        if (sslConfig.certificate.credentialsProvider.isPresent()) {
            String beanName = sslConfig.certificate.credentialsProviderName.orElse(null);
            CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)beanName);
            String name = sslConfig.certificate.credentialsProvider.get();
            credentials = credentialsProvider.getCredentials(name);
        }
        Optional<Path> keyStoreFile = sslConfig.certificate.keyStoreFile;
        Optional<String> keyStorePassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.keyStorePassword, credentials, sslConfig.certificate.keyStorePasswordKey);
        Optional<String> keyStoreKeyPassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.keyStoreKeyPassword, credentials, sslConfig.certificate.keyStoreKeyPasswordKey);
        Optional<Path> trustStoreFile = sslConfig.certificate.trustStoreFile;
        Optional<String> trustStorePassword = HttpServerOptionsUtils.getCredential(sslConfig.certificate.trustStorePassword, credentials, sslConfig.certificate.trustStorePasswordKey);
        HttpServerOptions serverOptions = new HttpServerOptions();
        if (JdkSSLEngineOptions.isAlpnAvailable()) {
            serverOptions.setUseAlpn(true);
            serverOptions.setAlpnVersions(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
        }
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        serverOptions.setIdleTimeout(idleTimeout);
        serverOptions.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        if (!certificates.isEmpty() && !keys.isEmpty()) {
            HttpServerOptionsUtils.createPemKeyCertOptions(certificates, keys, serverOptions);
        } else if (keyStoreFile.isPresent()) {
            options = HttpServerOptionsUtils.createKeyStoreOptions(keyStoreFile.get(), keyStorePassword.orElse("password"), sslConfig.certificate.keyStoreFileType, sslConfig.certificate.keyStoreProvider, sslConfig.certificate.keyStoreKeyAlias, keyStoreKeyPassword);
            serverOptions.setKeyCertOptions((KeyCertOptions)options);
        }
        if (trustStoreFile.isPresent()) {
            if (!trustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            options = HttpServerOptionsUtils.createKeyStoreOptions(trustStoreFile.get(), trustStorePassword.get(), sslConfig.certificate.trustStoreFileType, sslConfig.certificate.trustStoreProvider, sslConfig.certificate.trustStoreCertAlias, Optional.empty());
            serverOptions.setTrustOptions((TrustOptions)options);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            serverOptions.addEnabledCipherSuite(cipher);
        }
        serverOptions.setEnabledSecureTransportProtocols(sslConfig.protocols);
        serverOptions.setSsl(true);
        serverOptions.setSni(sslConfig.sni);
        int sslPort = httpConfiguration.determinePort(launchMode);
        serverOptions.setPort(sslPort == 0 ? -2 : sslPort);
        serverOptions.setClientAuth(buildTimeConfig.tlsClientAuth);
        HttpServerOptionsUtils.applyCommonOptionsForManagementInterface(serverOptions, buildTimeConfig, httpConfiguration, websocketSubProtocols);
        return serverOptions;
    }

    private static Optional<String> getCredential(Optional<String> password, Map<String, String> credentials, Optional<String> passwordKey) {
        if (password.isPresent()) {
            return password;
        }
        if (passwordKey.isPresent()) {
            return Optional.ofNullable(credentials.get(passwordKey.get()));
        }
        return Optional.empty();
    }

    public static void applyCommonOptions(HttpServerOptions httpServerOptions, HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        httpServerOptions.setHost(httpConfiguration.host);
        HttpServerOptionsUtils.setIdleTimeout(httpConfiguration, httpServerOptions);
        httpServerOptions.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        httpServerOptions.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        httpServerOptions.setMaxFormAttributeSize(httpConfiguration.limits.maxFormAttributeSize.asBigInteger().intValueExact());
        httpServerOptions.setWebSocketSubProtocols(websocketSubProtocols);
        httpServerOptions.setReusePort(httpConfiguration.soReusePort);
        httpServerOptions.setTcpQuickAck(httpConfiguration.tcpQuickAck);
        httpServerOptions.setTcpCork(httpConfiguration.tcpCork);
        httpServerOptions.setAcceptBacklog(httpConfiguration.acceptBacklog);
        httpServerOptions.setTcpFastOpen(httpConfiguration.tcpFastOpen);
        httpServerOptions.setCompressionSupported(buildTimeConfig.enableCompression);
        if (buildTimeConfig.compressionLevel.isPresent()) {
            httpServerOptions.setCompressionLevel(buildTimeConfig.compressionLevel.getAsInt());
        }
        httpServerOptions.setDecompressionSupported(buildTimeConfig.enableDecompression);
        httpServerOptions.setMaxInitialLineLength(httpConfiguration.limits.maxInitialLineLength);
        httpServerOptions.setHandle100ContinueAutomatically(httpConfiguration.handle100ContinueAutomatically);
        if (httpConfiguration.http2) {
            Http2Settings settings = new Http2Settings();
            if (httpConfiguration.limits.headerTableSize.isPresent()) {
                settings.setHeaderTableSize(httpConfiguration.limits.headerTableSize.getAsLong());
            }
            settings.setPushEnabled(httpConfiguration.http2PushEnabled);
            if (httpConfiguration.limits.maxConcurrentStreams.isPresent()) {
                settings.setMaxConcurrentStreams(httpConfiguration.limits.maxConcurrentStreams.getAsLong());
            }
            if (httpConfiguration.initialWindowSize.isPresent()) {
                settings.setInitialWindowSize(httpConfiguration.initialWindowSize.getAsInt());
            }
            if (httpConfiguration.limits.maxFrameSize.isPresent()) {
                settings.setMaxFrameSize(httpConfiguration.limits.maxFrameSize.getAsInt());
            }
            if (httpConfiguration.limits.maxHeaderListSize.isPresent()) {
                settings.setMaxHeaderListSize(httpConfiguration.limits.maxHeaderListSize.getAsLong());
            }
            httpServerOptions.setInitialSettings(settings);
        }
    }

    public static void applyCommonOptionsForManagementInterface(HttpServerOptions options, ManagementInterfaceBuildTimeConfig buildTimeConfig, ManagementInterfaceConfiguration httpConfiguration, List<String> websocketSubProtocols) {
        options.setHost(httpConfiguration.host.orElse("0.0.0.0"));
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        options.setIdleTimeout(idleTimeout);
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
        options.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        options.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        options.setMaxFormAttributeSize(httpConfiguration.limits.maxFormAttributeSize.asBigInteger().intValueExact());
        options.setMaxInitialLineLength(httpConfiguration.limits.maxInitialLineLength);
        options.setWebSocketSubProtocols(websocketSubProtocols);
        options.setAcceptBacklog(httpConfiguration.acceptBacklog);
        options.setCompressionSupported(buildTimeConfig.enableCompression);
        if (buildTimeConfig.compressionLevel.isPresent()) {
            options.setCompressionLevel(buildTimeConfig.compressionLevel.getAsInt());
        }
        options.setDecompressionSupported(buildTimeConfig.enableDecompression);
        options.setHandle100ContinueAutomatically(httpConfiguration.handle100ContinueAutomatically);
    }

    private static KeyStoreOptions createKeyStoreOptions(Path path, String password, Optional<String> fileType, Optional<String> provider, Optional<String> alias, Optional<String> aliasPassword) throws IOException {
        String type = fileType.isPresent() ? fileType.get().toLowerCase() : HttpServerOptionsUtils.findKeystoreFileType(path);
        byte[] data = HttpServerOptionsUtils.getFileContent(path);
        KeyStoreOptions options = new KeyStoreOptions().setPassword(password).setValue(Buffer.buffer((byte[])data)).setType(type.toUpperCase()).setProvider((String)provider.orElse(null)).setAlias((String)alias.orElse(null)).setAliasPassword((String)aliasPassword.orElse(null));
        return options;
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            try (InputStream is = resource;){
                data = HttpServerOptionsUtils.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = HttpServerOptionsUtils.doRead(is);
        }
        return data;
    }

    private static void createPemKeyCertOptions(List<Path> certFile, List<Path> keyFile, HttpServerOptions serverOptions) throws IOException {
        if (certFile.size() != keyFile.size()) {
            throw new ConfigurationException("Invalid certificate configuration - `files` and `keyFiles` must have the same number of elements");
        }
        ArrayList<Buffer> certificates = new ArrayList<Buffer>();
        ArrayList<Buffer> keys = new ArrayList<Buffer>();
        for (Path p : certFile) {
            byte[] cert = HttpServerOptionsUtils.getFileContent(p);
            certificates.add(Buffer.buffer((byte[])cert));
        }
        for (Path p : keyFile) {
            byte[] key = HttpServerOptionsUtils.getFileContent(p);
            keys.add(Buffer.buffer((byte[])key));
        }
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions().setCertValues(certificates).setKeyValues(keys);
        serverOptions.setPemKeyCertOptions(pemKeyCertOptions);
    }

    private static String findKeystoreFileType(Path storePath) {
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "pkcs12";
        }
        return "jks";
    }

    private static byte[] doRead(InputStream is) throws IOException {
        return is.readAllBytes();
    }

    private static void setIdleTimeout(HttpConfiguration httpConfiguration, HttpServerOptions options) {
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        options.setIdleTimeout(idleTimeout);
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
    }
}

