/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.jsonrpc;

import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcResponse;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;

public final class JsonRpcCodec {
    private final JsonMapper jsonMapper;

    public JsonRpcCodec(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public JsonRpcRequest readRequest(String json) {
        return new JsonRpcRequest(this.jsonMapper, (JsonObject)this.jsonMapper.fromString(json, Object.class));
    }

    public void writeResponse(ServerWebSocket socket, int id, Object object, MessageType messageType) {
        this.writeResponse(socket, new JsonRpcResponse(id, new JsonRpcResponse.Result(messageType.name(), object)));
    }

    public void writeMethodNotFoundResponse(ServerWebSocket socket, int id, String jsonRpcMethodName) {
        this.writeResponse(socket, new JsonRpcResponse(id, new JsonRpcResponse.Error(-32601, "Method [" + jsonRpcMethodName + "] not found")));
    }

    public void writeErrorResponse(ServerWebSocket socket, int id, String jsonRpcMethodName, Throwable exception) {
        this.writeResponse(socket, new JsonRpcResponse(id, new JsonRpcResponse.Error(-32603, "Method [" + jsonRpcMethodName + "] failed: " + exception.getMessage())));
    }

    private void writeResponse(ServerWebSocket socker, JsonRpcResponse response) {
        socker.writeTextMessage(this.jsonMapper.toString(response, true));
    }
}

