/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.runtime.BlockingOperationControl;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import jakarta.inject.Inject;
import java.util.function.Supplier;

public class VertxBlockingSecurityExecutor
implements BlockingSecurityExecutor {
    @Inject
    Vertx vertx;

    public <T> Uni<T> executeBlocking(final Supplier<? extends T> supplier) {
        return Uni.createFrom().deferred(new Supplier<Uni<? extends T>>(){

            @Override
            public Uni<? extends T> get() {
                if (BlockingOperationControl.isBlockingAllowed()) {
                    try {
                        return Uni.createFrom().item(supplier.get());
                    }
                    catch (Throwable t) {
                        return Uni.createFrom().failure(t);
                    }
                }
                Context local = VertxContext.getOrCreateDuplicatedContext((Vertx)VertxBlockingSecurityExecutor.this.vertx);
                VertxContextSafetyToggle.setContextSafe((Context)local, (boolean)true);
                return Uni.createFrom().completionStage(local.executeBlocking(new Handler<Promise<T>>(){

                    public void handle(Promise<T> promise) {
                        try {
                            promise.complete(supplier.get());
                        }
                        catch (Throwable t) {
                            promise.fail(t);
                        }
                    }
                }).toCompletionStage());
            }
        });
    }
}

