/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.websockets.next.InboundProcessingMode;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import java.lang.reflect.Type;

public interface WebSocketEndpoint {
    public InboundProcessingMode inboundProcessingMode();

    public Future<Void> onOpen();

    default public ExecutionModel onOpenExecutionModel() {
        return ExecutionModel.NONE;
    }

    public Future<Void> onTextMessage(Object var1);

    default public ExecutionModel onTextMessageExecutionModel() {
        return ExecutionModel.NONE;
    }

    default public Type consumedTextMultiType() {
        return null;
    }

    default public Object decodeTextMultiItem(Object message) {
        throw new UnsupportedOperationException();
    }

    public Future<Void> onBinaryMessage(Object var1);

    default public ExecutionModel onBinaryMessageExecutionModel() {
        return ExecutionModel.NONE;
    }

    default public Type consumedBinaryMultiType() {
        return null;
    }

    default public Object decodeBinaryMultiItem(Object message) {
        throw new UnsupportedOperationException();
    }

    public Future<Void> onPongMessage(Buffer var1);

    default public ExecutionModel onPongMessageExecutionModel() {
        return ExecutionModel.NONE;
    }

    public Future<Void> onClose();

    default public ExecutionModel onCloseExecutionModel() {
        return ExecutionModel.NONE;
    }

    public Uni<Void> doOnError(Throwable var1);

    public String beanIdentifier();

    public static enum ExecutionModel {
        WORKER_THREAD,
        VIRTUAL_THREAD,
        EVENT_LOOP,
        NONE;


        boolean isBlocking() {
            return this == WORKER_THREAD || this == VIRTUAL_THREAD;
        }
    }
}

